/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.io.HtmlOutput;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.QueryExecutor;
import com.scythebill.birdlist.ui.panels.reports.ReportHints;
import com.scythebill.birdlist.ui.panels.reports.ReportPrintDialog;
import com.scythebill.birdlist.ui.panels.reports.ReportPrintPreferences;
import com.scythebill.birdlist.ui.panels.reports.SortType;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

class PrintAction
extends AbstractAction {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.shortDate().withZone(DateTimeZone.forTimeZone(TimeZone.getDefault()));
    private static final String PRINT_SCRIPT = "window.print();";
    private static final String TEST_FOR_SAFARI = Joiner.on('\n').join("var isSafari = navigator.vendor && navigator.vendor.indexOf('Apple') > -1 &&", "    navigator.userAgent && !navigator.userAgent.match('CriOS');", "if (isSafari) {", "  alert('Compact printing is not supported in Safari;  please load in Chrome or Firefox');", "} else {", "window.print();", "}");
    private final ReportSet reportSet;
    private final TaxonomyStore taxonomyStore;
    private final QueryExecutor queryExecutor;
    private final String fileName;
    private final Alerts alerts;
    private final ReportPrintDialog reportPrintDialog;

    public PrintAction(String fileName, ReportSet reportSet, TaxonomyStore taxonomyStore, QueryExecutor queryExecutor, Alerts alerts, ReportPrintDialog reportPrintDialog) {
        this.fileName = fileName;
        this.reportSet = reportSet;
        this.taxonomyStore = taxonomyStore;
        this.queryExecutor = queryExecutor;
        this.alerts = alerts;
        this.reportPrintDialog = reportPrintDialog;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Optional<String> reportName;
        File temp;
        ReportPrintPreferences prefs = this.reportPrintDialog.getConfiguration((Component)event.getSource());
        if (prefs == null) {
            return;
        }
        try {
            temp = File.createTempFile(this.fileName, ".html");
        }
        catch (IOException e) {
            this.alerts.showError(null, Messages.Name.COULD_NOT_PRINT, Messages.Name.COULD_NOT_CREATE_TEMPORARY_FILE_TO_PRINT, e);
            return;
        }
        QueryExecutor executor = this.queryExecutor;
        if (prefs.onlyCountable) {
            executor = executor.onlyCountable();
        }
        QueryResults queryResults = executor.executeQuery(null, null);
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        HtmlOutput htmlOutput = new HtmlOutput(taxonomy, this.queryExecutor.getRootLocation(), this.alerts);
        Set<ReportHints> reportHints = this.queryExecutor.getReportHints();
        if (prefs.compactPrinting) {
            htmlOutput.setScript(TEST_FOR_SAFARI);
        } else {
            htmlOutput.setScript(PRINT_SCRIPT);
        }
        if (prefs.omitSpAndHybrid) {
            htmlOutput.setOmitSpAndHybrid(prefs.omitSpAndHybrid);
        }
        if ((reportName = this.queryExecutor.getReportAbbreviation()).isPresent()) {
            htmlOutput.setTitle(String.format("%s - %s - %s", reportName.get(), this.fileName, DATE_FORMAT.print(new Instant())));
        } else {
            htmlOutput.setTitle(String.format("%s - %s", this.fileName, DATE_FORMAT.print(new Instant())));
        }
        htmlOutput.setShowStatus(prefs.showStatus);
        htmlOutput.setCompactOutput(prefs.compactPrinting);
        htmlOutput.setScientificOrCommon(this.reportPrintDialog.getScientificOrCommonFromConfiguration(prefs));
        htmlOutput.setSightingsCount(prefs.compactPrinting ? 0 : prefs.maximumSightings);
        if (prefs.sortType != SortType.DEFAULT) {
            htmlOutput.setSortAllSightings(true);
            htmlOutput.setShowFamilyTotals(false);
            htmlOutput.setShowFamilies(false);
        } else {
            boolean showFamilyTotals = reportHints.contains((Object)ReportHints.SPECIES_STATUS_RESTRICTION) ? false : !reportHints.contains((Object)ReportHints.LOCATION_RESTRICTION) || queryResults.getChecklist(taxonomy) != null;
            htmlOutput.setShowFamilyTotals(showFamilyTotals);
            htmlOutput.setShowFamilies(prefs.showFamilies);
        }
        try {
            htmlOutput.writeSpeciesList(temp, queryResults, prefs.sortType.ordering(), prefs.sortSightingsType.ordering(), this.reportSet.getLocations());
            DesktopUtils.openHtmlFileInBrowser(temp);
        }
        catch (IOException e) {
            this.alerts.showError(null, Messages.getMessage(Messages.Name.COULD_NOT_PRINT), Messages.getFormattedMessage(Messages.Name.COULD_NOT_CREATE_TEMPORARY_FILE_TO_PRINT_IN, temp.getParentFile().getAbsolutePath()), e);
        }
    }
}

