/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

class PhotographedQueryField
extends AbstractQueryField {
    private final JComboBox<QueryType> queryOptions = new JComboBox<QueryType>(QueryType.values());
    private final JPanel emptyValueField = new JPanel();
    private static final Gson GSON = new Gson();

    public PhotographedQueryField() {
        super(QueryFieldFactory.QueryFieldType.PHOTOGRAPHED);
        this.queryOptions.addActionListener(e -> this.firePredicateUpdated());
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.queryOptions;
    }

    @Override
    public JComponent getValueField() {
        return this.emptyValueField;
    }

    @Override
    public Predicate<Sighting> predicate(Taxon.Type depth) {
        QueryType type = (QueryType)((Object)this.queryOptions.getSelectedItem());
        switch (type) {
            case HAS_PHOTO: 
            case HAS_NO_PHOTO: {
                Predicate predicate = sighting -> sighting.hasSightingInfo() && sighting.getSightingInfo().isPhotographed();
                if (type == QueryType.HAS_NO_PHOTO) {
                    predicate = Predicates.not(predicate);
                }
                return predicate;
            }
            case HAS_FAVORITE: 
            case HAS_NO_FAVORITE: {
                Predicate favoritePredicate = sighting -> sighting.hasSightingInfo() && sighting.getSightingInfo().getPhotos().stream().anyMatch(Photo::isFavorite);
                if (type == QueryType.HAS_NO_FAVORITE) {
                    favoritePredicate = Predicates.not(favoritePredicate);
                }
                return favoritePredicate;
            }
        }
        throw new AssertionError((Object)("Unexpected type: " + type));
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    @Override
    public JsonElement persist() {
        Persisted persisted = new Persisted((QueryType)((Object)this.queryOptions.getSelectedItem()));
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                int asInt = primitive.getAsInt();
                if (asInt == 0) {
                    this.queryOptions.setSelectedItem((Object)QueryType.HAS_PHOTO);
                } else if (asInt == 1) {
                    this.queryOptions.setSelectedItem((Object)QueryType.HAS_NO_PHOTO);
                }
            } else if (primitive.isBoolean()) {
                this.queryOptions.setSelectedItem((Object)(primitive.getAsBoolean() ? QueryType.HAS_PHOTO : QueryType.HAS_NO_PHOTO));
            }
        } else {
            Persisted persisted = GSON.fromJson(json, Persisted.class);
            this.queryOptions.setSelectedItem((Object)persisted.type);
        }
    }

    @Override
    public Optional<String> name() {
        QueryType type = (QueryType)((Object)this.queryOptions.getSelectedItem());
        switch (type) {
            case HAS_PHOTO: {
                return Optional.of("photographed");
            }
            case HAS_NO_PHOTO: {
                return Optional.of("not photographed");
            }
            case HAS_FAVORITE: {
                return Optional.of("has favorite");
            }
            case HAS_NO_FAVORITE: {
                return Optional.of("no favorite");
            }
        }
        throw new AssertionError((Object)("Unexpected type: " + type));
    }

    private static enum QueryType {
        HAS_PHOTO(Messages.Name.YES_TEXT),
        HAS_NO_PHOTO(Messages.Name.NO_TEXT),
        HAS_FAVORITE(Messages.Name.HAS_FAVORITE),
        HAS_NO_FAVORITE(Messages.Name.HAS_NO_FAVORITE);

        private final Messages.Name text;

        private QueryType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class Persisted {
        QueryType type;

        public Persisted(QueryType type) {
            this.type = type;
        }
    }
}

