/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class NeverQueryDefinition
implements QueryDefinition,
QueryDefinition.Preprocessor {
    private final ImmutableList<QueryDefinition> queryDefinitions;
    private final Taxonomy taxonomy;
    private final Taxon.Type depth;
    private Set<SightingTaxon> excludedTaxa = new HashSet<SightingTaxon>();

    public NeverQueryDefinition(QueryDefinition queryDefinition, Taxonomy taxonomy, Taxon.Type depth) {
        this(ImmutableList.of(queryDefinition), taxonomy, depth);
    }

    public NeverQueryDefinition(List<QueryDefinition> andedQueryDefinitions, Taxonomy taxonomy, Taxon.Type depth) {
        this.queryDefinitions = ImmutableList.copyOf(andedQueryDefinitions);
        this.taxonomy = taxonomy;
        this.depth = depth;
    }

    @Override
    public Optional<QueryDefinition.Preprocessor> preprocessor() {
        return Optional.of(this);
    }

    @Override
    public Predicate<Sighting> predicate() {
        return this::notInExcludedTaxa;
    }

    @Override
    public Optional<QueryDefinition.QueryAnnotation> annotate(Sighting sighting, SightingTaxon taxon) {
        for (QueryDefinition queryDefinition : this.queryDefinitions) {
            Optional<QueryDefinition.QueryAnnotation> annotation = queryDefinition.annotate(sighting, taxon);
            if (!annotation.isPresent()) continue;
            return annotation;
        }
        return Optional.absent();
    }

    @Override
    public void reset() {
        this.excludedTaxa.clear();
    }

    @Override
    public void preprocess(Sighting sighting, Predicate<Sighting> countablePredicate) {
        if (!TaxonUtils.areCompatible(this.taxonomy, sighting.getTaxonomy())) {
            return;
        }
        for (QueryDefinition queryDefinition : this.queryDefinitions) {
            if (queryDefinition.predicate().apply(sighting)) continue;
            return;
        }
        this.excludedTaxa.add(this.mapForDepth(sighting.getTaxon()));
    }

    private boolean notInExcludedTaxa(Sighting sighting) {
        if (!TaxonUtils.areCompatible(this.taxonomy, sighting.getTaxonomy())) {
            return false;
        }
        return !this.excludedTaxa.contains(this.mapForDepth(sighting.getTaxon()));
    }

    private SightingTaxon mapForDepth(SightingTaxon taxon) {
        if (this.depth == Taxon.Type.subspecies) {
            return taxon;
        }
        return taxon.resolve(this.taxonomy).getParentOfAtLeastType(this.depth);
    }
}

