/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.query.SyntheticLocations;
import com.scythebill.birdlist.model.sighting.Distance;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.VisitInfoPanel;
import com.scythebill.birdlist.ui.components.VisitInfoPreferences;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import com.scythebill.birdlist.ui.util.LocationScorer;
import java.text.NumberFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

class LocationQueryField
extends AbstractQueryField {
    private final LocationSet locationSet;
    private final JComboBox<QueryType> whereOptions = new JComboBox<QueryType>(QueryType.values());
    private final IndexerPanel<String> whereIndexer;
    private final SyntheticLocations syntheticLocations;
    private final JPanel distanceBox;
    private final AutoSelectJFormattedTextField distanceField;
    private final JComboBox<VisitInfoPanel.MilesOrKilometers> milesOrKilometers;
    private final JPanel valueBox;
    private final LocationIdToString idToString;
    private final Indexer<String> allLocationsIndexer;
    private final Indexer<String> locationsWithLatLongIndexer;
    private static final Gson GSON = new Gson();

    public LocationQueryField(LocationSet locationSet, VisitInfoPreferences visitInfoPreferences, LocationScorer locationScorer, boolean addNullName) {
        super(QueryFieldFactory.QueryFieldType.LOCATION);
        this.locationSet = locationSet;
        this.syntheticLocations = new SyntheticLocations(locationSet);
        this.idToString = new LocationIdToString(locationSet, this.syntheticLocations);
        this.idToString.setVerbose(true);
        this.whereIndexer = new IndexerPanel();
        this.whereIndexer.setPreviewText(Messages.Name.START_TYPING_A_LOCATION);
        this.whereIndexer.setOrdering(locationScorer.stringOrdering());
        this.allLocationsIndexer = this.idToString.createIndexer(addNullName);
        this.locationsWithLatLongIndexer = new LocationIdToString(locationSet, null).createIndexer(addNullName, l -> l.getLatLong().isPresent());
        this.distanceBox = new JPanel();
        this.distanceBox.setLayout(new BoxLayout(this.distanceBox, 2));
        this.distanceField = new AutoSelectJFormattedTextField();
        this.distanceField.setColumns(6);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumIntegerDigits(5);
        numberFormat.setMaximumFractionDigits(2);
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setMinimum(Float.valueOf(0.0f));
        numberFormatter.setValueClass(Float.class);
        numberFormatter.setMaximum(Float.valueOf(100000.0f));
        numberFormatter.setCommitsOnValidEdit(true);
        this.distanceField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        this.milesOrKilometers = new JComboBox<VisitInfoPanel.MilesOrKilometers>(VisitInfoPanel.MilesOrKilometers.values());
        this.milesOrKilometers.setSelectedItem((Object)visitInfoPreferences.milesOrKilometers);
        this.distanceBox.add(this.distanceField);
        this.distanceBox.add(Box.createHorizontalStrut(5));
        this.distanceBox.add(this.milesOrKilometers);
        this.distanceBox.add(Box.createHorizontalStrut(5));
        JLabel fromLabel = new JLabel(Messages.getMessage(Messages.Name.LOCATION_FROM));
        fromLabel.putClientProperty("birdlist.plainLabel", true);
        this.distanceBox.add(fromLabel);
        this.valueBox = new JPanel();
        this.valueBox.setLayout(new BoxLayout(this.valueBox, 3));
        this.valueBox.add(this.distanceBox);
        this.valueBox.add(this.whereIndexer);
        this.whereIndexer.addPropertyChangeListener("value", e -> this.firePredicateUpdated());
        this.whereOptions.addActionListener(e -> {
            this.updateLocationVisibility();
            this.resetIndexer();
            this.firePredicateUpdated();
        });
        this.milesOrKilometers.addActionListener(e -> {
            this.firePredicateUpdated();
            visitInfoPreferences.milesOrKilometers = (VisitInfoPanel.MilesOrKilometers)((Object)((Object)this.milesOrKilometers.getSelectedItem()));
        });
        this.distanceField.addPropertyChangeListener("value", e -> this.firePredicateUpdated());
        this.updateLocationVisibility();
        this.resetIndexer();
        this.whereIndexer.setValue(null);
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.whereOptions;
    }

    @Override
    public JComponent getValueField() {
        return this.valueBox;
    }

    @Override
    public boolean isSingleLine() {
        return false;
    }

    public Location getRootLocation() {
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        Object selectedItem = this.whereOptions.getSelectedItem();
        if (QueryType.IN.equals(selectedItem) || QueryType.IS.equals(selectedItem)) {
            return location;
        }
        return null;
    }

    public void setIsInLocation(String id) {
        this.whereOptions.setSelectedItem((Object)QueryType.IN);
        this.whereIndexer.setValue(id);
    }

    @Override
    public Predicate<Sighting> predicate(Taxon.Type depth) {
        String id = this.whereIndexer.getValue();
        Object selectedItem = this.whereOptions.getSelectedItem();
        if (QueryType.IS_NOT_SET.equals(selectedItem)) {
            return sighting -> sighting.getLocationId() == null;
        }
        if (id == null) {
            return Predicates.alwaysTrue();
        }
        Location location = this.locationSet.getLocation(id);
        SyntheticLocation synthetic = null;
        if (location == null) {
            synthetic = this.syntheticLocations.byId(id);
        }
        if (QueryType.IN.equals(selectedItem)) {
            if (synthetic != null) {
                return synthetic.isInPredicate();
            }
            return SightingPredicates.in(location, this.locationSet);
        }
        if (QueryType.NOT_IN.equals(selectedItem)) {
            if (synthetic != null) {
                return Predicates.not(synthetic.isInPredicate());
            }
            return Predicates.not(SightingPredicates.in(location, this.locationSet));
        }
        if (QueryType.IS.equals(selectedItem)) {
            if (synthetic != null) {
                return Predicates.alwaysFalse();
            }
            return SightingPredicates.is(location, this.locationSet);
        }
        if (QueryType.IS_NOT.equals(selectedItem)) {
            if (synthetic != null) {
                return Predicates.alwaysFalse();
            }
            return Predicates.not(SightingPredicates.is(location, this.locationSet));
        }
        if (QueryType.IS_NEARER_THAN.equals(selectedItem)) {
            if (location == null) {
                return Predicates.alwaysFalse();
            }
            if (!location.getLatLong().isPresent()) {
                return Predicates.alwaysFalse();
            }
            Object distanceValue = this.distanceField.getValue();
            if (distanceValue == null) {
                return Predicates.alwaysFalse();
            }
            float distanceInKm = ((Float)distanceValue).floatValue();
            if (this.milesOrKilometers.getSelectedItem() == VisitInfoPanel.MilesOrKilometers.MILES) {
                distanceInKm = Distance.inMiles(distanceInKm).kilometers();
            }
            if (distanceInKm <= 0.0f) {
                return SightingPredicates.is(location, this.locationSet);
            }
            LinkedHashSet<String> locationIds = new LinkedHashSet<String>();
            for (Location root : this.locationSet.rootLocations()) {
                LocationQueryField.addLocationsWithin(locationIds, root, distanceInKm, location.getLatLong().get());
            }
            return s -> locationIds.contains(s.getLocationId());
        }
        throw new IllegalStateException("Unknown location option: " + selectedItem);
    }

    private static void addLocationsWithin(Set<String> locationIds, Location location, float distanceInKm, LatLongCoordinates latLong) {
        if (location.getLatLong().isPresent() && latLong.kmDistance(location.getLatLong().get()) <= (double)distanceInKm) {
            locationIds.add(location.getId());
        }
        for (Location child : location.contents()) {
            LocationQueryField.addLocationsWithin(locationIds, child, distanceInKm, latLong);
        }
    }

    @Override
    public boolean isNoOp() {
        return this.whereIndexer.getValue() == null;
    }

    @Nullable
    public Location getLocation() {
        String id = this.whereIndexer.getValue();
        if (id != null) {
            Location location = this.locationSet.getLocation(id);
            if (location == null) {
                location = this.syntheticLocations.byId(id);
            }
            return location;
        }
        return null;
    }

    @Override
    public Optional<String> abbreviation() {
        if (this.whereOptions.getSelectedItem() == QueryType.IS_NOT_SET) {
            return Optional.of(Messages.getMessage(Messages.Name.LOCATION_NOT_SET));
        }
        String id = this.whereIndexer.getValue();
        if (id != null) {
            Location location = this.locationSet.getLocation(id);
            if (location != null) {
                return Optional.of(location.getDisplayName());
            }
            SyntheticLocation syntheticLocation = this.syntheticLocations.byId(id);
            if (syntheticLocation != null) {
                return Optional.of(syntheticLocation.getDisplayName());
            }
        }
        return Optional.absent();
    }

    @Override
    public Optional<String> name() {
        Optional<String> name = this.abbreviation();
        return name.isPresent() ? name : Optional.of(Messages.getMessage(Messages.Name.WORLD_TEXT));
    }

    @Override
    public JsonElement persist() {
        Persisted persisted;
        if (this.whereOptions.getSelectedItem() == QueryType.IS_NEARER_THAN) {
            Object distanceValue = this.distanceField.getValue();
            persisted = new Persisted((QueryType)((Object)this.whereOptions.getSelectedItem()), this.whereIndexer.getValue(), (VisitInfoPanel.MilesOrKilometers)((Object)this.milesOrKilometers.getSelectedItem()), distanceValue == null ? null : (Float)distanceValue);
        } else {
            persisted = new Persisted((QueryType)((Object)this.whereOptions.getSelectedItem()), this.whereIndexer.getValue());
        }
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        this.whereOptions.setSelectedItem((Object)persisted.type);
        if (persisted.id == null) {
            this.whereIndexer.setValue(null);
        } else {
            if (this.locationSet.getLocation(persisted.id) == null && this.syntheticLocations.byId(persisted.id) == null) {
                throw new JsonSyntaxException("Unknown ID: " + persisted.id);
            }
            this.whereIndexer.setValue(persisted.id);
        }
        if (persisted.distance != null) {
            this.distanceField.setValue(persisted.distance);
        }
        if (persisted.milesOrKilometers != null) {
            this.milesOrKilometers.setSelectedItem((Object)persisted.milesOrKilometers);
        }
    }

    private void updateLocationVisibility() {
        Object selectedValue = this.whereOptions.getSelectedItem();
        this.whereIndexer.setVisible(selectedValue != QueryType.IS_NOT_SET);
        this.distanceBox.setVisible(selectedValue == QueryType.IS_NEARER_THAN);
    }

    private void resetIndexer() {
        this.whereIndexer.removeAllIndexerGroups();
        if (this.whereOptions.getSelectedItem() == QueryType.IS_NEARER_THAN) {
            this.whereIndexer.addIndexerGroup(this.idToString, this.locationsWithLatLongIndexer);
        } else {
            this.whereIndexer.addIndexerGroup(this.idToString, this.allLocationsIndexer);
        }
    }

    private static enum QueryType {
        IN(Messages.Name.LOCATION_IS_IN),
        NOT_IN(Messages.Name.LOCATION_IS_NOT_IN),
        IS(Messages.Name.LOCATION_IS),
        IS_NOT(Messages.Name.LOCATION_IS_NOT),
        IS_NEARER_THAN(Messages.Name.LOCATION_IS_NEARER_THAN),
        IS_NOT_SET(Messages.Name.LOCATION_IS_NOT_SET);

        private final Messages.Name text;

        private QueryType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class Persisted {
        QueryType type;
        String id;
        VisitInfoPanel.MilesOrKilometers milesOrKilometers;
        Float distance;

        public Persisted(QueryType type, String id) {
            this.type = type;
            this.id = id;
        }

        public Persisted(QueryType type, String id, VisitInfoPanel.MilesOrKilometers milesOrKilometers, Float distance) {
            this.type = type;
            this.id = id;
            this.milesOrKilometers = milesOrKilometers;
            this.distance = distance;
        }
    }
}

