/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.query.SyntheticLocations;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.CompositeQueryDefinition;
import com.scythebill.birdlist.ui.panels.reports.LocationQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPanel;
import com.scythebill.birdlist.ui.panels.reports.QueryPanelFactory;
import com.scythebill.birdlist.ui.panels.reports.StoredQueries;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;

class FirstSightingsQueryField
extends AbstractQueryField {
    private final LocationSet locationSet;
    private final TaxonomyStore taxonomyStore;
    private final JPanel valuePanel;
    private final JComboBox<QueryType> shouldBeOptions = new JComboBox<QueryType>(QueryType.values());
    private SyntheticLocations syntheticLocations;
    private final JLabel inLabel;
    private final QueryPanel queryPanel;
    private final QueryPanelFactory factory;
    private static final Gson GSON = new Gson();

    public FirstSightingsQueryField(LocationSet locationSet, TaxonomyStore taxonomyStore, QueryPanelFactory factory) {
        super(QueryFieldFactory.QueryFieldType.FIRST_SIGHTINGS);
        this.locationSet = locationSet;
        this.taxonomyStore = taxonomyStore;
        this.factory = factory;
        this.queryPanel = factory.newQueryPanel(ImmutableList.of(CompositeQueryDefinition.BooleanOperation.ALL, CompositeQueryDefinition.BooleanOperation.ANY), true, QueryFieldFactory.QueryFieldType.FIRST_SIGHTINGS, QueryFieldFactory.QueryFieldType.TIMES_SIGHTED);
        this.syntheticLocations = new SyntheticLocations(locationSet);
        this.inLabel = new JLabel(Messages.getMessage(Messages.Name.MY_FIRST_RECORDS_IN));
        this.inLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        JLabel shouldLabel = new JLabel(Messages.getMessage(Messages.Name.SHOULD_BE));
        this.valuePanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(this.valuePanel);
        this.valuePanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addComponent(this.inLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.queryPanel, -2, -2, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(shouldLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shouldBeOptions, -2, -2, -2)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createBaselineGroup(false, false).addComponent(this.inLabel).addComponent(this.queryPanel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createBaselineGroup(false, false).addComponent(shouldLabel).addComponent(this.shouldBeOptions)));
        this.queryPanel.addPredicateChangedListener(e -> this.firePredicateUpdated());
        this.shouldBeOptions.addActionListener(e -> this.firePredicateUpdated());
    }

    @Override
    public JComponent getComparisonChooser() {
        return null;
    }

    @Override
    public JComponent getValueField() {
        return this.valuePanel;
    }

    @Override
    public boolean isSingleLine() {
        return false;
    }

    @Override
    public QueryDefinition queryDefinition(ReportSet reportSet, Taxon.Type depth) {
        return new FirstSightingsQueryDefinition(this.queryPanel.queryDefinition(this.taxonomyStore.getTaxonomy(), depth), depth, this.taxonomyStore.getTaxonomy(), (QueryType)((Object)this.shouldBeOptions.getSelectedItem()));
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    @Override
    public Optional<String> abbreviation() {
        return Optional.absent();
    }

    @Override
    public Optional<String> name() {
        return Optional.absent();
    }

    @Override
    public JsonElement persist() {
        Persisted persisted = new Persisted((QueryType)((Object)this.shouldBeOptions.getSelectedItem()), null, this.queryPanel.persist());
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        this.shouldBeOptions.setSelectedItem((Object)persisted.type);
        if (persisted.id != null) {
            if (this.locationSet.getLocation(persisted.id) == null && this.syntheticLocations.byId(persisted.id) == null) {
                throw new JsonSyntaxException("Unknown ID: " + persisted.id);
            }
            ArrayList<CompositeQueryDefinition.BooleanOperation> operations = new ArrayList<CompositeQueryDefinition.BooleanOperation>(1);
            operations.add(CompositeQueryDefinition.BooleanOperation.ALL);
            ArrayList<QueryFieldFactory.QueryField> fields = new ArrayList<QueryFieldFactory.QueryField>(1);
            LocationQueryField field = (LocationQueryField)this.factory.newQueryFieldFactory().newField(QueryFieldFactory.QueryFieldType.LOCATION);
            fields.add(field);
            field.setIsInLocation(persisted.id);
            this.queryPanel.restore(new StoredQueries.RestoredQuery(operations, fields));
        }
        if (!Strings.isNullOrEmpty(persisted.query)) {
            this.queryPanel.restore(persisted.query);
        }
    }

    private static enum QueryType {
        HIGHLIGHTED(Messages.Name.FIRST_RECORDS_HIGHLIGHTED),
        INCLUDED(Messages.Name.FIRST_RECORDS_INCLUDED);

        private final Messages.Name text;

        private QueryType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class FirstSightingsQueryDefinition
    implements QueryDefinition,
    QueryDefinition.Preprocessor,
    Predicate<Sighting> {
        private static final Ordering<Sighting> PREFERRED_SIGHTING = SightingComparators.preferEarlier();
        private final Map<SightingTaxon, Sighting> liferSightings = Maps.newHashMapWithExpectedSize(5000);
        private final Taxon.Type depth;
        private final Taxonomy taxonomy;
        private final QueryType queryType;
        private final Predicate<Sighting> predicate;

        public FirstSightingsQueryDefinition(QueryDefinition queryDefinition, Taxon.Type depth, Taxonomy taxonomy, QueryType queryType) {
            this.predicate = queryDefinition.predicate();
            this.depth = depth;
            this.taxonomy = taxonomy;
            this.queryType = queryType;
        }

        @Override
        public Optional<QueryDefinition.Preprocessor> preprocessor() {
            return Optional.of(this);
        }

        @Override
        public Predicate<Sighting> predicate() {
            if (this.queryType == QueryType.HIGHLIGHTED) {
                return Predicates.alwaysTrue();
            }
            return this;
        }

        @Override
        public boolean apply(Sighting sighting) {
            if (!TaxonUtils.areCompatible(this.taxonomy, sighting.getTaxonomy())) {
                return false;
            }
            SightingTaxon taxon = this.toDepth(sighting.getTaxon());
            if (taxon == null) {
                return false;
            }
            return this.liferSightings.get(taxon) == sighting;
        }

        @Override
        public void reset() {
            this.liferSightings.clear();
        }

        @Override
        public void preprocess(Sighting sighting, Predicate<Sighting> countablePredicate) {
            if (countablePredicate != null && !countablePredicate.apply(sighting)) {
                return;
            }
            if (this.predicate.apply(sighting)) {
                SightingTaxon.Resolved resolved = sighting.getTaxon().resolve(this.taxonomy);
                if (this.queryType == QueryType.INCLUDED) {
                    SightingTaxon taxon = this.toDepth(sighting.getTaxon());
                    this.preprocess(taxon, sighting);
                } else {
                    SightingTaxon taxon = resolved.getSightingTaxon();
                    SightingTaxon groupTaxon = resolved.getParentOfAtLeastType(Taxon.Type.group);
                    SightingTaxon speciesTaxon = resolved.getParentOfAtLeastType(Taxon.Type.species);
                    this.preprocess(speciesTaxon, sighting);
                    if (!groupTaxon.equals(speciesTaxon)) {
                        this.preprocess(groupTaxon, sighting);
                    }
                    if (!taxon.equals(groupTaxon)) {
                        this.preprocess(taxon, sighting);
                    }
                }
            }
        }

        private void preprocess(SightingTaxon taxon, Sighting sighting) {
            if (this.isPossibleLiferTaxon(taxon)) {
                Sighting existing = this.liferSightings.get(taxon);
                if (existing != null && PREFERRED_SIGHTING.compare(existing, sighting) >= 0) {
                    return;
                }
                this.liferSightings.put(taxon, sighting);
            }
        }

        private SightingTaxon toDepth(SightingTaxon taxon) {
            SightingTaxon.Resolved resolved = taxon.resolve(this.taxonomy);
            return resolved.getParentOfAtLeastType(this.depth);
        }

        @Override
        public Optional<QueryDefinition.QueryAnnotation> annotate(Sighting sighting, SightingTaxon taxon) {
            if (this.queryType == QueryType.INCLUDED) {
                return Optional.absent();
            }
            if (this.liferSightings.get(taxon) == sighting) {
                return Optional.of(QueryDefinition.QueryAnnotation.LIFER);
            }
            return Optional.absent();
        }

        private boolean isPossibleLiferTaxon(SightingTaxon taxon) {
            return taxon != null && (taxon.getType() == SightingTaxon.Type.SINGLE || taxon.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES);
        }
    }

    static class Persisted {
        QueryType type;
        String id;
        String query;

        public Persisted(QueryType type, String id, String query) {
            this.type = type;
            this.id = id;
            this.query = query;
        }
    }
}

