/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.FamilyReportPreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Component;
import javax.annotation.Nullable;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

class FamilyReportDialog {
    private Alerts alerts;
    private FamilyReportPreferences familyReportPreferences;
    private FontManager fontManager;
    private NamesPreferences namesPreferences;

    @Inject
    FamilyReportDialog(Alerts alerts, FamilyReportPreferences familyReportPreferences, NamesPreferences namesPreferences, FontManager fontManager) {
        this.alerts = alerts;
        this.familyReportPreferences = familyReportPreferences;
        this.namesPreferences = namesPreferences;
        this.fontManager = fontManager;
    }

    @Nullable
    public FamilyReportPreferences getConfiguration(Component parent) {
        FamilyReportConfigurationPanel panel = new FamilyReportConfigurationPanel();
        this.fontManager.applyTo(panel);
        String formattedMessage = this.alerts.getFormattedDialogMessage(Messages.Name.FAMILY_REPORT_OPTIONS, Messages.Name.FAMILY_REPORT_OPTIONS_MESSAGE, new Object[0]);
        int okCancel = this.alerts.showOkCancelWithPanel(SwingUtilities.getWindowAncestor(parent), formattedMessage, panel);
        if (okCancel != 0) {
            return null;
        }
        panel.updatePreferences();
        return this.familyReportPreferences;
    }

    public NamesPreferences.ScientificOrCommon getScientificOrCommonFromConfiguration(FamilyReportPreferences prefs) {
        NamesPreferences.ScientificOrCommon scientificOrCommon = this.namesPreferences.scientificOrCommon;
        if (prefs.includeScientific) {
            if (scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_ONLY) {
                return NamesPreferences.ScientificOrCommon.COMMON_FIRST;
            }
        } else {
            switch (scientificOrCommon) {
                case SCIENTIFIC_ONLY: 
                case COMMON_FIRST: 
                case SCIENTIFIC_FIRST: {
                    return NamesPreferences.ScientificOrCommon.COMMON_ONLY;
                }
            }
        }
        return scientificOrCommon;
    }

    class FamilyReportConfigurationPanel
    extends JPanel {
        private JCheckBox includeScientific;
        private JLabel sortByLabel;
        private JComboBox<FamilyReportPreferences.SortBy> sortByCombobox;

        FamilyReportConfigurationPanel() {
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            this.includeScientific = new JCheckBox(Messages.getMessage(Messages.Name.SCIENTIFIC_NAME_QUESTION));
            this.includeScientific.setSelected(FamilyReportDialog.this.familyReportPreferences.includeScientific);
            if (FamilyReportDialog.this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_ONLY) {
                this.includeScientific.setSelected(false);
            } else if (FamilyReportDialog.this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.SCIENTIFIC_ONLY) {
                this.includeScientific.setSelected(true);
            }
            this.sortByLabel = new JLabel(Messages.getMessage(Messages.Name.SORT_BY));
            this.sortByCombobox = new JComboBox<FamilyReportPreferences.SortBy>(FamilyReportPreferences.SortBy.values());
            this.sortByCombobox.setSelectedItem((Object)FamilyReportDialog.this.familyReportPreferences.sortBy);
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.includeScientific).addGroup(layout.createSequentialGroup().addComponent(this.sortByLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sortByCombobox)));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.includeScientific).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.sortByLabel).addComponent(this.sortByCombobox)));
        }

        void updatePreferences() {
            FamilyReportDialog.this.familyReportPreferences.includeScientific = this.includeScientific.isSelected();
            FamilyReportDialog.this.familyReportPreferences.sortBy = (FamilyReportPreferences.SortBy)((Object)this.sortByCombobox.getSelectedItem());
        }
    }
}

