/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

class FamilyQueryField
extends AbstractQueryField {
    private final IndexerPanel<String> familyIndexer;
    private final TaxonomyStore taxonomyStore;
    private final JPanel noComparison;
    private static final Gson GSON = new Gson();

    public FamilyQueryField(TaxonomyStore taxonomyStore) {
        super(QueryFieldFactory.QueryFieldType.FAMILY);
        this.taxonomyStore = taxonomyStore;
        this.familyIndexer = new IndexerPanel();
        this.familyIndexer.setPreviewText(Messages.Name.START_TYPING_A_FAMILY);
        this.noComparison = new JPanel();
        this.attachIndexers();
        this.familyIndexer.addPropertyChangeListener("value", e -> this.firePredicateUpdated());
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.noComparison;
    }

    @Override
    public JComponent getValueField() {
        return this.familyIndexer;
    }

    @Override
    public Predicate<Sighting> predicate(Taxon.Type depth) {
        String id = this.familyIndexer.getValue();
        if (id == null) {
            return Predicates.alwaysTrue();
        }
        Taxon family = this.taxonomyStore.getTaxonomy().getTaxon(id);
        if (family == null) {
            return Predicates.alwaysFalse();
        }
        return sighting -> {
            if (!TaxonUtils.areCompatible(this.taxonomyStore.getTaxonomy(), sighting.getTaxonomy())) {
                return false;
            }
            SightingTaxon.Resolved resolved = sighting.getTaxon().resolve(this.taxonomyStore.getTaxonomy());
            Taxon taxon = resolved.getTaxa().iterator().next();
            return TaxonUtils.isChildOf(family, taxon);
        };
    }

    @Override
    public boolean isNoOp() {
        return this.familyIndexer.getValue() == null;
    }

    @Override
    public Optional<String> abbreviation() {
        String id = this.familyIndexer.getValue();
        if (id != null) {
            Taxon taxon = this.taxonomyStore.getTaxonomy().getTaxon(id);
            if (taxon == null) {
                return Optional.absent();
            }
            if (taxon.getCommonName() != null) {
                return Optional.of(taxon.getCommonName());
            }
            return Optional.of(taxon.getName());
        }
        return Optional.absent();
    }

    @Override
    public Optional<String> name() {
        return this.abbreviation();
    }

    @Override
    public JsonElement persist() {
        Persisted persisted = new Persisted(this.familyIndexer.getValue());
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        if (persisted.id == null) {
            this.familyIndexer.setValue(null);
        } else {
            this.familyIndexer.setValue(persisted.id);
        }
    }

    @Override
    public void taxonomyUpdated() {
        this.attachIndexers();
    }

    private void attachIndexers() {
        String value = this.familyIndexer.getValue();
        final Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        boolean resetIndexer = taxonomy.getTaxon(value) == null;
        Indexer familyCommonNames = new Indexer();
        Indexer familySciNames = new Indexer();
        TaxonUtils.visitTaxa(taxonomy, taxon -> {
            if (taxon.getType() == Taxon.Type.family) {
                if (taxon.getCommonName() != null) {
                    familyCommonNames.add(taxon.getCommonName(), taxon.getId());
                }
                familySciNames.add(taxon.getName(), taxon.getId());
                return false;
            }
            return true;
        });
        ToString<String> commonNameToString = new ToString<String>(){

            @Override
            public String getString(String o) {
                Taxon taxon = taxonomy.getTaxon(o);
                if (taxon == null) {
                    return Messages.getMessage(Messages.Name.NO_FAMILY);
                }
                return taxon.getCommonName() == null ? taxon.getName() : taxon.getCommonName();
            }

            @Override
            public String getPreviewString(String o) {
                return this.getString(o);
            }
        };
        ToString<String> sciNameToString = new ToString<String>(){

            @Override
            public String getString(String o) {
                Taxon taxon = taxonomy.getTaxon(o);
                if (taxon == null) {
                    return Messages.getMessage(Messages.Name.NO_FAMILY);
                }
                return taxon.getName();
            }

            @Override
            public String getPreviewString(String o) {
                return this.getString(o);
            }
        };
        this.familyIndexer.removeAllIndexerGroups();
        this.familyIndexer.addIndexerGroup(commonNameToString, familyCommonNames);
        this.familyIndexer.addIndexerGroup(sciNameToString, familySciNames);
        if (resetIndexer) {
            this.familyIndexer.setTextValue("");
        }
    }

    static class Persisted {
        String id;

        public Persisted(String id) {
            this.id = id;
        }
    }
}

