/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.ExtendedTaxonomyChecklists;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.actions.IdentifyLifersFromChecklistsAction;
import com.scythebill.birdlist.ui.actions.ReturnAction;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.ShrinkToFit;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;

public class ExtendedReportMenuPanel
extends JPanel
implements FontManager.FontsUpdatedListener,
ShrinkToFit,
Titled {
    private JButton returnButton;
    private JButton bigDaysAndYears;
    private JButton yearComparison;
    private JButton identifyLifers;
    private JButton totalTicks;
    private JPanel centerBox;
    private JLabel extendedReportLabel;
    private JLabel bigDaysAndYearsLabel;
    private JLabel yearComparisonLabel;
    private JLabel identifyLifersLabel;
    private JLabel emptyLabel;
    private final FontManager fontManager;
    private JLabel totalTicksLabel;
    private TaxonomyStore taxonomyStore;
    private JButton splitsAndLumps;
    private JLabel splitsAndLumpsLabel;
    private final ReportSet reportSet;
    private JLabel identifyFamilyLifersLabel;
    private JButton identifyFamilyLifers;

    @Inject
    public ExtendedReportMenuPanel(ReturnAction returnAction, IdentifyLifersFromChecklistsAction identifyLifersFromChecklistsAction, NavigableFrame navigableFrame, FontManager fontManager, EventBusRegistrar eventBusRegistrar, TaxonomyStore taxonomyStore, ReportSet reportSet) {
        this.fontManager = fontManager;
        this.taxonomyStore = taxonomyStore;
        this.reportSet = reportSet;
        this.initGUI();
        this.returnButton.setAction(returnAction);
        this.bigDaysAndYears.addActionListener(e -> navigableFrame.navigateTo("bigDay"));
        this.yearComparison.addActionListener(e -> navigableFrame.navigateTo("yearComparison"));
        this.splitsAndLumps.addActionListener(e -> navigableFrame.navigateTo("splitsAndLumps"));
        this.totalTicks.addActionListener(e -> navigableFrame.navigateTo("totalTicks"));
        this.identifyLifers.addActionListener(e -> identifyLifersFromChecklistsAction.showMap(Taxon.Type.species));
        this.identifyFamilyLifers.addActionListener(e -> identifyLifersFromChecklistsAction.showMap(Taxon.Type.family));
        this.returnButton.setAction(returnAction);
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.taxonomyChanged(null);
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.centerBox = new JPanel();
        this.add(this.centerBox);
        this.extendedReportLabel = new JLabel(Messages.getMessage(Messages.Name.SPECIAL_REPORTS_TITLE));
        this.extendedReportLabel.putClientProperty("birdlist.plainLabel", true);
        this.bigDaysAndYears = new JButton();
        this.bigDaysAndYears.setText(Messages.getMessage(Messages.Name.BIG_DAYS_MONTHS_YEARS));
        this.yearComparison = new JButton();
        this.yearComparison.setText(Messages.getMessage(Messages.Name.YEAR_COMPARISONS));
        this.totalTicks = new JButton();
        this.totalTicks.setText(Messages.getMessage(Messages.Name.TOTAL_TICKS));
        this.identifyLifers = new JButton();
        this.identifyLifers.setText(Messages.getMessage(Messages.Name.WORLD_LIFER_MAP));
        this.identifyFamilyLifers = new JButton();
        this.identifyFamilyLifers.setText(Messages.getMessage(Messages.Name.WORLD_FAMILY_LIFER_MAP));
        this.splitsAndLumps = new JButton();
        this.splitsAndLumps.setText(Messages.getMessage(Messages.Name.SPLITS_AND_LUMPS));
        this.returnButton = new JButton();
        this.bigDaysAndYearsLabel = new JLabel(Messages.getMessage(Messages.Name.BIG_DAYS_MONTHS_YEARS_EXPLANATION));
        this.bigDaysAndYearsLabel.putClientProperty("birdlist.plainLabel", true);
        this.yearComparisonLabel = new JLabel(Messages.getMessage(Messages.Name.YEAR_COMPARISONS_EXPLANATION));
        this.yearComparisonLabel.putClientProperty("birdlist.plainLabel", true);
        this.totalTicksLabel = new JLabel(Messages.getMessage(Messages.Name.TOTAL_TICKS_EXPLANATION));
        this.totalTicksLabel.putClientProperty("birdlist.plainLabel", true);
        this.identifyLifersLabel = new JLabel(Messages.getMessage(Messages.Name.WORLD_LIFER_MAP_EXPLANATION));
        this.identifyLifersLabel.putClientProperty("birdlist.plainLabel", true);
        this.identifyFamilyLifersLabel = new JLabel(Messages.getMessage(Messages.Name.WORLD_FAMILY_LIFER_MAP_EXPLANATION));
        this.identifyFamilyLifersLabel.putClientProperty("birdlist.plainLabel", true);
        this.splitsAndLumpsLabel = new JLabel(Messages.getMessage(Messages.Name.SPLITS_AND_LUMPS_EXPLANATION));
        this.splitsAndLumpsLabel.putClientProperty("birdlist.plainLabel", true);
        this.emptyLabel = new JLabel();
        this.fontManager.applyTo(this);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.centerBox.setPreferredSize(fontManager.scale(new Dimension(700, 600)));
        this.centerBox.setMinimumSize(this.centerBox.getPreferredSize());
        this.centerBox.setBorder(new EmptyBorder(fontManager.scale(20), fontManager.scale(60), fontManager.scale(20), fontManager.scale(60)));
        GroupLayout layout = new GroupLayout(this.centerBox);
        this.centerBox.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addComponent(this.extendedReportLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.bigDaysAndYears, GroupLayout.Alignment.LEADING, -2, fontManager.scale(174), -2).addComponent(this.totalTicks, GroupLayout.Alignment.LEADING, -2, fontManager.scale(174), -2).addComponent(this.yearComparison, GroupLayout.Alignment.LEADING, -2, fontManager.scale(174), -2).addComponent(this.splitsAndLumps, GroupLayout.Alignment.LEADING, -2, fontManager.scale(174), -2).addComponent(this.identifyLifers, GroupLayout.Alignment.LEADING, -2, fontManager.scale(174), -2).addComponent(this.identifyFamilyLifers, GroupLayout.Alignment.LEADING, -2, fontManager.scale(174), -2).addComponent(this.returnButton, GroupLayout.Alignment.LEADING, -2, fontManager.scale(174), -2)).addGap(63).addGroup(layout.createParallelGroup().addComponent(this.bigDaysAndYearsLabel).addComponent(this.totalTicksLabel).addComponent(this.yearComparisonLabel).addComponent(this.splitsAndLumpsLabel).addComponent(this.identifyLifersLabel).addComponent(this.identifyFamilyLifersLabel).addComponent(this.emptyLabel)))).addContainerGap(67, 67));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.extendedReportLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.bigDaysAndYears, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.bigDaysAndYearsLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.totalTicks, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.totalTicksLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.yearComparison, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.yearComparisonLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.splitsAndLumps, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.splitsAndLumpsLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.identifyLifers, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.identifyLifersLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.identifyFamilyLifers, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.identifyFamilyLifersLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.returnButton, GroupLayout.Alignment.BASELINE, -2, fontManager.scale(58), -2).addComponent(this.emptyLabel)).addContainerGap(82, 82));
        layout.linkSize(this.bigDaysAndYears, this.totalTicks, this.identifyLifers, this.returnButton);
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        ExtendedTaxonomyChecklists checklists;
        boolean hasChecklists = this.taxonomyStore.getTaxonomy().isBuiltIn() ? true : (checklists = this.reportSet.getExtendedTaxonomyChecklist(this.taxonomyStore.getTaxonomy().getId())) != null && !checklists.getChecklists().isEmpty();
        this.identifyLifers.setEnabled(hasChecklists);
        this.splitsAndLumps.setEnabled(this.taxonomyStore.getTaxonomy().isBuiltIn());
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.SPECIAL_REPORTS);
    }
}

