/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.scythebill.birdlist.model.export.EBirdCsvExport;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.reports.QueryExecutor;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileNameExtensionFilter;

class EbirdExportAction
extends AbstractAction {
    private final QueryExecutor queryExecutor;
    private final FileDialogs fileDialogs;
    private final ReportSet reportSet;
    private final Taxonomy clements;
    private final Alerts alerts;

    public EbirdExportAction(FileDialogs fileDialogs, ReportSet reportSet, QueryExecutor queryExecutor, @Clements Taxonomy clements, Alerts alerts) {
        this.fileDialogs = fileDialogs;
        this.reportSet = reportSet;
        this.queryExecutor = queryExecutor;
        this.clements = clements;
        this.alerts = alerts;
    }

    private static Frame getParentFrame(Object object) {
        for (Component c = (Component)object; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Frame parentFrame = EbirdExportAction.getParentFrame(event.getSource());
        QueryResults queryResults = this.queryExecutor.executeQuery(Taxon.Type.group, this.clements);
        if (Iterables.isEmpty(queryResults.getAllSightings())) {
            return;
        }
        boolean isAnyAcceptableSighting = false;
        for (Sighting sighting : queryResults.getAllSightings()) {
            if (!EBirdCsvExport.isAcceptableEBirdRecord(sighting, this.reportSet)) continue;
            isAnyAcceptableSighting = true;
            break;
        }
        if (!isAnyAcceptableSighting) {
            this.alerts.showMessage((Object)parentFrame, Messages.Name.NO_SIGHTINGS_TO_EXPORT, Messages.Name.NO_SIGHTINGS_SUFFICIENTLY_DETAILED, new Object[0]);
            return;
        }
        Optional<String> reportName = this.queryExecutor.getReportAbbreviation();
        String fileName = reportName.isPresent() ? String.format("eBird-export-%s.csv", reportName.get()) : "eBird-export.csv";
        File file = this.fileDialogs.saveFile(parentFrame, Messages.getMessage(Messages.Name.SAVE_FOR_EBIRD), fileName, new FileNameExtensionFilter(Messages.getMessage(Messages.Name.CSV_FILES), "csv"), FilePreferences.FileType.OTHER);
        if (file != null) {
            ArrayList<Sighting> sightings = Lists.newArrayList(queryResults.getAllSightings());
            Collections.sort(sightings, SightingComparators.preferEarlier().compound(SightingComparators.inTaxonomicOrder(this.clements)).reversed());
            Iterator<Sighting> sightingIterator = sightings.iterator();
            int loopCount = 0;
            File out = file;
            do {
                ByteSink outSupplier = Files.asByteSink(out, new FileWriteMode[0]);
                try {
                    new EBirdCsvExport(this.clements).writeSpeciesList(outSupplier, sightingIterator, queryResults, this.reportSet);
                }
                catch (IOException e) {
                    FileDialogs.showFileSaveError(this.alerts, e, out);
                    break;
                }
                if (!sightingIterator.hasNext()) continue;
                try {
                    out = this.getAuxiliaryFile(file, ++loopCount);
                }
                catch (IOException e) {
                    this.alerts.showError(null, Messages.Name.SAVING_FAILED_TITLE, Messages.Name.FILE_WAS_TOO_LONG, new Object[0]);
                    break;
                }
            } while (sightingIterator.hasNext());
        }
    }

    private File getAuxiliaryFile(File base, int loopCount) throws IOException {
        Object name = base.getName();
        int periodIndex = ((String)name).lastIndexOf(46);
        name = periodIndex < 0 ? (String)name + "-" + loopCount : ((String)name).substring(0, periodIndex) + "-" + loopCount + ((String)name).substring(periodIndex);
        File auxiliary = new File(base.getParent(), (String)name);
        if (!auxiliary.exists() && !auxiliary.createNewFile()) {
            throw new IOException("Could not create file");
        }
        return auxiliary;
    }
}

