/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.query.QueryProcessor;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.panels.reports.EbirdExportAction;
import com.scythebill.birdlist.ui.panels.reports.QueryExecutor;
import com.scythebill.birdlist.ui.panels.reports.ReportHints;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.annotation.Nullable;
import org.joda.time.ReadablePartial;

public class EBirdDirectExporter {
    private final FileDialogs fileDialogs;
    private final ReportSet reportSet;
    private final Taxonomy clements;
    private final Alerts alerts;

    @Inject
    public EBirdDirectExporter(FileDialogs fileDialogs, ReportSet reportSet, @Clements Taxonomy clements, Alerts alerts) {
        this.fileDialogs = fileDialogs;
        this.reportSet = reportSet;
        this.clements = clements;
        this.alerts = alerts;
    }

    public void doExport(Component parent, final Location location, final ReadablePartial date, final @Nullable ReadablePartial time, final @Nullable ReadablePartial endDate) {
        QueryExecutor queryExecutor = new QueryExecutor(){

            @Override
            public Location getRootLocation() {
                return location;
            }

            @Override
            public Set<ReportHints> getReportHints() {
                return ImmutableSet.of();
            }

            @Override
            public Optional<String> getReportAbbreviation() {
                if (time == null) {
                    return Optional.of(String.format("%s-%s", location.getDisplayName(), PartialIO.toString(date)));
                }
                return Optional.of(String.format("%s-%s-%s", location.getDisplayName(), PartialIO.toString(date), TimeIO.toFileString(time)));
            }

            @Override
            public Optional<String> getReportName() {
                return this.getReportAbbreviation();
            }

            @Override
            public QueryResults executeQuery(Taxon.Type depthOverride, Taxonomy taxonomyOverride) {
                Predicate<Sighting> sightingPredicate;
                QueryProcessor queryProcessor = new QueryProcessor(EBirdDirectExporter.this.reportSet, taxonomyOverride);
                if (endDate == null) {
                    sightingPredicate = Predicates.and(SightingPredicates.is(location, EBirdDirectExporter.this.reportSet.getLocations()), SightingPredicates.dateIsExactly(date));
                    if (time != null) {
                        sightingPredicate = Predicates.and(sightingPredicate, SightingPredicates.timeIsExactly(time));
                    }
                } else {
                    sightingPredicate = Predicates.and(SightingPredicates.is(location, EBirdDirectExporter.this.reportSet.getLocations()), new Predicate<Sighting>(){

                        @Override
                        public boolean apply(Sighting sighting) {
                            return date.equals(sighting.getStartDateAsPartial()) && endDate.equals(sighting.getEndDateAsPartial());
                        }
                    });
                }
                Predicate<Sighting> countablePredicate = Predicates.alwaysTrue();
                return queryProcessor.runQuery(sightingPredicate, countablePredicate, depthOverride);
            }

            @Override
            public QueryExecutor onlyCountable() {
                throw new UnsupportedOperationException();
            }

            @Override
            public QueryExecutor includeIncompatibleSightings() {
                throw new UnsupportedOperationException();
            }
        };
        new EbirdExportAction(this.fileDialogs, this.reportSet, queryExecutor, this.clements, this.alerts).actionPerformed(new ActionEvent(parent, 0, ""));
    }
}

