/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.components.DatePanel;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;

class DateQueryField
extends AbstractQueryField {
    private final JComboBox<QueryType> whenOptions = new JComboBox<QueryType>(QueryType.values());
    private final DatePanel fromDatePanel = new DatePanel();
    private final DatePanel toDatePanel = new DatePanel();
    private final JPanel valuePanel;
    private static final Gson GSON = new Gson();

    public DateQueryField() {
        super(QueryFieldFactory.QueryFieldType.DATE);
        this.whenOptions.addActionListener(e -> {
            this.updateDateVisibility();
            this.firePredicateUpdated();
        });
        this.valuePanel = new JPanel();
        BoxLayout box = new BoxLayout(this.valuePanel, 1);
        this.valuePanel.setLayout(box);
        this.valuePanel.add(this.fromDatePanel);
        this.valuePanel.add(this.toDatePanel);
        this.updateDateVisibility();
        PropertyChangeListener setDatePredicateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (((DatePanel)evt.getSource()).isVisible()) {
                    DateQueryField.this.firePredicateUpdated();
                }
            }
        };
        this.fromDatePanel.addPropertyChangeListener("value", setDatePredicateListener);
        this.toDatePanel.addPropertyChangeListener("value", setDatePredicateListener);
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.whenOptions;
    }

    @Override
    public JComponent getValueField() {
        return this.valuePanel;
    }

    @Override
    public boolean isSingleLine() {
        return false;
    }

    @Override
    public Predicate<Sighting> predicate(Taxon.Type depth) {
        QueryType whenOption = (QueryType)((Object)this.whenOptions.getSelectedItem());
        if (QueryType.TODAY.equals((Object)whenOption)) {
            final LocalDate now = new LocalDate(GJChronology.getInstance());
            return new Predicate<Sighting>(){

                @Override
                public boolean apply(Sighting sighting) {
                    ReadablePartial date = sighting.getSingleDateAsPartial();
                    if (date == null) {
                        return false;
                    }
                    if (!(date.isSupported(DateTimeFieldType.dayOfMonth()) && date.isSupported(DateTimeFieldType.monthOfYear()) && date.isSupported(DateTimeFieldType.year()))) {
                        return false;
                    }
                    return date.get(DateTimeFieldType.dayOfMonth()) == now.getDayOfMonth() && date.get(DateTimeFieldType.monthOfYear()) == now.getMonthOfYear() && date.get(DateTimeFieldType.year()) == now.getYear();
                }
            };
        }
        if (QueryType.THIS_YEAR.equals((Object)whenOption)) {
            final LocalDate now = new LocalDate(GJChronology.getInstance());
            return new Predicate<Sighting>(){

                @Override
                public boolean apply(Sighting sighting) {
                    ReadablePartial date = sighting.getStartDateAsPartial();
                    if (date == null) {
                        return false;
                    }
                    if (!date.isSupported(DateTimeFieldType.year())) {
                        return false;
                    }
                    if (date.get(DateTimeFieldType.year()) != now.getYear()) {
                        return false;
                    }
                    ReadablePartial endDate = sighting.getEndDateAsPartial();
                    if (date == endDate) {
                        return true;
                    }
                    if (endDate == null) {
                        return false;
                    }
                    if (!endDate.isSupported(DateTimeFieldType.year())) {
                        return false;
                    }
                    return endDate.get(DateTimeFieldType.year()) == now.getYear();
                }
            };
        }
        if (QueryType.NOT_SET.equals((Object)whenOption)) {
            return sighting -> sighting.getStoredDateAsPartial() == null;
        }
        if (QueryType.BETWEEN.equals((Object)whenOption)) {
            ReadablePartial from = this.fromDatePanel.getValue();
            ReadablePartial to = this.toDatePanel.getValue();
            if (from != null && to != null && !to.isSupported(DateTimeFieldType.year()) && !from.isSupported(DateTimeFieldType.year()) && SightingComparators.comparePartials(to, from) < 0) {
                return Predicates.or(SightingPredicates.afterOrEquals(from), SightingPredicates.beforeOrEquals(to));
            }
        }
        Predicate<Sighting> fromPredicate = this.getFromPredicate(whenOption);
        Predicate<Sighting> toPredicate = this.getToPredicate(whenOption);
        if (fromPredicate == null) {
            return toPredicate == null ? Predicates.alwaysTrue() : toPredicate;
        }
        if (toPredicate == null) {
            return fromPredicate;
        }
        if (QueryType.NOT_DURING == whenOption) {
            return Predicates.not(Predicates.and(fromPredicate, toPredicate));
        }
        return Predicates.and(fromPredicate, toPredicate);
    }

    private Predicate<Sighting> getToPredicate(QueryType whenOption) {
        Predicate<Sighting> toPredicate = null;
        if (QueryType.BETWEEN == whenOption || QueryType.BEFORE == whenOption || QueryType.DURING == whenOption || QueryType.NOT_DURING == whenOption) {
            ReadablePartial to;
            ReadablePartial readablePartial = to = QueryType.DURING == whenOption || QueryType.NOT_DURING == whenOption ? this.fromDatePanel.getValue() : this.toDatePanel.getValue();
            if (to != null) {
                toPredicate = whenOption == QueryType.BEFORE ? SightingPredicates.before(to) : SightingPredicates.beforeOrEquals(to);
            }
        }
        return toPredicate;
    }

    private Predicate<Sighting> getFromPredicate(QueryType whenOption) {
        ReadablePartial after;
        Predicate<Sighting> fromPredicate = null;
        if ((QueryType.BETWEEN == whenOption || QueryType.AFTER == whenOption || QueryType.DURING == whenOption || QueryType.NOT_DURING == whenOption) && (after = this.fromDatePanel.getValue()) != null) {
            fromPredicate = whenOption == QueryType.AFTER ? SightingPredicates.after(after) : SightingPredicates.afterOrEquals(after);
        }
        return fromPredicate;
    }

    @Override
    public boolean isNoOp() {
        QueryType whenOption = (QueryType)((Object)this.whenOptions.getSelectedItem());
        Predicate<Sighting> fromPredicate = this.getFromPredicate(whenOption);
        Predicate<Sighting> toPredicate = this.getToPredicate(whenOption);
        return fromPredicate == null && toPredicate == null;
    }

    private void updateDateVisibility() {
        Object selectedValue = this.whenOptions.getSelectedItem();
        this.toDatePanel.setVisible(QueryType.BETWEEN.equals(selectedValue) || QueryType.BEFORE.equals(selectedValue));
        this.fromDatePanel.setVisible(QueryType.BETWEEN.equals(selectedValue) || QueryType.AFTER.equals(selectedValue) || QueryType.DURING.equals(selectedValue) || QueryType.NOT_DURING.equals(selectedValue));
    }

    @Override
    public Optional<String> name() {
        ReadablePartial to;
        Object selectedValue = this.whenOptions.getSelectedItem();
        if (QueryType.THIS_YEAR == selectedValue) {
            return Optional.of(Messages.getMessage(Messages.Name.DATE_YEAR));
        }
        if (QueryType.TODAY == selectedValue) {
            return Optional.of(Messages.getMessage(Messages.Name.DATE_TODAY));
        }
        if (QueryType.NOT_SET == selectedValue) {
            return Optional.of(Messages.getMessage(Messages.Name.DATE_NOT_SET));
        }
        if (QueryType.DURING == selectedValue) {
            ReadablePartial from = this.fromDatePanel.getValue();
            if (from != null) {
                return Optional.of(PartialIO.toShortUserString(from, Locale.getDefault()));
            }
        } else if (QueryType.NOT_DURING == selectedValue) {
            ReadablePartial from = this.fromDatePanel.getValue();
            if (from != null) {
                return Optional.of(Messages.getFormattedMessage(Messages.Name.DATE_NOT_FORMAT, PartialIO.toShortUserString(from, Locale.getDefault())));
            }
        } else if (QueryType.AFTER == selectedValue) {
            ReadablePartial from = this.fromDatePanel.getValue();
            if (from != null) {
                return Optional.of(Messages.getFormattedMessage(Messages.Name.DATE_AFTER_FORMAT, PartialIO.toShortUserString(from, Locale.getDefault())));
            }
        } else if (QueryType.BEFORE == selectedValue && (to = this.toDatePanel.getValue()) != null) {
            return Optional.of(Messages.getFormattedMessage(Messages.Name.DATE_BEFORE_FORMAT, PartialIO.toShortUserString(to, Locale.getDefault())));
        }
        return Optional.absent();
    }

    @Override
    public Optional<String> abbreviation() {
        Object selectedValue = this.whenOptions.getSelectedItem();
        if (QueryType.BETWEEN.equals(selectedValue)) {
            ReadablePartial from = this.fromDatePanel.getValue();
            ReadablePartial to = this.toDatePanel.getValue();
            if (from == null) {
                if (to != null) {
                    return Optional.of(PartialIO.toString(to));
                }
            } else {
                if (to == null) {
                    return Optional.of(PartialIO.toString(from));
                }
                if (from.isSupported(DateTimeFieldType.year()) && to.isSupported(DateTimeFieldType.year())) {
                    int toYear;
                    int fromYear = from.get(DateTimeFieldType.year());
                    if (fromYear == (toYear = to.get(DateTimeFieldType.year()))) {
                        return Optional.of(Integer.toString(fromYear));
                    }
                    return Optional.of(String.format("%s-%s", fromYear, toYear));
                }
            }
            return Optional.absent();
        }
        if (QueryType.AFTER.equals(selectedValue) || QueryType.DURING.equals(selectedValue) || QueryType.NOT_DURING.equals(selectedValue)) {
            ReadablePartial from = this.fromDatePanel.getValue();
            if (from != null) {
                return Optional.of(PartialIO.toString(from));
            }
        } else if (QueryType.BEFORE.equals(selectedValue)) {
            ReadablePartial to = this.fromDatePanel.getValue();
            if (to != null) {
                return Optional.of(PartialIO.toString(to));
            }
        } else {
            if (QueryType.TODAY.equals(selectedValue)) {
                return Optional.of(PartialIO.toString(new LocalDate(GJChronology.getInstance())));
            }
            if (QueryType.THIS_YEAR.equals(selectedValue)) {
                LocalDate today = new LocalDate(GJChronology.getInstance());
                return Optional.of(Integer.toString(today.getYear()));
            }
        }
        return Optional.absent();
    }

    @Override
    public JsonElement persist() {
        Persisted persisted = new Persisted((QueryType)((Object)this.whenOptions.getSelectedItem()), this.toStringMaybeNull(this.fromDatePanel.getValue()), this.toStringMaybeNull(this.toDatePanel.getValue()));
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        this.whenOptions.setSelectedItem((Object)persisted.type);
        this.fromDatePanel.setValue(this.fromStringMaybeNull(persisted.from));
        this.toDatePanel.setValue(this.fromStringMaybeNull(persisted.to));
    }

    private String toStringMaybeNull(ReadablePartial partial) {
        return partial == null || partial.size() == 0 ? null : PartialIO.toString(partial);
    }

    private ReadablePartial fromStringMaybeNull(String string) {
        return string == null ? null : PartialIO.fromString(string);
    }

    private static enum QueryType {
        DURING(Messages.Name.DATE_IS_DURING),
        BETWEEN(Messages.Name.DATE_IS_BETWEEN),
        AFTER(Messages.Name.DATE_IS_AFTER),
        BEFORE(Messages.Name.DATE_IS_BEFORE),
        THIS_YEAR(Messages.Name.DATE_IS_THIS_YEAR),
        TODAY(Messages.Name.DATE_IS_TODAY),
        NOT_DURING(Messages.Name.DATE_IS_NOT_DURING),
        NOT_SET(Messages.Name.DATE_IS_NOT_SET);

        private final Messages.Name text;

        private QueryType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class Persisted {
        QueryType type;
        String from;
        String to;

        public Persisted(QueryType type, String from, String to) {
            this.type = type;
            this.from = from;
            this.to = to;
        }
    }
}

