/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.NeverQueryDefinition;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

class CompositeQueryDefinition
implements QueryDefinition {
    private final Optional<QueryDefinition.Preprocessor> preprocessor;
    private final Predicate<Sighting> predicate;
    private final ImmutableList<QueryDefinition> definitions;

    public CompositeQueryDefinition(ReportSet reportSet, List<QueryFieldFactory.QueryField> queryFields, List<BooleanOperation> booleanOperations, Taxonomy taxonomy, Taxon.Type depth) {
        Preconditions.checkState(queryFields.size() == booleanOperations.size());
        ArrayList<Predicate<Sighting>> orPredicates = Lists.newArrayList();
        ArrayList andPredicates = Lists.newArrayList();
        ArrayList<QueryDefinition> neverAllQueryDefinitions = Lists.newArrayList();
        ArrayList<Optional<QueryDefinition.Preprocessor>> preprocessors = Lists.newArrayList();
        ImmutableList.Builder definitionsBuilder = ImmutableList.builder();
        for (int i = 0; i < queryFields.size(); ++i) {
            QueryFieldFactory.QueryField queryField = queryFields.get(i);
            BooleanOperation booleanOperation = booleanOperations.get(i);
            QueryDefinition queryDefinition = queryField.queryDefinition(reportSet, depth);
            if (booleanOperation == BooleanOperation.NEVER_ALL) {
                neverAllQueryDefinitions.add(queryDefinition);
                continue;
            }
            if (booleanOperation == BooleanOperation.NEVER) {
                queryDefinition = new NeverQueryDefinition(queryDefinition, taxonomy, depth);
                booleanOperation = BooleanOperation.ALL;
            }
            if (booleanOperation == BooleanOperation.ALL) {
                andPredicates.add(queryDefinition.predicate());
            } else {
                orPredicates.add(queryDefinition.predicate());
            }
            preprocessors.add(queryDefinition.preprocessor());
            definitionsBuilder.add(queryDefinition);
        }
        if (!neverAllQueryDefinitions.isEmpty()) {
            NeverQueryDefinition neverAll = new NeverQueryDefinition(neverAllQueryDefinitions, taxonomy, depth);
            preprocessors.add(neverAll.preprocessor());
            definitionsBuilder.add(neverAll);
            andPredicates.add(neverAll.predicate());
        }
        this.definitions = definitionsBuilder.build();
        if (!orPredicates.isEmpty()) {
            andPredicates.add(Predicates.or(orPredicates));
        }
        this.predicate = Predicates.and(andPredicates);
        final ImmutableList actualPreprocessors = ImmutableList.copyOf(Optional.presentInstances(preprocessors));
        this.preprocessor = actualPreprocessors.isEmpty() ? Optional.absent() : Optional.of(new QueryDefinition.Preprocessor(){

            @Override
            public void preprocess(Sighting sighting, Predicate<Sighting> countablePredicate) {
                for (QueryDefinition.Preprocessor preprocessor : actualPreprocessors) {
                    preprocessor.preprocess(sighting, countablePredicate);
                }
            }

            @Override
            public void reset() {
                for (QueryDefinition.Preprocessor preprocessor : actualPreprocessors) {
                    preprocessor.reset();
                }
            }
        });
    }

    @Override
    public Optional<QueryDefinition.Preprocessor> preprocessor() {
        return this.preprocessor;
    }

    @Override
    public Predicate<Sighting> predicate() {
        return this.predicate;
    }

    @Override
    public Optional<QueryDefinition.QueryAnnotation> annotate(Sighting sighting, SightingTaxon taxon) {
        for (QueryDefinition definition : this.definitions) {
            Optional<QueryDefinition.QueryAnnotation> annotate = definition.annotate(sighting, taxon);
            if (!annotate.isPresent()) continue;
            return annotate;
        }
        return Optional.absent();
    }

    @Override
    public Optional<QueryDefinition.PostProcessor> postprocessor() {
        List postProcessors = this.definitions.stream().map(QueryDefinition::postprocessor).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
        if (postProcessors.isEmpty()) {
            return Optional.absent();
        }
        if (postProcessors.size() == 1) {
            return Optional.of((QueryDefinition.PostProcessor)postProcessors.get(0));
        }
        return Optional.of(new CompositePostProcessor(postProcessors));
    }

    static enum BooleanOperation {
        ALL(Messages.Name.QUERY_AND),
        ANY(Messages.Name.QUERY_OR),
        NEVER(Messages.Name.QUERY_NEVER),
        NEVER_ALL(Messages.Name.QUERY_NEVER_ALL);

        private final Messages.Name text;

        private BooleanOperation(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class CompositePostProcessor
    implements QueryDefinition.PostProcessor {
        private final ImmutableList<QueryDefinition.PostProcessor> postProcessors;

        public CompositePostProcessor(Iterable<QueryDefinition.PostProcessor> postProcessors) {
            this.postProcessors = ImmutableList.copyOf(postProcessors);
        }

        @Override
        public boolean acceptTaxon(SightingTaxon sightingTaxon, Collection<Sighting> sightings, @Nullable Predicate<Sighting> countablePredicate) {
            for (QueryDefinition.PostProcessor postProcessor : this.postProcessors) {
                if (postProcessor.acceptTaxon(sightingTaxon, sightings, countablePredicate)) continue;
                return false;
            }
            return true;
        }
    }
}

