/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;

class BreedingBirdCodeQueryField
extends AbstractQueryField {
    private final JComboBox<QueryType> queryOptions = new JComboBox<QueryType>(QueryType.values());
    private final JComboBox<BreedingBirdLevel> levelOptions = new JComboBox<BreedingBirdLevel>(BreedingBirdLevel.values());
    private static final Gson GSON = new Gson();

    public BreedingBirdCodeQueryField() {
        super(QueryFieldFactory.QueryFieldType.BREEDING_CODE);
        this.levelOptions.setMaximumRowCount(this.levelOptions.getItemCount());
        this.queryOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreedingBirdCodeQueryField.this.levelOptions.setEnabled(!QueryType.ANY.equals(BreedingBirdCodeQueryField.this.queryOptions.getSelectedItem()));
                BreedingBirdCodeQueryField.this.firePredicateUpdated();
            }
        });
        this.levelOptions.addActionListener(e -> this.firePredicateUpdated());
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.queryOptions;
    }

    @Override
    public JComponent getValueField() {
        return this.levelOptions;
    }

    @Override
    public Predicate<Sighting> predicate(Taxon.Type depth) {
        if (QueryType.ANY.equals(this.queryOptions.getSelectedItem())) {
            return Predicates.alwaysTrue();
        }
        EnumSet<SightingInfo.BreedingBirdCode> allowedCodes = EnumSet.noneOf(SightingInfo.BreedingBirdCode.class);
        if (QueryType.IS.equals(this.queryOptions.getSelectedItem()) || QueryType.IS_NOT.equals(this.queryOptions.getSelectedItem())) {
            BreedingBirdLevel level = this.breedingBirdLevel();
            allowedCodes.addAll(level.getCodes());
            if (QueryType.IS_NOT.equals(this.queryOptions.getSelectedItem())) {
                allowedCodes = EnumSet.complementOf(allowedCodes);
            }
        } else {
            for (int i = 0; i <= this.levelOptions.getSelectedIndex(); ++i) {
                BreedingBirdLevel level = BreedingBirdLevel.values()[i];
                allowedCodes.addAll(level.getCodes());
            }
        }
        final EnumSet<SightingInfo.BreedingBirdCode> computedCodes = allowedCodes;
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting input) {
                SightingInfo.BreedingBirdCode code = !input.hasSightingInfo() ? SightingInfo.BreedingBirdCode.NONE : input.getSightingInfo().getBreedingBirdCode();
                return computedCodes.contains((Object)code);
            }
        };
    }

    private BreedingBirdLevel breedingBirdLevel() {
        return BreedingBirdLevel.values()[this.levelOptions.getSelectedIndex()];
    }

    @Override
    public boolean isNoOp() {
        return QueryType.ANY.equals(this.queryOptions.getSelectedItem());
    }

    @Override
    public JsonElement persist() {
        Persisted persisted = new Persisted((QueryType)((Object)this.queryOptions.getSelectedItem()), this.breedingBirdLevel());
        return GSON.toJsonTree(persisted);
    }

    @Override
    public void restore(JsonElement json) {
        Persisted persisted = GSON.fromJson(json, Persisted.class);
        this.queryOptions.setSelectedItem((Object)persisted.type);
        this.levelOptions.setSelectedItem((Object)persisted.level);
    }

    static enum QueryType {
        IS(Messages.Name.CODE_IS),
        IS_AT_LEAST(Messages.Name.CODE_IS_AT_LEAST),
        IS_NOT(Messages.Name.CODE_IS_NOT),
        ANY(Messages.Name.CODE_IS_ANY);

        private final Messages.Name text;

        private QueryType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static enum BreedingBirdLevel {
        CONFIRMED(Messages.Name.CODE_CONFIRMED, SightingInfo.BreedingBirdCode.NEST_WITH_YOUNG, SightingInfo.BreedingBirdCode.NEST_WITH_EGGS, SightingInfo.BreedingBirdCode.OCCUPIED_NEST, SightingInfo.BreedingBirdCode.RECENTLY_FLEDGED, SightingInfo.BreedingBirdCode.FEEDING_YOUNG, SightingInfo.BreedingBirdCode.CARRYING_FECAL_SAC, SightingInfo.BreedingBirdCode.CARRYING_FOOD, SightingInfo.BreedingBirdCode.DISTRACTION_DISPLAY, SightingInfo.BreedingBirdCode.USED_NEST),
        CONFIRMED_PROBABLE(Messages.Name.CODE_CONFIRMED_PROBABLE, SightingInfo.BreedingBirdCode.NEST_BUILDING, SightingInfo.BreedingBirdCode.CARRYING_NESTING_MATERIAL),
        PROBABLE(Messages.Name.CODE_PROBABLE, SightingInfo.BreedingBirdCode.TERRITORIAL_DEFENSE, SightingInfo.BreedingBirdCode.COURTSHIP_DISPLAY_OR_COPULATION, SightingInfo.BreedingBirdCode.VISITING_PROBABLE_NEST_SITE, SightingInfo.BreedingBirdCode.AGITATED_BEHAVIOR, SightingInfo.BreedingBirdCode.PHYSIOLOGICAL_EVIDENCE, SightingInfo.BreedingBirdCode.MULTIPLE_SINGING_BIRDS, SightingInfo.BreedingBirdCode.SINGING_BIRD_7_DAYS, SightingInfo.BreedingBirdCode.WOODPECKER_WREN_NEST_BUILDING),
        POSSIBLE(Messages.Name.CODE_POSSIBLE, SightingInfo.BreedingBirdCode.PAIR_IN_SUITABLE_HABITAT, SightingInfo.BreedingBirdCode.SINGING_BIRD, SightingInfo.BreedingBirdCode.IN_APPROPRIATE_HABITAT),
        NEST_WITH_YOUNG(SightingInfo.BreedingBirdCode.NEST_WITH_YOUNG),
        NEST_WITH_EGGS(SightingInfo.BreedingBirdCode.NEST_WITH_EGGS),
        CARRYING_FECAL_SAC(SightingInfo.BreedingBirdCode.CARRYING_FECAL_SAC),
        FEEDING_YOUNG(SightingInfo.BreedingBirdCode.FEEDING_YOUNG),
        CARRYING_FOOD(SightingInfo.BreedingBirdCode.CARRYING_FOOD),
        RECENTLY_FLEDGED(SightingInfo.BreedingBirdCode.RECENTLY_FLEDGED),
        OCCUPIED_NEST(SightingInfo.BreedingBirdCode.OCCUPIED_NEST),
        USED_NEST(SightingInfo.BreedingBirdCode.USED_NEST),
        DISTRACTION_DISPLAY(SightingInfo.BreedingBirdCode.DISTRACTION_DISPLAY),
        NEST_BUILDING(SightingInfo.BreedingBirdCode.NEST_BUILDING),
        CARRYING_NESTING_MATERIAL(SightingInfo.BreedingBirdCode.CARRYING_NESTING_MATERIAL),
        PHYSIOLOGICAL_EVIDENCE(SightingInfo.BreedingBirdCode.PHYSIOLOGICAL_EVIDENCE),
        WOODPECKER_WREN_NEST_BUILDING(SightingInfo.BreedingBirdCode.WOODPECKER_WREN_NEST_BUILDING),
        AGITATED_BEHAVIOR(SightingInfo.BreedingBirdCode.AGITATED_BEHAVIOR),
        VISITING_PROBABLE_NEST_SITE(SightingInfo.BreedingBirdCode.VISITING_PROBABLE_NEST_SITE),
        COURTSHIP_DISPLAY_OR_COPULATION(SightingInfo.BreedingBirdCode.COURTSHIP_DISPLAY_OR_COPULATION),
        TERRITORIAL_DEFENSE(SightingInfo.BreedingBirdCode.TERRITORIAL_DEFENSE),
        PAIR_IN_SUITABLE_HABITAT(SightingInfo.BreedingBirdCode.PAIR_IN_SUITABLE_HABITAT),
        MULTIPLE_SINGING_BIRDS(SightingInfo.BreedingBirdCode.MULTIPLE_SINGING_BIRDS),
        SINGING_BIRD_7_DAYS(SightingInfo.BreedingBirdCode.SINGING_BIRD_7_DAYS),
        SINGING_BIRD(SightingInfo.BreedingBirdCode.SINGING_BIRD),
        IN_APPROPRIATE_HABITAT(SightingInfo.BreedingBirdCode.IN_APPROPRIATE_HABITAT),
        FLYOVER(SightingInfo.BreedingBirdCode.FLYOVER);

        private final ImmutableList<SightingInfo.BreedingBirdCode> codes;
        private final Messages.Name name;

        private BreedingBirdLevel(SightingInfo.BreedingBirdCode oneCode) {
            this.name = Messages.getName(oneCode);
            this.codes = ImmutableList.of(oneCode);
        }

        private BreedingBirdLevel(Messages.Name name, SightingInfo.BreedingBirdCode ... codes) {
            this.name = name;
            this.codes = ImmutableList.copyOf(codes);
        }

        public ImmutableList<SightingInfo.BreedingBirdCode> getCodes() {
            return this.codes;
        }

        public String toString() {
            return Messages.getMessage(this.name);
        }
    }

    static class Persisted {
        QueryType type;
        BreedingBirdLevel level;

        public Persisted(QueryType type, BreedingBirdLevel level) {
            this.type = type;
            this.level = level;
        }
    }
}

