/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.AbstractQueryField;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

abstract class BooleanQueryField
extends AbstractQueryField {
    private final JLabel label = new JLabel(Messages.getMessage(Messages.Name.VALUE_IS));
    private final JComboBox<String> options = new JComboBox<String>(new String[]{Messages.getMessage(Messages.Name.VALUE_YES), Messages.getMessage(Messages.Name.VALUE_NO), Messages.getMessage(Messages.Name.VALUE_ANY)});

    public BooleanQueryField(QueryFieldFactory.QueryFieldType type, boolean defaultValue) {
        super(type);
        this.options.setSelectedIndex(defaultValue ? 0 : 1);
        this.options.addActionListener(e -> this.firePredicateUpdated());
    }

    @Override
    public JComponent getComparisonChooser() {
        return this.label;
    }

    @Override
    public JComponent getValueField() {
        return this.options;
    }

    @Override
    protected Predicate<Sighting> predicate(Taxon.Type depth) {
        if (this.options.getSelectedIndex() == 2) {
            return Predicates.alwaysTrue();
        }
        boolean currentValue = this.currentValue();
        return this.predicateFromBoolean(currentValue);
    }

    @Override
    public final boolean isNoOp() {
        return this.options.getSelectedIndex() == 2;
    }

    @Override
    public Optional<Boolean> getBooleanValue() {
        if (this.isNoOp()) {
            return Optional.absent();
        }
        return Optional.of(this.currentValue());
    }

    protected boolean currentValue() {
        return this.options.getSelectedIndex() == 0;
    }

    protected abstract Predicate<Sighting> predicateFromBoolean(boolean var1);

    @Override
    public JsonElement persist() {
        if (this.isNoOp()) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(this.currentValue());
    }

    @Override
    public void restore(JsonElement persisted) {
        if (persisted == null || persisted.isJsonNull()) {
            this.options.setSelectedIndex(2);
        } else {
            this.options.setSelectedIndex(persisted.getAsBoolean() ? 0 : 1);
        }
    }
}

