/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Optional;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.ByteSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.scythebill.birdlist.model.export.BirdTrackCsvExport;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.sighting.VisitInfoKeyOrdering;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.ui.imports.ImportPreferences;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.reports.QueryExecutor;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileNameExtensionFilter;

class BirdTrackExportAction
extends AbstractAction {
    private final QueryExecutor queryExecutor;
    private final FileDialogs fileDialogs;
    private final ReportSet reportSet;
    private final Taxonomy taxonomy;
    private final Alerts alerts;
    private final NamesPreferences namesPreferences;
    private final ImportPreferences importPreferences;

    public BirdTrackExportAction(FileDialogs fileDialogs, ReportSet reportSet, QueryExecutor queryExecutor, NamesPreferences namesPreferences, ImportPreferences importPreferences, Taxonomy taxonomy, Alerts alerts) {
        this.fileDialogs = fileDialogs;
        this.reportSet = reportSet;
        this.queryExecutor = queryExecutor;
        this.namesPreferences = namesPreferences;
        this.importPreferences = importPreferences;
        this.taxonomy = taxonomy;
        this.alerts = alerts;
    }

    private static Frame getParentFrame(Object object) {
        for (Component c = (Component)object; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Frame parentFrame = BirdTrackExportAction.getParentFrame(event.getSource());
        QueryResults queryResults = this.queryExecutor.executeQuery(Taxon.Type.group, this.taxonomy);
        Multimap<VisitInfoKey, Sighting> sightingsByVisitInfo = Multimaps.newMultimap(new TreeMap(new VisitInfoKeyOrdering()), ArrayList::new);
        for (Sighting sighting : queryResults.getAllSightings()) {
            VisitInfoKey visitInfoKey;
            if (!BirdTrackCsvExport.isAcceptableSighting(this.reportSet, sighting) || (visitInfoKey = VisitInfoKey.forSighting(sighting)) == null) continue;
            sightingsByVisitInfo.put(visitInfoKey, sighting);
        }
        if (sightingsByVisitInfo.isEmpty()) {
            this.alerts.showMessage(event.getSource(), Messages.Name.BIRDTRACK_NO_ACCEPTABLE_SIGHTINGS_TITLE, Messages.Name.BIRDTRACK_NO_ACCEPTABLE_SIGHTINGS_MESSAGE, new Object[0]);
            return;
        }
        Optional<String> reportName = this.queryExecutor.getReportAbbreviation();
        String fileName = reportName.isPresent() ? String.format("BirdTrack-export-%s.csv", reportName.get()) : "BirdTrack-export.csv";
        File file = this.fileDialogs.saveFile(parentFrame, Messages.getMessage(Messages.Name.SAVE_FOR_BIRDTRACK), fileName, new FileNameExtensionFilter(Messages.getMessage(Messages.Name.CSV_FILES), "csv"), FilePreferences.FileType.OTHER);
        if (file != null) {
            Iterator<Sighting> sightingIterator = sightingsByVisitInfo.values().iterator();
            int loopCount = 0;
            File out = file;
            do {
                ByteSink outSupplier = Files.asByteSink(out, new FileWriteMode[0]);
                try {
                    BirdTrackCsvExport export = new BirdTrackCsvExport(this.namesPreferences);
                    if (this.importPreferences.excelCompatibleCsv) {
                        export.useExcelCompatibleCsv();
                    }
                    export.writeSpeciesList(outSupplier, queryResults, sightingIterator, this.taxonomy, this.reportSet);
                }
                catch (IOException e) {
                    FileDialogs.showFileSaveError(this.alerts, e, out);
                    break;
                }
                if (!sightingIterator.hasNext()) continue;
                try {
                    out = this.getAuxiliaryFile(file, ++loopCount);
                }
                catch (IOException e) {
                    this.alerts.showError(null, Messages.Name.SAVING_FAILED_TITLE, Messages.Name.FILE_WAS_TOO_LONG, new Object[0]);
                    break;
                }
            } while (sightingIterator.hasNext());
        }
    }

    private File getAuxiliaryFile(File base, int loopCount) throws IOException {
        Object name = base.getName();
        int periodIndex = ((String)name).lastIndexOf(46);
        name = periodIndex < 0 ? (String)name + "-" + loopCount : ((String)name).substring(0, periodIndex) + "-" + loopCount + ((String)name).substring(periodIndex);
        File auxiliary = new File(base.getParent(), (String)name);
        if (!auxiliary.exists() && !auxiliary.createNewFile()) {
            throw new IOException("Could not create file");
        }
        return auxiliary;
    }
}

