/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.query.PartialPredicates;
import com.scythebill.birdlist.model.query.QueryProcessor;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.actions.ActionBroker;
import com.scythebill.birdlist.ui.actions.Attachable;
import com.scythebill.birdlist.ui.actions.ForwardingAction;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPanel;
import com.scythebill.birdlist.ui.panels.reports.QueryPanelFactory;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.panels.reports.ReportsBrowserPanel;
import com.scythebill.birdlist.ui.util.FocusTracker;
import com.scythebill.birdlist.ui.util.ListListModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;

public class BigDayPanel
extends JPanel
implements FontManager.FontsUpdatedListener,
Titled {
    private static final long MAX_RESULTS = 50L;
    private final ReportSet reportSet;
    private final QueryPanelFactory queryPanelFactory;
    private final TaxonomyStore taxonomyStore;
    private final QueryPreferences queryPreferences;
    private final ReportsBrowserPanel reportsBrowserPanel;
    private QueryPanel queryPanel;
    private JButton returnButton;
    private final NavigableFrame navigableFrame;
    private JComboBox<BigDayType> typeComboBox;
    private JList<BigDayResult> bigDayResultList;
    private JScrollPane bigDayResultScrollPane;
    private JScrollPane reportsScrollPane;
    private Timer showBigDayTimer;
    private ActionBroker actionBroker;

    @Inject
    BigDayPanel(ReportSet reportSet, ReportsBrowserPanel reportsBrowserPanel, QueryPanelFactory queryPanelFactory, TaxonomyStore taxonomyStore, EventBusRegistrar eventBusRegistrar, FontManager fontManager, QueryPreferences queryPreferences, NavigableFrame navigableFrame, ActionBroker actionBroker) {
        this.reportSet = reportSet;
        this.reportsBrowserPanel = reportsBrowserPanel;
        this.queryPanelFactory = queryPanelFactory;
        this.taxonomyStore = taxonomyStore;
        this.queryPreferences = queryPreferences;
        this.navigableFrame = navigableFrame;
        this.actionBroker = actionBroker;
        this.initGUI(eventBusRegistrar);
        this.attachListeners();
        fontManager.applyTo(this);
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.taxonomyChanged(null);
    }

    private void attachListeners() {
        this.returnButton.addActionListener(e -> this.navigableFrame.navigateTo("extendedReportsMenu"));
        this.queryPanel.addPredicateChangedListener(e -> this.showQueryInList());
        this.typeComboBox.addActionListener(e -> this.showQueryInList());
        this.showBigDayTimer = new Timer(200, e -> this.showSingleBigDay());
        this.showBigDayTimer.setRepeats(false);
        this.bigDayResultList.addListSelectionListener(e -> this.showBigDayTimer.restart());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent event) {
                BigDayPanel.this.showBigDayTimer.stop();
            }
        });
        this.bigDayResultList.setDragEnabled(true);
        this.bigDayResultList.setTransferHandler(new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c) {
                if (BigDayPanel.this.bigDayResultList.isSelectionEmpty()) {
                    return null;
                }
                String bigDaysAsText = IntStream.of(BigDayPanel.this.bigDayResultList.getSelectedIndices()).sorted().mapToObj(i -> BigDayPanel.this.bigDayResultList.getModel().getElementAt(i).toString()).collect(Collectors.joining("\n"));
                return new StringSelection(bigDaysAsText);
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        new FocusTracker(this.bigDayResultList){
            private final Action copy;
            {
                this.copy = new CopyActionWrapper(TransferHandler.getCopyAction());
            }

            @Override
            protected void focusGained(Component child) {
                BigDayPanel.this.actionBroker.publishAction("copy", this.copy);
            }

            @Override
            protected void focusLost(Component child) {
                BigDayPanel.this.actionBroker.unpublishAction("copy", this.copy);
            }
        };
    }

    private void initGUI(EventBusRegistrar eventBusRegistrar) {
        this.queryPanel = this.queryPanelFactory.newQueryPanel(QueryFieldFactory.QueryFieldType.SP_OR_HYBRID, QueryFieldFactory.QueryFieldType.SUBSPECIES_ALLOCATED, QueryFieldFactory.QueryFieldType.TIMES_SIGHTED);
        this.typeComboBox = new JComboBox<BigDayType>(BigDayType.values());
        this.returnButton = new JButton(Messages.getMessage(Messages.Name.BACK_TO_SPECIAL_REPORTS));
        this.bigDayResultList = new JList(new ListListModel());
        this.bigDayResultScrollPane = new JScrollPane(this.bigDayResultList, 20, 31);
        this.reportsScrollPane = new JScrollPane(this.reportsBrowserPanel);
        this.reportsBrowserPanel.setEditableSightings(true);
        this.reportsBrowserPanel.setReturnPanelName("bigDay");
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setBorder(new EmptyBorder(fontManager.scale(20), fontManager.scale(20), fontManager.scale(20), fontManager.scale(20)));
        GroupLayout layout = new GroupLayout(this);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.typeComboBox, -2, -2, -2).addComponent(this.queryPanel, -2, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.bigDayResultScrollPane).addComponent(this.reportsScrollPane)).addComponent(this.returnButton, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.typeComboBox, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.queryPanel, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.bigDayResultScrollPane, -2, -2, Short.MAX_VALUE).addComponent(this.reportsScrollPane, -2, -2, Short.MAX_VALUE)).addGap(10).addComponent(this.returnButton));
        this.setLayout(layout);
        Dimension preferredSize = fontManager.scale(new Dimension(760, 680));
        preferredSize.width += 200;
        this.setPreferredSize(preferredSize);
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.reportsBrowserPanel.setTaxonomy(this.taxonomyStore.getTaxonomy());
        this.queryPanel.taxonomyUpdated();
        this.showQueryInList();
    }

    private void showQueryInList() {
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        Predicate<Sighting> countablePredicate = this.queryPreferences.getCountablePredicate(taxonomy, this.queryPanel.containsQueryFieldType(QueryFieldFactory.QueryFieldType.SIGHTING_STATUS), this.queryPanel.getBooleanValueIfPresent(QueryFieldFactory.QueryFieldType.ALLOW_HEARD_ONLY));
        QueryProcessor queryProcessor = new QueryProcessor(this.reportSet, taxonomy);
        queryProcessor.onlyIncludeCountableSightings().dontIncludeFamilyNames();
        QueryResults results = queryProcessor.runQuery(this.queryPanel.queryDefinition(taxonomy, Taxon.Type.species), countablePredicate, Taxon.Type.species);
        LinkedHashMap<ReadablePartial, BigDayResult> queries = new LinkedHashMap<ReadablePartial, BigDayResult>();
        BigDayType type = (BigDayType)((Object)this.typeComboBox.getSelectedItem());
        for (Sighting sighting : results.getAllSightings()) {
            SightingTaxon species;
            ReadablePartial dateBucket = type.extractDate(sighting.getStartDateAsPartial(), sighting.getEndDateAsPartial());
            if (dateBucket == null || (species = sighting.getTaxon().resolve(taxonomy).getParentOfAtLeastType(Taxon.Type.species)).getType() == SightingTaxon.Type.HYBRID || species.getType() == SightingTaxon.Type.SP) continue;
            BigDayResult result = queries.computeIfAbsent(dateBucket, k -> new BigDayResult((ReadablePartial)k));
            if (result.count() == 0) {
                if (sighting.getLocationId() != null) {
                    result.location = this.reportSet.getLocations().getLocation(sighting.getLocationId());
                }
            } else if (result.location != null) {
                if (sighting.getLocationId() == null) {
                    result.location = null;
                } else if (!sighting.getLocationId().equals(result.location.getId())) {
                    result.location = Locations.getCommonAncestor(result.location, this.reportSet.getLocations().getLocation(sighting.getLocationId()));
                }
            }
            result.addSpecies(species.getId());
        }
        this.showBigDayTimer.stop();
        this.reportsBrowserPanel.setModel(null);
        ArrayList list = queries.values().stream().sorted(Comparator.comparing(BigDayResult::count).reversed()).limit(50L).collect(Collectors.toCollection(ArrayList::new));
        this.bigDayResultList.setModel(new ListListModel(list));
    }

    private void showSingleBigDay() {
        BigDayResult result = this.bigDayResultList.getSelectedValue();
        if (result == null) {
            this.reportsBrowserPanel.setModel(null);
        } else {
            Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
            Predicate<Sighting> countablePredicate = this.queryPreferences.getCountablePredicate(this.taxonomyStore.getTaxonomy(), this.queryPanel.containsQueryFieldType(QueryFieldFactory.QueryFieldType.SIGHTING_STATUS), this.queryPanel.getBooleanValueIfPresent(QueryFieldFactory.QueryFieldType.ALLOW_HEARD_ONLY));
            QueryProcessor queryProcessor = new QueryProcessor(this.reportSet, this.taxonomyStore.getTaxonomy()).onlyIncludeCountableSightings().withAdditionalPredicate(Predicates.and(SightingPredicates.afterOrEquals(result.date), SightingPredicates.beforeOrEquals(result.date)));
            HashSet allLocationIds = new HashSet();
            if (result.location != null) {
                Locations.visitLocations(result.location, l -> allLocationIds.add(l.getId()));
            }
            ArrayList locationTrips = this.reportSet.getTrips().allTrips().stream().filter(t -> result.location == null || allLocationIds.contains(t.locationId())).filter(t -> PartialPredicates.afterOrEquals(result.date).apply(t.startDate()) && PartialPredicates.beforeOrEquals(result.date).apply(t.endDate())).collect(Collectors.toCollection(ArrayList::new));
            QueryResults results = queryProcessor.runQuery(this.queryPanel.queryDefinition(taxonomy, Taxon.Type.species), countablePredicate, Taxon.Type.species);
            this.reportsBrowserPanel.setLocationRoot(result.location);
            this.reportsBrowserPanel.setQueryResults(results, true, locationTrips, false);
            this.reportsBrowserPanel.revalidate();
        }
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.BIG_DAY);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum BigDayType {
        BIG_DAY(Messages.Name.BIG_DAY){

            @Override
            ReadablePartial extractDate(ReadablePartial start, ReadablePartial end) {
                if (!(start != null && start.isSupported(DateTimeFieldType.dayOfMonth()) && start.isSupported(DateTimeFieldType.monthOfYear()) && start.isSupported(DateTimeFieldType.year()) && start.equals(end))) {
                    return null;
                }
                return start;
            }
        }
        ,
        BIG_MONTH(Messages.Name.BIG_MONTH){

            @Override
            ReadablePartial extractDate(ReadablePartial start, ReadablePartial end) {
                if (start != null && end != null && start.isSupported(DateTimeFieldType.year()) && end.isSupported(DateTimeFieldType.year()) && start.get(DateTimeFieldType.year()) == end.get(DateTimeFieldType.year()) && start.isSupported(DateTimeFieldType.monthOfYear()) && end.isSupported(DateTimeFieldType.monthOfYear()) && start.get(DateTimeFieldType.monthOfYear()) == end.get(DateTimeFieldType.monthOfYear())) {
                    return new Partial().with(DateTimeFieldType.year(), start.get(DateTimeFieldType.year())).with(DateTimeFieldType.monthOfYear(), start.get(DateTimeFieldType.monthOfYear()));
                }
                return null;
            }
        }
        ,
        BIG_YEAR(Messages.Name.BIG_YEAR){

            @Override
            ReadablePartial extractDate(ReadablePartial start, ReadablePartial end) {
                if (start != null && end != null && start.isSupported(DateTimeFieldType.year()) && end.isSupported(DateTimeFieldType.year()) && start.get(DateTimeFieldType.year()) == end.get(DateTimeFieldType.year())) {
                    return new Partial().with(DateTimeFieldType.year(), start.get(DateTimeFieldType.year()));
                }
                return null;
            }
        };

        private final Messages.Name text;

        private BigDayType(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }

        abstract ReadablePartial extractDate(ReadablePartial var1, ReadablePartial var2);
    }

    class BigDayResult {
        final ReadablePartial date;
        final LinkedHashSet<String> species;
        Location location;

        BigDayResult(ReadablePartial date) {
            this.date = date;
            this.species = new LinkedHashSet();
            this.location = null;
        }

        int count() {
            return this.species.size();
        }

        public String toString() {
            if (this.location == null) {
                return String.format("%d: \t%s", this.count(), PartialIO.toShortUserString(this.date, Locale.getDefault()));
            }
            return String.format("%d: \t%s \t%s", this.count(), PartialIO.toShortUserString(this.date, Locale.getDefault()), this.location.getDisplayName());
        }

        public void addSpecies(String id) {
            this.species.add(id);
        }
    }

    private class CopyActionWrapper
    extends ForwardingAction
    implements Attachable,
    ListSelectionListener {
        public CopyActionWrapper(Action wrapped) {
            super(BigDayPanel.this.bigDayResultList, wrapped);
        }

        @Override
        public void attach() {
            BigDayPanel.this.bigDayResultList.addListSelectionListener(this);
            this.updateEnabled();
        }

        @Override
        public void unattach() {
            BigDayPanel.this.bigDayResultList.removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabled();
        }

        private void updateEnabled() {
            this.setEnabled(!BigDayPanel.this.bigDayResultList.isSelectionEmpty());
        }
    }
}

