/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.reports;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.query.PredicateQueryDefinition;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.panels.reports.QueryFieldFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

abstract class AbstractQueryField
implements QueryFieldFactory.QueryField {
    private final List<ActionListener> predicateUpdatedListeners = Lists.newArrayList();
    private final QueryFieldFactory.QueryFieldType type;

    public AbstractQueryField(QueryFieldFactory.QueryFieldType type) {
        this.type = type;
    }

    @Override
    public QueryFieldFactory.QueryFieldType getType() {
        return this.type;
    }

    @Override
    public void addPredicateUpdatedListener(ActionListener e) {
        this.predicateUpdatedListeners.add(e);
    }

    @Override
    public QueryDefinition queryDefinition(ReportSet reportSet, Taxon.Type depth) {
        return new PredicateQueryDefinition(this.predicate(depth));
    }

    protected Predicate<Sighting> predicate(Taxon.Type depth) {
        throw new UnsupportedOperationException("predicate() not overridden");
    }

    protected void firePredicateUpdated() {
        ActionEvent e = new ActionEvent(this, 0, null);
        for (ActionListener l : this.predicateUpdatedListeners) {
            l.actionPerformed(e);
        }
    }
}

