/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.panels.location.LocationPreview;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jxmapviewer.JXMapKit;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.OSMTileFactoryInfo;
import org.jxmapviewer.input.MapClickListener;
import org.jxmapviewer.painter.AttributionPainter;
import org.jxmapviewer.painter.CompoundPainter;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.DefaultWaypoint;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.Waypoint;
import org.jxmapviewer.viewer.WaypointPainter;

public class OpenStreetMapLocationPreviewPanel
extends JPanel
implements LocationPreview {
    private static DefaultTileFactory tileFactory;
    private JXMapKit mapKit = new JXMapKit();

    public static void main(String[] args) throws IOException {
        JFrame frame = new JFrame();
        final AutoSelectJFormattedTextField latitudeField = new AutoSelectJFormattedTextField();
        latitudeField.setColumns(10);
        NumberFormatter latitudeFormatter = OpenStreetMapLocationPreviewPanel.allowNullDecimalFormatter();
        latitudeFormatter.setValueClass(Double.class);
        latitudeFormatter.setMinimum(Double.valueOf(-90.0));
        latitudeFormatter.setMaximum(Double.valueOf(90.0));
        latitudeFormatter.setCommitsOnValidEdit(true);
        latitudeField.setFormatterFactory(new DefaultFormatterFactory(latitudeFormatter));
        final AutoSelectJFormattedTextField longitudeField = new AutoSelectJFormattedTextField();
        longitudeField.setColumns(10);
        NumberFormatter longitudeFormatter = OpenStreetMapLocationPreviewPanel.allowNullDecimalFormatter();
        longitudeFormatter.setValueClass(Double.class);
        longitudeFormatter.setMinimum(Double.valueOf(-180.0));
        longitudeFormatter.setMaximum(Double.valueOf(180.0));
        longitudeFormatter.setCommitsOnValidEdit(true);
        longitudeField.setFormatterFactory(new DefaultFormatterFactory(longitudeFormatter));
        JButton ok = new JButton("OK");
        final OpenStreetMapLocationPreviewPanel previewPanel = new OpenStreetMapLocationPreviewPanel();
        previewPanel.setPreferredSize(new Dimension(500, 500));
        Box box = Box.createVerticalBox();
        box.add(previewPanel);
        box.add(latitudeField);
        box.add(longitudeField);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Double latitude = (Double)latitudeField.getValue();
                Double longitude = (Double)longitudeField.getValue();
                previewPanel.setLatLong(LatLongCoordinates.withLatAndLong(latitude, longitude));
            }
        });
        box.add(ok);
        previewPanel.addMapClickedListener(new LocationPreview.MapClickedListener(){

            @Override
            public void mapClicked(LatLongCoordinates latLong) {
                previewPanel.setLatLong(latLong);
            }
        });
        frame.setContentPane(box);
        frame.setVisible(true);
        frame.pack();
    }

    private static NumberFormatter allowNullDecimalFormatter() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumIntegerDigits(3);
        numberFormat.setMaximumFractionDigits(6);
        return new NumberFormatter(numberFormat){

            @Override
            public Object stringToValue(String string) throws ParseException {
                if ("".equals(string)) {
                    return null;
                }
                return super.stringToValue(string);
            }
        };
    }

    @Inject
    public OpenStreetMapLocationPreviewPanel() {
        this.mapKit.setTileFactory(tileFactory);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mapKit, "Center");
        this.mapKit.setZoom(7);
        this.mapKit.setMiniMapVisible(false);
        this.mapKit.setZoomSliderVisible(false);
        CompoundPainter<JXMapViewer> cp = new CompoundPainter<JXMapViewer>();
        cp.setCacheable(false);
        cp.addPainter(new AttributionPainter());
        cp.addPainter(new WaypointPainter<Waypoint>(){

            @Override
            public Set<Waypoint> getWaypoints() {
                GeoPosition addressLocation = OpenStreetMapLocationPreviewPanel.this.mapKit.getAddressLocation();
                if (addressLocation == null) {
                    return ImmutableSet.of();
                }
                return ImmutableSet.of(new DefaultWaypoint(addressLocation));
            }
        });
        this.mapKit.getMainMap().setOverlayPainter(cp);
        this.mapKit.getMainMap().addMouseListener(new MapClickListener(this.mapKit.getMainMap()){

            @Override
            public void mapClicked(GeoPosition location) {
                if (location != null) {
                    LatLongCoordinates clicked = LatLongCoordinates.withLatAndLong(location.getLatitude(), location.getLongitude());
                    for (LocationPreview.MapClickedListener listener : (LocationPreview.MapClickedListener[])OpenStreetMapLocationPreviewPanel.this.getListeners(LocationPreview.MapClickedListener.class)) {
                        listener.mapClicked(clicked);
                    }
                }
            }
        });
    }

    @Override
    public void setLatLong(LatLongCoordinates newLatLong) {
        if (newLatLong == null) {
            this.mapKit.setAddressLocation(null);
        } else {
            this.mapKit.setAddressLocation(new GeoPosition(newLatLong.latitudeAsDouble(), newLatLong.longitudeAsDouble()));
        }
    }

    @Override
    public LatLongCoordinates getLatLong() {
        GeoPosition addressLocation = this.mapKit.getAddressLocation();
        if (addressLocation == null) {
            return null;
        }
        return LatLongCoordinates.withLatAndLong(addressLocation.getLatitude(), addressLocation.getLongitude());
    }

    @Override
    public void addMapClickedListener(LocationPreview.MapClickedListener listener) {
        this.listenerList.add(LocationPreview.MapClickedListener.class, listener);
    }

    @Override
    public void removeMapClickedListener(LocationPreview.MapClickedListener listener) {
        this.listenerList.remove(LocationPreview.MapClickedListener.class, listener);
    }

    static {
        OSMTileFactoryInfo info = new OSMTileFactoryInfo();
        DefaultTileFactory newTileFactory = new DefaultTileFactory(info);
        newTileFactory.setThreadPoolSize(8);
        tileFactory = newTileFactory;
    }
}

