/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import java.awt.Point;
import java.awt.geom.Point2D;

class MercatorProjection {
    private static final double MERCATOR_RANGE = 256.0;
    private static final Point2D.Double PIXEL_ORIGIN = new Point2D.Double(128.0, 128.0);
    private static final double PIXELS_PER_DEGREE_LONGITUDE = 0.7111111111111111;
    private static final double PIXELS_PER_RADIAN_LONGITUDE = 40.74366543152521;

    MercatorProjection() {
    }

    static Point2D.Double latLongToPoint(LatLongCoordinates latLong) {
        Point2D.Double point = new Point2D.Double(0.0, 0.0);
        point.x = MercatorProjection.PIXEL_ORIGIN.x + latLong.longitudeAsDouble() * 0.7111111111111111;
        double siny = MercatorProjection.bound(Math.sin(MercatorProjection.degreesToRadians(latLong.latitudeAsDouble())), -0.9999, 0.9999);
        point.y = MercatorProjection.PIXEL_ORIGIN.y + 0.5 * Math.log((1.0 + siny) / (1.0 - siny)) * -40.74366543152521;
        return point;
    }

    static LatLongCoordinates pointToLatLong(Point2D.Double point) {
        double longitude = (point.x - MercatorProjection.PIXEL_ORIGIN.x) / 0.7111111111111111;
        double latRadians = (point.y - MercatorProjection.PIXEL_ORIGIN.y) / -40.74366543152521;
        double latitude = MercatorProjection.radiansToDegrees(2.0 * Math.atan(Math.exp(latRadians)) - 1.5707963267948966);
        if (latitude > 90.0) {
            latitude -= 180.0;
        } else if (latitude < -90.0) {
            latitude += 180.0;
        }
        if (longitude > 180.0) {
            longitude -= 360.0;
        } else if (longitude < -180.0) {
            longitude += 360.0;
        }
        return LatLongCoordinates.withLatAndLong(latitude, longitude);
    }

    static LatLongCoordinates northwestCorner(LatLongCoordinates center, int zoom, int mapWidth, int mapHeight) {
        double scale = Math.pow(2.0, zoom);
        Point2D.Double centerPoint = MercatorProjection.latLongToPoint(center);
        Point2D.Double southWestPoint = new Point2D.Double(centerPoint.x - (double)(mapWidth / 2) / scale, centerPoint.y - (double)(mapHeight / 2) / scale);
        return MercatorProjection.pointToLatLong(southWestPoint);
    }

    static LatLongCoordinates southeastCorner(LatLongCoordinates center, int zoom, int mapWidth, int mapHeight) {
        double scale = Math.pow(2.0, zoom);
        Point2D.Double centerPoint = MercatorProjection.latLongToPoint(center);
        Point2D.Double southWestPoint = new Point2D.Double(centerPoint.x + (double)(mapWidth / 2) / scale, centerPoint.y + (double)(mapHeight / 2) / scale);
        return MercatorProjection.pointToLatLong(southWestPoint);
    }

    static LatLongCoordinates point(LatLongCoordinates center, int zoomLevel, int width, int height, Point point) {
        double scale = Math.pow(2.0, zoomLevel);
        Point2D.Double centerPoint = MercatorProjection.latLongToPoint(center);
        double xFraction = (double)point.x / (double)width - 0.5;
        double yFraction = (double)point.y / (double)height - 0.5;
        Point2D.Double clickedPoint = new Point2D.Double(centerPoint.x + (double)width * xFraction / scale, centerPoint.y + (double)height * yFraction / scale);
        return MercatorProjection.pointToLatLong(clickedPoint);
    }

    private static double degreesToRadians(double degrees) {
        return degrees * (Math.PI / 180);
    }

    private static double radiansToDegrees(double radians) {
        return radians / (Math.PI / 180);
    }

    private static double bound(double value, double minimum, double maximum) {
        if (value < minimum) {
            return minimum;
        }
        if (value > maximum) {
            return maximum;
        }
        return value;
    }
}

