/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.ui.util.BaseTreeModel;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;

public class LocationTreeModel
extends BaseTreeModel {
    private static final Ordering<Object> COLLATOR_ORDERING = Ordering.from(Collator.getInstance());
    private static final Ordering<Location> LOCATION_ORDERING = new Ordering<Location>(){

        @Override
        public int compare(Location left, Location right) {
            String leftString = LocationIdToString.getStringWithType(left);
            String rightString = LocationIdToString.getStringWithType(right);
            return COLLATOR_ORDERING.compare(leftString, rightString);
        }
    };
    private static final Logger logger = Logger.getLogger(LocationTreeModel.class.getName());
    static final Object ROOT = new Object();
    private final LocationSet locationSet;
    private final LoadingCache<Object, List<Location>> childrenCache;
    private final PredefinedLocations predefinedLocations;
    private Predicate<Location> filter;

    public LocationTreeModel(LocationSet locationSet, PredefinedLocations predefinedLocations, Predicate<Location> filter) {
        this.locationSet = locationSet;
        this.predefinedLocations = predefinedLocations;
        this.filter = filter;
        this.childrenCache = CacheBuilder.newBuilder().build(new CacheLoader<Object, List<Location>>(){

            @Override
            public List<Location> load(Object key) throws Exception {
                return LocationTreeModel.this.getSortedLocationChildren(key);
            }
        });
    }

    @Override
    public Object getChild(Object node, int index) {
        return this.childrenCache.getUnchecked(node).get(index);
    }

    @Override
    public int getChildCount(Object node) {
        return this.childrenCache.getUnchecked(node).size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.childrenCache.getUnchecked(parent).indexOf(child);
    }

    @Override
    public Object getRoot() {
        return ROOT;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.childrenCache.getUnchecked(node).isEmpty();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object value) {
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            this.childrenCache.invalidateAll();
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, path));
        } else {
            this.childrenCache.invalidate(value);
            this.childrenCache.invalidate(path.getLastPathComponent());
            this.childrenCache.invalidate(parentPath.getLastPathComponent());
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, parentPath));
        }
    }

    public void newLocation(TreePath path, Location location) {
        this.childrenCache.invalidate(path.getLastPathComponent());
        this.childrenCache.invalidate(location);
        while (location.getParent() != path.getLastPathComponent()) {
            if ((location = location.getParent()) == null) {
                logger.warning(String.format("Could not find location's parent in path %s, invalidating child cache", path));
                this.childrenCache.invalidateAll();
                break;
            }
            this.childrenCache.invalidate(location);
        }
        if (location == null) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, path));
        } else {
            int newIndex = this.getIndexOfChild(path.getLastPathComponent(), location);
            if (newIndex < 0) {
                logger.warning(String.format("Expected to find location %s in path %s, invalidating tree", location.getDisplayName(), path.getParentPath()));
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(ROOT)));
            } else if (location.isBuiltInLocation()) {
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, path));
            } else {
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, path, new int[]{newIndex}, new Object[]{location}));
            }
        }
    }

    private List<Location> getSortedLocationChildren(Object from) {
        Iterable<Location> unsorted;
        if (from == ROOT) {
            unsorted = this.locationSet.rootLocations();
        } else {
            Location location = (Location)from;
            unsorted = location.contents();
            ImmutableCollection<PredefinedLocations.PredefinedLocation> predefinedList = this.predefinedLocations.getPredefinedLocations(location);
            if (!predefinedList.isEmpty()) {
                ArrayList<Location> notYetStoredList = Lists.newArrayList();
                for (PredefinedLocations.PredefinedLocation predefined : predefinedList) {
                    Location locationByCode;
                    if (predefined.getCode() == null || (locationByCode = this.locationSet.getLocationByCode(predefined.getCode())) != null) continue;
                    notYetStoredList.add(predefined.create(this.locationSet, location));
                }
                unsorted = Iterables.concat(unsorted, notYetStoredList);
            }
        }
        return LOCATION_ORDERING.sortedCopy(Iterables.filter(unsorted, this.filter));
    }

    public Location findActualLocation(Location location) {
        if (location.getId() != null) {
            return location;
        }
        Location parent = this.findActualLocation(location.getParent());
        List<Location> list = this.childrenCache.getUnchecked(parent);
        for (Location possibility : list) {
            if (!location.getModelName().equals(possibility.getModelName())) continue;
            return possibility;
        }
        return location;
    }
}

