/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.ui.actions.ActionBroker;
import com.scythebill.birdlist.ui.actions.Attachable;
import com.scythebill.birdlist.ui.actions.ForwardingAction;
import com.scythebill.birdlist.ui.datatransfer.SightingsGroup;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.location.LocationTreeModel;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FixDropTargetScrolling;
import com.scythebill.birdlist.ui.util.FocusTracker;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class LocationTree
extends JTree {
    private final ReportSet reportSet;
    private final PredefinedLocations predefinedLocations;
    private final FontManager fontManager;
    private final ActionBroker actionBroker;
    private final List<LocationsEditedListener> locationsEditedListeners = Lists.newCopyOnWriteArrayList();
    private final Alerts alerts;
    private final Timer hoverTimer;
    private static final DataFlavor LOCATIONS_FLAVOR;

    public LocationTree(ReportSet reportSet, PredefinedLocations predefinedLocations, Predicate<Location> locationFilter, ActionBroker actionBroker, FontManager fontManager, Alerts alerts) {
        super(new LocationTreeModel(reportSet.getLocations(), predefinedLocations, locationFilter));
        this.predefinedLocations = predefinedLocations;
        this.actionBroker = actionBroker;
        this.fontManager = fontManager;
        this.alerts = alerts;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON);
        this.setTransferHandler(new LocationTransferHandler());
        this.reportSet = reportSet;
        this.hoverTimer = new Timer(500, e -> {
            TreePath path;
            JTree.DropLocation dropLocation = this.getDropLocation();
            if (dropLocation != null && (path = dropLocation.getPath()) != null) {
                this.expandPath(path);
            }
        });
        this.hoverTimer.setRepeats(false);
        new LocationTreeFocusTracker();
        FixDropTargetScrolling.install(this, new Insets(10, 0, 10, 0));
        this.addPropertyChangeListener(event -> {
            if ("dropLocation".equals(event.getPropertyName())) {
                JTree.DropLocation oldValue = (JTree.DropLocation)event.getOldValue();
                if (this.isQuaqua()) {
                    this.repaintDropLocation(oldValue);
                    this.repaintDropLocation(this.getDropLocation());
                }
                if (oldValue == null) {
                    this.hoverTimer.stop();
                } else {
                    this.hoverTimer.restart();
                }
            }
        });
    }

    @Override
    public void doLayout() {
        Font font = this.fontManager.getTextFont();
        this.setRowHeight(UIUtils.getFontHeight(this.getGraphics(), font) + 4);
        super.doLayout();
    }

    private void repaintDropLocation(JTree.DropLocation loc) {
        if (loc == null) {
            return;
        }
        TreePath path = loc.getPath();
        if (path != null) {
            Rectangle r = this.getPathBounds(path);
            r.x = 0;
            r.width = this.getWidth();
            this.repaint(r);
        }
    }

    public void setLocationFilter(Predicate<Location> locationFilter) {
        ArrayList<Location> selectedLocations = new ArrayList<Location>();
        if (this.getSelectionPaths() != null) {
            for (TreePath treePath : this.getSelectionPaths()) {
                Location location;
                Object lastPathComponent = treePath.getLastPathComponent();
                if (!(lastPathComponent instanceof Location) || !locationFilter.apply(location = (Location)lastPathComponent)) continue;
                selectedLocations.add(location);
            }
        }
        this.setModel(new LocationTreeModel(this.reportSet.getLocations(), this.predefinedLocations, locationFilter));
        this.selectLocations(selectedLocations);
    }

    public void addLocationsEditedListener(LocationsEditedListener listener) {
        this.locationsEditedListeners.add(listener);
    }

    public Location getSelectedLocation() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Object lastPathComponent = treePath.getLastPathComponent();
        if (lastPathComponent instanceof Location) {
            return (Location)lastPathComponent;
        }
        return null;
    }

    public void selectLocation(Location location) {
        if (location instanceof SyntheticLocation) {
            SyntheticLocation synthetic = (SyntheticLocation)location;
            Collection<Location> locations = synthetic.syntheticChecklistUnionLocations(this.reportSet.getLocations(), this.predefinedLocations);
            if (locations != null) {
                this.selectLocations(locations);
            }
        } else {
            TreePath treePath = this.getTreePath(location);
            this.setSelectionPath(treePath);
            this.setExpandedState(treePath, true);
            this.scrollPathToVisible(treePath);
        }
    }

    public void selectLocations(Iterable<Location> locations) {
        ArrayList<TreePath> treePaths = Lists.newArrayList();
        for (Location location : locations) {
            treePaths.add(this.getTreePath(location));
        }
        this.setSelectionPaths(treePaths.toArray(new TreePath[0]));
        if (!treePaths.isEmpty()) {
            this.setExpandedState(((TreePath)treePaths.get(0)).getParentPath(), true);
            this.scrollPathToVisible((TreePath)treePaths.get(0));
        }
    }

    private void fireLocationsEditedEvent() {
        for (LocationsEditedListener listener : this.locationsEditedListeners) {
            listener.onEdited();
        }
    }

    TreePath getTreePath(Location location) {
        if (location == null) {
            return new TreePath(this.getModel().getRoot());
        }
        location = ((LocationTreeModel)this.getModel()).findActualLocation(location);
        return this.getTreePath(location.getParent()).pathByAddingChild(location);
    }

    @Override
    public boolean isRowSelected(int row) {
        JTree.DropLocation dropLocation;
        if (this.isQuaqua() && (dropLocation = this.getDropLocation()) != null && dropLocation.getPath() != null && this.getRowForPath(dropLocation.getPath()) == row) {
            return true;
        }
        return super.isRowSelected(row);
    }

    private boolean isQuaqua() {
        return this.getUI().getClass().getName().contains("Quaqua");
    }

    static {
        try {
            LOCATIONS_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=" + LocalLocationsSet.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private class LocationTransferHandler
    extends TransferHandler {
        private LocationTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            TreePath[] paths = LocationTree.this.getSelectionPaths();
            if (paths == null || paths.length == 0) {
                return null;
            }
            Location commonParent = null;
            ImmutableList.Builder locations = ImmutableList.builder();
            for (TreePath path : paths) {
                Location location = (Location)path.getLastPathComponent();
                if (location.isBuiltInLocation() && location.getType() == Location.Type.region) {
                    return null;
                }
                if (commonParent == null) {
                    commonParent = location.getParent();
                } else if (location.getParent() != commonParent) {
                    return null;
                }
                locations.add(location);
            }
            return new LocationTransferable((List<Location>)((Object)locations.build()));
        }

        @Override
        public int getSourceActions(JComponent component) {
            return 2;
        }

        @Override
        public boolean canImport(JComponent component, DataFlavor[] flavors) {
            throw new UnsupportedOperationException("Legacy canImport() not supported");
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            TreePath target = this.getDropTarget(transferSupport);
            if (target == null) {
                return false;
            }
            if (!(target.getLastPathComponent() instanceof Location)) {
                return false;
            }
            Location targetLocation = (Location)target.getLastPathComponent();
            if (transferSupport.isDataFlavorSupported(LOCATIONS_FLAVOR)) {
                if (!transferSupport.isDrop()) {
                    return false;
                }
                ImmutableList<Location> sourceLocations = this.getLocations(transferSupport);
                for (Location sourceLocation : sourceLocations) {
                    if (targetLocation != sourceLocation && !Locations.isDescendentOfLocation(sourceLocation, targetLocation)) continue;
                    return false;
                }
                return true;
            }
            return transferSupport.isDataFlavorSupported(SightingsGroup.FLAVOR);
        }

        @Override
        public boolean importData(JComponent component, Transferable data) {
            throw new UnsupportedOperationException("Legacy importData() not supported.");
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (!this.canImport(transferSupport)) {
                return false;
            }
            try {
                TreePath target = this.getDropTarget(transferSupport);
                Location targetLocation = (Location)target.getLastPathComponent();
                if (transferSupport.isDataFlavorSupported(LOCATIONS_FLAVOR)) {
                    ImmutableList<Location> sourceLocations = this.getLocations(transferSupport);
                    LinkedHashSet<Location> expandedLocations = Sets.newLinkedHashSet();
                    for (int i = 0; i < LocationTree.this.getRowCount(); ++i) {
                        if (!LocationTree.this.isExpanded(i)) continue;
                        Location location = (Location)LocationTree.this.getPathForRow(i).getLastPathComponent();
                        expandedLocations.add(location);
                    }
                    Point scrollPoint = LocationTree.this.getParent() instanceof JViewport ? ((JViewport)LocationTree.this.getParent()).getViewPosition() : null;
                    LocationTree.this.reportSet.getLocations().ensureAdded(targetLocation);
                    Location builtInDuplicate = null;
                    ArrayList<Location> nonDuplicateSourceLocations = new ArrayList<Location>();
                    ArrayList<Location> duplicateSourceLocations = new ArrayList<Location>();
                    ArrayList<Location> duplicateTargetLocations = new ArrayList<Location>();
                    for (Location sourceLocation : sourceLocations) {
                        Location existingLocation = targetLocation.getContent(sourceLocation.getModelName());
                        PredefinedLocations.PredefinedLocation existingPredefinedLocation = LocationTree.this.predefinedLocations.getPredefinedLocationChildThatHasNotBeenCreatedYet(LocationTree.this.reportSet.getLocations(), targetLocation, sourceLocation.getModelName());
                        if (existingLocation != null || existingPredefinedLocation != null) {
                            if (sourceLocation.isBuiltInLocation()) {
                                builtInDuplicate = sourceLocation;
                                continue;
                            }
                            duplicateSourceLocations.add(sourceLocation);
                            if (existingLocation != null) {
                                duplicateTargetLocations.add(existingLocation);
                                continue;
                            }
                            duplicateTargetLocations.add(existingPredefinedLocation.create(LocationTree.this.reportSet.getLocations(), targetLocation));
                            continue;
                        }
                        nonDuplicateSourceLocations.add(sourceLocation);
                    }
                    if (builtInDuplicate != null) {
                        String duplicateName = builtInDuplicate.getModelName();
                        SwingUtilities.invokeLater(() -> LocationTree.this.alerts.showError((Object)SwingUtilities.getWindowAncestor(LocationTree.this), Messages.Name.NAME_ALREADY_EXISTS_TITLE, Messages.Name.NAME_ALREADY_EXISTS_MESSAGE, duplicateName, targetLocation.getDisplayName()));
                        return false;
                    }
                    if (!duplicateSourceLocations.isEmpty()) {
                        if (duplicateSourceLocations.size() == 1) {
                            Location onlyDuplicateSource = (Location)duplicateSourceLocations.get(0);
                            SwingUtilities.invokeLater(() -> {
                                if (LocationTree.this.alerts.showOkCancel((Object)SwingUtilities.getWindowAncestor(LocationTree.this), Messages.Name.MERGE_LOCATIONS_TITLE, Messages.Name.MERGE_SINGLE_LOCATION_MESSAGE, HtmlResponseWriter.htmlEscape(onlyDuplicateSource.getModelName()), HtmlResponseWriter.htmlEscape(targetLocation.getModelName())) == 0) {
                                    this.finishLocationsDrop(targetLocation, nonDuplicateSourceLocations, duplicateSourceLocations, duplicateTargetLocations, expandedLocations, scrollPoint);
                                }
                            });
                        } else {
                            SwingUtilities.invokeLater(() -> {
                                if (LocationTree.this.alerts.showOkCancel((Object)SwingUtilities.getWindowAncestor(LocationTree.this), Messages.Name.MERGE_LOCATIONS_TITLE, Messages.Name.MERGE_MULTIPLE_LOCATIONS_MESSAGE, duplicateSourceLocations.size(), HtmlResponseWriter.htmlEscape(targetLocation.getModelName())) == 0) {
                                    this.finishLocationsDrop(targetLocation, nonDuplicateSourceLocations, duplicateSourceLocations, duplicateTargetLocations, expandedLocations, scrollPoint);
                                }
                            });
                        }
                    } else {
                        this.finishLocationsDrop(targetLocation, nonDuplicateSourceLocations, duplicateSourceLocations, duplicateTargetLocations, expandedLocations, scrollPoint);
                    }
                    return true;
                }
                if (transferSupport.isDataFlavorSupported(SightingsGroup.FLAVOR)) {
                    SightingsGroup sightingsGroup = SightingsGroup.fromTransferable(transferSupport.getTransferable());
                    ArrayList<Sighting> newSightings = Lists.newArrayList();
                    LocationTree.this.reportSet.getLocations().ensureAdded(targetLocation);
                    for (Sighting.Builder sighting : sightingsGroup.sightingBuilders()) {
                        sighting.setLocation(targetLocation);
                        newSightings.add(sighting.build());
                    }
                    LocationTree.this.reportSet.mutator().adding(newSightings).mutate();
                    for (Map.Entry entry : sightingsGroup.getVisitInfoMap().entrySet()) {
                        VisitInfoKey updatedKey = ((VisitInfoKey)entry.getKey()).withLocationId(targetLocation.getId());
                        if (LocationTree.this.reportSet.getVisitInfo(updatedKey) != null) continue;
                        LocationTree.this.reportSet.putVisitInfo(updatedKey, (VisitInfo)entry.getValue());
                    }
                    if (!transferSupport.isDrop()) {
                        LocationTree.this.fireLocationsEditedEvent();
                    }
                    return true;
                }
                throw new RuntimeException("Should not reach: " + Lists.newArrayList(transferSupport.getDataFlavors()));
            }
            catch (RuntimeException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Error", e);
                throw e;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void finishLocationsDrop(Location targetLocation, List<Location> nonDuplicateSourceLocations, List<Location> duplicateSourceLocations, List<Location> duplicateTargetLocations, Set<Location> expandedLocations, Point scrollPoint) {
            Rectangle rectangle;
            void var8_11;
            for (Location location : nonDuplicateSourceLocations) {
                LocationTree.this.reportSet.getLocations().ensureAdded(location);
            }
            HashSet<Location> oldSourceParents = Sets.newHashSet();
            for (Location sourceLocation : nonDuplicateSourceLocations) {
                oldSourceParents.add(sourceLocation.getParent());
                sourceLocation.reparent(targetLocation);
            }
            boolean bl = false;
            while (var8_11 < duplicateSourceLocations.size()) {
                Location duplicateSourceLocation = duplicateSourceLocations.get((int)var8_11);
                Location duplicateTargetLocation = duplicateTargetLocations.get((int)var8_11);
                Locations.replaceLocation(duplicateTargetLocation, duplicateSourceLocation, LocationTree.this.reportSet);
                oldSourceParents.add(duplicateSourceLocation.getParent());
                ++var8_11;
            }
            for (Location oldSourceParent : oldSourceParents) {
                LocationTree.this.getModel().valueForPathChanged(LocationTree.this.getTreePath(oldSourceParent), oldSourceParent);
            }
            LocationTree.this.getModel().valueForPathChanged(LocationTree.this.getTreePath(targetLocation), targetLocation);
            LocationTree.this.selectLocations(Iterables.concat(nonDuplicateSourceLocations, duplicateTargetLocations));
            for (Location expandedLocation : expandedLocations) {
                LocationTree.this.expandPath(LocationTree.this.getTreePath(expandedLocation));
            }
            LocationTree.this.reportSet.getLocations().markDirty();
            if (scrollPoint != null) {
                ((JViewport)LocationTree.this.getParent()).setViewPosition(scrollPoint);
            }
            if ((rectangle = this.getSelectionBounds()) != null) {
                LocationTree.this.scrollRectToVisible(rectangle);
            }
            LocationTree.this.fireLocationsEditedEvent();
        }

        private Rectangle getSelectionBounds() {
            if (LocationTree.this.getSelectionCount() == 0) {
                return null;
            }
            TreePath[] selectionPaths = LocationTree.this.getSelectionPaths();
            Rectangle bounds = LocationTree.this.getPathBounds(selectionPaths[0]);
            for (int i = 1; i < selectionPaths.length; ++i) {
                bounds.add(LocationTree.this.getPathBounds(selectionPaths[i]));
            }
            return bounds;
        }

        private ImmutableList<Location> getLocations(TransferHandler.TransferSupport transferSupport) {
            try {
                return ((LocalLocationsSet)transferSupport.getTransferable().getTransferData((DataFlavor)LocationTree.LOCATIONS_FLAVOR)).locations;
            }
            catch (UnsupportedFlavorException | IOException e) {
                throw new RuntimeException(e);
            }
        }

        private TreePath getDropTarget(TransferHandler.TransferSupport transferSupport) {
            if (!transferSupport.isDrop()) {
                TreePath[] paths = LocationTree.this.getSelectionPaths();
                if (paths == null || paths.length != 1) {
                    return null;
                }
                return paths[0];
            }
            JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
            return dropLocation.getPath();
        }
    }

    private class LocationTreeFocusTracker
    extends FocusTracker {
        private final Action paste;

        public LocationTreeFocusTracker() {
            super(LocationTree.this);
            this.paste = new PasteActionWrapper(TransferHandler.getPasteAction());
        }

        @Override
        protected void focusGained(Component child) {
            LocationTree.this.actionBroker.publishAction("paste", this.paste);
        }

        @Override
        protected void focusLost(Component child) {
            LocationTree.this.actionBroker.unpublishAction("paste", this.paste);
        }
    }

    public static interface LocationsEditedListener {
        public void onEdited();
    }

    static class LocalLocationsSet {
        final ImmutableList<Location> locations;

        LocalLocationsSet(List<Location> locations) {
            this.locations = ImmutableList.copyOf(locations);
        }
    }

    protected class PasteActionWrapper
    extends ForwardingAction
    implements Attachable,
    FlavorListener,
    TreeSelectionListener {
        public PasteActionWrapper(Action wrapped) {
            super(LocationTree.this, wrapped);
        }

        @Override
        public void attach() {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.addFlavorListener(this);
            LocationTree.this.getSelectionModel().addTreeSelectionListener(this);
            this.updateEnabled();
        }

        private void updateEnabled() {
            this.setEnabled(this.pasteAvailable());
        }

        private boolean pasteAvailable() {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                if (!clipboard.isDataFlavorAvailable(SightingsGroup.FLAVOR)) {
                    return false;
                }
            }
            catch (IllegalStateException e) {
                return false;
            }
            TreePath[] paths = LocationTree.this.getSelectionPaths();
            return paths != null && paths.length == 1;
        }

        @Override
        public void unattach() {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.removeFlavorListener(this);
            LocationTree.this.getSelectionModel().removeTreeSelectionListener(this);
        }

        @Override
        public void flavorsChanged(FlavorEvent e) {
            this.updateEnabled();
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.updateEnabled();
        }
    }

    private static class LocationTransferable
    implements Transferable {
        private final LocalLocationsSet locations;

        public LocationTransferable(List<Location> locations) {
            this.locations = new LocalLocationsSet(locations);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (LOCATIONS_FLAVOR.equals(flavor)) {
                return this.locations;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{LOCATIONS_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return LOCATIONS_FLAVOR.equals(flavor);
        }
    }
}

