/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.ui.actions.locationapi.LocationApiPreferences;
import com.scythebill.birdlist.ui.panels.location.GoogleLocationPreviewPanel;
import com.scythebill.birdlist.ui.panels.location.LocationPreview;
import com.scythebill.birdlist.ui.panels.location.OpenStreetMapLocationPreviewPanel;
import javax.swing.JPanel;

public class LocationPreviews {
    private final LocationApiPreferences locationApiPreferences;
    private final Provider<GoogleLocationPreviewPanel> googlePanelProvider;
    private final Provider<OpenStreetMapLocationPreviewPanel> openStreetMapPanelProvider;

    @Inject
    public LocationPreviews(LocationApiPreferences locationApiPreferences, Provider<GoogleLocationPreviewPanel> googlePanelProvider, Provider<OpenStreetMapLocationPreviewPanel> openStreetMapPanelProvider) {
        this.locationApiPreferences = locationApiPreferences;
        this.googlePanelProvider = googlePanelProvider;
        this.openStreetMapPanelProvider = openStreetMapPanelProvider;
    }

    public LocationPreview getLocationPreview() {
        switch (this.locationApiPreferences.mapProvider) {
            case GOOGLE: {
                return this.googlePanelProvider.get();
            }
            case OPEN_STREET_MAP: {
                return this.openStreetMapPanelProvider.get();
            }
            case NONE: {
                return new NullLocationPreview();
            }
        }
        throw new AssertionError((Object)("Unexpected map provider: " + this.locationApiPreferences.mapProvider));
    }

    static class NullLocationPreview
    extends JPanel
    implements LocationPreview {
        private LatLongCoordinates latLong;

        NullLocationPreview() {
        }

        @Override
        public void setLatLong(LatLongCoordinates newLatLong) {
            this.latLong = newLatLong;
        }

        @Override
        public LatLongCoordinates getLatLong() {
            return this.latLong;
        }

        @Override
        public void addMapClickedListener(LocationPreview.MapClickedListener listener) {
        }

        @Override
        public void removeMapClickedListener(LocationPreview.MapClickedListener listener) {
        }
    }
}

