/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.google.common.base.Objects;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class LocationEditorPanel
extends JPanel {
    private Location lastLocation = null;
    private JTextField name;
    private JLabel nameLabel;
    private boolean dontUpdateValue;

    public LocationEditorPanel() {
        this.initGUI();
        this.hookUpContents();
    }

    private void hookUpContents() {
        this.name.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LocationEditorPanel.this.updateValue();
            }
        });
        this.name.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LocationEditorPanel.this.updateValue();
            }
        });
    }

    private void updateValue() {
        Location newValue;
        Location oldValue;
        if (!this.dontUpdateValue && !Objects.equal(oldValue = this.lastLocation, newValue = this.getValue())) {
            this.lastLocation = newValue;
            this.firePropertyChange("value", oldValue, newValue);
        }
    }

    private void initGUI() {
        BoxLayout layout = new BoxLayout(this, 2);
        this.setLayout(layout);
        this.nameLabel = new JLabel(Messages.getMessage(Messages.Name.NAME_LABEL));
        this.name = new JTextField();
        this.name.setColumns(20);
        this.add(this.nameLabel);
        this.add(this.name);
    }

    public Location getValue() {
        if (this.lastLocation == null) {
            return null;
        }
        if ("".equals(this.name.getText())) {
            return null;
        }
        return this.lastLocation.asBuilder().setName(this.name.getText()).build();
    }

    public void setLocation(Location location) {
        this.dontUpdateValue = true;
        this.lastLocation = location;
        if (location == null) {
            this.name.setText("");
        } else {
            this.name.setText(location.getDisplayName());
        }
        this.dontUpdateValue = false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.nameLabel.setEnabled(enabled);
        this.name.setEnabled(enabled);
    }
}

