/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.ChecklistSynthesizer;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.ClementsChecklist;
import com.scythebill.birdlist.model.checklist.ClementsChecklistWriter;
import com.scythebill.birdlist.model.checklist.TransposedChecklistSynthesizer;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.QueryProcessor;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.query.SyntheticLocations;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.sighting.VisitInfoKeyOrdering;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.actions.ActionBroker;
import com.scythebill.birdlist.ui.actions.ReturnAction;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.components.BaseTaxonBrowserPanel;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.NewLocationDialog;
import com.scythebill.birdlist.ui.components.SpeciesIndexerPanelConfigurer;
import com.scythebill.birdlist.ui.components.VisitInfoPreferences;
import com.scythebill.birdlist.ui.components.WherePanel;
import com.scythebill.birdlist.ui.components.WherePanelIndexers;
import com.scythebill.birdlist.ui.datatransfer.SightingsGroup;
import com.scythebill.birdlist.ui.events.DefaultUserChangedEvent;
import com.scythebill.birdlist.ui.events.DefaultUserStore;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.io.ChecklistHtmlOutput;
import com.scythebill.birdlist.ui.io.ChecklistXlsOutput;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.BrowsePreferences;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.ShowSpeciesMap;
import com.scythebill.birdlist.ui.panels.SpHybridDialog;
import com.scythebill.birdlist.ui.panels.SpeciesInfoDescriber;
import com.scythebill.birdlist.ui.panels.location.ChecklistPrintDialog;
import com.scythebill.birdlist.ui.panels.location.ChecklistPrintPreferences;
import com.scythebill.birdlist.ui.panels.location.ChecklistXlsDialog;
import com.scythebill.birdlist.ui.panels.location.CreateChecklistPanel;
import com.scythebill.birdlist.ui.panels.location.EditChecklistPanel;
import com.scythebill.birdlist.ui.panels.location.LocationBrowsePreferences;
import com.scythebill.birdlist.ui.panels.location.LocationEditorPanel;
import com.scythebill.birdlist.ui.panels.location.LocationTree;
import com.scythebill.birdlist.ui.panels.location.LocationTreeModel;
import com.scythebill.birdlist.ui.panels.reports.QueryDialog;
import com.scythebill.birdlist.ui.panels.reports.QueryExecutor;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.panels.reports.ReportHints;
import com.scythebill.birdlist.ui.panels.reports.ReportsActionFactory;
import com.scythebill.birdlist.ui.panels.reports.ReportsBrowserPanel;
import com.scythebill.birdlist.ui.panels.reports.ReportsTreeModel;
import com.scythebill.birdlist.ui.prefs.ReportSetPreference;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import com.scythebill.birdlist.ui.util.EncounteredLocations;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import com.scythebill.birdlist.ui.util.LocationScorer;
import com.scythebill.birdlist.ui.util.OpenMapUrl;
import com.scythebill.birdlist.ui.util.ResolvedWithKey;
import com.scythebill.birdlist.ui.util.ResolvedWithSighting;
import com.scythebill.birdlist.ui.util.ScanSeenTaxa;
import com.scythebill.birdlist.ui.util.UIUtils;
import com.scythebill.birdlist.ui.util.VisibilityDetector;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.CellRendererPane;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.joda.time.LocalTime;

public class LocationBrowsePanel
extends JPanel
implements Titled,
FontManager.FontsUpdatedListener {
    private static final int SELECTION_QUERY_DELAY_MILLIS = 200;
    private final FontManager fontManager;
    private final ReportSet reportSet;
    private final TaxonomyStore taxonomyStore;
    private final ActionBroker actionBroker;
    private final NewLocationDialog newLocationDialog;
    private final Checklists checklists;
    private final TransposedChecklistSynthesizer transposedChecklistSynthesizer;
    private final ChecklistSynthesizer checklistSynthesizer;
    private final Alerts alerts;
    private final QueryPreferences queryPreferences;
    private final BrowsePreferences browsePreferences;
    private final ReportSetPreference<LocationBrowsePreferences> locationBrowsePreferences;
    private LocationTree locationTree;
    private ReportsBrowserPanel reportsBrowser;
    private JButton returnButton;
    private IndexerPanel<Object> locationIndexPanel;
    private JButton jumpButton;
    private IndexerPanel<String> speciesIndexPanel;
    private JButton speciesJumpButton;
    private JLabel totalLabel;
    private Timer runQueryTimer;
    private LocationEditorPanel locationEditorPanel;
    private JButton deleteLocation;
    private JButton editLocation;
    private JButton newLocation;
    private JScrollPane treeScrollPane;
    private JScrollPane reportsScrollPane;
    private final ImageIcon checkIcon;
    private final ImageIcon latLongIcon;
    private final ListeningExecutorService executorService;
    private QueryResults currentQueryResults;
    private ScanSeenTaxa scanSeenTaxa;
    private boolean customScanner;
    private JComboBox<Object> reportFilterCombo;
    private JCheckBox noRarities;
    private JButton xlsButton;
    private JButton tripReportButton;
    private final FileDialogs fileDialogs;
    private final ChecklistXlsDialog checklistXlsDialog;
    private final ChecklistPrintDialog checklistPrintDialog;
    private final PredefinedLocations predefinedLocations;
    private final EventBusRegistrar eventBusRegistrar;
    private final SpeciesInfoDescriber speciesInfoDescriber;
    private final SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer;
    private final ShowSpeciesMap showSpeciesMap;
    private final QueryDialog queryDialog;
    private JButton addSightingButton;
    private JButton removeSightingButton;
    private WherePanelIndexers whereIndexers;
    private JButton editChecklist;
    private JButton shareChecklist;
    private JPanel reportsOrEditChecklist;
    private DefaultUserStore defaultUserStore;
    private JCheckBox onlyVisitedLocations;
    private Set<Location> addedLocations = new LinkedHashSet<Location>();
    private Predicate<Location> locationFilter;
    private final CellRendererPane cellRendererPane = new CellRendererPane();
    private TreePath cachedRendererComponentPath;
    private static final Object LAT_LONG_PROPERTY = new Object();
    private final OpenMapUrl openMapUrl;
    private ReportsActionFactory reportsActionFactory;
    private JButton printButton;
    private JButton createTripButton;
    private LocationScorer locationScorer;
    private SyntheticLocations syntheticLocations;
    private static final ImmutableSet<VisitInfo.ObservationType> SAFE_OBSERVATION_TYPES = ImmutableSet.of(VisitInfo.ObservationType.INCIDENTAL, VisitInfo.ObservationType.HISTORICAL);

    @Inject
    public LocationBrowsePanel(ReportSet reportSet, TaxonomyStore taxonomyStore, DefaultUserStore defaultUserStore, LocationReportsBrowserPanel reportsBrowser, ActionBroker actionBroker, ReturnAction returnAction, FontManager fontManager, EventBusRegistrar eventBusRegistrar, NewLocationDialog newLocationDialog, FileDialogs fileDialogs, PredefinedLocations predefinedLocations, Checklists checklists, TransposedChecklistSynthesizer transposedChecklistSynthesizer, ChecklistSynthesizer checklistSynthesizer, ChecklistXlsDialog checklistXlsDialog, ChecklistPrintDialog checklistPrintDialog, QueryDialog queryDialog, QueryPreferences queryPreferences, ReportsActionFactory reportsActionFactory, BrowsePreferences browsePreferences, ReportSetPreference<LocationBrowsePreferences> locationBrowsePreferences, Alerts alerts, ListeningExecutorService executorService, SpeciesInfoDescriber speciesInfoDescriber, SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer, ShowSpeciesMap showSpeciesMap, OpenMapUrl openMapUrl, LocationScorer locationScorer, VisibilityDetector visibilityDetector) {
        Location location;
        this.reportSet = reportSet;
        this.taxonomyStore = taxonomyStore;
        this.defaultUserStore = defaultUserStore;
        this.reportsBrowser = reportsBrowser;
        this.actionBroker = actionBroker;
        this.fontManager = fontManager;
        this.eventBusRegistrar = eventBusRegistrar;
        this.newLocationDialog = newLocationDialog;
        this.fileDialogs = fileDialogs;
        this.predefinedLocations = predefinedLocations;
        this.syntheticLocations = new SyntheticLocations(reportSet.getLocations());
        this.checklists = checklists;
        this.transposedChecklistSynthesizer = transposedChecklistSynthesizer;
        this.checklistSynthesizer = checklistSynthesizer;
        this.checklistXlsDialog = checklistXlsDialog;
        this.checklistPrintDialog = checklistPrintDialog;
        this.queryDialog = queryDialog;
        this.queryPreferences = queryPreferences;
        this.reportsActionFactory = reportsActionFactory;
        this.browsePreferences = browsePreferences;
        this.locationBrowsePreferences = locationBrowsePreferences;
        this.alerts = alerts;
        this.executorService = executorService;
        this.speciesInfoDescriber = speciesInfoDescriber;
        this.speciesIndexerPanelConfigurer = speciesIndexerPanelConfigurer;
        this.showSpeciesMap = showSpeciesMap;
        this.openMapUrl = openMapUrl;
        this.locationScorer = locationScorer;
        ImageIcon checkOriginalSize = new ImageIcon(LocationTree.class.getResource("check.png"));
        this.checkIcon = new ImageIcon(checkOriginalSize.getImage().getScaledInstance(12, 12, 4));
        ImageIcon latLongOriginalSize = new ImageIcon(WherePanel.class.getResource("latlong.png"));
        this.latLongIcon = new ImageIcon(latLongOriginalSize.getImage().getScaledInstance(12, 12, 4));
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.initGUI();
        this.hookUpContents(returnAction);
        visibilityDetector.install(this.returnButton);
        String initialLocationId = locationBrowsePreferences.get().lastLocationId;
        if (initialLocationId != null && (location = reportSet.getLocations().getLocation(initialLocationId)) != null) {
            this.locationTree.selectLocation(location);
        }
    }

    private void hookUpContents(ReturnAction returnAction) {
        this.updateLocationFilter();
        this.whereIndexers = new WherePanelIndexers(this.reportSet.getLocations(), this.predefinedLocations, false, null, this.locationFilter, this.syntheticLocations);
        this.attachLocationIndexer();
        this.returnButton.setAction(returnAction);
        this.locationIndexPanel.addPropertyChangeListener("value", e -> this.jumpButton.setEnabled(e.getNewValue() != null));
        this.locationIndexPanel.addActionListener(e -> this.jumpButton.doClick(100));
        this.locationIndexPanel.setOrdering(this.locationScorer.ordering());
        this.jumpButton.setEnabled(false);
        this.jumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object locationId = LocationBrowsePanel.this.locationIndexPanel.getValue();
                Location location = WherePanelIndexers.toLocation(LocationBrowsePanel.this.reportSet.getLocations(), locationId);
                if (location != null) {
                    LocationBrowsePanel.this.locationTree.selectLocation(location);
                    LocationBrowsePanel.this.locationTree.requestFocusInWindow();
                }
            }
        });
        this.speciesIndexPanel.addPropertyChangeListener("value", e -> this.speciesJumpButton.setEnabled(e.getNewValue() != null));
        this.speciesIndexPanel.addActionListener(e -> this.speciesJumpButton.doClick(100));
        this.speciesIndexPanel.setEnabled(false);
        this.speciesJumpButton.setEnabled(false);
        this.speciesJumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Taxon taxon;
                String id = LocationBrowsePanel.this.speciesIndexPanel.getValue();
                if (id != null && (taxon = LocationBrowsePanel.this.taxonomyStore.getTaxonomy().getTaxon(id)) != null) {
                    LocationBrowsePanel.this.reportsBrowser.selectTaxon(taxon);
                    LocationBrowsePanel.this.reportsBrowser.requestFocusInWindow();
                }
            }
        });
        this.runQueryTimer = new Timer(200, e -> {
            this.runQueryForCurrentSelection();
            this.updateLocationEditingForSelection();
        });
        this.runQueryTimer.setRepeats(false);
        this.locationTree.addTreeSelectionListener(e -> {
            this.runQueryTimer.restart();
            this.cachedRendererComponentPath = null;
        });
        this.locationTree.addLocationsEditedListener(new LocationTree.LocationsEditedListener(){

            @Override
            public void onEdited() {
                LocationBrowsePanel.this.rebuildLocationIndices();
                LocationBrowsePanel.this.updateLocationEditingForSelection();
                LocationBrowsePanel.this.runQueryForCurrentSelection();
            }
        });
        this.locationTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                LocationBrowsePanel.this.cachedRendererComponentPath = null;
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                LocationBrowsePanel.this.cachedRendererComponentPath = null;
            }
        });
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            MouseAdapter adapter = new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    TreePath path = LocationBrowsePanel.this.locationTree.getPathForLocation(e.getX(), e.getY());
                    LatLongCoordinates latLong = LocationBrowsePanel.this.isOverLatLongIcon(path, e.getPoint());
                    if (latLong != null) {
                        LocationBrowsePanel.this.locationTree.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        LocationBrowsePanel.this.locationTree.setCursor(Cursor.getDefaultCursor());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    TreePath path = LocationBrowsePanel.this.locationTree.getPathForLocation(e.getX(), e.getY());
                    LatLongCoordinates latLong = LocationBrowsePanel.this.isOverLatLongIcon(path, e.getPoint());
                    if (latLong != null) {
                        LocationBrowsePanel.this.openMapUrl.openLatLong(latLong);
                        e.consume();
                    }
                }
            };
            this.locationTree.addMouseListener(adapter);
            this.locationTree.addMouseMotionListener(adapter);
        }
        this.reportFilterCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (LocationBrowsePanel.this.reportFilterCombo.getSelectedItem() == ReportFilter.CUSTOM_FILTER) {
                    QueryDialog.QueryDefinitionReceiver queryDefinitionReceiver = new QueryDialog.QueryDefinitionReceiver(){

                        @Override
                        public void queryDefinitionAvailable(QueryDefinition queryDefinition, Optional<String> optionalName) {
                            LocationBrowsePanel.this.reportFilterCombo.addItem(new CustomReportFilter(queryDefinition, optionalName));
                            LocationBrowsePanel.this.reportFilterCombo.setSelectedIndex(LocationBrowsePanel.this.reportFilterCombo.getItemCount() - 1);
                            LocationBrowsePanel.this.reportFilterCombo.setMaximumRowCount(LocationBrowsePanel.this.reportFilterCombo.getItemCount());
                            LocationBrowsePanel.this.startScanningTaxa(LocationBrowsePanel.this.reportsBrowser.getTaxonomy());
                        }

                        @Override
                        public void cancelled() {
                            LocationBrowsePanel.this.reportFilterCombo.setSelectedIndex(0);
                        }
                    };
                    LocationBrowsePanel.this.queryDialog.showQueryDefinition(SwingUtilities.getWindowAncestor(LocationBrowsePanel.this), "<html>" + Messages.getMessage(Messages.Name.CUSTOM_FILTER_HELP), LocationBrowsePanel.this.reportSet, LocationBrowsePanel.this.taxonomyStore.getTaxonomy(), queryDefinitionReceiver);
                } else if (LocationBrowsePanel.this.customScanner || LocationBrowsePanel.this.reportFilterCombo.getSelectedItem() instanceof CustomReportFilter) {
                    LocationBrowsePanel.this.startScanningTaxa(LocationBrowsePanel.this.reportsBrowser.getTaxonomy());
                } else {
                    LocationBrowsePanel.this.runQueryForCurrentSelection();
                }
            }
        });
        this.noRarities.addActionListener(e -> this.runQueryForCurrentSelection());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent event) {
                LocationBrowsePanel.this.runQueryTimer.stop();
            }
        });
        this.locationEditorPanel.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Location oldLocation = (Location)event.getOldValue();
                Location newLocation = (Location)event.getNewValue();
                LocationBrowsePanel.this.replaceWithEditedLocation(oldLocation, newLocation);
            }
        });
        this.reportsBrowser.addVisitInfoKeyChangedListener(new ReportsBrowserPanel.VisitInfoKeyChangedListener(){

            @Override
            public void newVisitInfoKey(VisitInfoKey visitInfoKey) {
                List<Location> selectedLocations = LocationBrowsePanel.this.getSelectedLocations();
                Location newLocation = LocationBrowsePanel.this.reportSet.getLocations().getLocation(visitInfoKey.locationId());
                boolean isInAny = false;
                for (Location selectedLocation : selectedLocations) {
                    if (!newLocation.isIn(selectedLocation)) continue;
                    isInAny = true;
                    break;
                }
                TreePath lastParentPath = null;
                TreePath treePath = LocationBrowsePanel.this.locationTree.getTreePath(newLocation);
                ImmutableList<Object> pathList = ImmutableList.copyOf(treePath.getPath());
                ArrayList<Object> establishedPath = Lists.newArrayList(pathList.get(0));
                for (Object nextEntry : Iterables.skip(pathList, 1)) {
                    Object previousEntry = Iterables.getLast(establishedPath);
                    if (LocationBrowsePanel.this.locationTree.getModel().getIndexOfChild(previousEntry, nextEntry) < 0) break;
                    establishedPath.add(nextEntry);
                }
                if (establishedPath.size() != pathList.size()) {
                    lastParentPath = new TreePath(establishedPath.toArray());
                }
                if (!isInAny) {
                    if (lastParentPath != null) {
                        LocationBrowsePanel.this.updateTreeForNewPath(lastParentPath, newLocation);
                    } else {
                        LocationBrowsePanel.this.locationTree.setSelectionPath(treePath);
                        LocationBrowsePanel.this.locationTree.scrollPathToVisible(treePath);
                    }
                } else if (lastParentPath != null) {
                    TreePath[] selectionPaths = LocationBrowsePanel.this.locationTree.getSelectionPaths();
                    LocationBrowsePanel.this.updateTreeForNewPath(lastParentPath, newLocation);
                    LocationBrowsePanel.this.locationTree.setSelectionPaths(selectionPaths);
                }
                LocationBrowsePanel.this.runQueryForCurrentSelection();
                LocationBrowsePanel.this.reportsBrowser.selectVisitInfo(visitInfoKey);
            }

            @Override
            public void deletedVisitInfoKey(VisitInfoKey visitInfoKey) {
                LocationBrowsePanel.this.runQueryForCurrentSelection();
            }
        });
        this.onlyVisitedLocations.addActionListener(e -> {
            Object locationId;
            this.browsePreferences.onlyVisitedLocations = this.onlyVisitedLocations.isSelected();
            this.updateLocationFilter();
            this.rebuildLocationIndices();
            if (this.onlyVisitedLocations.isSelected() && (locationId = this.locationIndexPanel.getValue()) != null && !this.locationFilter.apply(this.reportSet.getLocations().getLocation((String)locationId))) {
                this.locationIndexPanel.setTextValue("");
            }
        });
        this.updateSightingButtons(null);
        this.setTaxonomy(this.taxonomyStore.getTaxonomy());
    }

    private void rebuildLocationIndices() {
        this.whereIndexers.reindex(false, this.locationFilter);
        this.attachLocationIndexer();
    }

    public void attachLocationIndexer() {
        this.whereIndexers.configureIndexer(this.locationIndexPanel);
    }

    private boolean replaceWithEditedLocation(Location oldLocation, Location newLocation) {
        if (newLocation == null) {
            return false;
        }
        Location existingLocation = null;
        PredefinedLocations.PredefinedLocation existingPredefinedLocation = null;
        if (newLocation.getParent() != null) {
            existingLocation = newLocation.getParent().getContent(newLocation.getModelName());
            if (existingLocation == oldLocation) {
                existingLocation = null;
            } else if (existingLocation == null) {
                existingPredefinedLocation = this.predefinedLocations.getPredefinedLocationChildThatHasNotBeenCreatedYet(this.reportSet.getLocations(), newLocation.getParent(), newLocation.getModelName());
            }
        }
        if (newLocation.isBuiltInLocation()) {
            this.alerts.showError((Object)this, Messages.Name.NAME_ALREADY_EXISTS_TITLE, Messages.Name.NAME_ALREADY_EXISTS_MESSAGE, HtmlResponseWriter.htmlEscape(newLocation.getModelName()), HtmlResponseWriter.htmlEscape(newLocation.getParent().getModelName()));
            this.locationEditorPanel.setLocation(oldLocation);
            return false;
        }
        boolean parentsHaveChanged = oldLocation.getParent() != newLocation.getParent();
        TreePath oldTreePath = this.locationTree.getTreePath(oldLocation);
        if (existingLocation != null || existingPredefinedLocation != null) {
            if (this.alerts.showOkCancel((Object)this, Messages.Name.MERGE_LOCATIONS_TITLE, Messages.Name.MERGE_SINGLE_LOCATION_MESSAGE, HtmlResponseWriter.htmlEscape(newLocation.getModelName()), HtmlResponseWriter.htmlEscape(newLocation.getParent().getModelName())) != 0) {
                this.locationEditorPanel.setLocation(oldLocation);
                return false;
            }
            this.whereIndexers.remove(oldLocation);
            newLocation = existingLocation != null ? existingLocation : existingPredefinedLocation.create(this.reportSet.getLocations(), newLocation.getParent());
            Locations.replaceLocation(newLocation, oldLocation, this.reportSet);
            parentsHaveChanged = true;
        } else {
            this.whereIndexers.remove(oldLocation);
            this.reportSet.replaceLocation(oldLocation, newLocation);
            this.reportSet.getLocations().ensureAdded(newLocation);
        }
        this.whereIndexers.add(newLocation);
        if (this.addedLocations.contains(oldLocation)) {
            this.addedLocations.add(newLocation);
        }
        if (parentsHaveChanged) {
            TreePath newTreePath = this.locationTree.getTreePath(newLocation);
            this.locationTree.getModel().valueForPathChanged(oldTreePath, oldTreePath.getLastPathComponent());
            this.locationTree.getModel().valueForPathChanged(newTreePath, newTreePath.getLastPathComponent());
            this.locationTree.setSelectionPath(newTreePath);
            this.locationTree.scrollPathToVisible(newTreePath);
        } else {
            TreePath[] paths = this.locationTree.getSelectionPaths();
            if (paths != null) {
                for (int i = 0; i < paths.length; ++i) {
                    paths[i] = this.replacePathSegment(paths[i], oldLocation, newLocation);
                }
            }
            TreePath newTreePath = this.locationTree.getTreePath(newLocation);
            this.locationTree.getModel().valueForPathChanged(newTreePath, newLocation);
            this.locationTree.setSelectionPaths(paths);
            this.locationTree.scrollPathToVisible(newTreePath);
        }
        this.locationEditorPanel.setLocation(newLocation);
        return true;
    }

    private TreePath replacePathSegment(TreePath treePath, Object oldSegment, Object newSegment) {
        Object[] pathObjects = treePath.getPath();
        for (int i = 0; i < pathObjects.length; ++i) {
            if (pathObjects[i] != oldSegment) continue;
            pathObjects[i] = newSegment;
            return new TreePath(pathObjects);
        }
        return treePath;
    }

    private void runQueryForCurrentSelection() {
        List<Object> queriedTaxa;
        this.cachedRendererComponentPath = null;
        TreePath[] paths = this.locationTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            this.reportsBrowser.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("")));
            this.totalLabel.setText(" ");
            this.reportFilterCombo.setEnabled(false);
            this.noRarities.setEnabled(false);
            this.xlsButton.setVisible(false);
            this.printButton.setVisible(false);
            this.editChecklist.setVisible(false);
            this.shareChecklist.setVisible(false);
            queriedTaxa = ImmutableList.of();
        } else {
            ArrayList<Location> locations = Lists.newArrayList();
            for (TreePath path : paths) {
                locations.add((Location)path.getLastPathComponent());
            }
            Checklist checklist = this.getChecklist(this.taxonomyStore.getTaxonomy(), locations);
            QueryProcessor processor = this.newQueryProcessor(locations, checklist, null).includingIncompatibleSightings();
            if (locations.size() != 1 || !this.taxonomyStore.getTaxonomy().isBuiltIn() || checklist != null && checklist.isSynthetic() || checklist == null && ((Location)locations.get(0)).isBuiltInLocation() && ((Location)locations.get(0)).getType() == Location.Type.region) {
                this.editChecklist.setVisible(false);
                this.shareChecklist.setVisible(false);
            } else if (checklist != null) {
                this.editChecklist.setText(checklist.isBuiltIn() ? Messages.getMessage(Messages.Name.CORRECT_CHECKLIST) : Messages.getMessage(Messages.Name.EDIT_CHECKLIST));
                this.editChecklist.setVisible(true);
                this.shareChecklist.setVisible(!checklist.isBuiltIn());
            } else {
                this.editChecklist.setVisible(true);
                this.editChecklist.setText(Messages.getMessage(Messages.Name.CREATE_CHECKLIST));
                this.shareChecklist.setVisible(false);
            }
            Predicate<Sighting> predicate = this.locationPredicate(locations);
            QueryResults queryResults = processor.runQuery(predicate, this.queryPreferences.getCountablePredicate(this.taxonomyStore.getTaxonomy(), false, null), Taxon.Type.species);
            this.reportsBrowser.setLocationRoot(locations.size() == 1 ? (Location)locations.get(0) : null);
            HashSet allLocationIds = new HashSet();
            for (Location location : locations) {
                Locations.visitLocations(location, l -> allLocationIds.add(l.getId()));
            }
            ArrayList locationTrips = this.reportSet.getTrips().allTrips().stream().filter(t -> allLocationIds.contains(t.locationId())).collect(Collectors.toCollection(ArrayList::new));
            this.reportsBrowser.setQueryResults(queryResults, true, locationTrips, false);
            Object root = this.reportsBrowser.getModel().getRoot();
            int childCount = this.reportsBrowser.getModel().getChildCount(root);
            for (int i = 0; i < childCount; ++i) {
                SightingTaxon.Resolved resolved;
                Object child = this.reportsBrowser.getModel().getChild(root, i);
                boolean selectChild = false;
                if (child instanceof SightingTaxon.Resolved && (resolved = (SightingTaxon.Resolved)child).getSmallestTaxonType() != Taxon.Type.family) {
                    selectChild = true;
                }
                if (this.reportsBrowser.isVisitsParentNode(child)) {
                    selectChild = true;
                }
                if (!selectChild) continue;
                this.reportsBrowser.setSelectionPath(new TreePath(new Object[]{root, child}));
                break;
            }
            queryResults.addListener(() -> this.queryResultsUpdated(queryResults));
            this.queryResultsUpdated(queryResults);
            this.reportFilterCombo.setEnabled(checklist != null);
            this.noRarities.setEnabled(checklist != null);
            this.xlsButton.setVisible(checklist != null);
            this.printButton.setVisible(checklist != null);
            queriedTaxa = queryResults.getTaxaAsList();
        }
        this.speciesIndexPanel.setTextValue("");
        if (queriedTaxa.isEmpty()) {
            this.speciesIndexPanel.setEnabled(false);
        } else {
            LinkedHashSet<String> taxa = new LinkedHashSet<String>();
            for (SightingTaxon.Resolved resolved : queriedTaxa) {
                if (resolved.getType() != SightingTaxon.Type.SINGLE) continue;
                Taxon taxon = resolved.getTaxon();
                taxa.add(taxon.getId());
            }
            this.speciesIndexPanel.setFilter(taxa::contains);
            this.speciesIndexPanel.setEnabled(true);
        }
        this.runQueryTimer.stop();
    }

    private Predicate<Sighting> locationPredicate(List<Location> locations) {
        ArrayList<Predicate<Sighting>> predicates = Lists.newArrayList();
        for (Location location : locations) {
            predicates.add(SightingPredicates.in(location, this.reportSet.getLocations()));
        }
        Predicate<Sighting> predicate = Predicates.or(predicates);
        Object filter = this.reportFilterCombo.getSelectedItem();
        if (filter == ReportFilter.ONLY_LIFERS) {
            predicate = Predicates.and(predicate, this.queryPreferences.getCountablePredicate(this.taxonomyStore.getTaxonomy(), false, null));
        }
        if (this.defaultUserStore.getUser() != null) {
            predicate = Predicates.and(predicate, SightingPredicates.includesUser(this.defaultUserStore.getUser()));
        }
        return predicate;
    }

    private void queryResultsUpdated(QueryResults queryResults) {
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        int speciesCount = queryResults.getCountableSpeciesSize(taxonomy, false);
        Checklist checklist = queryResults.getChecklist(taxonomy);
        if (checklist != null) {
            String totalsText = this.getChecklistTotals(checklist, taxonomy, speciesCount, this.scanSeenTaxa);
            this.totalLabel.setText(totalsText);
        } else {
            this.totalLabel.setText(Messages.getFormattedMessage(Messages.Name.TOTAL_SPECIES_FORMAT_NO_CHECKLIST, speciesCount));
        }
        Object filter = this.reportFilterCombo.getSelectedItem();
        boolean filterWithFamilyTotals = filter == ReportFilter.ONLY_RECORDED || filter == ReportFilter.SHOW_ALL;
        this.reportsBrowser.setShowFamilyTotals(checklist != null && filterWithFamilyTotals);
        this.currentQueryResults = queryResults;
    }

    private String getChecklistTotals(Checklist checklist, Taxonomy taxonomy, int speciesCount, ScanSeenTaxa currentSeenTaxa) {
        int lifers = -1;
        boolean ignoreRarities = this.noRarities.isSelected();
        Set<String> seenTaxa = null;
        if (currentSeenTaxa != null && (seenTaxa = currentSeenTaxa.getSeenTaxa(taxonomy, null)) != null) {
            lifers = 0;
            for (SightingTaxon taxon : checklist.getTaxa(taxonomy)) {
                Checklist.Status status;
                if (taxon.getType() != SightingTaxon.Type.SINGLE || seenTaxa.contains(taxon.getId()) || (status = checklist.getStatus(taxonomy, taxon)) == Checklist.Status.ESCAPED || status == Checklist.Status.EXTINCT || (status == Checklist.Status.RARITY || status == Checklist.Status.RARITY_FROM_INTRODUCED) && ignoreRarities) continue;
                ++lifers;
            }
        }
        int checklistCount = checklist.getTaxa(taxonomy).size();
        checklistCount -= checklist.getTaxa(taxonomy, Checklist.Status.ESCAPED).size();
        if (this.noRarities.isSelected()) {
            checklistCount -= checklist.getTaxa(taxonomy, Checklist.Status.RARITY).size();
        }
        ImmutableSet<SightingTaxon> endemics = checklist.getTaxa(taxonomy, Checklist.Status.ENDEMIC);
        int endemicCount = endemics.size();
        int endemicsSeen = 0;
        if (seenTaxa != null) {
            for (SightingTaxon endemic : endemics) {
                if (!seenTaxa.contains(endemic.getId())) continue;
                ++endemicsSeen;
            }
        }
        if (lifers >= 0) {
            Object reportFilterObj = this.reportFilterCombo.getSelectedItem();
            String lifersString = reportFilterObj instanceof CustomReportFilter ? Messages.getFormattedMessage(Messages.Name.SIGHTINGS_NEW_FOR_FORMAT, lifers, ((CustomReportFilter)reportFilterObj).optionalName.or(Messages.getMessage(Messages.Name.CUSTOM_REPORT))) : Messages.getFormattedMessage(Messages.Name.POSSIBLE_LIFERS_FORMAT, lifers);
            if (endemicCount == 0) {
                return Messages.getFormattedMessage(Messages.Name.TOTAL_SPECIES_WITH_LIFERS_FORMAT, speciesCount, checklistCount, lifersString);
            }
            if (endemicsSeen > 0) {
                return Messages.getFormattedMessage(Messages.Name.TOTAL_SPECIES_WITH_LIFERS_AND_ENDEMICS_SOME_SEEN, speciesCount, endemicsSeen, checklistCount, endemicCount, lifersString);
            }
            return Messages.getFormattedMessage(Messages.Name.TOTAL_SPECIES_WITH_LIFERS_AND_ENDEMICS, speciesCount, checklistCount, endemicCount, lifersString);
        }
        if (endemicCount == 0) {
            return Messages.getFormattedMessage(Messages.Name.TOTAL_SPECIES_FORMAT, speciesCount, checklistCount);
        }
        if (endemicsSeen > 0) {
            return Messages.getFormattedMessage(Messages.Name.TOTAL_SPECIES_WITH_ENDEMICS_SOME_SEEN, speciesCount, endemicsSeen, checklistCount, endemicCount);
        }
        return Messages.getFormattedMessage(Messages.Name.TOTAL_SPECIES_WITH_ENDEMICS, speciesCount, checklistCount, endemicCount);
    }

    private void updateLocationEditingForSelection() {
        Location location = this.getOnlySelectedLocation();
        this.locationEditorPanel.setLocation(location);
        if (location == null) {
            this.locationEditorPanel.setEnabled(false);
            this.deleteLocation.setEnabled(false);
            this.editLocation.setEnabled(false);
            this.newLocation.setEnabled(false);
            this.newLocation.setToolTipText(Messages.getMessage(Messages.Name.CREATES_A_NEW_LOCATION));
        } else {
            this.locationEditorPanel.setEnabled(!location.isBuiltInLocation());
            this.deleteLocation.setEnabled(location.getParent() != null && location.contents().isEmpty() && !location.isBuiltInLocation());
            this.editLocation.setEnabled(location.getParent() != null && !location.isBuiltInLocation());
            this.newLocation.setEnabled(true);
            this.newLocation.setToolTipText(Messages.getFormattedMessage(Messages.Name.CREATES_A_NEW_LOCATION_INSIDE_FORMAT, location.getDisplayName()));
        }
        this.locationBrowsePreferences.get().lastLocationId = location == null ? null : location.getId();
        this.locationBrowsePreferences.save(false);
    }

    private void deleteLocation() {
        Location location = this.getOnlySelectedLocation();
        String locationName = LocationIdToString.getStringWithType(location);
        TreePath parentPath = this.locationTree.getTreePath(location.getParent());
        String parentLocationName = LocationIdToString.getStringWithType(location.getParent());
        if (this.alerts.showOkCancel((Object)this, Messages.Name.DELETE_LOCATION_TITLE, Messages.Name.DELETE_LOCATION_MESSAGE, HtmlResponseWriter.htmlEscape(locationName), HtmlResponseWriter.htmlEscape(parentLocationName)) == 0) {
            this.whereIndexers.remove(location);
            this.reportSet.deleteLocation(location);
            this.locationTree.getModel().valueForPathChanged(parentPath, parentPath.getLastPathComponent());
            this.locationTree.setSelectionPath(parentPath);
            this.locationTree.expandPath(parentPath);
        }
    }

    private void editLocation() {
        Location selectedLocation = this.getOnlySelectedLocation();
        Preconditions.checkState(!selectedLocation.isBuiltInLocation());
        this.newLocationDialog.editLocation(selectedLocation, SwingUtilities.getWindowAncestor(this), location -> this.replaceWithEditedLocation(selectedLocation, location));
    }

    private void newLocation() {
        Location selectedLocation = this.getOnlySelectedLocation();
        this.reportSet.getLocations().ensureAdded(selectedLocation);
        final TreePath path = this.locationTree.getTreePath(selectedLocation);
        NewLocationDialog.LocationReceiver locationReceiver = new NewLocationDialog.LocationReceiver(){

            @Override
            public boolean locationAvailable(Location location) {
                LocationBrowsePanel.this.reportSet.getLocations().ensureAdded(location);
                LocationBrowsePanel.this.addedLocations.add(location);
                LocationBrowsePanel.this.updateTreeForNewPath(path, location);
                return true;
            }
        };
        this.newLocationDialog.newLocation(selectedLocation, SwingUtilities.getWindowAncestor(this), locationReceiver);
    }

    private void updateTreeForNewPath(TreePath originalParentPath, Location location) {
        ((LocationTreeModel)this.locationTree.getModel()).newLocation(originalParentPath, location);
        TreePath newLocationPath = this.locationTree.getTreePath(location);
        this.locationTree.expandPath(newLocationPath.getParentPath());
        this.locationTree.selectLocation(location);
        this.rebuildLocationIndices();
    }

    /*
     * Unable to fully structure code
     */
    private QueryProcessor newQueryProcessor(List<Location> locations, final Checklist checklist, @Nullable Map<Taxonomy, Checklist> extendedTaxonomyChecklists) {
        block8: {
            block10: {
                block9: {
                    processor = new QueryProcessor(this.reportSet, this.taxonomyStore.getTaxonomy(), checklist, extendedTaxonomyChecklists);
                    if (checklist == null) break block8;
                    filter = this.reportFilterCombo.getSelectedItem();
                    if (filter != ReportFilter.ONLY_ENDEMICS) break block9;
                    processor.withTaxonFilter(new Predicate<SightingTaxon.Resolved>(){

                        @Override
                        public boolean apply(SightingTaxon.Resolved resolved) {
                            Checklist.Status status = checklist.getStatus(resolved.getTaxonomy(), resolved.getSightingTaxon());
                            return status == Checklist.Status.ENDEMIC;
                        }
                    });
                    break block10;
                }
                if (filter == ReportFilter.ONLY_LIFERS) ** GOTO lbl13
                if (filter instanceof CustomReportFilter) {
lbl13:
                    // 2 sources

                    processor.withTaxonFilter((Predicate)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, wouldBeLifer(com.scythebill.birdlist.model.sighting.SightingTaxon$Resolved ), (Lcom/scythebill/birdlist/model/sighting/SightingTaxon$Resolved;)Z)((ReportsBrowserPanel)this.reportsBrowser));
                } else if (filter == ReportFilter.NOT_SEEN_HERE) {
                    predicate = this.locationPredicate(locations);
                    queryResults = processor.runQuery(predicate, this.queryPreferences.getCountablePredicate(this.taxonomyStore.getTaxonomy(), false, null), Taxon.Type.species);
                    processor.withTaxonFilter((Predicate)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$newQueryProcessor$12(com.scythebill.birdlist.model.query.QueryResults com.scythebill.birdlist.model.sighting.SightingTaxon$Resolved ), (Lcom/scythebill/birdlist/model/sighting/SightingTaxon$Resolved;)Z)((QueryResults)queryResults));
                }
            }
            if (filter != ReportFilter.ONLY_RECORDED) {
                statusToIgnore = ImmutableSet.builder();
                if (this.noRarities.isSelected()) {
                    statusToIgnore.add((Object)Checklist.Status.RARITY);
                    statusToIgnore.add((Object)Checklist.Status.RARITY_FROM_INTRODUCED);
                }
                if (filter == ReportFilter.ONLY_LIFERS || filter instanceof CustomReportFilter) {
                    statusToIgnore.add((Object[])new Checklist.Status[]{Checklist.Status.EXTINCT, Checklist.Status.ESCAPED});
                }
                if (!this.queryPreferences.countIntroduced) {
                    statusToIgnore.add((Object)Checklist.Status.INTRODUCED);
                    statusToIgnore.add((Object)Checklist.Status.RARITY_FROM_INTRODUCED);
                }
                if (!this.browsePreferences.showExtinctTaxa) {
                    statusToIgnore.add((Object)Checklist.Status.EXTINCT);
                }
                processor.includeAllChecklistSpecies(statusToIgnore.build());
            }
        }
        return processor;
    }

    private Checklist getChecklist(Taxonomy taxonomy, Collection<Location> locations) {
        Checklist checklist;
        if (locations.size() == 1) {
            checklist = this.checklists.getChecklist(this.reportSet, taxonomy, locations.iterator().next());
        } else {
            boolean allBuiltIn = true;
            for (Location location : locations) {
                Checklist locationChecklist = this.checklists.getChecklist(this.reportSet, taxonomy, location);
                if (locationChecklist == null) {
                    return null;
                }
                if (locationChecklist.isBuiltIn()) continue;
                allBuiltIn = false;
                break;
            }
            checklist = allBuiltIn && taxonomy.isBuiltIn() ? this.transposedChecklistSynthesizer.synthesizeChecklist(this.reportSet, taxonomy, locations) : this.checklistSynthesizer.synthesizeChecklist(taxonomy, locations);
        }
        return checklist;
    }

    private void saveChecklistAsSpreadsheet() {
        Object birdChecklist;
        String fileName;
        List<Location> selectedLocations = this.getSelectedLocations();
        if (selectedLocations.isEmpty()) {
            return;
        }
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        Checklist checklist = this.getChecklist(taxonomy, selectedLocations);
        if (checklist == null) {
            return;
        }
        if (selectedLocations.size() == 1) {
            fileName = String.format("checklist-%s.xls", selectedLocations.get(0).getDisplayName());
        } else if (selectedLocations.size() <= 3) {
            ArrayList<String> locationNames = Lists.newArrayList();
            for (Location location : selectedLocations) {
                locationNames.add(location.getDisplayName());
            }
            fileName = String.format("checklist-%s.xls", Joiner.on('-').join(locationNames));
        } else {
            fileName = "checklist.xls";
        }
        File saveFile = this.fileDialogs.saveFile((Frame)SwingUtilities.getWindowAncestor(this), Messages.getMessage(Messages.Name.SAVE_A_SPREADSHEET), fileName, null, FilePreferences.FileType.OTHER);
        if (saveFile == null) {
            return;
        }
        LinkedHashMap<Taxonomy, Object> otherTaxonomiesWithChecklists = new LinkedHashMap<Taxonomy, Object>();
        if (!taxonomy.isBuiltIn() && (birdChecklist = this.getChecklist(this.taxonomyStore.getClements(), selectedLocations)) != null) {
            otherTaxonomiesWithChecklists.put(this.taxonomyStore.getClements(), birdChecklist);
        }
        for (Taxonomy extendedTaxonomy : this.reportSet.extendedTaxonomies()) {
            Checklist extendedChecklist;
            if (extendedTaxonomy == taxonomy || (extendedChecklist = this.getChecklist(extendedTaxonomy, selectedLocations)) == null) continue;
            otherTaxonomiesWithChecklists.put(extendedTaxonomy, extendedChecklist);
        }
        ChecklistXlsDialog.SpreadsheetConfiguration configuration = this.checklistXlsDialog.getConfiguration(this, !otherTaxonomiesWithChecklists.isEmpty(), selectedLocations);
        if (configuration == null) {
            return;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        if (selectedLocations.size() == 1) {
            Location country;
            Location selectedLocation = selectedLocations.get(0);
            locations.add(selectedLocation);
            Location state = Locations.getAncestorOfType(selectedLocation, Location.Type.state);
            if (state != null && state != selectedLocation) {
                locations.add(state);
            }
            if ((country = Locations.getAncestorOfType(selectedLocation, Location.Type.country)) != null && country != selectedLocation) {
                locations.add(country);
            }
        }
        locations.add(null);
        ScanSeenTaxa.start(this.reportSet, taxonomy, this.executorService, scanned -> {
            QueryProcessor processor = this.newQueryProcessor(selectedLocations, checklist, otherTaxonomiesWithChecklists).includingIncompatibleSightings();
            Predicate<Sighting> predicate = this.locationPredicate(selectedLocations);
            QueryResults queryResults = processor.runQuery(predicate, null, Taxon.Type.species);
            QueryResults worldResults = null;
            if (configuration.includeSighting && (configuration.checklistSightingOption == ChecklistXlsOutput.ChecklistSightingOption.FIRST_IN_WORLD || configuration.checklistSightingOption == ChecklistXlsOutput.ChecklistSightingOption.MOST_RECENT_IN_WORLD)) {
                QueryProcessor worldProcessor = new QueryProcessor(this.reportSet, queryResults.getTaxonomy()).includingIncompatibleSightings();
                Predicate<Sighting> worldPredicate = this.queryPreferences.getCountablePredicate(this.taxonomyStore.getTaxonomy(), false, null);
                if (this.defaultUserStore.getUser() != null) {
                    predicate = Predicates.and(predicate, SightingPredicates.includesUser(this.defaultUserStore.getUser()));
                }
                worldResults = worldProcessor.runQuery(worldPredicate, null, Taxon.Type.species);
            }
            try {
                ChecklistXlsOutput output = new ChecklistXlsOutput(saveFile);
                output.setIncludeScientific(configuration.includeScientific);
                output.setShowLifersInBold(configuration.showLifersInBold);
                output.setShowNewForColumn(configuration.showNewForColumn);
                output.setShowStatus(configuration.showStatus);
                output.setIncludeSighting(configuration.includeSighting);
                output.setChecklistSightingOption(configuration.checklistSightingOption);
                output.setShowFamilies(configuration.showFamilies);
                output.setShowAllTaxonomies(configuration.showAllTaxonomies);
                output.setOtherTaxonomiesWithChecklists(otherTaxonomiesWithChecklists);
                LinkedHashMap<Taxonomy, String> totalTextMap = new LinkedHashMap<Taxonomy, String>();
                totalTextMap.put(taxonomy, this.getChecklistTotals(checklist, queryResults.getTaxonomy(), queryResults.getCountableSpeciesSize(taxonomy, false), (ScanSeenTaxa)scanned));
                otherTaxonomiesWithChecklists.forEach((otherTaxonomy, otherChecklist) -> totalTextMap.put((Taxonomy)otherTaxonomy, this.getChecklistTotals((Checklist)otherChecklist, (Taxonomy)otherTaxonomy, queryResults.getCountableSpeciesSize((Taxonomy)otherTaxonomy, false), (ScanSeenTaxa)scanned)));
                output.setTotalText(totalTextMap);
                output.write(this.reportSet, queryResults, worldResults, checklist, (ScanSeenTaxa)scanned, (List<Location>)locations, configuration.daysToInclude);
            }
            catch (IOException e) {
                FileDialogs.showFileSaveError(this.alerts, e, saveFile);
                return;
            }
            try {
                Desktop.getDesktop().open(saveFile);
            }
            catch (IOException e) {
                this.alerts.showError((Object)this, Messages.Name.OPENING_FAILED, Messages.Name.NO_APPLICATION_FOR_XLS_FILES, new Object[0]);
            }
        }, locations, this.sightingPredicate(taxonomy), new ScanSeenTaxa.Options().setIncludeAllTaxonomies(configuration.showAllTaxonomies));
    }

    private void print() {
        File temp;
        List<Location> selectedLocations = this.getSelectedLocations();
        if (selectedLocations.isEmpty()) {
            return;
        }
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        Checklist checklist = this.getChecklist(taxonomy, selectedLocations);
        if (checklist == null) {
            return;
        }
        ChecklistPrintPreferences prefs = this.checklistPrintDialog.getConfiguration(this);
        if (prefs == null) {
            return;
        }
        try {
            temp = File.createTempFile("checklist", ".html");
        }
        catch (IOException e) {
            this.alerts.showError(null, Messages.Name.COULD_NOT_PRINT, Messages.Name.COULD_NOT_CREATE_TEMPORARY_FILE_TO_PRINT, e);
            return;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        if (selectedLocations.size() == 1) {
            Location country;
            Location selectedLocation = selectedLocations.get(0);
            locations.add(selectedLocation);
            Location state = Locations.getAncestorOfType(selectedLocation, Location.Type.state);
            if (state != null && state != selectedLocation) {
                locations.add(state);
            }
            if ((country = Locations.getAncestorOfType(selectedLocation, Location.Type.country)) != null && country != selectedLocation) {
                locations.add(country);
            }
        }
        locations.add(null);
        ScanSeenTaxa.start(this.reportSet, taxonomy, this.executorService, scanned -> {
            QueryProcessor processor = this.newQueryProcessor(selectedLocations, checklist, null);
            Predicate<Sighting> predicate = this.locationPredicate(selectedLocations);
            QueryResults queryResults = processor.runQuery(predicate, null, Taxon.Type.species);
            try {
                ChecklistHtmlOutput output = new ChecklistHtmlOutput(taxonomy);
                output.setTitle(selectedLocations.stream().map(Location::getDisplayName).collect(Collectors.joining(", ")));
                output.setTotalText(this.getChecklistTotals(checklist, queryResults.getTaxonomy(), queryResults.getCountableSpeciesSize(taxonomy, false), (ScanSeenTaxa)scanned));
                output.setShowStatus(prefs.showStatus);
                output.setShowFamilies(prefs.showFamilies);
                output.setShowLifersInBold(prefs.showLifersInBold);
                output.setCompactOutput(prefs.compactPrinting);
                output.setScientificOrCommon(this.checklistPrintDialog.getScientificOrCommonFromConfiguration(prefs));
                output.setPrint(true);
                output.setDaysToInclude(prefs.daysToPrint);
                output.writeSpeciesList(temp, this.reportSet, queryResults, checklist, (ScanSeenTaxa)scanned, (List<Location>)locations);
            }
            catch (IOException e) {
                this.alerts.showError((Object)this, Messages.Name.COULD_NOT_SAVE, Messages.Name.SAVING_THE_SPREADSHEET_DID_NOT_SUCCEED, new Object[0]);
                return;
            }
            try {
                DesktopUtils.openHtmlFileInBrowser(temp);
            }
            catch (IOException e) {
                this.alerts.showError((Object)this, Messages.getMessage(Messages.Name.COULD_NOT_PRINT), Messages.getFormattedMessage(Messages.Name.COULD_NOT_CREATE_TEMPORARY_FILE_TO_PRINT_IN, temp.getParentFile().getAbsolutePath()), e);
            }
        }, locations, this.sightingPredicate(taxonomy), new ScanSeenTaxa.Options());
    }

    private Location rootVistsLocation(Iterable<VisitInfoKey> visitInfoKeys) {
        Location root = null;
        for (VisitInfoKey visitInfoKey : visitInfoKeys) {
            Location location = this.reportSet.getLocations().getLocation(visitInfoKey.locationId());
            if (root == null) {
                root = location;
                continue;
            }
            root = Locations.getCommonAncestor(location, root);
        }
        return root;
    }

    private void createTrip(ActionEvent e) {
        Trip trip;
        Set<VisitInfoKey> visitInfoKeys = this.getSelectedVisitInfoKeys();
        if (visitInfoKeys.isEmpty()) {
            return;
        }
        if (visitInfoKeys.size() == 1) {
            VisitInfoKey visit = visitInfoKeys.iterator().next();
            VisitInfo visitInfo = this.reportSet.getVisitInfo(visit);
            boolean warning = visitInfo == null ? false : visitInfo.distance().isPresent() || visitInfo.area().isPresent() || visitInfo.completeChecklist() || !SAFE_OBSERVATION_TYPES.contains((Object)visitInfo.observationType());
            if (this.alerts.showYesNo((Object)this, Messages.Name.CONVERT_TO_A_TRIP_TITLE, warning ? Messages.Name.CONVERT_TO_A_TRIP_MESSAGE_WARNING : Messages.Name.CONVERT_TO_A_TRIP_MESSAGE_NOTE, new Object[0]) != 0) {
                return;
            }
            Location location = this.reportSet.getLocations().getLocation(visit.locationId());
            String name = String.format("%s, %s", location.getDisplayName(), PartialIO.toShortUserString(visit.date(), this.getLocale()));
            LocalTime endTime = !visit.startTime().isPresent() || visitInfo == null || !visitInfo.duration().isPresent() ? null : visit.startTime().get().plusMinutes((int)visitInfo.duration().get().getStandardMinutes());
            trip = this.reportSet.getTrips().newTripBuilder().withStartDate(visit.date()).withStartTime(visit.startTime().orNull()).withEndDate(visit.date()).withEndTime(endTime).withLocationId(visit.locationId()).withName(name).withNotes(visitInfo == null ? null : visitInfo.comments().orNull()).build();
            ImmutableList.Builder sightingsToAddBuilder = ImmutableList.builder();
            ImmutableList.Builder sightingsToRemoveBuilder = ImmutableList.builder();
            for (Sighting sighting : this.reportSet.getSightings()) {
                if (!visit.matches(sighting)) continue;
                sightingsToRemoveBuilder.add(sighting);
                sightingsToAddBuilder.add(sighting.asBuilder().setDate(null).setTime(null).setTrip(trip).build());
            }
            ImmutableCollection sightingsToAdd = sightingsToAddBuilder.build();
            ImmutableCollection sightingsToRemove = sightingsToRemoveBuilder.build();
            this.reportSet.mutator().adding(sightingsToAdd).removing(sightingsToRemove).mutate();
            this.reportsBrowser.getQueryResults().updateSightings(sightingsToRemove, sightingsToAdd, false);
            ((ReportsTreeModel)this.reportsBrowser.getModel()).removeVisitInfo(visit);
            this.reportsBrowser.invalidateSightings();
        } else {
            VisitInfo lastVisitInfo;
            ImmutableList<VisitInfoKey> sortedVisitInfoKeys = ImmutableList.sortedCopyOf(new VisitInfoKeyOrdering(), visitInfoKeys);
            VisitInfoKey first = (VisitInfoKey)sortedVisitInfoKeys.get(0);
            VisitInfoKey last = (VisitInfoKey)sortedVisitInfoKeys.get(sortedVisitInfoKeys.size() - 1);
            LocalTime endTime = last.startTime().orNull();
            if (endTime != null && (lastVisitInfo = this.reportSet.getVisitInfo(last)) != null && lastVisitInfo.duration().isPresent()) {
                endTime = endTime.plusMinutes((int)lastVisitInfo.duration().get().getStandardMinutes());
            }
            Location location = this.reportSet.getLocations().getLocation(first.locationId());
            for (VisitInfoKey visitInfoKey : Iterables.skip(sortedVisitInfoKeys, 1)) {
                location = Locations.getCommonAncestor(location, this.reportSet.getLocations().getLocation(visitInfoKey.locationId()));
            }
            String dateString = Trips.rangeToUserString(first.date(), last.date(), this.getLocale());
            String name = location == null ? dateString : (dateString == null ? location.getDisplayName() : String.format("%s, %s", location.getDisplayName(), dateString));
            trip = this.reportSet.getTrips().newTripBuilder().withStartDate(first.date()).withStartTime(first.startTime().orNull()).withEndDate(last.date()).withEndTime(endTime).withLocationId(location == null ? null : location.getId()).withName(name).build();
        }
        this.reportsBrowser.addTrip(trip);
        this.reportsBrowser.selectTrip(trip);
        this.reportSet.markDirty();
    }

    private void createTripReport(ActionEvent e) {
        Collection<String> checklistCodes;
        Location rootLocation;
        Predicate predicate;
        Set<VisitInfoKey> visitInfoKeys = this.getSelectedVisitInfoKeys();
        List<Trip> trips = this.getSelectedTrips();
        if (!visitInfoKeys.isEmpty()) {
            predicate = s -> visitInfoKeys.contains(VisitInfoKey.forSighting(s));
            rootLocation = this.rootVistsLocation(visitInfoKeys);
            checklistCodes = Checklists.getCountryChecklistCodes(this.reportSet, visitInfoKeys);
        } else if (!trips.isEmpty()) {
            predicate = Predicates.or(trips.stream().map(trip -> Trips.tripPredicate(this.reportSet, trip, null)).collect(ImmutableList.toImmutableList()));
            rootLocation = Trips.getLocationRoot(this.reportSet, trips);
            checklistCodes = Checklists.getCountryChecklistCodes(this.reportSet, trips);
        } else {
            return;
        }
        QueryExecutor executor = new QueryExecutor(){
            private boolean onlyCountable = false;
            private boolean includeIncompatibleSightings = false;

            @Override
            public QueryExecutor onlyCountable() {
                this.onlyCountable = true;
                return this;
            }

            @Override
            public QueryExecutor includeIncompatibleSightings() {
                this.includeIncompatibleSightings = true;
                return this;
            }

            @Override
            public Location getRootLocation() {
                return rootLocation;
            }

            @Override
            public Optional<String> getReportName() {
                return Optional.absent();
            }

            @Override
            public Set<ReportHints> getReportHints() {
                return ImmutableSet.of();
            }

            @Override
            public Optional<String> getReportAbbreviation() {
                return Optional.absent();
            }

            @Override
            public QueryResults executeQuery(Taxon.Type depthOverride, @Nullable Taxonomy taxonomyOverride) {
                LinkedHashMap<Taxonomy, Checklist> incompatibleTaxonomyChecklists;
                Taxonomy taxonomy = taxonomyOverride == null ? LocationBrowsePanel.this.taxonomyStore.getTaxonomy() : taxonomyOverride;
                Checklist checklist = LocationBrowsePanel.this.checklists.getChecklist(LocationBrowsePanel.this.reportSet, taxonomy, LocationBrowsePanel.this.checklistSynthesizer, checklistCodes);
                if (this.includeIncompatibleSightings) {
                    Object birdChecklist;
                    incompatibleTaxonomyChecklists = new LinkedHashMap<Taxonomy, Checklist>();
                    if (!taxonomy.isBuiltIn() && (birdChecklist = LocationBrowsePanel.this.checklists.getChecklist(LocationBrowsePanel.this.reportSet, LocationBrowsePanel.this.taxonomyStore.getClements(), LocationBrowsePanel.this.checklistSynthesizer, checklistCodes)) != null) {
                        incompatibleTaxonomyChecklists.put(LocationBrowsePanel.this.taxonomyStore.getClements(), (Checklist)birdChecklist);
                    }
                    for (Taxonomy extendedTaxonomy : LocationBrowsePanel.this.reportSet.extendedTaxonomies()) {
                        Checklist extendedChecklist;
                        if (extendedTaxonomy == taxonomy || (extendedChecklist = LocationBrowsePanel.this.checklists.getChecklist(LocationBrowsePanel.this.reportSet, extendedTaxonomy, LocationBrowsePanel.this.checklistSynthesizer, checklistCodes)) == null) continue;
                        incompatibleTaxonomyChecklists.put(extendedTaxonomy, extendedChecklist);
                    }
                } else {
                    incompatibleTaxonomyChecklists = null;
                }
                QueryProcessor processor = new QueryProcessor(LocationBrowsePanel.this.reportSet, taxonomy, checklist, incompatibleTaxonomyChecklists);
                if (this.includeIncompatibleSightings) {
                    processor.includingIncompatibleSightings();
                }
                if (this.onlyCountable) {
                    processor.onlyIncludeCountableSightings();
                }
                return processor.runQuery(predicate, null, depthOverride == null ? Taxon.Type.species : depthOverride);
            }
        };
        this.reportsActionFactory.saveAsTripReport(executor, null).actionPerformed(e);
    }

    private void editChecklist(boolean mustEdit) {
        final Location location = this.getOnlySelectedLocation();
        if (location == null) {
            return;
        }
        if (!this.taxonomyStore.getTaxonomy().isBuiltIn()) {
            return;
        }
        Checklist checklist = this.checklists.getChecklist(this.reportSet, this.taxonomyStore.getTaxonomy(), location);
        final CardLayout layout = (CardLayout)this.reportsOrEditChecklist.getLayout();
        if (checklist != null) {
            if (checklist.isBuiltIn() && this.alerts.showOkCancel((Object)this, Messages.Name.CORRECTING_A_BUILT_IN_CHECKLIST_TITLE, Messages.Name.CORRECTING_A_BUILT_IN_CHECKLIST_MESSAGE, location.getDisplayName()) != 0) {
                return;
            }
            final EditChecklistPanel editChecklistPanel = new EditChecklistPanel(this.reportSet, this.checklists, checklist, location, this.taxonomyStore, this.eventBusRegistrar, this.fontManager, this.executorService, this.speciesInfoDescriber, this.speciesIndexerPanelConfigurer, this.showSpeciesMap, this.alerts);
            editChecklistPanel.setPresenter(new EditChecklistPresenter(){

                @Override
                public void done() {
                    LocationBrowsePanel.this.reportsOrEditChecklist.remove(editChecklistPanel);
                    layout.first(LocationBrowsePanel.this.reportsOrEditChecklist);
                    LocationBrowsePanel.this.reenableEverything();
                    LocationBrowsePanel.this.runQueryForCurrentSelection();
                    if (LocationBrowsePanel.this.locationTree.getSelectionPath() != null && LocationBrowsePanel.this.locationTree.getSelectionPath().getLastPathComponent() == location) {
                        LocationBrowsePanel.this.locationTree.getModel().valueForPathChanged(LocationBrowsePanel.this.locationTree.getSelectionPath(), LocationBrowsePanel.this.newLocation);
                        LocationBrowsePanel.this.locationTree.selectLocation(location);
                    }
                }
            });
            this.reportsOrEditChecklist.add((Component)editChecklistPanel, "editChecklist");
            this.editChecklist.setText(Messages.getMessage(Messages.Name.EDITING_CHECKLIST));
        } else if (!mustEdit) {
            final CreateChecklistPanel createChecklistPanel = new CreateChecklistPanel(this.reportSet, this.checklists, location, this.taxonomyStore, this.eventBusRegistrar, this.fontManager);
            createChecklistPanel.setPresenter(new CreateChecklistPresenter(){
                private JPanel current;
                {
                    this.current = createChecklistPanel;
                }

                @Override
                public void created() {
                    this.reset();
                    LocationBrowsePanel.this.runQueryForCurrentSelection();
                    LocationBrowsePanel.this.editChecklist(true);
                }

                @Override
                public void cancel() {
                    this.reset();
                }

                @Override
                public void switchTo(JPanel panel) {
                    LocationBrowsePanel.this.reportsOrEditChecklist.remove(this.current);
                    this.current = panel;
                    LocationBrowsePanel.this.reportsOrEditChecklist.add((Component)panel, "createChecklist");
                    layout.last(LocationBrowsePanel.this.reportsOrEditChecklist);
                }

                private void reset() {
                    LocationBrowsePanel.this.reportsOrEditChecklist.remove(this.current);
                    layout.first(LocationBrowsePanel.this.reportsOrEditChecklist);
                    LocationBrowsePanel.this.reenableEverything();
                    LocationBrowsePanel.this.runQueryForCurrentSelection();
                }
            });
            this.reportsOrEditChecklist.add((Component)createChecklistPanel, "createChecklist");
            this.editChecklist.setText(Messages.getMessage(Messages.Name.CREATING_CHECKLIST));
        }
        layout.last(this.reportsOrEditChecklist);
        this.locationTree.setEnabled(false);
        this.newLocation.setEnabled(false);
        this.deleteLocation.setEnabled(false);
        this.editChecklist.setEnabled(false);
        this.shareChecklist.setEnabled(false);
        this.locationEditorPanel.setEnabled(false);
        this.xlsButton.setEnabled(false);
        this.printButton.setEnabled(false);
        this.reportFilterCombo.setEnabled(false);
        this.jumpButton.setEnabled(false);
        this.returnButton.setEnabled(false);
        this.locationIndexPanel.setEnabled(false);
        this.totalLabel.setEnabled(false);
        this.speciesJumpButton.setEnabled(false);
        this.speciesIndexPanel.setEnabled(false);
        this.onlyVisitedLocations.setEnabled(false);
    }

    private void shareChecklist() {
        Location location = this.getOnlySelectedLocation();
        if (location == null) {
            return;
        }
        Checklist checklist = this.checklists.getChecklist(this.reportSet, this.taxonomyStore.getClements(), location);
        if (checklist == null || checklist.isBuiltIn()) {
            return;
        }
        File saveFile = this.fileDialogs.saveFile((Frame)SwingUtilities.getWindowAncestor(this), Messages.getMessage(Messages.Name.SHARE_A_CHECKLIST), String.format("checklist-%s.csv", location.getDisplayName()), null, FilePreferences.FileType.OTHER);
        if (saveFile != null) {
            ClementsChecklistWriter writer = new ClementsChecklistWriter(this.taxonomyStore.getClements());
            try {
                writer.write(saveFile, (ClementsChecklist)checklist, location);
            }
            catch (IOException e) {
                FileDialogs.showFileSaveError(this.alerts, e, saveFile);
                return;
            }
        }
    }

    private void reenableEverything() {
        this.locationTree.setEnabled(true);
        this.editChecklist.setEnabled(true);
        this.shareChecklist.setEnabled(true);
        this.xlsButton.setEnabled(true);
        this.printButton.setEnabled(true);
        this.reportFilterCombo.setEnabled(true);
        this.jumpButton.setEnabled(true);
        this.returnButton.setEnabled(true);
        this.locationIndexPanel.setEnabled(true);
        this.totalLabel.setEnabled(true);
        this.speciesJumpButton.setEnabled(true);
        this.speciesIndexPanel.setEnabled(true);
        this.onlyVisitedLocations.setEnabled(true);
        this.updateLocationEditingForSelection();
    }

    private Location getOnlySelectedLocation() {
        TreePath[] paths = this.locationTree.getSelectionPaths();
        if (paths == null || paths.length != 1) {
            return null;
        }
        return (Location)paths[0].getLastPathComponent();
    }

    private List<Location> getSelectedLocations() {
        TreePath[] paths = this.locationTree.getSelectionPaths();
        ArrayList<Location> selectedLocations = Lists.newArrayList();
        if (paths != null) {
            for (TreePath path : paths) {
                selectedLocations.add((Location)path.getLastPathComponent());
            }
        }
        return selectedLocations;
    }

    private Set<VisitInfoKey> getSelectedVisitInfoKeys() {
        TreePath[] paths = this.reportsBrowser.getSelectionPaths();
        LinkedHashSet<VisitInfoKey> selectedVisitInfoKeys = new LinkedHashSet<VisitInfoKey>();
        if (paths != null) {
            for (TreePath path : paths) {
                Object lastPathComponent = path.getLastPathComponent();
                if (lastPathComponent instanceof VisitInfoKey) {
                    VisitInfoKey vik = (VisitInfoKey)lastPathComponent;
                    selectedVisitInfoKeys.add(vik);
                    continue;
                }
                if (lastPathComponent instanceof ReportsTreeModel.VisitInfoKeyNode) {
                    ReportsTreeModel.VisitInfoKeyNode vikn = (ReportsTreeModel.VisitInfoKeyNode)lastPathComponent;
                    selectedVisitInfoKeys.add(vikn.getVisitInfoKey());
                    continue;
                }
                if (lastPathComponent instanceof ReportsTreeModel.VisitsNode) continue;
                return ImmutableSet.of();
            }
        }
        return selectedVisitInfoKeys;
    }

    private List<Trip> getSelectedTrips() {
        TreePath[] paths = this.reportsBrowser.getSelectionPaths();
        ArrayList<Trip> selectedTrips = new ArrayList<Trip>();
        if (paths != null) {
            for (TreePath path : paths) {
                Object lastPathComponent = path.getLastPathComponent();
                if (lastPathComponent instanceof Trip) {
                    Trip trip = (Trip)lastPathComponent;
                    selectedTrips.add(trip);
                    continue;
                }
                if (lastPathComponent instanceof ReportsTreeModel.TripNode) {
                    ReportsTreeModel.TripNode tripNode = (ReportsTreeModel.TripNode)lastPathComponent;
                    selectedTrips.add(tripNode.getTrip());
                    continue;
                }
                if (lastPathComponent instanceof ReportsTreeModel.TripsNode) continue;
                return ImmutableList.of();
            }
        }
        return selectedTrips;
    }

    private void initGUI() {
        this.locationTree = new LocationTree(this.reportSet, this.predefinedLocations, Predicates.alwaysTrue(), this.actionBroker, this.fontManager, this.alerts);
        this.add(this.cellRendererPane);
        this.returnButton = new JButton();
        this.locationTree.setCellRenderer(new LocationTreeCellRenderer());
        this.treeScrollPane = new JScrollPane(this.locationTree);
        this.reportsScrollPane = new JScrollPane(this.reportsBrowser);
        this.reportsBrowser.setEditableSightings(true);
        this.reportsOrEditChecklist = new JPanel();
        this.reportsOrEditChecklist.setLayout(new CardLayout());
        this.reportsOrEditChecklist.add((Component)this.reportsScrollPane, "reports");
        this.jumpButton = new JButton(Messages.getMessage(Messages.Name.JUMP_TO_BUTTON));
        this.jumpButton.putClientProperty("JComponent.sizeVariant", "small");
        this.locationIndexPanel = new IndexerPanel();
        this.locationIndexPanel.setPreviewText(Messages.Name.START_TYPING_A_LOCATION);
        this.speciesJumpButton = new JButton(Messages.getMessage(Messages.Name.JUMP_TO_BUTTON));
        this.speciesJumpButton.putClientProperty("JComponent.sizeVariant", "small");
        this.speciesIndexPanel = new IndexerPanel();
        this.onlyVisitedLocations = new JCheckBox(Messages.getMessage(Messages.Name.ONLY_VISITED_LOCATIONS));
        this.onlyVisitedLocations.setSelected(this.browsePreferences.onlyVisitedLocations);
        this.totalLabel = new JLabel(" ");
        this.locationEditorPanel = new LocationEditorPanel();
        this.locationEditorPanel.setEnabled(false);
        this.editLocation = new JButton();
        this.editLocation.setAction(new AbstractAction(Messages.getMessage(Messages.Name.EDIT_WITH_ELLIPSIS)){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocationBrowsePanel.this.editLocation();
            }
        });
        this.editLocation.setEnabled(false);
        this.deleteLocation = new JButton();
        this.deleteLocation.setAction(new AbstractAction(Messages.getMessage(Messages.Name.DELETE_WITH_ELLIPSIS)){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocationBrowsePanel.this.deleteLocation();
            }
        });
        this.deleteLocation.setToolTipText(Messages.getMessage(Messages.Name.DELETE_LOCATION_HELP));
        this.deleteLocation.setEnabled(false);
        this.newLocation = new JButton();
        this.newLocation.setAction(new AbstractAction(Messages.getMessage(Messages.Name.NEW_MENU)){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocationBrowsePanel.this.newLocation();
            }
        });
        this.newLocation.setEnabled(false);
        this.reportFilterCombo = new JComboBox<Object>((Object[])ReportFilter.values()){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.reportFilterCombo.setEnabled(false);
        this.noRarities = new JCheckBox(Messages.getMessage(Messages.Name.HIDE_RARITIES));
        this.noRarities.setEnabled(false);
        this.printButton = new JButton();
        this.printButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.PRINT_MENU)){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocationBrowsePanel.this.print();
            }
        });
        this.printButton.setVisible(false);
        this.xlsButton = new JButton();
        this.xlsButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.SAVE_AS_SPREADSHEET)){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocationBrowsePanel.this.saveChecklistAsSpreadsheet();
            }
        });
        this.xlsButton.setVisible(false);
        this.createTripButton = new JButton();
        this.createTripButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.CREATE_TRIP)){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocationBrowsePanel.this.createTrip(event);
            }
        });
        this.createTripButton.setVisible(false);
        this.tripReportButton = new JButton();
        this.tripReportButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.EXPORT_TO_TRIP_REPORT)){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocationBrowsePanel.this.createTripReport(event);
            }
        });
        this.tripReportButton.setVisible(false);
        this.editChecklist = new JButton();
        this.editChecklist.setAction(new AbstractAction(Messages.getMessage(Messages.Name.EDIT_CHECKLIST)){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocationBrowsePanel.this.editChecklist(false);
            }
        });
        this.editChecklist.setVisible(false);
        this.shareChecklist = new JButton();
        this.shareChecklist.setAction(new AbstractAction(Messages.getMessage(Messages.Name.SHARE_CHECKLIST)){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocationBrowsePanel.this.shareChecklist();
            }
        });
        this.shareChecklist.setVisible(false);
        this.addSightingButton = new JButton();
        this.addSightingButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.ADD_SIGHTING)){

            @Override
            public void actionPerformed(ActionEvent event) {
                TreePath[] selection = LocationBrowsePanel.this.reportsBrowser.getSelectionPaths();
                if (selection != null && selection.length == 1 && selection[0].getLastPathComponent() instanceof SightingTaxon.Resolved) {
                    LocationBrowsePanel.this.addSighting(selection[0], (SightingTaxon.Resolved)selection[0].getLastPathComponent());
                }
            }
        });
        this.removeSightingButton = new JButton();
        this.removeSightingButton.setAction(new AbstractAction(Messages.getMessage(Messages.Name.REMOVE_SIGHTING)){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocationBrowsePanel.this.removeSightings(event);
            }
        });
        this.reportsBrowser.getSelectionModel().addTreeSelectionListener(e -> this.updateSightingButtons(this.reportsBrowser.getSelectionPaths()));
        this.reportsBrowser.setLocationEditingAllowed(false);
        this.fontManager.applyTo(this);
    }

    private void removeSightings(ActionEvent event) {
        int okCancel = this.alerts.showOkCancel((Object)this, Messages.Name.REMOVE_SIGHTINGS, this.reportsBrowser.getSelectionCount() > 1 ? Messages.Name.REMOVE_SIGHTINGS_CONFIRM : Messages.Name.REMOVE_SIGHTING_CONFIRM, new Object[0]);
        if (okCancel == 0) {
            this.reportsBrowser.getCutAction().actionPerformed(event);
        }
    }

    private void addSighting(TreePath path, SightingTaxon.Resolved resolved) {
        Preconditions.checkArgument(resolved.getLargestTaxonType().compareTo(Taxon.Type.species) <= 0, "Tried to add sighting of type %s", (Object)resolved.getLargestTaxonType());
        Location location = this.getOnlySelectedLocation();
        if (location == null) {
            return;
        }
        this.reportSet.getLocations().ensureAdded(location);
        Sighting sighting = Sighting.newBuilder().setLocation(location).setTaxon(resolved).build();
        SightingTaxon taxon = sighting.getTaxon();
        Checklist checklist = this.checklists.getNearestBuiltInChecklist(resolved.getTaxonomy(), this.reportSet, location);
        SightingInfo.SightingStatus status = null;
        if (resolved.getTaxonStatus() == Species.Status.IN) {
            status = SightingInfo.SightingStatus.INTRODUCED;
        } else if (resolved.getTaxonStatus() == Species.Status.DO) {
            Checklist.Status checklistStatus;
            status = SightingInfo.SightingStatus.DOMESTIC;
            if (checklist != null && ((checklistStatus = checklist.getStatus(resolved.getTaxonomy(), taxon)) == Checklist.Status.INTRODUCED || checklistStatus == Checklist.Status.RARITY_FROM_INTRODUCED)) {
                status = SightingInfo.SightingStatus.INTRODUCED;
            }
        } else if (checklist != null) {
            Checklist.Status checklistStatus = checklist.getStatus(resolved.getTaxonomy(), taxon);
            if (checklistStatus == Checklist.Status.INTRODUCED || checklistStatus == Checklist.Status.RARITY_FROM_INTRODUCED) {
                status = SightingInfo.SightingStatus.INTRODUCED;
            } else if (checklistStatus == Checklist.Status.ESCAPED) {
                status = SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED;
            }
        }
        if (status != null) {
            sighting.getSightingInfo().setSightingStatus(status);
        }
        if (this.defaultUserStore.getUser() != null) {
            sighting.getSightingInfo().setUsers(ImmutableSet.of(this.defaultUserStore.getUser()));
        }
        this.reportsBrowser.addSighting(path, sighting, false);
        this.reportsBrowser.setSelectionPath(path.getParentPath());
        this.reportsBrowser.setSelectionPath(path);
    }

    private void updateSightingButtons(TreePath[] reportSelection) {
        boolean allAreSightings = true;
        boolean allAreVisitInfoKeys = true;
        boolean allAreTrips = true;
        if (reportSelection != null) {
            for (TreePath path : reportSelection) {
                Object lastPathComponent = path.getLastPathComponent();
                if (lastPathComponent instanceof ResolvedWithKey) {
                    ResolvedWithKey rwk = (ResolvedWithKey)lastPathComponent;
                    List<Sighting> rwkSightings = this.reportsBrowser.getSightingsForResolvedWithKey(rwk);
                    allAreVisitInfoKeys = false;
                    allAreTrips = false;
                    allAreSightings = rwkSightings.size() == 1;
                } else {
                    if (!(lastPathComponent instanceof Sighting) && !(lastPathComponent instanceof ResolvedWithSighting)) {
                        allAreSightings = false;
                    }
                    if (!(lastPathComponent instanceof ReportsTreeModel.VisitInfoKeyNode) && !(lastPathComponent instanceof VisitInfoKey)) {
                        allAreVisitInfoKeys = false;
                    }
                    if (!(lastPathComponent instanceof Trip) && !(lastPathComponent instanceof ReportsTreeModel.TripNode)) {
                        allAreTrips = false;
                    }
                }
                if (!allAreSightings && !allAreVisitInfoKeys && !allAreTrips) break;
            }
        }
        if (reportSelection == null || reportSelection.length != 1) {
            this.addSightingButton.setEnabled(false);
        } else if (this.getOnlySelectedLocation() == null) {
            this.addSightingButton.setEnabled(false);
        } else {
            SightingTaxon.Resolved resolved;
            boolean addEnabled = false;
            if (reportSelection[0].getLastPathComponent() instanceof SightingTaxon.Resolved && (resolved = (SightingTaxon.Resolved)reportSelection[0].getLastPathComponent()).getLargestTaxonType().compareTo(Taxon.Type.species) <= 0) {
                addEnabled = true;
            }
            this.addSightingButton.setEnabled(addEnabled);
        }
        if (reportSelection == null || reportSelection.length == 0) {
            this.removeSightingButton.setEnabled(false);
            this.removeSightingButton.setText(Messages.getMessage(Messages.Name.REMOVE_SIGHTING));
        } else {
            this.removeSightingButton.setEnabled(allAreSightings);
            this.removeSightingButton.setText(reportSelection.length == 1 ? Messages.getMessage(Messages.Name.REMOVE_SIGHTING) : Messages.getMessage(Messages.Name.REMOVE_SIGHTINGS));
        }
        if (this.removeSightingButton.isEnabled()) {
            this.removeSightingButton.setVisible(true);
            this.addSightingButton.setVisible(false);
        } else {
            this.addSightingButton.setVisible(true);
            this.removeSightingButton.setVisible(false);
        }
        if (reportSelection == null || reportSelection.length == 0) {
            this.tripReportButton.setVisible(false);
        } else {
            this.tripReportButton.setVisible(allAreTrips || allAreVisitInfoKeys);
        }
        if (reportSelection == null || reportSelection.length == 0) {
            this.createTripButton.setVisible(false);
        } else {
            this.createTripButton.setVisible(allAreVisitInfoKeys);
            if (allAreVisitInfoKeys) {
                if (reportSelection.length == 1) {
                    this.createTripButton.setText(Messages.getMessage(Messages.Name.CONVERT_TO_A_TRIP));
                } else {
                    this.createTripButton.setText(Messages.getMessage(Messages.Name.CREATE_TRIP));
                }
            }
        }
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.BROWSE_BY_LOCATION);
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.setTaxonomy(event.getTaxonomy());
        this.runQueryForCurrentSelection();
        if (this.onlyVisitedLocations.isSelected()) {
            this.updateLocationFilter();
        }
    }

    @Subscribe
    public void defaultUserChanged(DefaultUserChangedEvent event) {
        this.startScanningTaxa(this.reportsBrowser.getTaxonomy());
        this.runQueryForCurrentSelection();
    }

    private void setTaxonomy(Taxonomy taxonomy) {
        this.reportsBrowser.setTaxonomy(taxonomy);
        this.speciesIndexerPanelConfigurer.configure(this.speciesIndexPanel, taxonomy);
        this.speciesIndexerPanelConfigurer.addSimpleTaxa(this.speciesIndexPanel, taxonomy, TaxonUtils.getDescendantsOfType(taxonomy.getRoot(), Taxon.Type.family));
        this.startScanningTaxa(taxonomy);
    }

    private void updateLocationFilter() {
        this.locationFilter = this.getLocationFilter();
        this.locationTree.setLocationFilter(this.locationFilter);
    }

    private Predicate<Location> getLocationFilter() {
        final Predicate syntheticLocationsOnlyIfChecklistUnionAvailable = l -> {
            if (l instanceof SyntheticLocation) {
                SyntheticLocation synthetic = (SyntheticLocation)l;
                return synthetic.syntheticChecklistUnion() != null;
            }
            return true;
        };
        if (!this.onlyVisitedLocations.isSelected()) {
            return syntheticLocationsOnlyIfChecklistUnionAvailable;
        }
        try {
            final EncounteredLocations encounteredLocations = (EncounteredLocations)EncounteredLocations.scan(this.taxonomyStore.getTaxonomy(), this.reportSet, this.executorService).get();
            return new Predicate<Location>(){

                @Override
                public boolean apply(Location location) {
                    return syntheticLocationsOnlyIfChecklistUnionAvailable.apply(location) && (encounteredLocations.encounteredLocation(location) || LocationBrowsePanel.this.addedLocations.contains(location));
                }
            };
        }
        catch (InterruptedException | ExecutionException e) {
            this.alerts.showError((Object)this, (Throwable)e, "Could not scan locations", "Location scanning failed.", new Object[0]);
            return syntheticLocationsOnlyIfChecklistUnionAvailable;
        }
    }

    private void startScanningTaxa(Taxonomy taxonomy) {
        if (this.scanSeenTaxa != null) {
            this.scanSeenTaxa.cancel();
        }
        Predicate<Sighting> sightingPredicate = this.sightingPredicate(taxonomy);
        this.scanSeenTaxa = ScanSeenTaxa.start(this.reportSet, taxonomy, this.executorService, scanned -> {
            if (this.currentQueryResults != null) {
                this.runQueryForCurrentSelection();
            }
        }, Lists.newArrayList(new Location[]{null}), sightingPredicate, new ScanSeenTaxa.Options());
        this.reportsBrowser.setSeenTaxa(this.scanSeenTaxa);
    }

    private Predicate<Sighting> sightingPredicate(Taxonomy taxonomy) {
        Predicate<Sighting> sightingPredicate;
        Object reportFilter = this.reportFilterCombo.getSelectedItem();
        if (reportFilter instanceof CustomReportFilter) {
            sightingPredicate = ((CustomReportFilter)reportFilter).queryDefinition.predicate();
            this.customScanner = true;
        } else {
            sightingPredicate = this.queryPreferences.getCountablePredicate(taxonomy, false, null);
            this.customScanner = false;
        }
        if (this.defaultUserStore.getUser() != null) {
            sightingPredicate = Predicates.and(sightingPredicate, SightingPredicates.includesUser(this.defaultUserStore.getUser()));
        }
        return sightingPredicate;
    }

    private LatLongCoordinates isOverLatLongIcon(TreePath path, Point locationTreePoint) {
        if (path == null || !(path.getLastPathComponent() instanceof Location)) {
            return null;
        }
        Location location = (Location)path.getLastPathComponent();
        if (!location.getLatLong().isPresent()) {
            return null;
        }
        Container container = this.getValidatedRendererComponent(path);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            JComponent jChild;
            Component child = container.getComponent(i);
            if (!(child instanceof JComponent) || (jChild = (JComponent)child).getClientProperty(LAT_LONG_PROPERTY) == null) continue;
            Rectangle bounds = child.getBounds();
            Point pathLocation = this.locationTree.getPathBounds(path).getLocation();
            if (!bounds.contains(locationTreePoint.getX() - (double)pathLocation.x, locationTreePoint.getY() - (double)pathLocation.y)) continue;
            return location.getLatLong().get();
        }
        return null;
    }

    private Container getValidatedRendererComponent(TreePath path) {
        if (path == null || !(path.getLastPathComponent() instanceof Location)) {
            return null;
        }
        if (path.equals(this.cachedRendererComponentPath) && this.cellRendererPane.getComponentCount() == 1) {
            return (Container)this.cellRendererPane.getComponent(0);
        }
        Location location = (Location)path.getLastPathComponent();
        TreeCellRenderer renderer = this.locationTree.getCellRenderer();
        int row = this.locationTree.getRowForPath(path);
        boolean focused = this.locationTree.getSelectionModel().getLeadSelectionRow() == row && this.locationTree.isFocusOwner();
        Container container = (Container)renderer.getTreeCellRendererComponent(this.locationTree, location, this.locationTree.getSelectionModel().isPathSelected(path), this.locationTree.isExpanded(path), this.locationTree.getModel().isLeaf(location), this.locationTree.getRowForPath(path), focused);
        Rectangle pathBounds = this.locationTree.getPathBounds(path);
        this.cellRendererPane.removeAll();
        this.cellRendererPane.add(container);
        container.setSize(pathBounds.getSize());
        container.validate();
        this.cachedRendererComponentPath = path;
        return container;
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        layout.setAutoCreateContainerGaps(true);
        this.setLayout(layout);
        this.cachedRendererComponentPath = null;
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createBaselineGroup(false, false).addComponent(this.locationIndexPanel).addComponent(this.jumpButton).addComponent(this.speciesIndexPanel).addComponent(this.speciesJumpButton).addComponent(this.onlyVisitedLocations)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.totalLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.reportFilterCombo).addComponent(this.noRarities).addComponent(this.createTripButton).addComponent(this.tripReportButton).addComponent(this.printButton).addComponent(this.xlsButton).addComponent(this.editChecklist).addComponent(this.shareChecklist)).addGroup(layout.createParallelGroup().addComponent(this.treeScrollPane, fontManager.scale(200), fontManager.scale(600), Integer.MAX_VALUE).addComponent(this.reportsOrEditChecklist, fontManager.scale(200), fontManager.scale(600), Integer.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.locationEditorPanel).addComponent(this.editLocation).addComponent(this.deleteLocation).addComponent(this.newLocation).addComponent(this.addSightingButton).addComponent(this.removeSightingButton).addComponent(this.returnButton)));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.locationIndexPanel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jumpButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.speciesIndexPanel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.speciesJumpButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.onlyVisitedLocations)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.totalLabel)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.reportFilterCombo, -2, -2, -2).addComponent(this.noRarities, -2, -2, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.createTripButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.printButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xlsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tripReportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editChecklist).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shareChecklist)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.treeScrollPane, fontManager.scale(150), fontManager.scale(250), fontManager.scale(300)).addComponent(this.reportsOrEditChecklist, fontManager.scale(400), -2, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.locationEditorPanel, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editLocation, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteLocation, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newLocation, -2, -2, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.addSightingButton, -2, -2, -2).addComponent(this.removeSightingButton, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.returnButton, -2, -2, -2)));
        Dimension size = fontManager.scale(new Dimension(1280, 800));
        this.setPreferredSize(size);
        ((LocationTreeCellRenderer)this.locationTree.getCellRenderer()).setFont(fontManager.getTextFont());
    }

    private static /* synthetic */ boolean lambda$newQueryProcessor$12(QueryResults queryResults, SightingTaxon.Resolved resolved) {
        return queryResults.getAllSightings(resolved).isEmpty();
    }

    static enum ReportFilter {
        SHOW_ALL(Messages.Name.SHOW_EVERYTHING),
        ONLY_RECORDED(Messages.Name.ONLY_RECORDED),
        ONLY_LIFERS(Messages.Name.ONLY_LIFERS),
        NOT_SEEN_HERE(Messages.Name.NOT_SEEN_HERE),
        ONLY_ENDEMICS(Messages.Name.ONLY_ENDEMICS),
        CUSTOM_FILTER(Messages.Name.CUSTOM_FILTER);

        private final Messages.Name text;

        private ReportFilter(Messages.Name text) {
            this.text = text;
        }

        public String toString() {
            return Messages.getMessage(this.text);
        }
    }

    static class CustomReportFilter {
        private final QueryDefinition queryDefinition;
        private final Optional<String> optionalName;

        CustomReportFilter(QueryDefinition queryDefinition, Optional<String> optionalName) {
            this.queryDefinition = queryDefinition;
            this.optionalName = optionalName;
        }

        public String toString() {
            if (this.optionalName.isPresent()) {
                return Messages.getFormattedMessage(Messages.Name.NEW_FOR_FORMAT, this.optionalName.get());
            }
            return Messages.getMessage(Messages.Name.NEW_FOR_CUSTOM_REPORT);
        }

        public QueryDefinition queryDefinition() {
            return this.queryDefinition;
        }
    }

    static interface EditChecklistPresenter {
        public void done();
    }

    static interface CreateChecklistPresenter {
        public void created();

        public void cancel();

        public void switchTo(JPanel var1);
    }

    private class LocationTreeCellRenderer
    extends DefaultTreeCellRenderer {
        LocationTreeCellRenderer() {
            this.putClientProperty("birdlist.plainLabel", true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Location location = null;
            if (value instanceof Location) {
                location = (Location)value;
                value = LocationIdToString.getStringWithType(location);
            }
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (location != null) {
                boolean hasLatLong = location.getLatLong().isPresent();
                boolean hasChecklist = LocationBrowsePanel.this.checklists.hasChecklist(LocationBrowsePanel.this.taxonomyStore.getTaxonomy(), LocationBrowsePanel.this.reportSet, location);
                if (location != null && (hasLatLong || hasChecklist)) {
                    JPanel panel = new JPanel();
                    panel.setOpaque(false);
                    panel.setLayout(new BoxLayout(panel, 0));
                    panel.add(component);
                    if (hasChecklist) {
                        panel.add(Box.createRigidArea(new Dimension(10, 10)));
                        panel.add(new JLabel(LocationBrowsePanel.this.checkIcon));
                    }
                    if (hasLatLong) {
                        panel.add(Box.createRigidArea(new Dimension(10, 10)));
                        JLabel latLongLabel = new JLabel(LocationBrowsePanel.this.latLongIcon);
                        latLongLabel.putClientProperty(LAT_LONG_PROPERTY, location.getLatLong().get());
                        panel.add(latLongLabel);
                    }
                    return panel;
                }
            }
            return component;
        }
    }

    static class ReturnToTripAction
    extends AbstractAction {
        private final NavigableFrame navigableFrame;
        private final Location selectedLocation;
        private final Trip trip;

        ReturnToTripAction(NavigableFrame navigableFrame, Location selectedLocation, Trip trip) {
            this.navigableFrame = navigableFrame;
            this.selectedLocation = selectedLocation;
            this.trip = trip;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel navigateTo = this.navigableFrame.navigateTo("browseLocations");
            if (navigateTo != null) {
                LocationBrowsePanel locationBrowsePanel = (LocationBrowsePanel)navigateTo;
                locationBrowsePanel.locationTree.selectLocation(this.selectedLocation);
                locationBrowsePanel.runQueryForCurrentSelection();
                locationBrowsePanel.updateLocationEditingForSelection();
                SwingUtilities.invokeLater(() -> {
                    locationBrowsePanel.reportsBrowser.selectTrip(this.trip);
                    locationBrowsePanel.reportsBrowser.requestFocus();
                    locationBrowsePanel.reportsBrowser.scrollListSelectionsIntoView();
                });
            }
        }
    }

    static class ReturnToVisitInfoAction
    extends AbstractAction {
        private final NavigableFrame navigableFrame;
        private final Location selectedLocation;
        private final VisitInfoKey visitInfoKey;

        ReturnToVisitInfoAction(NavigableFrame navigableFrame, Location selectedLocation, VisitInfoKey visitInfoKey) {
            this.navigableFrame = navigableFrame;
            this.selectedLocation = selectedLocation;
            this.visitInfoKey = visitInfoKey;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel navigateTo = this.navigableFrame.navigateTo("browseLocations");
            if (navigateTo != null) {
                LocationBrowsePanel locationBrowsePanel = (LocationBrowsePanel)navigateTo;
                locationBrowsePanel.locationTree.selectLocation(this.selectedLocation);
                locationBrowsePanel.runQueryForCurrentSelection();
                locationBrowsePanel.updateLocationEditingForSelection();
                SwingUtilities.invokeLater(() -> {
                    locationBrowsePanel.reportsBrowser.selectVisitInfo(this.visitInfoKey);
                    locationBrowsePanel.reportsBrowser.requestFocus();
                    locationBrowsePanel.reportsBrowser.scrollListSelectionsIntoView();
                });
            }
        }
    }

    static class LocationReportsBrowserPanel
    extends ReportsBrowserPanel {
        private final NavigableFrame navigableFrame;

        @Override
        protected boolean canImportSightings(TransferHandler.TransferSupport transferSupport, TreePath target, SightingsGroup sightings) {
            if ((target = this.getDropTargetPath(target)) == null) {
                return false;
            }
            VisitInfoKey visitInfoKey = this.getVisitInfoKeyForSightingImport(target);
            if (visitInfoKey != null) {
                return !this.getImportableSightings(sightings, visitInfoKey).isEmpty();
            }
            Trip trip = this.getTripForSightingImport(target);
            if (trip != null) {
                SightingTaxon.Resolved resolved;
                Object object = target.getLastPathComponent();
                if (object instanceof ResolvedWithKey) {
                    ResolvedWithKey rwk = (ResolvedWithKey)object;
                    resolved = rwk.getResolved();
                } else {
                    resolved = null;
                }
                return !this.getImportableSightings(sightings, trip, resolved).isEmpty();
            }
            return super.canImportSightings(transferSupport, target, sightings);
        }

        @Override
        protected boolean canImportSightingsToPath(TreePath treePath) {
            if ((treePath = this.getDropTargetPath(treePath)) == null) {
                return false;
            }
            Object lastPathComponent = treePath.getLastPathComponent();
            if (lastPathComponent instanceof ReportsTreeModel.VisitInfoKeyNode || lastPathComponent instanceof VisitInfoKey || lastPathComponent instanceof ReportsTreeModel.TripNode || lastPathComponent instanceof Trip || lastPathComponent instanceof ResolvedWithKey) {
                return true;
            }
            return super.canImportSightingsToPath(treePath);
        }

        @Override
        protected boolean doImport(TransferHandler.TransferSupport transferSupport, SightingsGroup sightings, TreePath target) {
            if ((target = this.getDropTargetPath(target)) == null) {
                return false;
            }
            VisitInfoKey visitInfoKey = this.getVisitInfoKeyForSightingImport(target);
            if (visitInfoKey != null) {
                Location location = Preconditions.checkNotNull(this.getReportSet().getLocations().getLocation(visitInfoKey.locationId()));
                ImmutableList.Builder newSightingsBuilder = ImmutableList.builder();
                for (Sighting sighting : this.getImportableSightings(sightings, visitInfoKey)) {
                    Sighting.Builder builder = sighting.asBuilder();
                    builder.setDate(visitInfoKey.date());
                    builder.setTime(visitInfoKey.startTime().orNull());
                    builder.setLocation(location);
                    newSightingsBuilder.add(builder.build());
                }
                this.addSightings(target, newSightingsBuilder.build(), false);
                return true;
            }
            Trip trip = this.getTripForSightingImport(target);
            if (trip != null) {
                SightingTaxon.Resolved resolved;
                Object sighting = target.getLastPathComponent();
                if (sighting instanceof ResolvedWithKey) {
                    ResolvedWithKey rwk = (ResolvedWithKey)sighting;
                    resolved = rwk.getResolved();
                } else {
                    resolved = null;
                }
                ImmutableList.Builder newSightingsBuilder = ImmutableList.builder();
                Predicate<Sighting> partOfTrip = SightingPredicates.isPartOfTrip(trip, this.getReportSet().getLocations());
                for (Sighting sighting2 : this.getImportableSightings(sightings, trip, resolved)) {
                    Sighting.Builder builder;
                    if (partOfTrip.apply(sighting2)) {
                        if (resolved == null) {
                            newSightingsBuilder.add(sighting2);
                            continue;
                        }
                        builder = sighting2.asBuilder();
                        builder.setTaxon(resolved);
                        newSightingsBuilder.add(builder.build());
                        continue;
                    }
                    builder = sighting2.asBuilder();
                    builder.setDate(null);
                    builder.setTime(null);
                    builder.setLocation(this.getReportSet().getLocations().getLocation(trip.locationId()));
                    builder.setTrip(trip);
                    if (resolved != null) {
                        builder.setTaxon(resolved);
                    }
                    newSightingsBuilder.add(builder.build());
                }
                this.addSightings(target, newSightingsBuilder.build(), false);
                return true;
            }
            Object newSightingsBuilder = target.getLastPathComponent();
            if (newSightingsBuilder instanceof SightingTaxon.Resolved) {
                SightingTaxon.Resolved resolved = (SightingTaxon.Resolved)newSightingsBuilder;
                if (resolved.getType() == SightingTaxon.Type.SINGLE) {
                    SightingTaxon sightingTaxon = resolved.getSightingTaxonInBaseTaxonomy();
                    if (sightingTaxon == null) {
                        return false;
                    }
                    ImmutableList.Builder newSightingsBuilder2 = ImmutableList.builder();
                    for (Sighting sighting : this.getImportableSightings(sightings, sightingTaxon)) {
                        Sighting.Builder builder = sighting.asBuilder();
                        builder.setTaxon(sightingTaxon);
                        newSightingsBuilder2.add(builder.build());
                    }
                    this.addSightings(target, newSightingsBuilder2.build(), true);
                    return true;
                }
                return false;
            }
            return super.doImport(transferSupport, sightings, target);
        }

        @Override
        protected boolean canMoveSightings() {
            return true;
        }

        private TreePath getDropTargetPath(TreePath treePath) {
            if (treePath == null) {
                return treePath;
            }
            Object lastPathComponent = treePath.getLastPathComponent();
            if (lastPathComponent instanceof Trip || lastPathComponent instanceof VisitInfoKey || lastPathComponent instanceof Sighting) {
                return this.getDropTargetPath(treePath.getParentPath());
            }
            if (lastPathComponent instanceof ResolvedWithKey && treePath.getParentPath() != null && treePath.getParentPath().getLastPathComponent() instanceof ReportsTreeModel.VisitInfoKeyNode) {
                return this.getDropTargetPath(treePath.getParentPath());
            }
            return treePath;
        }

        private VisitInfoKey getVisitInfoKeyForSightingImport(TreePath treePath) {
            Object lastPathComponent = treePath.getLastPathComponent();
            if (lastPathComponent instanceof ReportsTreeModel.VisitInfoKeyNode) {
                ReportsTreeModel.VisitInfoKeyNode vikn = (ReportsTreeModel.VisitInfoKeyNode)lastPathComponent;
                return vikn.getVisitInfoKey();
            }
            return null;
        }

        private Trip getTripForSightingImport(TreePath treePath) {
            Object lastPathComponent = treePath.getLastPathComponent();
            if (lastPathComponent instanceof ReportsTreeModel.TripNode) {
                ReportsTreeModel.TripNode tn = (ReportsTreeModel.TripNode)lastPathComponent;
                return tn.getTrip();
            }
            if (lastPathComponent instanceof ResolvedWithKey) {
                ResolvedWithKey rwk = (ResolvedWithKey)lastPathComponent;
                return rwk.getTrip();
            }
            return null;
        }

        @Override
        protected String getReturnPanelName() {
            return "browseLocations";
        }

        @Override
        protected BaseTaxonBrowserPanel.PostNavigateAction returnToSighting(TreePath oldParentPath, Sighting sighting) {
            return new ReturnToSighting(this.getReportSet(), sighting, this.getLocationRoot(), super.returnToSighting(oldParentPath, sighting));
        }

        private ImmutableList<Sighting> getImportableSightings(SightingsGroup sightings, VisitInfoKey visitInfo) {
            LinkedHashSet<SightingTaxon> existingTaxaForVisit = new LinkedHashSet<SightingTaxon>();
            for (Sighting sighting : this.getReportSet().getSightings()) {
                if (!visitInfo.matches(sighting)) continue;
                existingTaxaForVisit.add(sighting.getTaxon());
            }
            ImmutableList.Builder importableSightings = ImmutableList.builder();
            for (Sighting sighting : sightings.getSightings()) {
                if (existingTaxaForVisit.contains(sighting.getTaxon())) continue;
                importableSightings.add(sighting);
            }
            return importableSightings.build();
        }

        private ImmutableList<Sighting> getImportableSightings(SightingsGroup sightings, Trip trip, @Nullable SightingTaxon.Resolved resolved) {
            Predicate<Sighting> isInTripPredicate = SightingPredicates.isPartOfTrip(trip, this.getReportSet().getLocations());
            LinkedHashSet<Object> visitInfoKeysInTrip = new LinkedHashSet<Object>();
            for (Sighting sighting : sightings.getSightings()) {
                Object vik;
                if (!isInTripPredicate.apply(sighting) || (vik = VisitInfoKey.forSighting(sighting)) == null) continue;
                visitInfoKeysInTrip.add(vik);
            }
            LinkedHashSet<SightingTaxon> existingTaxaForTrip = new LinkedHashSet<SightingTaxon>();
            LinkedHashMultimap<VisitInfoKey, SightingTaxon> existingTaxaForVisits = LinkedHashMultimap.create();
            for (Sighting sighting : this.getReportSet().getSightings()) {
                if (sighting.getTrip() == trip) {
                    existingTaxaForTrip.add(sighting.getTaxon());
                    continue;
                }
                for (VisitInfoKey visitInfoKey : visitInfoKeysInTrip) {
                    if (!visitInfoKey.matches(sighting)) continue;
                    existingTaxaForVisits.put(visitInfoKey, sighting.getTaxon());
                }
            }
            ImmutableList.Builder importableSightings = ImmutableList.builder();
            for (Sighting sighting : sightings.getSightings()) {
                VisitInfoKey vik;
                SightingTaxon sightingTaxon;
                SightingTaxon sightingTaxon2 = sightingTaxon = resolved == null ? sighting.getTaxon() : resolved.getSightingTaxonInBaseTaxonomy();
                if (sighting.getTrip() == trip ? existingTaxaForTrip.contains(sightingTaxon) : isInTripPredicate.apply(sighting) && existingTaxaForVisits.containsEntry(vik = VisitInfoKey.forSighting(sighting), sightingTaxon)) continue;
                importableSightings.add(sighting);
            }
            return importableSightings.build();
        }

        private ImmutableList<Sighting> getImportableSightings(SightingsGroup sightings, SightingTaxon targetTaxon) {
            LinkedHashSet<VisitInfoKey> existingVisitInfosForKey = new LinkedHashSet<VisitInfoKey>();
            for (Sighting sighting : this.getReportSet().getSightings()) {
                if (!sighting.getTaxon().equals(targetTaxon)) continue;
                existingVisitInfosForKey.add(VisitInfoKey.forSighting(sighting));
            }
            ImmutableList.Builder importableSightings = ImmutableList.builder();
            for (Sighting sighting : sightings.getSightings()) {
                if (existingVisitInfosForKey.contains(VisitInfoKey.forSighting(sighting))) continue;
                importableSightings.add(sighting);
            }
            return importableSightings.build();
        }

        @Inject
        public LocationReportsBrowserPanel(FontManager fontManager, ReportSet reportSet, ActionBroker actionBroker, NewLocationDialog newLocationDialog, SpHybridDialog spHybridDialog, PredefinedLocations predefinedLocations, SpeciesInfoDescriber speciesInfoDescriber, OpenMapUrl openMapUrl, VisitInfoPreferences visitInfoPreferences, QueryPreferences queryPreferences, FileDialogs fileDialogs, Alerts alerts, NavigableFrame navigableFrame, LocationScorer locationScorer) {
            super(fontManager, reportSet, actionBroker, newLocationDialog, spHybridDialog, predefinedLocations, speciesInfoDescriber, openMapUrl, visitInfoPreferences, queryPreferences, fileDialogs, alerts, navigableFrame, locationScorer);
            this.navigableFrame = navigableFrame;
        }

        @Override
        protected Action getReturnToCurrentVisitInfoAction(VisitInfoKey visitInfoKey) {
            LocationBrowsePanel locationBrowsePanel = UIUtils.findParentOfType(this, LocationBrowsePanel.class);
            Location selectedLocation = locationBrowsePanel.locationTree.getSelectedLocation();
            return new ReturnToVisitInfoAction(this.navigableFrame, selectedLocation, visitInfoKey);
        }

        @Override
        protected Action getReturnToCurrentTripAction(Trip trip) {
            LocationBrowsePanel locationBrowsePanel = UIUtils.findParentOfType(this, LocationBrowsePanel.class);
            Location selectedLocation = locationBrowsePanel.locationTree.getSelectedLocation();
            return new ReturnToTripAction(this.navigableFrame, selectedLocation, trip);
        }

        @Override
        protected boolean canImportSightings() {
            return this.getSelectionCount() == 1;
        }

        static class ReturnToSighting
        implements BaseTaxonBrowserPanel.PostNavigateAction {
            private final BaseTaxonBrowserPanel.PostNavigateAction postNavigateAction;
            private final Location location;

            public ReturnToSighting(ReportSet reportSet, Sighting sighting, Location location, BaseTaxonBrowserPanel.PostNavigateAction postNavigateAction) {
                this.location = location == null ? reportSet.getLocations().getLocation(sighting.getLocationId()) : location;
                this.postNavigateAction = postNavigateAction;
            }

            @Override
            public void postNavigate(JPanel panel) {
                LocationBrowsePanel locationBrowsePanel = (LocationBrowsePanel)panel;
                if (this.location != null) {
                    locationBrowsePanel.locationTree.selectLocation(this.location);
                    locationBrowsePanel.runQueryForCurrentSelection();
                    locationBrowsePanel.updateLocationEditingForSelection();
                    SwingUtilities.invokeLater(() -> this.postNavigateAction.postNavigate(panel));
                }
            }
        }
    }
}

