/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.util.ColorFunctions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.ui.actions.locationapi.google.GoogleStaticGeoImageLoader;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.components.ProgressSpinner;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.location.LocationPreview;
import com.scythebill.birdlist.ui.panels.location.MercatorProjection;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class GoogleLocationPreviewPanel
extends JPanel
implements LocationPreview {
    private static final Logger logger = Logger.getLogger(GoogleLocationPreviewPanel.class.getName());
    private static final int ZOOM_BUTTON_SIZE = 24;
    private static final int MAX_ZOOM_LEVEL = 18;
    private static final int MIN_ZOOM_LEVEL = 0;
    private int zoomLevel = 12;
    private GoogleStaticGeoImageLoader staticImageLoader;
    private LatLongCoordinates latLong;
    private ProgressSpinner spinner;
    private JLabel imageLabel;
    private JLabel zoomInLabel;
    private JLabel zoomOutLabel;
    private ListenableFuture<BufferedImage> currentImageLoad;
    private MouseAdapter mapClickedMouseAdapter;
    private MouseAdapter zoomInMouseAdapter;
    private MouseAdapter zoomOutMouseAdapter;

    public static void main(String[] args) throws IOException {
        CloseableHttpClient httpClient = HttpClients.custom().disableCookieManagement().setMaxConnPerRoute(3).setMaxConnTotal(20).setConnectionManager(new PoolingHttpClientConnectionManager()).build();
        JFrame frame = new JFrame();
        final AutoSelectJFormattedTextField latitudeField = new AutoSelectJFormattedTextField();
        latitudeField.setColumns(10);
        NumberFormatter latitudeFormatter = GoogleLocationPreviewPanel.allowNullDecimalFormatter();
        latitudeFormatter.setValueClass(Double.class);
        latitudeFormatter.setMinimum(Double.valueOf(-90.0));
        latitudeFormatter.setMaximum(Double.valueOf(90.0));
        latitudeFormatter.setCommitsOnValidEdit(true);
        latitudeField.setFormatterFactory(new DefaultFormatterFactory(latitudeFormatter));
        final AutoSelectJFormattedTextField longitudeField = new AutoSelectJFormattedTextField();
        longitudeField.setColumns(10);
        NumberFormatter longitudeFormatter = GoogleLocationPreviewPanel.allowNullDecimalFormatter();
        longitudeFormatter.setValueClass(Double.class);
        longitudeFormatter.setMinimum(Double.valueOf(-180.0));
        longitudeFormatter.setMaximum(Double.valueOf(180.0));
        longitudeFormatter.setCommitsOnValidEdit(true);
        longitudeField.setFormatterFactory(new DefaultFormatterFactory(longitudeFormatter));
        JButton ok = new JButton("OK");
        ListeningScheduledExecutorService executorService = MoreExecutors.listeningDecorator(Executors.newScheduledThreadPool(3));
        final GoogleLocationPreviewPanel previewPanel = new GoogleLocationPreviewPanel(new GoogleStaticGeoImageLoader(httpClient, executorService, Resources.toString(Resources.getResource("googleapikey.txt"), StandardCharsets.UTF_8)));
        previewPanel.setPreferredSize(new Dimension(500, 500));
        Box box = Box.createVerticalBox();
        box.add(previewPanel);
        box.add(latitudeField);
        box.add(longitudeField);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Double latitude = (Double)latitudeField.getValue();
                Double longitude = (Double)longitudeField.getValue();
                previewPanel.setLatLong(LatLongCoordinates.withLatAndLong(latitude, longitude));
            }
        });
        box.add(ok);
        previewPanel.addMapClickedListener(new LocationPreview.MapClickedListener(){

            @Override
            public void mapClicked(LatLongCoordinates latLong) {
                String url = String.format("http://maps.google.com/maps/place/%s,%s/@%s,%s,%sz", latLong.latitude(), latLong.longitude(), latLong.latitude(), latLong.longitude(), 12);
                try {
                    Desktop.getDesktop().browse(URI.create(url));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Failed to open URL", e);
                }
            }
        });
        frame.setContentPane(box);
        frame.setVisible(true);
        frame.pack();
    }

    @Inject
    public GoogleLocationPreviewPanel(GoogleStaticGeoImageLoader staticImageLoader) {
        this.staticImageLoader = staticImageLoader;
        this.spinner = new ProgressSpinner();
        this.imageLabel = new JLabel();
        this.zoomInLabel = this.newClickableLabel("+");
        this.zoomOutLabel = this.newClickableLabel("-");
        this.zoomInLabel.setVisible(false);
        this.zoomOutLabel.setVisible(false);
        this.setLayout(null);
        this.add(this.spinner);
        this.add(this.imageLabel);
        this.add(this.zoomInLabel);
        this.add(this.zoomOutLabel);
    }

    @Override
    public void addMapClickedListener(LocationPreview.MapClickedListener listener) {
        this.listenerList.add(LocationPreview.MapClickedListener.class, listener);
    }

    @Override
    public void removeMapClickedListener(LocationPreview.MapClickedListener listener) {
        this.listenerList.remove(LocationPreview.MapClickedListener.class, listener);
    }

    private JLabel newClickableLabel(String string) {
        JLabel label = new JLabel(string){

            @Override
            public void updateUI() {
                super.updateUI();
                if (!FlatLaf.isLafDark()) {
                    this.setBackground(Color.WHITE);
                } else {
                    this.setBackground(ColorFunctions.lighten(UIManager.getColor("Label.background"), 0.2f));
                }
            }
        };
        label.setOpaque(true);
        label.setBorder(new LineBorder(Color.BLACK, 1));
        label.setCursor(Cursor.getPredefinedCursor(12));
        if (!FlatLaf.isLafDark()) {
            label.setBackground(Color.WHITE);
        } else {
            label.setBackground(ColorFunctions.lighten(UIManager.getColor("Label.background"), 0.2f));
        }
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setHorizontalTextPosition(0);
        label.setVerticalTextPosition(0);
        return label;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Dimension imageSize = this.imageLabel.getPreferredSize();
        this.imageLabel.setBounds(0, 0, imageSize.width, imageSize.height);
        Dimension spinnerSize = this.spinner.getPreferredSize();
        this.spinner.setLocation((imageSize.width - spinnerSize.width) / 2, (imageSize.height - spinnerSize.height) / 2);
        this.spinner.setSize(spinnerSize);
        this.zoomInLabel.setSize(24, 24);
        this.zoomOutLabel.setSize(24, 24);
        this.zoomInLabel.setLocation(imageSize.width, 0);
        this.zoomOutLabel.setLocation(imageSize.width, 23);
    }

    private void setErrorLoadingImage() {
        this.imageLabel.setText(Messages.getMessage(Messages.Name.ERROR_LOADING_IMAGE));
        this.imageLabel.setIcon(null);
    }

    private static NumberFormatter allowNullDecimalFormatter() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumIntegerDigits(3);
        numberFormat.setMaximumFractionDigits(6);
        return new NumberFormatter(numberFormat){

            @Override
            public Object stringToValue(String string) throws ParseException {
                if ("".equals(string)) {
                    return null;
                }
                return super.stringToValue(string);
            }
        };
    }

    @Override
    public LatLongCoordinates getLatLong() {
        return this.latLong;
    }

    @Override
    public void setLatLong(LatLongCoordinates latLong) {
        if (Objects.equal(latLong, this.latLong)) {
            return;
        }
        this.removeClickable();
        this.latLong = latLong;
        this.reloadImage();
    }

    private void reloadImage() {
        if (this.latLong == null) {
            this.imageLabel.setIcon(null);
            this.imageLabel.setText(null);
            this.zoomInLabel.setVisible(false);
            this.zoomOutLabel.setVisible(false);
            this.spinner.stop();
            return;
        }
        if (this.currentImageLoad != null) {
            this.currentImageLoad.cancel(true);
        }
        Dimension size = this.getSize();
        Dimension imageSize = this.staticImageLoader.allowedDimension(size);
        imageSize.width = Math.min(imageSize.width, size.width - 24);
        this.imageLabel.setPreferredSize(imageSize);
        this.revalidate();
        this.spinner.start();
        this.currentImageLoad = this.staticImageLoader.asyncLoad(this.latLong, imageSize, this.zoomLevel);
        Futures.addCallback(this.currentImageLoad, new FutureCallback<BufferedImage>(){

            @Override
            public void onFailure(Throwable t) {
                if (!(t instanceof CancellationException)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GoogleLocationPreviewPanel.this.currentImageLoad = null;
                            GoogleLocationPreviewPanel.this.setErrorLoadingImage();
                            GoogleLocationPreviewPanel.this.zoomInLabel.setVisible(false);
                            GoogleLocationPreviewPanel.this.zoomOutLabel.setVisible(false);
                            GoogleLocationPreviewPanel.this.spinner.stop();
                        }
                    });
                }
            }

            @Override
            public void onSuccess(final BufferedImage image) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LatLongCoordinates currentLatLong = GoogleLocationPreviewPanel.this.latLong;
                        if (currentLatLong != null) {
                            GoogleLocationPreviewPanel.this.makeClickable(GoogleLocationPreviewPanel.this.latLong);
                        } else {
                            GoogleLocationPreviewPanel.this.removeClickable();
                        }
                        GoogleLocationPreviewPanel.this.currentImageLoad = null;
                        GoogleLocationPreviewPanel.this.spinner.stop();
                        GoogleLocationPreviewPanel.this.zoomInLabel.setVisible(image != null);
                        GoogleLocationPreviewPanel.this.zoomOutLabel.setVisible(image != null);
                        GoogleLocationPreviewPanel.this.imageLabel.setIcon(image == null ? null : new ImageIcon(image));
                        GoogleLocationPreviewPanel.this.imageLabel.setText(null);
                        GoogleLocationPreviewPanel.this.repaint();
                    }
                });
            }
        }, MoreExecutors.directExecutor());
    }

    private void removeClickable() {
        this.imageLabel.setCursor(null);
        if (this.mapClickedMouseAdapter != null) {
            this.imageLabel.removeMouseListener(this.mapClickedMouseAdapter);
            this.zoomInLabel.removeMouseListener(this.zoomInMouseAdapter);
            this.zoomOutLabel.removeMouseListener(this.zoomOutMouseAdapter);
            this.mapClickedMouseAdapter = null;
        }
    }

    private void makeClickable(final LatLongCoordinates latLong) {
        Preconditions.checkNotNull(latLong);
        this.imageLabel.setCursor(Cursor.getPredefinedCursor(12));
        if (this.mapClickedMouseAdapter != null) {
            this.imageLabel.removeMouseListener(this.mapClickedMouseAdapter);
        }
        if (this.zoomInMouseAdapter != null) {
            this.zoomInLabel.removeMouseListener(this.zoomInMouseAdapter);
        }
        if (this.zoomOutMouseAdapter != null) {
            this.zoomOutLabel.removeMouseListener(this.zoomOutMouseAdapter);
        }
        this.mapClickedMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                LatLongCoordinates clicked = MercatorProjection.point(latLong, GoogleLocationPreviewPanel.this.zoomLevel, GoogleLocationPreviewPanel.this.imageLabel.getWidth(), GoogleLocationPreviewPanel.this.imageLabel.getHeight(), event.getPoint());
                for (LocationPreview.MapClickedListener listener : (LocationPreview.MapClickedListener[])GoogleLocationPreviewPanel.this.getListeners(LocationPreview.MapClickedListener.class)) {
                    listener.mapClicked(clicked);
                }
            }
        };
        this.zoomInMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (latLong != null && GoogleLocationPreviewPanel.this.zoomLevel < 18) {
                    ++GoogleLocationPreviewPanel.this.zoomLevel;
                    GoogleLocationPreviewPanel.this.reloadImage();
                }
            }
        };
        this.zoomOutMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (latLong != null && GoogleLocationPreviewPanel.this.zoomLevel > 0) {
                    --GoogleLocationPreviewPanel.this.zoomLevel;
                    GoogleLocationPreviewPanel.this.reloadImage();
                }
            }
        };
        this.imageLabel.addMouseListener(this.mapClickedMouseAdapter);
        this.zoomInLabel.addMouseListener(this.zoomInMouseAdapter);
        this.zoomOutLabel.addMouseListener(this.zoomOutMouseAdapter);
    }
}

