/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.formdev.flatlaf.FlatLaf;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.ClementsChecklist;
import com.scythebill.birdlist.model.io.CsvExportLines;
import com.scythebill.birdlist.model.io.ExportLines;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.ResolvedComparator;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.SpeciesIndexerPanelConfigurer;
import com.scythebill.birdlist.ui.components.table.DeleteColumn;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.ShowSpeciesMap;
import com.scythebill.birdlist.ui.panels.SpeciesInfoDescriber;
import com.scythebill.birdlist.ui.panels.location.LocationBrowsePanel;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import com.scythebill.birdlist.ui.util.LocationTaxonScorer;
import com.scythebill.birdlist.ui.util.TaxonScorer;
import com.scythebill.birdlist.ui.util.UIUtils;
import com.scythebill.birdlist.ui.util.UiFutures;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class EditChecklistPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private final ReportSet reportSet;
    private final Location location;
    private final Checklists checklists;
    private JButton okButton;
    private JButton deleteButton;
    private JButton cancelButton;
    private JSeparator separator;
    private JTable table;
    private JScrollPane tableScrollPane;
    private JTableHeader columnHeader;
    private LocationBrowsePanel.EditChecklistPresenter presenter;
    private Map<SightingTaxon, Checklist.Status> checklistMap;
    private List<String[]> builtInEdits;
    private FontManager fontManager;
    private IndexerPanel<String> indexer;
    private JButton add;
    private JEditorPane speciesInfoText;
    private JScrollPane speciesInfoScrollPane;
    private Checklist parentChecklist;
    private ListeningExecutorService executorService;
    private SpeciesInfoDescriber speciesInfoDescriber;
    private Location parentChecklistLocation;
    private Alerts alerts;
    private Checklist checklist;
    private TaxonomyStore taxonomyStore;
    private JLabel count;
    private final SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer;
    private final ShowSpeciesMap showSpeciesMap;
    private static final Logger logger = Logger.getLogger(EditChecklistPanel.class.getName());
    private static final List<Messages.Name> COLUMN_NAMES = ImmutableList.of(Messages.Name.COMMON_COLUMN, Messages.Name.SCIENTIFIC_COLUMN, Messages.Name.STATUS_COLUMN, Messages.Name.DELETE_COLUMN);
    private static final ImmutableBiMap<Integer, Checklist.Status> STATUS_INDICES;
    private Future<?> scorerFuture;
    private Taxonomy taxonomy;

    public EditChecklistPanel(ReportSet reportSet, Checklists checklists, Checklist checklist, Location location, TaxonomyStore taxonomyStore, EventBusRegistrar eventBusRegistrar, FontManager fontManager, ListeningExecutorService executorService, SpeciesInfoDescriber speciesInfoDescriber, SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer, ShowSpeciesMap showSpeciesMap, Alerts alerts) {
        Taxonomy taxonomy;
        this.reportSet = reportSet;
        this.checklists = checklists;
        this.checklist = checklist;
        this.taxonomyStore = taxonomyStore;
        this.fontManager = fontManager;
        this.executorService = executorService;
        this.speciesInfoDescriber = speciesInfoDescriber;
        this.speciesIndexerPanelConfigurer = speciesIndexerPanelConfigurer;
        this.showSpeciesMap = showSpeciesMap;
        this.alerts = alerts;
        this.location = location;
        if (checklist.isBuiltIn()) {
            taxonomy = taxonomyStore.getIoc();
            this.checklistMap = Maps.newHashMap();
            for (SightingTaxon taxon : checklist.getTaxa(taxonomy)) {
                this.checklistMap.put(taxon, checklist.getStatus(taxonomy, taxon));
            }
            this.builtInEdits = Lists.newArrayList();
        } else {
            taxonomy = taxonomyStore.getTaxonomy();
            this.checklistMap = Maps.newHashMap(((ClementsChecklist)checklist).baseChecklistMap());
            eventBusRegistrar.registerWhenInHierarchy(this);
        }
        for (Location checklistLocation = location.getParent(); checklistLocation != null; checklistLocation = checklistLocation.getParent()) {
            if (!checklists.hasChecklist(taxonomyStore.getTaxonomy(), reportSet, checklistLocation)) continue;
            this.parentChecklist = checklists.getChecklist(reportSet, taxonomyStore.getTaxonomy(), checklistLocation);
            this.parentChecklistLocation = checklistLocation;
            break;
        }
        this.initGUI();
        this.setTaxonomy(taxonomy);
        fontManager.applyTo(this);
    }

    private void initGUI() {
        this.table = new JTable();
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Object.class, new CellRenderer());
        this.tableScrollPane = new JScrollPane(this.table, 22, 30);
        this.columnHeader = new JTableHeader();
        this.tableScrollPane.setColumnHeaderView(this.columnHeader);
        this.indexer = new IndexerPanel();
        this.add = new JButton(Messages.getMessage(Messages.Name.ADD_SPECIES));
        this.add.setEnabled(false);
        this.count = new JLabel();
        this.speciesInfoText = new JEditorPane(){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setBackground(FlatLaf.isLafDark() ? UIManager.getColor("EditorPane.background") : Color.WHITE);
            }
        };
        this.speciesInfoText.setContentType("text/html");
        if (!FlatLaf.isLafDark()) {
            this.speciesInfoText.setBackground(Color.WHITE);
        }
        this.speciesInfoText.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.speciesInfoScrollPane = new JScrollPane(this.speciesInfoText);
        this.speciesInfoScrollPane.setVerticalScrollBarPolicy(20);
        this.speciesInfoScrollPane.setHorizontalScrollBarPolicy(31);
        this.speciesInfoText.setEditable(false);
        this.speciesInfoText.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (SpeciesInfoDescriber.isShowMapUrl(event.getURL())) {
                        String id = SpeciesInfoDescriber.getShowMapSpeciesId(event.getURL());
                        try {
                            EditChecklistPanel.this.showSpeciesMap.showRange(EditChecklistPanel.this.reportSet, EditChecklistPanel.this.taxonomy, id);
                        }
                        catch (IOException e) {
                            EditChecklistPanel.this.alerts.showError((Object)EditChecklistPanel.this, (Throwable)e, Messages.Name.MAP_FAILED, Messages.Name.COULDNT_WRITE_MAP, new Object[0]);
                        }
                    } else {
                        try {
                            DesktopUtils.openUrlInBrowser(event.getURL().toURI(), EditChecklistPanel.this.alerts);
                        }
                        catch (URISyntaxException e) {
                            logger.log(Level.WARNING, "Couldn't open URL " + event.getURL(), e);
                        }
                    }
                }
            }
        });
        this.updateSpeciesText();
        this.indexer.addPropertyChangeListener("selectedValue", e -> this.updateSpeciesText());
        this.indexer.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                EditChecklistPanel.this.add.setEnabled(e.getNewValue() != null);
                EditChecklistPanel.this.updateSpeciesText();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(e -> this.updateSpeciesText());
        this.indexer.addActionListener(e -> this.add.doClick(100));
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String id = EditChecklistPanel.this.indexer.getValue();
                if (id == null) {
                    return;
                }
                Taxon taxon = EditChecklistPanel.this.taxonomy.getTaxon(id);
                SightingTaxon.Resolved resolved = SightingTaxons.newResolved(taxon);
                int row = EditChecklistPanel.this.checklistModel().addResolved(resolved);
                EditChecklistPanel.this.table.setRowSelectionInterval(row, row);
                EditChecklistPanel.this.table.scrollRectToVisible(EditChecklistPanel.this.table.getCellRect(row, 0, true));
                EditChecklistPanel.this.add.setEnabled(false);
            }
        });
        this.okButton = new JButton(Messages.getMessage(Messages.Name.OK_BUTTON));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (EditChecklistPanel.this.checklist.isBuiltIn()) {
                    StringWriter sw = new StringWriter();
                    sw.append("Location: " + Locations.getLocationCode(EditChecklistPanel.this.location) + "\n");
                    sw.append("Taxonomy: " + EditChecklistPanel.this.taxonomy.getName() + "\n");
                    try {
                        ExportLines exportLines = CsvExportLines.fromWriter(sw);
                        exportLines.nextLine(new String[]{"Action", "Checklist", "ID", "Status"});
                        for (String[] line : EditChecklistPanel.this.builtInEdits) {
                            exportLines.nextLine(line);
                        }
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                    EditChecklistPanel.this.alerts.showFeedback(Messages.Name.CHECKLIST_CORRECTIONS_ARE_READY, sw.toString());
                    EditChecklistPanel.this.presenter.done();
                } else {
                    Map<SightingTaxon, Checklist.Status> updatedChecklistMap = EditChecklistPanel.this.checklistModel().getChecklistMap();
                    ClementsChecklist updatedChecklist = new ClementsChecklist(updatedChecklistMap);
                    EditChecklistPanel.this.reportSet.setChecklist(EditChecklistPanel.this.location, updatedChecklist);
                    EditChecklistPanel.this.reportSet.markDirty();
                    EditChecklistPanel.this.presenter.done();
                }
            }
        });
        this.cancelButton = new JButton(Messages.getMessage(Messages.Name.CANCEL_BUTTON));
        this.cancelButton.addActionListener(e -> this.presenter.done());
        this.deleteButton = new JButton(Messages.getMessage(Messages.Name.DELETE_CHECKLIST_BUTTON));
        if (this.checklist.isBuiltIn()) {
            this.deleteButton.setVisible(false);
        } else {
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (EditChecklistPanel.this.alerts.showOkCancel((Object)EditChecklistPanel.this, Messages.Name.DELETE_CHECKLIST_TITLE, Messages.Name.DELETE_CHECKLIST_MESSAGE, new Object[0]) == 0) {
                        EditChecklistPanel.this.reportSet.removeChecklist(EditChecklistPanel.this.location);
                        EditChecklistPanel.this.reportSet.markDirty();
                        EditChecklistPanel.this.presenter.done();
                    }
                }
            });
        }
        this.separator = new JSeparator();
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int column = EditChecklistPanel.this.table.columnAtPoint(e.getPoint());
                if (e.getClickCount() != 1) {
                    return;
                }
                if (column != 3) {
                    return;
                }
                int row = EditChecklistPanel.this.table.rowAtPoint(e.getPoint());
                if (row < 0) {
                    return;
                }
                ChecklistTableModel checklistModel = EditChecklistPanel.this.checklistModel();
                checklistModel.removeRow(row);
            }
        });
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.speciesInfoText.setPreferredSize(fontManager.scale(new Dimension(480, 50)));
        this.speciesInfoText.setMaximumSize(fontManager.scale(new Dimension(Short.MAX_VALUE, 100)));
        this.setBorder(new EmptyBorder(fontManager.scale(20), fontManager.scale(20), fontManager.scale(15), fontManager.scale(20)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.indexer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.add).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.count)).addComponent(this.speciesInfoScrollPane).addComponent(this.tableScrollPane).addComponent(this.separator).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.deleteButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createBaselineGroup(false, false).addComponent(this.indexer).addComponent(this.add).addComponent(this.count)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.speciesInfoScrollPane, fontManager.scale(50), fontManager.scale(100), fontManager.scale(100)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tableScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separator, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.deleteButton).addComponent(this.cancelButton).addComponent(this.okButton)));
        layout.linkSize(this.cancelButton, this.okButton);
        this.table.setSurrendersFocusOnKeystroke(true);
    }

    private JComboBox<String> statusComboBox() {
        return new JComboBox<String>(new String[]{"", Messages.getMessage(Messages.Name.CHECKLIST_STATUS_INTRODUCED), Messages.getMessage(Messages.Name.CHECKLIST_STATUS_NOT_ESTABLISHED), Messages.getMessage(Messages.Name.CHECKLIST_STATUS_RARITY), Messages.getMessage(Messages.Name.CHECKLIST_STATUS_RARITY_FROM_INTRODUCED), Messages.getMessage(Messages.Name.CHECKLIST_STATUS_ENDEMIC), Messages.getMessage(Messages.Name.CHECKLIST_STATUS_EXTINCT)});
    }

    private Box horizontalBox(JComboBox<?> comboBox) {
        Box box = Box.createHorizontalBox();
        box.add(comboBox);
        box.add(Box.createHorizontalGlue());
        box.setOpaque(true);
        return box;
    }

    public void setPresenter(LocationBrowsePanel.EditChecklistPresenter editChecklistPresenter) {
        this.presenter = editChecklistPresenter;
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.checklistMap = this.checklistModel().getChecklistMap();
        this.setTaxonomy(event.getTaxonomy());
    }

    public ChecklistTableModel checklistModel() {
        ChecklistTableModel model = (ChecklistTableModel)this.table.getModel();
        return model;
    }

    private void setTaxonomy(Taxonomy taxonomy) {
        this.taxonomy = taxonomy;
        this.table.setModel(new ChecklistTableModel(taxonomy, this.checklistMap));
        this.table.getModel().addTableModelListener(e -> this.updateCount());
        this.updateCount();
        TableColumn deleteColumn = this.table.getColumnModel().getColumn(3);
        deleteColumn.setMaxWidth(80);
        deleteColumn.setWidth(80);
        deleteColumn.setResizable(false);
        final JLabel deleteLabel = DeleteColumn.createDeleteLabel();
        deleteLabel.setHorizontalAlignment(0);
        deleteColumn.setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                EditChecklistPanel.this.setCellAppearance(isSelected, row, deleteLabel, deleteLabel);
                deleteLabel.setOpaque(true);
                return deleteLabel;
            }
        });
        TableColumn statusColumn = this.table.getColumnModel().getColumn(2);
        this.table.setRowHeight(this.fontManager.scale(20));
        JComboBox<String> editCombo = this.statusComboBox();
        statusColumn.setCellEditor(new StatusComboEditor((Component)this.horizontalBox(editCombo), editCombo));
        final JComboBox<String> renderCombo = this.statusComboBox();
        final Box renderBox = this.horizontalBox(renderCombo);
        statusColumn.setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                EditChecklistPanel.this.setCellAppearance(isSelected, row, renderBox, renderCombo);
                renderCombo.setSelectedIndex((Integer)((ImmutableMap)((Object)STATUS_INDICES.inverse())).get(value));
                return renderBox;
            }
        });
        this.speciesIndexerPanelConfigurer.configure(this.indexer, taxonomy);
        ReportSet emptyReports = new ReportSet(this.reportSet.getLocations(), new Trips(this.reportSet.getLocations()), ImmutableList.of(), this.taxonomyStore.getClements());
        TaxonScorer scorer = LocationTaxonScorer.newTaxonScorer(taxonomy, emptyReports, this.location.getParent(), null, this.checklists);
        this.indexer.setOrdering(scorer::ordering);
        if (this.scorerFuture != null) {
            this.scorerFuture.cancel(true);
        }
        this.scorerFuture = scorer.start(this.executorService);
        UiFutures.cancelFutureOnHide(this.scorerFuture, this);
    }

    private void setCellAppearance(boolean isSelected, int row, Component component, Component fontComponent) {
        Color color = isSelected ? (UIUtils.isMacOS() || this.hasFocus() ? UIManager.getColor("TextPane.selectionBackground") : UIManager.getColor("Table.selectionBackground")) : UIManager.getColor(row % 2 == 0 ? "Table.alternateBackground.0" : "Table.alternateBackground.1");
        if (color == null) {
            color = UIManager.getColor("Table.background");
        }
        component.setBackground(color);
        fontComponent.setFont(this.fontManager.getTableFont());
        fontComponent.setMaximumSize(fontComponent.getPreferredSize());
    }

    private void updateSpeciesText() {
        StringBuilder builder = new StringBuilder("<html>");
        String id = this.indexer.getSelectedValue();
        if (id == null) {
            id = this.indexer.getValue();
        }
        if (id == null && this.table.getModel() instanceof ChecklistTableModel) {
            int anchorSelectionIndex = this.table.getSelectionModel().getAnchorSelectionIndex();
            id = ((ChecklistTableModel)this.table.getModel()).getTaxonAtRow(anchorSelectionIndex);
        }
        if (id == null) {
            builder.append("<span style='color:gray'>").append(Messages.getMessage(Messages.Name.SPECIES_INFORMATION_WILL_APPEAR_HERE)).append("</span>");
            builder.append("</html>");
            this.speciesInfoText.setText(builder.toString());
            return;
        }
        Taxon taxon = this.taxonomy.getTaxon(id);
        if (taxon != null) {
            SightingTaxon.Resolved resolved = SightingTaxons.newResolved(taxon);
            this.speciesInfoDescriber.toHtmlText(resolved, this.reportSet, this.parentChecklist, this.parentChecklistLocation, builder);
        }
        builder.append("</html>");
        this.speciesInfoText.setText(builder.toString());
        this.speciesInfoText.select(0, 0);
    }

    private void updateCount() {
        this.count.setText(Messages.getFormattedMessage(Messages.Name.TOTAL_FORMAT, this.table.getModel().getRowCount()));
    }

    static {
        ImmutableBiMap.Builder statusBuilder = ImmutableBiMap.builder();
        statusBuilder.put((Object)0, (Object)Checklist.Status.NATIVE);
        statusBuilder.put((Object)1, (Object)Checklist.Status.INTRODUCED);
        statusBuilder.put((Object)2, (Object)Checklist.Status.ESCAPED);
        statusBuilder.put((Object)3, (Object)Checklist.Status.RARITY);
        statusBuilder.put((Object)4, (Object)Checklist.Status.RARITY_FROM_INTRODUCED);
        statusBuilder.put((Object)5, (Object)Checklist.Status.ENDEMIC);
        statusBuilder.put((Object)6, (Object)Checklist.Status.EXTINCT);
        STATUS_INDICES = statusBuilder.build();
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            hasFocus = false;
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            EditChecklistPanel.this.setCellAppearance(isSelected, row, component, component);
            return component;
        }
    }

    private class ChecklistTableModel
    extends AbstractTableModel {
        private final List<TableRow> list = Lists.newArrayList();

        ChecklistTableModel(Taxonomy taxonomy, Map<SightingTaxon, Checklist.Status> checklistMap) {
            for (Map.Entry<SightingTaxon, Checklist.Status> entry : checklistMap.entrySet()) {
                SightingTaxon.Resolved resolved = EditChecklistPanel.this.checklist.isBuiltIn() ? entry.getKey().resolveInternal(taxonomy) : entry.getKey().resolve(taxonomy);
                this.list.add(new TableRow(entry.getKey(), resolved, entry.getValue()));
            }
            Collections.sort(this.list);
        }

        @Override
        public String getColumnName(int index) {
            return Messages.getMessage(COLUMN_NAMES.get(index));
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.size();
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            TableRow tableRow = this.list.get(row);
            switch (column) {
                case 0: {
                    return tableRow.resolved.getCommonName();
                }
                case 1: {
                    return tableRow.resolved.getFullName();
                }
                case 2: {
                    return tableRow.status;
                }
                case 3: {
                    return "";
                }
            }
            throw new AssertionError((Object)("Unexpected column " + column));
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            TableRow tableRow = this.list.get(row);
            if (column == 2) {
                Checklist.Status status = (Checklist.Status)((Object)o);
                Preconditions.checkNotNull(status);
                tableRow.status = status;
                this.fireTableCellUpdated(row, column);
                if (EditChecklistPanel.this.builtInEdits != null) {
                    EditChecklistPanel.this.builtInEdits.add(new String[]{"setStatus", "ioc", tableRow.taxon.getId(), Strings.nullToEmpty(tableRow.status.text()), tableRow.resolved.getCommonName()});
                }
            } else {
                throw new IllegalArgumentException("Unexpected column: " + column);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        public void removeRow(int row) {
            TableRow tableRow = this.list.get(row);
            if (EditChecklistPanel.this.builtInEdits != null) {
                EditChecklistPanel.this.builtInEdits.add(new String[]{"remove", "ioc", tableRow.taxon.getId(), "", tableRow.resolved.getCommonName()});
            }
            this.list.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public Map<SightingTaxon, Checklist.Status> getChecklistMap() {
            HashMap<SightingTaxon, Checklist.Status> map = Maps.newHashMapWithExpectedSize(this.list.size());
            for (TableRow row : this.list) {
                map.put(row.taxon, row.status);
            }
            return map;
        }

        public int addResolved(SightingTaxon.Resolved resolved) {
            SightingTaxon taxon = resolved.getSightingTaxonInBaseTaxonomy();
            TableRow row = new TableRow(taxon, resolved, Checklist.Status.NATIVE);
            int index = Collections.binarySearch(this.list, row);
            if (index >= 0) {
                return index;
            }
            if (EditChecklistPanel.this.builtInEdits != null) {
                EditChecklistPanel.this.builtInEdits.add(new String[]{"add", "ioc", resolved.getTaxon().getId(), "", resolved.getCommonName()});
            }
            int insertionIndex = -(index + 1);
            this.list.add(insertionIndex, row);
            this.fireTableRowsInserted(insertionIndex, insertionIndex);
            return insertionIndex;
        }

        public String getTaxonAtRow(int row) {
            if (row < 0) {
                return null;
            }
            SightingTaxon.Resolved resolved = this.list.get((int)row).resolved;
            if (resolved.getType() != SightingTaxon.Type.SINGLE) {
                return null;
            }
            return resolved.getTaxon().getId();
        }
    }

    class StatusComboEditor
    extends ComboBoxCellEditor {
        public StatusComboEditor(Component component, JComboBox<String> comboBox) {
            super(component, comboBox);
        }

        @Override
        public Object getCellEditorValue() {
            return STATUS_INDICES.get(this.comboBox.getSelectedIndex());
        }

        @Override
        protected void updateComboBox(Object value) {
            this.comboBox.setSelectedIndex((Integer)((ImmutableMap)((Object)STATUS_INDICES.inverse())).get(value));
        }
    }

    class ComboBoxCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Component component;
        protected JComboBox<?> comboBox;

        public ComboBoxCellEditor(Component component, JComboBox<?> comboBox) {
            this.component = component;
            this.comboBox = comboBox;
            comboBox.addActionListener(e -> this.stopCellEditing());
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.updateComboBox(value);
            EditChecklistPanel.this.setCellAppearance(true, row, this.component, this.comboBox);
            return this.component;
        }

        protected void updateComboBox(Object value) {
            this.comboBox.setSelectedItem(value);
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            if (event instanceof MouseEvent) {
                return ((MouseEvent)event).getClickCount() >= 1;
            }
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject event) {
            if (event instanceof MouseEvent) {
                MouseEvent mouse = (MouseEvent)event;
                return mouse.getID() != 506;
            }
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }
    }

    static class TableRow
    implements Comparable<TableRow> {
        private static final ResolvedComparator comparator = new ResolvedComparator();
        final SightingTaxon taxon;
        final SightingTaxon.Resolved resolved;
        Checklist.Status status;

        TableRow(SightingTaxon taxon, SightingTaxon.Resolved resolved, Checklist.Status status) {
            this.taxon = taxon;
            this.resolved = resolved;
            this.status = status;
        }

        @Override
        public int compareTo(TableRow that) {
            return comparator.compare(this.resolved, that.resolved);
        }
    }
}

