/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.ClementsChecklist;
import com.scythebill.birdlist.model.query.QueryProcessor;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.location.CreateChecklistFromTextPanel;
import com.scythebill.birdlist.ui.panels.location.LocationBrowsePanel;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;

class CreateChecklistPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private final ReportSet reportSet;
    private final Checklists checklists;
    private final Location location;
    private final TaxonomyStore taxonomyStore;
    private JRadioButton yourSightings;
    private JLabel helpText;
    private JRadioButton copyAndPasteMagic;
    private JButton okButton;
    private JButton cancelButton;
    private JSeparator separator;
    private LocationBrowsePanel.CreateChecklistPresenter createChecklistPresenter;
    private JLabel yourSightingsText;
    private JLabel copyAndPasteText;
    private EventBusRegistrar eventBusRegistrar;
    private FontManager fontManager;

    public CreateChecklistPanel(ReportSet reportSet, Checklists checklists, Location location, TaxonomyStore taxonomyStore, EventBusRegistrar eventBusRegistrar, FontManager fontManager) {
        this.reportSet = reportSet;
        this.checklists = checklists;
        this.location = location;
        this.taxonomyStore = taxonomyStore;
        this.eventBusRegistrar = eventBusRegistrar;
        this.fontManager = fontManager;
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.initGUI();
        fontManager.applyTo(this);
    }

    private void initGUI() {
        this.helpText = new JLabel(Messages.getFormattedMessage(Messages.Name.HOW_TO_GET_STARTED_WITH_CHECKLIST, this.location.getDisplayName()));
        this.yourSightings = new JRadioButton(Messages.getMessage(Messages.Name.START_WITH_YOUR_SIGHTINGS), true);
        this.yourSightingsText = new JLabel(Messages.getFormattedMessage(Messages.Name.START_WITH_YOUR_SIGHTINGS_HELP, this.location.getDisplayName()));
        this.yourSightingsText.putClientProperty("birdlist.plainLabel", true);
        this.copyAndPasteMagic = new JRadioButton(Messages.getMessage(Messages.Name.COPY_AND_PASTE_MAGIC), true);
        this.copyAndPasteText = new JLabel(Messages.getMessage(Messages.Name.COPY_AND_PASTE_MAGIC_HELP));
        this.copyAndPasteText.putClientProperty("birdlist.plainLabel", true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.yourSightings);
        group.add(this.copyAndPasteMagic);
        this.okButton = new JButton(Messages.getMessage(Messages.Name.OK_BUTTON));
        this.okButton.addActionListener(e -> {
            if (this.yourSightings.isSelected()) {
                this.yourSightings();
            } else {
                this.copyAndPasteMagic();
            }
        });
        this.cancelButton = new JButton(Messages.getMessage(Messages.Name.CANCEL_BUTTON));
        this.cancelButton.addActionListener(e -> this.createChecklistPresenter.cancel());
        this.separator = new JSeparator();
    }

    private void copyAndPasteMagic() {
        CreateChecklistFromTextPanel panel = new CreateChecklistFromTextPanel(this.reportSet, this.checklists, this.location, this.taxonomyStore, this.eventBusRegistrar, this.fontManager, this.createChecklistPresenter);
        this.createChecklistPresenter.switchTo(panel);
    }

    private void yourSightings() {
        QueryProcessor processor = new QueryProcessor(this.reportSet, this.taxonomyStore.getClements());
        Predicate<Sighting> predicate = SightingPredicates.in(this.location, this.reportSet.getLocations());
        QueryResults queryResults = processor.runQuery(predicate, null, Taxon.Type.subspecies);
        HashMap<SightingTaxon, Checklist.Status> checklistMap = Maps.newHashMap();
        for (SightingTaxon.Resolved resolved : queryResults.getTaxaAsList()) {
            if (resolved.getSmallestTaxonType() == Taxon.Type.family) continue;
            Checklist.Status status = null;
            for (Sighting sighting : queryResults.getAllSightings(resolved)) {
                SightingInfo.SightingStatus sightingStatus = sighting.getSightingInfo().getSightingStatus();
                switch (sightingStatus) {
                    case ID_UNCERTAIN: 
                    case RECORD_NOT_ACCEPTED: 
                    case DOMESTIC: 
                    case RESTRAINED: 
                    case UNSATISFACTORY_VIEWS: 
                    case DEAD: 
                    case NOT_BY_ME: 
                    case SIGNS: {
                        break;
                    }
                    case BETTER_VIEW_DESIRED: 
                    case NONE: {
                        if (status != null) break;
                        status = Checklist.Status.NATIVE;
                        break;
                    }
                    case INTRODUCED: {
                        status = Checklist.Status.INTRODUCED;
                        break;
                    }
                    case INTRODUCED_NOT_ESTABLISHED: {
                        status = Checklist.Status.ESCAPED;
                    }
                }
                if (status == null) continue;
                break;
            }
            if (status == null) continue;
            checklistMap.put(resolved.getParentOfAtLeastType(Taxon.Type.species), status);
        }
        this.reportSet.setChecklist(this.location, new ClementsChecklist(checklistMap));
        this.reportSet.markDirty();
        this.createChecklistPresenter.created();
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setBorder(new EmptyBorder(fontManager.scale(20), fontManager.scale(20), fontManager.scale(15), fontManager.scale(20)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.helpText).addComponent(this.yourSightings).addComponent(this.yourSightingsText).addComponent(this.copyAndPasteMagic).addComponent(this.copyAndPasteText).addComponent(this.separator).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.helpText).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.yourSightings).addComponent(this.yourSightingsText).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.copyAndPasteMagic).addComponent(this.copyAndPasteText).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separator, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup().addComponent(this.cancelButton).addComponent(this.okButton)));
        layout.linkSize(this.cancelButton, this.okButton);
    }

    public void setPresenter(LocationBrowsePanel.CreateChecklistPresenter createChecklistPresenter) {
        this.createChecklistPresenter = createChecklistPresenter;
    }
}

