/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.ClementsChecklist;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.location.LocationBrowsePanel;
import com.scythebill.birdlist.ui.util.FindSpeciesInText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class CreateChecklistFromTextPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private final ReportSet reportSet;
    private final Location location;
    private final TaxonomyStore taxonomyStore;
    private final LocationBrowsePanel.CreateChecklistPresenter createChecklistPresenter;
    private final Set<SightingTaxon> foundSet = Sets.newHashSet();
    private JScrollPane scrollPane;
    private JLabel helpText;
    private JLabel moreHelpText;
    private JButton okButton;
    private JButton cancelButton;
    private JSeparator separator;
    private JTextArea textArea;
    private JButton parse;
    private FindSpeciesInText findSpeciesInText;
    private JLabel resultsText;
    private boolean useSecondarySearch;
    private Checklist checklist;

    public CreateChecklistFromTextPanel(ReportSet reportSet, Checklists checklists, Location location, TaxonomyStore taxonomyStore, EventBusRegistrar eventBusRegistrar, FontManager fontManager, LocationBrowsePanel.CreateChecklistPresenter createChecklistPresenter) {
        this.reportSet = Preconditions.checkNotNull(reportSet);
        this.location = Preconditions.checkNotNull(location);
        this.taxonomyStore = Preconditions.checkNotNull(taxonomyStore);
        this.createChecklistPresenter = Preconditions.checkNotNull(createChecklistPresenter);
        for (Location checklistLocation = location.getParent(); checklistLocation != null; checklistLocation = checklistLocation.getParent()) {
            if (!checklists.hasChecklist(taxonomyStore.getTaxonomy(), reportSet, checklistLocation)) continue;
            this.checklist = checklists.getChecklist(reportSet, taxonomyStore.getTaxonomy(), checklistLocation);
            break;
        }
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.initGUI();
        fontManager.applyTo(this);
        this.taxonomyChanged(null);
    }

    private void initGUI() {
        this.helpText = new JLabel(Messages.getMessage(Messages.Name.CLICK_START_HELP));
        this.moreHelpText = new JLabel("");
        this.resultsText = new JLabel("");
        this.textArea = new JTextArea(20, 60);
        this.scrollPane = new JScrollPane(this.textArea, 20, 30);
        this.parse = new JButton(Messages.getMessage(Messages.Name.START_BUTTON));
        this.parse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FindSpeciesInText.TaxonSearch search = CreateChecklistFromTextPanel.this.useSecondarySearch ? CreateChecklistFromTextPanel.this.findSpeciesInText.secondarySearch(true) : CreateChecklistFromTextPanel.this.findSpeciesInText.primarySearch();
                FindSpeciesInText.Results results = CreateChecklistFromTextPanel.this.findSpeciesInText.search(CreateChecklistFromTextPanel.this.textArea.getText(), search);
                int previousSize = CreateChecklistFromTextPanel.this.foundSet.size();
                for (SightingTaxon.Resolved resolved : results.found) {
                    SightingTaxon sightingTaxon = resolved.getSightingTaxonInBaseTaxonomy();
                    if (sightingTaxon == null) continue;
                    CreateChecklistFromTextPanel.this.foundSet.add(sightingTaxon);
                }
                int foundCount = results.found.size();
                int newFound = CreateChecklistFromTextPanel.this.foundSet.size() - previousSize;
                if (foundCount == 0) {
                    if (CreateChecklistFromTextPanel.this.foundSet.isEmpty()) {
                        CreateChecklistFromTextPanel.this.resultsText.setText(Messages.getMessage(Messages.Name.NOTHING_FOUND));
                    } else {
                        CreateChecklistFromTextPanel.this.resultsText.setText(Messages.getFormattedMessage(Messages.Name.NOTHING_NEW_STILL_FORMAT, CreateChecklistFromTextPanel.this.foundSet.size()));
                    }
                } else if (foundCount == newFound) {
                    if (previousSize == 0) {
                        CreateChecklistFromTextPanel.this.resultsText.setText(Messages.getFormattedMessage(Messages.Name.FOUND_SPECIES_CLICK_REMAINING_TEXT, foundCount));
                    } else {
                        CreateChecklistFromTextPanel.this.resultsText.setText(Messages.getFormattedMessage(Messages.Name.FOUND_SPECIES_NOW_TOTAL, foundCount, CreateChecklistFromTextPanel.this.foundSet.size()));
                    }
                } else {
                    CreateChecklistFromTextPanel.this.resultsText.setText(Messages.getFormattedMessage(Messages.Name.FOUND_EVEN_MORE_SPECIES, foundCount, newFound, CreateChecklistFromTextPanel.this.foundSet.size()));
                }
                CreateChecklistFromTextPanel.this.textArea.setText(results.remainingText);
                CreateChecklistFromTextPanel.this.useSecondarySearch = true;
                CreateChecklistFromTextPanel.this.updateParseButton();
                if (!CreateChecklistFromTextPanel.this.foundSet.isEmpty()) {
                    CreateChecklistFromTextPanel.this.okButton.setEnabled(true);
                }
            }
        });
        this.parse.setEnabled(false);
        this.okButton = new JButton(Messages.getMessage(Messages.Name.CREATE_A_CHECKLIST));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                HashMap<SightingTaxon, Checklist.Status> map;
                if (CreateChecklistFromTextPanel.this.checklist == null) {
                    map = Maps.asMap(CreateChecklistFromTextPanel.this.foundSet, Functions.constant(Checklist.Status.NATIVE));
                } else {
                    map = Maps.newHashMap();
                    for (SightingTaxon taxon : CreateChecklistFromTextPanel.this.foundSet) {
                        SightingTaxon resolvedTaxon = taxon.resolve(CreateChecklistFromTextPanel.this.taxonomyStore.getTaxonomy()).getSightingTaxon();
                        Checklist.Status status = CreateChecklistFromTextPanel.this.checklist.getStatus(CreateChecklistFromTextPanel.this.taxonomyStore.getTaxonomy(), resolvedTaxon);
                        if (status == null || status == Checklist.Status.ENDEMIC) {
                            status = Checklist.Status.NATIVE;
                        }
                        map.put(taxon, status);
                    }
                }
                CreateChecklistFromTextPanel.this.reportSet.setChecklist(CreateChecklistFromTextPanel.this.location, new ClementsChecklist(map));
                CreateChecklistFromTextPanel.this.reportSet.markDirty();
                CreateChecklistFromTextPanel.this.createChecklistPresenter.created();
            }
        });
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(Messages.getMessage(Messages.Name.CANCEL_BUTTON));
        this.cancelButton.addActionListener(e -> this.createChecklistPresenter.cancel());
        this.separator = new JSeparator();
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                CreateChecklistFromTextPanel.this.updateParseButton();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CreateChecklistFromTextPanel.this.useSecondarySearch = false;
                CreateChecklistFromTextPanel.this.updateParseButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CreateChecklistFromTextPanel.this.useSecondarySearch = false;
                CreateChecklistFromTextPanel.this.updateParseButton();
            }
        });
    }

    private void updateParseButton() {
        this.parse.setEnabled(this.textArea.getDocument().getLength() > 0);
        this.parse.setText(this.useSecondarySearch ? Messages.getMessage(Messages.Name.TRY_HARDER) : (this.foundSet.isEmpty() ? Messages.getMessage(Messages.Name.START_BUTTON) : Messages.getMessage(Messages.Name.ADD_MORE)));
        this.helpText.setText(this.useSecondarySearch ? Messages.getMessage(Messages.Name.CLICK_TRY_HARDER_HELP) : Messages.getMessage(Messages.Name.CLICK_START_HELP));
        this.moreHelpText.setText(this.useSecondarySearch ? Messages.getMessage(Messages.Name.OR_ENTER_MORE_TEXT) : "");
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setBorder(new EmptyBorder(fontManager.scale(20), fontManager.scale(20), fontManager.scale(15), fontManager.scale(20)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.helpText)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.parse)).addComponent(this.moreHelpText).addComponent(this.resultsText).addComponent(this.scrollPane).addComponent(this.separator).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createBaselineGroup(false, false).addComponent(this.helpText).addComponent(this.parse)).addComponent(this.moreHelpText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultsText).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separator, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup().addComponent(this.cancelButton).addComponent(this.okButton)));
        layout.linkSize(this.cancelButton, this.okButton);
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.findSpeciesInText = new FindSpeciesInText(this.taxonomyStore.getTaxonomy(), this.checklist);
        this.useSecondarySearch = false;
        this.updateParseButton();
    }
}

