/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.io.ChecklistXlsOutput;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.location.ChecklistSpreadsheetPreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.text.NumberFormatter;

class ChecklistXlsDialog {
    private Alerts alerts;
    private ChecklistSpreadsheetPreferences checklistSpreadsheetPreferences;
    private FontManager fontManager;

    @Inject
    ChecklistXlsDialog(Alerts alerts, ChecklistSpreadsheetPreferences checklistSpreadsheetPreferences, FontManager fontManager) {
        this.alerts = alerts;
        this.checklistSpreadsheetPreferences = checklistSpreadsheetPreferences;
        this.fontManager = fontManager;
    }

    @Nullable
    public SpreadsheetConfiguration getConfiguration(JComponent parent, boolean otherTaxonomiesPossible, List<Location> selectedLocations) {
        ChecklistConfigurationPanel panel = new ChecklistConfigurationPanel(otherTaxonomiesPossible, selectedLocations);
        this.fontManager.applyTo(panel);
        String formattedMessage = this.alerts.getFormattedDialogMessage(Messages.Name.SPREADSHEET_OPTIONS, Messages.Name.CHOOSE_OPTIONS_FOR_CHECKLIST, new Object[0]);
        int okCancel = this.alerts.showOkCancelWithPanel(parent, formattedMessage, panel);
        if (okCancel != 0) {
            return null;
        }
        SpreadsheetConfiguration configuration = panel.toConfiguration();
        this.checklistSpreadsheetPreferences.includeScientific = configuration.includeScientific;
        this.checklistSpreadsheetPreferences.includeSighting = configuration.includeSighting;
        this.checklistSpreadsheetPreferences.checklistSightingOption = configuration.checklistSightingOption;
        this.checklistSpreadsheetPreferences.showLifers = configuration.showLifersInBold;
        this.checklistSpreadsheetPreferences.showNewForColumn = configuration.showNewForColumn;
        this.checklistSpreadsheetPreferences.showStatus = configuration.showStatus;
        this.checklistSpreadsheetPreferences.showAllTaxonomies = configuration.showAllTaxonomies;
        this.checklistSpreadsheetPreferences.showFamilies = configuration.showFamilies;
        this.checklistSpreadsheetPreferences.daysToPrint = configuration.daysToInclude;
        return configuration;
    }

    class ChecklistConfigurationPanel
    extends JPanel {
        private JCheckBox includeScientific;
        private JCheckBox includeSighting;
        private JCheckBox showLifersInBold;
        private AutoSelectJFormattedTextField daysToInclude;
        private JCheckBox showStatus;
        private JCheckBox showFamilies;
        private JCheckBox showNewForColumn;
        private JCheckBox showAllTaxonomies;
        private JComboBox<Object> checklistSightingOptionCombobox;

        ChecklistConfigurationPanel(boolean otherTaxonomiesPossible, List<Location> selectedLocations) {
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            this.includeScientific = new JCheckBox(Messages.getMessage(Messages.Name.SCIENTIFIC_NAME_QUESTION));
            this.includeScientific.setSelected(ChecklistXlsDialog.this.checklistSpreadsheetPreferences.includeScientific);
            this.showFamilies = new JCheckBox(Messages.getMessage(Messages.Name.SHOW_FAMILIES_QUESTION));
            this.showFamilies.setSelected(ChecklistXlsDialog.this.checklistSpreadsheetPreferences.showFamilies);
            this.showLifersInBold = new JCheckBox(Messages.getMessage(Messages.Name.LIFERS_IN_BOLD_QUESTION));
            this.showLifersInBold.setSelected(ChecklistXlsDialog.this.checklistSpreadsheetPreferences.showLifers);
            this.showNewForColumn = new JCheckBox(Messages.getMessage(Messages.Name.NEW_FOR_COLUMN_QUESTION));
            this.showNewForColumn.setSelected(ChecklistXlsDialog.this.checklistSpreadsheetPreferences.showNewForColumn);
            this.showStatus = new JCheckBox(Messages.getMessage(Messages.Name.SHOW_THREATENED_STATUS_QUESTION));
            this.showStatus.setSelected(ChecklistXlsDialog.this.checklistSpreadsheetPreferences.showStatus);
            this.showAllTaxonomies = new JCheckBox(Messages.getMessage(Messages.Name.INCLUDE_ALL_TAXONOMIES_QUESTION));
            this.showAllTaxonomies.setSelected(ChecklistXlsDialog.this.checklistSpreadsheetPreferences.showAllTaxonomies);
            this.showAllTaxonomies.setEnabled(otherTaxonomiesPossible);
            this.includeSighting = new JCheckBox(Messages.getMessage(Messages.Name.INCLUDE_ONE_SIGHTING_QUESTION));
            this.includeSighting.setSelected(ChecklistXlsDialog.this.checklistSpreadsheetPreferences.includeSighting);
            JLabel checklistSightingOptionsLabel = new JLabel(Messages.getMessage(Messages.Name.WHICH_SIGHTING_QUESTION));
            ArrayList<String> includeSightingTextOptions = new ArrayList<String>();
            block6: for (ChecklistXlsOutput.ChecklistSightingOption checklistSightingOption : ChecklistXlsOutput.ChecklistSightingOption.values()) {
                switch (checklistSightingOption) {
                    case FIRST_IN_LOCATION: {
                        if (selectedLocations.size() == 1) {
                            includeSightingTextOptions.add(Messages.getFormattedMessage(Messages.Name.FIRST_IN_FORMAT, selectedLocations.get(0).getDisplayName()));
                            continue block6;
                        }
                        includeSightingTextOptions.add(Messages.getMessage(Messages.Name.FIRST_IN_CHECKLIST_REGION));
                        continue block6;
                    }
                    case MOST_RECENT_IN_LOCATION: {
                        if (selectedLocations.size() == 1) {
                            includeSightingTextOptions.add(Messages.getFormattedMessage(Messages.Name.MOST_RECENT_IN_FORMAT, selectedLocations.get(0).getDisplayName()));
                            continue block6;
                        }
                        includeSightingTextOptions.add(Messages.getMessage(Messages.Name.MOST_RECENT_IN_CHECKLIST_REGION));
                        continue block6;
                    }
                    case FIRST_IN_WORLD: {
                        includeSightingTextOptions.add(Messages.getMessage(Messages.Name.LIFER_SIGHTING));
                        continue block6;
                    }
                    case MOST_RECENT_IN_WORLD: {
                        includeSightingTextOptions.add(Messages.getMessage(Messages.Name.MOST_RECENT_ANYWHERE));
                        continue block6;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown option: " + checklistSightingOption));
                    }
                }
            }
            this.checklistSightingOptionCombobox = new JComboBox<Object>(includeSightingTextOptions.toArray());
            this.checklistSightingOptionCombobox.setSelectedIndex(Arrays.asList(ChecklistXlsOutput.ChecklistSightingOption.values()).indexOf((Object)ChecklistXlsDialog.this.checklistSpreadsheetPreferences.checklistSightingOption));
            checklistSightingOptionsLabel.setEnabled(this.includeSighting.isSelected());
            this.checklistSightingOptionCombobox.setEnabled(this.includeSighting.isSelected());
            this.includeSighting.addActionListener(e -> {
                checklistSightingOptionsLabel.setEnabled(this.includeSighting.isSelected());
                this.checklistSightingOptionCombobox.setEnabled(this.includeSighting.isSelected());
            });
            NumberFormatter numberFormatter = new NumberFormatter();
            numberFormatter.setValueClass(Integer.class);
            numberFormatter.setMinimum(Integer.valueOf(0));
            numberFormatter.setMaximum(Integer.valueOf(60));
            this.daysToInclude = new AutoSelectJFormattedTextField(numberFormatter);
            this.daysToInclude.setColumns(3);
            this.daysToInclude.setValue(ChecklistXlsDialog.this.checklistSpreadsheetPreferences.daysToPrint);
            JLabel daysToIncludeLabel = new JLabel(Messages.getMessage(Messages.Name.NUMBERS_OF_COLUMNS_FOR_RECORDS));
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.includeScientific).addComponent(this.showFamilies).addComponent(this.showLifersInBold).addComponent(this.showNewForColumn).addComponent(this.showStatus).addComponent(this.showAllTaxonomies).addComponent(this.includeSighting).addComponent(checklistSightingOptionsLabel).addComponent(this.checklistSightingOptionCombobox).addComponent(daysToIncludeLabel).addComponent(this.daysToInclude, -2, -2, -2));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.includeScientific).addComponent(this.showFamilies).addComponent(this.showLifersInBold).addComponent(this.showNewForColumn).addComponent(this.showStatus).addComponent(this.showAllTaxonomies).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.includeSighting).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(checklistSightingOptionsLabel).addComponent(this.checklistSightingOptionCombobox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(daysToIncludeLabel).addComponent(this.daysToInclude));
        }

        SpreadsheetConfiguration toConfiguration() {
            SpreadsheetConfiguration config = new SpreadsheetConfiguration();
            config.includeScientific = this.includeScientific.isSelected();
            config.showLifersInBold = this.showLifersInBold.isSelected();
            config.showNewForColumn = this.showNewForColumn.isSelected();
            config.showFamilies = this.showFamilies.isSelected();
            config.showStatus = this.showStatus.isSelected();
            config.showAllTaxonomies = this.showAllTaxonomies.isSelected();
            config.includeSighting = this.includeSighting.isSelected();
            config.checklistSightingOption = ChecklistXlsOutput.ChecklistSightingOption.values()[this.checklistSightingOptionCombobox.getSelectedIndex()];
            config.daysToInclude = (Integer)this.daysToInclude.getValue();
            return config;
        }
    }

    class SpreadsheetConfiguration {
        boolean includeScientific;
        boolean includeSighting;
        boolean showLifersInBold;
        boolean showNewForColumn;
        boolean showStatus;
        boolean showFamilies;
        int daysToInclude;
        boolean showAllTaxonomies;
        ChecklistXlsOutput.ChecklistSightingOption checklistSightingOption;

        SpreadsheetConfiguration() {
        }
    }
}

