/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.google.common.collect.TreeMultimap;
import com.scythebill.birdlist.model.checklist.ChecklistResolution;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.ResolvedComparator;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.Dimension;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class ChecklistResolutionResults {
    private ChecklistResolutionResults() {
    }

    public static JComponent asPanel(ChecklistResolution checklistResolution, Taxonomy taxonomy, FontManager fontManager) {
        ResolvedComparator resolvedComparator = new ResolvedComparator();
        TreeMultimap<SightingTaxon.Resolved, SightingTaxon.Resolved> resolutions = TreeMultimap.create(resolvedComparator, resolvedComparator);
        checklistResolution.taxaMappings().forEach((k, v) -> resolutions.put((Object)k.resolve(taxonomy), (Object)v.resolve(taxonomy)));
        StringBuilder resultsString = new StringBuilder("<ul>");
        LinkedHashSet<String> encounteredGenera = new LinkedHashSet<String>();
        for (SightingTaxon.Resolved from : resolutions.keySet()) {
            SortedSet toSet = resolutions.get((Object)from);
            if (toSet.size() == 1 && toSet.contains(from)) continue;
            String fromString = ChecklistResolutionResults.speciesAsString(from, encounteredGenera);
            String toString = Messages.join(resolutions.get((Object)from), r -> ChecklistResolutionResults.speciesAsString(r, encounteredGenera));
            resultsString.append("<li>");
            resultsString.append(Messages.getFormattedMessage(Messages.Name.WILL_BECOME_FORMAT, fromString, toString));
        }
        JEditorPane resultsText = new JEditorPane("text/html", resultsString.toString());
        JScrollPane scrollPane = new JScrollPane(resultsText);
        resultsText.setEditable(false);
        resultsText.putClientProperty("JEditorPane.honorDisplayProperties", true);
        resultsText.setCaretPosition(0);
        scrollPane.setPreferredSize(fontManager.scale(new Dimension(540, 300)));
        scrollPane.setAlignmentX(0.0f);
        Box panel = Box.createVerticalBox();
        panel.add(Box.createVerticalStrut(15));
        panel.add(scrollPane);
        return panel;
    }

    private static String speciesAsString(SightingTaxon.Resolved species, Set<String> encounteredGenera) {
        Object sci = species.getFullName();
        String currentGenus = ((String)sci).substring(0, ((String)sci).indexOf(32));
        if (!encounteredGenera.add(currentGenus)) {
            sci = currentGenus.charAt(0) + ". " + ((String)sci).substring(((String)sci).indexOf(32) + 1);
        }
        return String.format("<b>%s</b> (<i>%s</i>)", species.getCommonName(), sci);
    }
}

