/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels.location;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.ui.components.AutoSelectJFormattedTextField;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.location.ChecklistPrintPreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.Nullable;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;

class ChecklistPrintDialog {
    private Alerts alerts;
    private ChecklistPrintPreferences reportPrintPreferences;
    private FontManager fontManager;
    private NamesPreferences namesPreferences;
    public JLabel daysToIncludeLabel;

    @Inject
    ChecklistPrintDialog(Alerts alerts, ChecklistPrintPreferences reportPrintPreferences, NamesPreferences namesPreferences, FontManager fontManager) {
        this.alerts = alerts;
        this.reportPrintPreferences = reportPrintPreferences;
        this.namesPreferences = namesPreferences;
        this.fontManager = fontManager;
    }

    @Nullable
    public ChecklistPrintPreferences getConfiguration(Component parent) {
        PrintConfigurationPanel panel = new PrintConfigurationPanel();
        this.fontManager.applyTo(panel);
        String formattedMessage = this.alerts.getFormattedDialogMessage(Messages.Name.PRINT_OPTIONS_TITLE, Messages.Name.PRINT_OPTIONS_MESSAGE, new Object[0]);
        int okCancel = this.alerts.showOkCancelWithPanel(SwingUtilities.getWindowAncestor(parent), formattedMessage, panel);
        if (okCancel != 0) {
            return null;
        }
        panel.updatePreferences();
        return this.reportPrintPreferences;
    }

    public NamesPreferences.ScientificOrCommon getScientificOrCommonFromConfiguration(ChecklistPrintPreferences prefs) {
        NamesPreferences.ScientificOrCommon scientificOrCommon = this.namesPreferences.scientificOrCommon;
        if (prefs.includeScientific) {
            if (scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_ONLY) {
                return NamesPreferences.ScientificOrCommon.COMMON_FIRST;
            }
        } else {
            switch (scientificOrCommon) {
                case SCIENTIFIC_ONLY: 
                case COMMON_FIRST: 
                case SCIENTIFIC_FIRST: {
                    return NamesPreferences.ScientificOrCommon.COMMON_ONLY;
                }
            }
        }
        return scientificOrCommon;
    }

    class PrintConfigurationPanel
    extends JPanel {
        private JCheckBox includeScientific;
        private JCheckBox showFamilies;
        private JCheckBox showStatus;
        private JCheckBox showLifersInBold;
        private JCheckBox compactPrinting;
        private AutoSelectJFormattedTextField daysToInclude;

        PrintConfigurationPanel() {
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            this.includeScientific = new JCheckBox(Messages.getMessage(Messages.Name.SCIENTIFIC_NAME_QUESTION));
            this.includeScientific.setSelected(ChecklistPrintDialog.this.reportPrintPreferences.includeScientific);
            if (ChecklistPrintDialog.this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_ONLY) {
                this.includeScientific.setSelected(false);
            } else if (ChecklistPrintDialog.this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.SCIENTIFIC_ONLY) {
                this.includeScientific.setSelected(true);
            }
            this.showFamilies = new JCheckBox(Messages.getMessage(Messages.Name.SHOW_FAMILIES_QUESTION));
            this.showFamilies.setSelected(ChecklistPrintDialog.this.reportPrintPreferences.showFamilies);
            this.showStatus = new JCheckBox(Messages.getMessage(Messages.Name.SHOW_THREATENED_STATUS_QUESTION));
            this.showStatus.setSelected(ChecklistPrintDialog.this.reportPrintPreferences.showStatus);
            this.showLifersInBold = new JCheckBox(Messages.getMessage(Messages.Name.LIFERS_IN_BOLD_QUESTION));
            this.showLifersInBold.setSelected(ChecklistPrintDialog.this.reportPrintPreferences.showLifersInBold);
            this.compactPrinting = new JCheckBox(Messages.getMessage(Messages.Name.COMPACT_PRINT_QUESTION));
            this.compactPrinting.setSelected(ChecklistPrintDialog.this.reportPrintPreferences.compactPrinting);
            NumberFormatter numberFormatter = new NumberFormatter();
            numberFormatter.setValueClass(Integer.class);
            numberFormatter.setMinimum(Integer.valueOf(0));
            numberFormatter.setMaximum(Integer.valueOf(60));
            this.daysToInclude = new AutoSelectJFormattedTextField(numberFormatter);
            this.daysToInclude.setColumns(3);
            this.daysToInclude.setValue(ChecklistPrintDialog.this.reportPrintPreferences.daysToPrint);
            ChecklistPrintDialog.this.daysToIncludeLabel = new JLabel(Messages.getMessage(Messages.Name.NUMBERS_OF_COLUMNS_FOR_RECORDS));
            ChecklistPrintDialog.this.daysToIncludeLabel.setEnabled(!this.compactPrinting.isSelected());
            this.daysToInclude.setEnabled(!this.compactPrinting.isSelected());
            this.compactPrinting.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChecklistPrintDialog.this.daysToIncludeLabel.setEnabled(!PrintConfigurationPanel.this.compactPrinting.isSelected());
                    PrintConfigurationPanel.this.daysToInclude.setEnabled(!PrintConfigurationPanel.this.compactPrinting.isSelected());
                }
            });
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.includeScientific).addComponent(this.showFamilies).addComponent(this.showStatus).addComponent(this.showLifersInBold).addComponent(this.compactPrinting).addComponent(ChecklistPrintDialog.this.daysToIncludeLabel).addComponent(this.daysToInclude, -2, -2, -2));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.includeScientific).addComponent(this.showFamilies).addComponent(this.showStatus).addComponent(this.showLifersInBold).addComponent(this.compactPrinting).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(ChecklistPrintDialog.this.daysToIncludeLabel).addComponent(this.daysToInclude));
        }

        void updatePreferences() {
            ChecklistPrintDialog.this.reportPrintPreferences.includeScientific = this.includeScientific.isSelected();
            ChecklistPrintDialog.this.reportPrintPreferences.showFamilies = this.showFamilies.isSelected();
            ChecklistPrintDialog.this.reportPrintPreferences.showStatus = this.showStatus.isSelected();
            ChecklistPrintDialog.this.reportPrintPreferences.showLifersInBold = this.showLifersInBold.isSelected();
            ChecklistPrintDialog.this.reportPrintPreferences.compactPrinting = this.compactPrinting.isSelected();
            ChecklistPrintDialog.this.reportPrintPreferences.daysToPrint = (Integer)this.daysToInclude.getValue();
        }
    }
}

