/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.WizardContentPanel;
import com.scythebill.birdlist.ui.util.VisibilityDetector;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public abstract class WizardPanelBase<T>
extends JPanel
implements Titled,
FontManager.FontsUpdatedListener {
    private JButton nextButton;
    private JButton backButton;
    private JButton cancelButton;
    private JButton doneButton;
    private AbstractAction cancelAction;
    private AbstractAction backAction;
    private AbstractAction nextAction;
    private AbstractAction saveAction;
    private JPanel wizardContent;
    private CardLayout wizardContentLayout;
    private List<WizardContentPanel<T>> pages = Lists.newArrayList();
    private Set<String> pageNames = Sets.newHashSet();
    private int currentIndex = -1;
    private JSeparator separator;
    private final NavigableFrame navigableFrame;
    private final VisibilityDetector visibilityDetector;

    public WizardPanelBase(NavigableFrame navigableFrame, VisibilityDetector visibilityDetector) {
        this.visibilityDetector = visibilityDetector;
        this.initGUI();
        this.navigableFrame = navigableFrame;
    }

    protected abstract T wizardValue();

    private void initGUI() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getActionMap().put("cancel", this.getCancelAction());
        this.nextButton = new JButton();
        this.nextButton.setText(Messages.getMessage(Messages.Name.NEXT_WITH_RIGHT_ARROW));
        this.nextButton.setAction(this.getNextAction());
        this.nextButton.putClientProperty("birdlist.buttonSize", (Object)FontManager.ButtonSize.MEDIUM);
        this.backButton = new JButton();
        this.backButton.setText(Messages.getMessage(Messages.Name.BACK_WITH_LEFT_ARROW));
        this.backButton.setAction(this.getBackAction());
        this.backButton.putClientProperty("birdlist.buttonSize", (Object)FontManager.ButtonSize.MEDIUM);
        this.cancelButton = new JButton();
        this.cancelButton.setText(Messages.getMessage(Messages.Name.CANCEL_BUTTON));
        this.cancelButton.setAction(this.getCancelAction());
        this.cancelButton.putClientProperty("birdlist.buttonSize", (Object)FontManager.ButtonSize.MEDIUM);
        this.doneButton = new JButton();
        this.doneButton.setText(Messages.getMessage(Messages.Name.DONE_BUTTON));
        this.doneButton.setAction(this.getSaveAction());
        this.doneButton.putClientProperty("birdlist.buttonSize", (Object)FontManager.ButtonSize.MEDIUM);
        this.visibilityDetector.install(this.doneButton);
        this.separator = new JSeparator();
        this.wizardContent = new JPanel();
        this.wizardContentLayout = new CardLayout();
        this.wizardContent.setLayout(this.wizardContentLayout);
    }

    private AbstractAction getCancelAction() {
        if (this.cancelAction == null) {
            this.cancelAction = new AbstractAction(Messages.getMessage(Messages.Name.CANCEL_BUTTON), null){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WizardContentPanel oldPage = WizardPanelBase.this.getCurrentPage();
                    if (oldPage != null) {
                        oldPage.leaving(false);
                    }
                    WizardPanelBase.this.navigableFrame.complete(evt);
                }
            };
        }
        return this.cancelAction;
    }

    private AbstractAction getBackAction() {
        if (this.backAction == null) {
            this.backAction = new AbstractAction(Messages.getMessage(Messages.Name.BACK_WITH_LEFT_ARROW), null){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WizardPanelBase.this.showPage(WizardPanelBase.this.getPreviousIndex());
                }
            };
        }
        return this.backAction;
    }

    private AbstractAction getNextAction() {
        if (this.nextAction == null) {
            this.nextAction = new AbstractAction(Messages.getMessage(Messages.Name.NEXT_WITH_RIGHT_ARROW), null){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WizardPanelBase.this.showPage(WizardPanelBase.this.getNextIndex());
                }
            };
        }
        return this.nextAction;
    }

    private AbstractAction getSaveAction() {
        if (this.saveAction == null) {
            this.saveAction = new AbstractAction(Messages.getMessage(Messages.Name.DONE_BUTTON), null){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WizardContentPanel oldPage = WizardPanelBase.this.getCurrentPage();
                    if (oldPage != null && !oldPage.leaving(true)) {
                        return;
                    }
                    if (WizardPanelBase.this.save()) {
                        WizardPanelBase.this.navigableFrame.complete(evt);
                    }
                }
            };
        }
        return this.saveAction;
    }

    protected abstract boolean save();

    protected void addPage(final WizardContentPanel<T> panel) {
        Preconditions.checkNotNull(panel);
        String name = panel.getName();
        Preconditions.checkNotNull(name);
        Preconditions.checkArgument(!this.pageNames.contains(name), "Name " + name + " is already in this wizard.");
        this.pages.add(panel);
        this.pageNames.add(name);
        this.wizardContent.add(panel, name);
        panel.addPropertyChangeListener("complete", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (panel.getName().equals(WizardPanelBase.this.getCurrentName())) {
                    WizardPanelBase.this.updateButtons((Boolean)evt.getNewValue());
                }
            }
        });
        if (this.pages.size() == 1) {
            this.showPage(0);
        }
    }

    public void showPage(int index) {
        Preconditions.checkArgument(index >= 0, "Trying to navigate past the start of the wizard");
        Preconditions.checkArgument(index < this.pages.size(), "Trying to navigate past the end of the wizard");
        WizardContentPanel<T> oldPage = this.getCurrentPage();
        if (oldPage != null) {
            if (index > this.currentIndex) {
                if (!oldPage.leaving(true)) {
                    return;
                }
            } else {
                oldPage.leaving(false);
            }
        }
        WizardContentPanel<T> newPage = this.pages.get(index);
        newPage.beforeShown();
        this.wizardContentLayout.show(this.wizardContent, newPage.getName());
        this.currentIndex = index;
        this.updateButtons(newPage.isComplete());
        this.navigableFrame.updateTitle();
        SwingUtilities.invokeLater(newPage::shown);
    }

    @Override
    public String getTitle() {
        Object title = this.getWizardTitle();
        WizardContentPanel<T> page = this.pages.get(this.getCurrentIndex());
        if (page instanceof Titled) {
            title = (String)title + " - " + ((Titled)((Object)page)).getTitle();
        }
        return title;
    }

    protected abstract String getWizardTitle();

    private void updateButtons(boolean complete) {
        boolean isLastPage = this.getCurrentIndex() == this.pages.size() - 1;
        this.saveAction.setEnabled(complete && isLastPage);
        this.nextAction.setEnabled(complete && !isLastPage);
        this.backAction.setEnabled(this.getCurrentIndex() != 0);
    }

    protected final int getCurrentIndex() {
        return this.currentIndex;
    }

    protected int getPreviousIndex() {
        return this.getCurrentIndex() - 1;
    }

    protected int getNextIndex() {
        return this.getCurrentIndex() + 1;
    }

    protected final WizardContentPanel<T> getCurrentPage() {
        if (this.getCurrentIndex() < 0 || this.getCurrentIndex() > this.pages.size()) {
            return null;
        }
        return this.pages.get(this.getCurrentIndex());
    }

    protected final String getCurrentName() {
        WizardContentPanel<T> panel = this.getCurrentPage();
        return panel == null ? null : panel.getName();
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout thisLayout = new GroupLayout(this);
        fontManager.applyTo(this.backButton);
        fontManager.applyTo(this.cancelButton);
        fontManager.applyTo(this.nextButton);
        fontManager.applyTo(this.doneButton);
        this.setLayout(thisLayout);
        GroupLayout.ParallelGroup verticalButtonGroup = thisLayout.createBaselineGroup(false, false).addComponent(this.nextButton).addComponent(this.backButton).addComponent(this.cancelButton).addComponent(this.doneButton);
        this.addExtraContentAfterDone(verticalButtonGroup);
        thisLayout.setVerticalGroup(thisLayout.createSequentialGroup().addContainerGap().addComponent(this.wizardContent, fontManager.scale(400), fontManager.scale(400), Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, -2, -2).addGap(fontManager.scale(18)).addGroup(verticalButtonGroup).addContainerGap());
        GroupLayout.SequentialGroup horizontalButtonGroup = thisLayout.createSequentialGroup().addComponent(this.cancelButton).addGap(fontManager.scale(86)).addComponent(this.backButton).addGap(fontManager.scale(20)).addComponent(this.nextButton).addGap(0, fontManager.scale(75), Short.MAX_VALUE).addComponent(this.doneButton);
        this.addExtraContentAfterDone(horizontalButtonGroup);
        thisLayout.setHorizontalGroup(thisLayout.createSequentialGroup().addContainerGap().addGroup(thisLayout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, horizontalButtonGroup).addComponent(this.wizardContent, GroupLayout.Alignment.LEADING, 0, fontManager.scale(600), Short.MAX_VALUE).addComponent(this.separator, GroupLayout.Alignment.LEADING, 0, fontManager.scale(600), Short.MAX_VALUE)).addContainerGap());
        thisLayout.linkSize(0, this.cancelButton, this.backButton, this.nextButton, this.doneButton);
    }

    protected void addExtraContentAfterDone(GroupLayout.SequentialGroup horizontalButtonGroup) {
    }

    protected void addExtraContentAfterDone(GroupLayout.ParallelGroup verticalButtonGroup) {
    }

    public Component getFocusableComponentAfterContent() {
        return this.cancelButton;
    }

    protected int getPageCount() {
        return this.pages.size();
    }
}

