/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Preconditions;
import com.scythebill.birdlist.ui.panels.WizardPanelBase;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;

public abstract class WizardContentPanel<T>
extends JPanel {
    private final String name;
    private boolean complete;
    private Class<T> type;

    public WizardContentPanel(String name, Class<T> type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isComplete() {
        return this.complete;
    }

    protected T wizardValue() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof WizardPanelBase)) continue;
            WizardPanelBase wizard = (WizardPanelBase)parent;
            return this.type.cast(wizard.wizardValue());
        }
        throw new IllegalStateException("No parent found");
    }

    protected Component getFocusableComponentAfterContent() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof WizardPanelBase)) continue;
            WizardPanelBase wizard = (WizardPanelBase)parent;
            return wizard.getFocusableComponentAfterContent();
        }
        throw new IllegalStateException("No parent found");
    }

    public void setComplete(boolean complete) {
        if (complete != this.complete) {
            this.complete = complete;
            this.firePropertyChange("complete", !complete, complete);
        }
    }

    protected void shown() {
    }

    protected boolean leaving(boolean validateLeaving) {
        Preconditions.checkState(!validateLeaving || this.isComplete(), "Panel is not complete");
        return true;
    }

    protected void beforeShown() {
    }

    protected boolean isActive() {
        return false;
    }
}

