/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.prefs.PreferencesManager;
import com.scythebill.birdlist.ui.uptodate.UpToDateLoader;
import com.scythebill.birdlist.ui.uptodate.UpToDatePreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VersionUpgradeNotice {
    private final FontManager fontManager;
    private final Alerts alerts;
    private final PreferencesManager preferencesManager;

    @Inject
    public VersionUpgradeNotice(Alerts alerts, PreferencesManager preferencesManager, FontManager fontManager) {
        this.alerts = alerts;
        this.preferencesManager = preferencesManager;
        this.fontManager = fontManager;
    }

    public void showUpgrade(ImmutableList<UpToDateLoader.VersionInfo> versionInfoList) {
        Preconditions.checkArgument(!versionInfoList.isEmpty());
        UpToDateLoader.VersionInfo newestVersion = (UpToDateLoader.VersionInfo)versionInfoList.get(0);
        UpToDatePreferences upToDate = this.preferencesManager.getPreference(UpToDatePreferences.class);
        if (Objects.equals(newestVersion.version, upToDate.notifiedVersion)) {
            return;
        }
        String formattedMessage = versionInfoList.size() == 1 ? this.alerts.getFormattedDialogMessage(Messages.Name.NEW_VERSION_IS_AVAILABLE, Messages.Name.NEW_VERSION_MESSAGE_ONE_VERSION, newestVersion.version) : this.alerts.getFormattedDialogMessage(Messages.Name.NEW_VERSION_IS_AVAILABLE, Messages.Name.NEW_VERSION_MESSAGE_MULTIPLE_VERSIONS, newestVersion.version);
        ArrayList<String> changes = new ArrayList<String>();
        for (UpToDateLoader.VersionInfo versionInfo : versionInfoList) {
            changes.addAll(Collections2.filter(versionInfo.changes, Predicates.notNull()));
        }
        JTextArea textArea = new JTextArea();
        JLabel label = new JLabel(formattedMessage);
        textArea.setText(Joiner.on('\n').join(changes));
        textArea.setRows(Math.min(5, changes.size()));
        textArea.setEditable(false);
        textArea.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(textArea);
        ArrayList<JComponent> components = Lists.newArrayList(label, scrollPane);
        for (JComponent component : components) {
            this.fontManager.applyTo(component);
        }
        Object[] options = new String[]{Messages.getMessage(Messages.Name.SKIP_THIS_VERSION), Messages.getMessage(Messages.Name.ASK_ME_LATER), Messages.getMessage(Messages.Name.DOWNLOAD_NOW)};
        int result = JOptionPane.showOptionDialog(null, components.toArray(), "", -1, 3, this.alerts.getAlertIcon(), options, options[2]);
        if (result == 2) {
            this.alerts.showMessage(null, Messages.Name.PLEASE_QUIT_TITLE, Messages.Name.PLEASE_QUIT_MESSAGE, new Object[0]);
            URI uri = MoreObjects.firstNonNull(newestVersion.url, URI.create("http://downloads.scythebill.com"));
            DesktopUtils.openUrlInBrowser(uri, this.alerts);
        } else if (result == 0) {
            upToDate.notifiedVersion = newestVersion.version;
        }
    }
}

