/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.UserSet;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.fonts.FontPreferences;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.UserDialog;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.ListListModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class UserSetPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private final ReportSet reportSet;
    private final Alerts alerts;
    private final UserDialog userDialog;
    private JList<User> userList;
    private JScrollPane scrollPane;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private UserSet userSet;

    public static void main(String[] args) {
        JFrame frame = new JFrame("UserSetPanel test");
        FontManager fontManager = new FontManager(new FontPreferences());
        UserSetPanel userSetPanel = new UserSetPanel(null, new Alerts(null), new UserDialog(fontManager));
        UserSet userSet = new UserSet();
        userSet.addUser(userSet.newUserBuilder().setName("Adam Winer").setAbbreviation("AW"));
        userSet.addUser(userSet.newUserBuilder().setName("Howard Winer").setAbbreviation("HW"));
        userSetPanel.setUserSet(userSet);
        userSetPanel.fontsUpdated(fontManager);
        frame.setContentPane(userSetPanel);
        frame.pack();
        frame.setVisible(true);
    }

    @Inject
    UserSetPanel(ReportSet reportSet, Alerts alerts, UserDialog userDialog) {
        this.reportSet = reportSet;
        this.alerts = alerts;
        this.userDialog = userDialog;
        this.initComponents();
        this.setUserSet(new UserSet());
    }

    private void initComponents() {
        this.userList = new JList();
        this.userList.setSelectionMode(0);
        this.userList.setModel(new ListListModel());
        this.userList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                User user = (User)value;
                value = user.name() != null ? (user.abbreviation() != null ? String.format("%s (%s)", user.name(), user.abbreviation()) : user.name()) : user.abbreviation();
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.userList.addListSelectionListener(e -> {
            boolean selectionIsEmpty = this.userList.getSelectedIndex() < 0;
            this.editButton.setEnabled(!selectionIsEmpty);
            this.deleteButton.setEnabled(!selectionIsEmpty);
        });
        this.scrollPane = new JScrollPane(this.userList, 20, 31);
        this.addButton = new JButton(Messages.getMessage(Messages.Name.ADD_WITH_ELLIPSIS));
        this.addButton.addActionListener(this::addUser);
        this.editButton = new JButton(Messages.getMessage(Messages.Name.EDIT_WITH_ELLIPSIS));
        this.editButton.addActionListener(this::editUser);
        this.editButton.setEnabled(false);
        this.deleteButton = new JButton(Messages.getMessage(Messages.Name.DELETE_WITH_ELLIPSIS));
        this.deleteButton.addActionListener(this::deleteUser);
        this.deleteButton.setEnabled(false);
    }

    public void setUserSet(UserSet userSet) {
        this.userSet = userSet;
        List<User> list = this.userList();
        list.clear();
        list.addAll(userSet.allUsers());
        Collections.sort(list, User.comparator());
    }

    private List<User> userList() {
        return ((ListListModel)this.userList.getModel()).asList();
    }

    private void addUser(ActionEvent e) {
        this.userDialog.showUserDialog(this, Messages.getMessage(Messages.Name.ADD_OBSERVER), this.userSet, null, builder -> {
            User newUser = this.userSet.addUser(builder);
            this.insertUser(newUser);
        });
    }

    private void insertUser(User user) {
        List<User> list = this.userList();
        int index = Collections.binarySearch(list, user, User.comparator());
        if (index < 0) {
            index = -index - 1;
        }
        list.add(index, user);
    }

    private void editUser(ActionEvent e) {
        User user = this.userList.getSelectedValue();
        if (user != null) {
            int index = this.userList.getSelectedIndex();
            this.userDialog.showUserDialog(this, Messages.getMessage(Messages.Name.EDIT_OBSERVER), this.userSet, user, builder -> {
                User updatedUser = this.userSet.addUser(builder);
                this.userList().remove(index);
                this.insertUser(updatedUser);
            });
        }
    }

    private void deleteUser(ActionEvent e) {
        final User user = this.userList.getSelectedValue();
        if (user != null) {
            String userName;
            boolean anySightingsWithUser = false;
            boolean anySightingsWithOnlyThatUser = false;
            ImmutableSet<User> onlyThatUser = ImmutableSet.of(user);
            for (Sighting sighting : this.reportSet.getSightings()) {
                if (!sighting.hasSightingInfo()) continue;
                ImmutableSet<User> users = sighting.getSightingInfo().getUsers();
                if (!anySightingsWithUser && users.contains(user)) {
                    anySightingsWithUser = true;
                }
                if (!users.equals(onlyThatUser)) continue;
                anySightingsWithOnlyThatUser = true;
                break;
            }
            boolean removeSightingsWithOnlyThatUser = false;
            String string = userName = user.name() != null ? user.name() : user.abbreviation();
            if (anySightingsWithOnlyThatUser) {
                int option = this.alerts.showWithOptions((Object)this, Messages.getMessage(Messages.Name.DELETE_OBSERVER_TITLE), Messages.getFormattedMessage(Messages.Name.DELETE_OBSERVER_AND_MAYBE_SIGHTINGS_MESSAGE, userName), Messages.getMessage(Messages.Name.DROP_SIGHTINGS), Messages.getMessage(Messages.Name.LEAVE_EMPTY), Messages.getMessage(Messages.Name.CANCEL_BUTTON));
                if (option < 0 || option >= 2) {
                    return;
                }
                removeSightingsWithOnlyThatUser = option == 0;
            } else if (anySightingsWithUser && this.alerts.showOkCancel((Object)this, Messages.Name.DELETE_OBSERVER_TITLE, Messages.Name.DELETE_OBSERVER_MESSAGE, userName) != 0) {
                return;
            }
            int index = this.userList.getSelectedIndex();
            this.userList().remove(index);
            this.userSet.removeUser(user);
            if (anySightingsWithUser) {
                LoadingCache<ImmutableSet<User>, ImmutableSet<User>> removedUserCache = CacheBuilder.newBuilder().build(new CacheLoader<ImmutableSet<User>, ImmutableSet<User>>(){

                    @Override
                    public ImmutableSet<User> load(ImmutableSet<User> set) throws Exception {
                        return set.stream().filter(existing -> !existing.equals(user)).collect(ImmutableSet.toImmutableSet());
                    }
                });
                ArrayList<Sighting> sightingsToRemove = new ArrayList<Sighting>();
                for (Sighting sighting : this.reportSet.getSightings()) {
                    if (!sighting.hasSightingInfo()) continue;
                    ImmutableSet<User> users = sighting.getSightingInfo().getUsers();
                    if (removeSightingsWithOnlyThatUser && users.equals(onlyThatUser)) {
                        sightingsToRemove.add(sighting);
                        continue;
                    }
                    if (!users.contains(user)) continue;
                    sighting.getSightingInfo().setUsers((Collection<User>)removedUserCache.getUnchecked(users));
                }
                if (!sightingsToRemove.isEmpty()) {
                    this.reportSet.mutator().removing(sightingsToRemove).mutate();
                }
            }
        }
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent(this.scrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.addButton, -2, -2, -2).addComponent(this.editButton, -2, -2, -2).addComponent(this.deleteButton, -2, -2, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.scrollPane).addGroup(groupLayout.createSequentialGroup().addComponent(this.addButton, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton, -2, -2, -2)));
        groupLayout.linkSize(this.addButton, this.editButton, this.deleteButton);
        this.setLayout(groupLayout);
    }
}

