/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.UserSet;
import com.scythebill.birdlist.ui.components.ErrorLabel;
import com.scythebill.birdlist.ui.components.OkCancelPanel;
import com.scythebill.birdlist.ui.components.PossiblyRequiredLabel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.fonts.FontPreferences;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class UserDialog {
    private final FontManager fontManager;

    public static void main(String[] args) {
        UserSet userSet = new UserSet();
        User aw = userSet.addUser(userSet.newUserBuilder().setName("Adam Winer").setAbbreviation("AW"));
        userSet.addUser(userSet.newUserBuilder().setName("Howard Winer").setAbbreviation("HW"));
        UserDialog userDialog = new UserDialog(new FontManager(new FontPreferences()));
        userDialog.showUserDialog(null, "Test Title", userSet, aw, u -> System.err.println(userSet.addUser(u)));
    }

    @Inject
    UserDialog(FontManager fontManager) {
        this.fontManager = fontManager;
    }

    public void showUserDialog(Component parent, String title, UserSet userSet, @Nullable User user, final ResultsListener listener) {
        Dialog.ModalityType modality = Toolkit.getDefaultToolkit().isModalityTypeSupported(Dialog.ModalityType.DOCUMENT_MODAL) ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.APPLICATION_MODAL;
        final JDialog dialog = new JDialog(parent == null ? null : SwingUtilities.getWindowAncestor(parent), title, modality);
        final UserPanel userPanel = new UserPanel(userSet, user);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        };
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                User.Builder value = userPanel.getValue();
                if (value != null) {
                    listener.userAvailable(value);
                    dialog.dispose();
                }
            }
        };
        userPanel.addPropertyChangeListener("value", e -> okAction.setEnabled(e.getNewValue() != null));
        okAction.setEnabled(userPanel.getValue() != null);
        OkCancelPanel okCancel = new OkCancelPanel(okAction, cancelAction, userPanel, userPanel.nameField);
        okCancel.setPreferredSize(this.fontManager.scale(new Dimension(450, 200)));
        dialog.setContentPane(okCancel);
        this.fontManager.applyTo(okCancel);
        dialog.pack();
        dialog.setVisible(true);
    }

    public static interface ResultsListener {
        public void userAvailable(User.Builder var1);
    }

    class UserPanel
    extends JPanel
    implements FontManager.FontsUpdatedListener {
        private final UserSet userSet;
        private final User user;
        private User.Builder value;
        private PossiblyRequiredLabel nameLabel;
        private JTextField nameField;
        private PossiblyRequiredLabel abbreviationLabel;
        private JTextField abbreviationField;
        private ErrorLabel errors;
        private boolean editedAbbreviation;

        UserPanel(@Nullable UserSet userSet, User user) {
            this.userSet = userSet;
            this.user = user;
            User.Builder builder = this.value = user == null ? null : user.asBuilder();
            this.editedAbbreviation = user == null ? false : !Strings.isNullOrEmpty(user.abbreviation());
            this.initComponents();
        }

        public User.Builder getValue() {
            return this.value;
        }

        private void initComponents() {
            DocumentListener recomputeValue = new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    UserPanel.this.recomputeValue();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    UserPanel.this.recomputeValue();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    UserPanel.this.recomputeValue();
                }
            };
            this.nameLabel = new PossiblyRequiredLabel(Messages.getMessage(Messages.Name.NAME_LABEL));
            this.nameLabel.setRequired(true);
            this.nameField = new JTextField(20);
            if (this.value != null) {
                this.nameField.setText(Strings.nullToEmpty(this.value.name()));
            }
            this.nameField.getDocument().addDocumentListener(recomputeValue);
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    if (!UserPanel.this.editedAbbreviation) {
                        UserPanel.this.recomputeAbbreviation();
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    if (!UserPanel.this.editedAbbreviation) {
                        UserPanel.this.recomputeAbbreviation();
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    if (!UserPanel.this.editedAbbreviation) {
                        UserPanel.this.recomputeAbbreviation();
                    }
                }
            });
            this.abbreviationLabel = new PossiblyRequiredLabel(Messages.getMessage(Messages.Name.ABBREVIATION_LABEL));
            this.abbreviationLabel.setRequired(true);
            this.abbreviationField = new JTextField(10);
            if (this.value != null) {
                this.abbreviationField.setText(Strings.nullToEmpty(this.value.abbreviation()));
            }
            this.abbreviationField.getDocument().addDocumentListener(recomputeValue);
            this.abbreviationField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() != '\t') {
                        UserPanel.this.editedAbbreviation = true;
                    }
                }
            });
            this.errors = new ErrorLabel();
        }

        private void recomputeAbbreviation() {
            Optional<String> defaultAbbreviation = this.userSet.computeDefaultAbbreviation(this.nameField.getText(), Optional.ofNullable(this.user));
            defaultAbbreviation.ifPresent(this.abbreviationField::setText);
        }

        private boolean isAbbreviationAvailable(String abbreviation) {
            if (!this.userSet.hasUserWithAbbreviation(abbreviation)) {
                return true;
            }
            User userByAbbreviation = this.userSet.userByAbbreviation(abbreviation);
            return userByAbbreviation == this.user;
        }

        @Override
        public void fontsUpdated(FontManager fontManager) {
            GroupLayout groupLayout = new GroupLayout(this);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(fontManager.scale(10)).addComponent(this.errors)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.abbreviationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameField, -2, -2, -2).addComponent(this.abbreviationField, -2, -2, -2))));
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createBaselineGroup(false, false).addComponent(this.nameLabel).addComponent(this.nameField)).addGroup(groupLayout.createBaselineGroup(false, false).addComponent(this.abbreviationLabel).addComponent(this.abbreviationField)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.errors));
            this.setLayout(groupLayout);
        }

        private void recomputeValue() {
            User.Builder newValue = this.user == null ? this.userSet.newUserBuilder() : this.user.asBuilder();
            String name = this.nameField.getText();
            newValue.setName(name);
            String abbreviation = this.abbreviationField.getText();
            newValue.setAbbreviation(abbreviation);
            if (!abbreviation.isEmpty() && !this.isAbbreviationAvailable(abbreviation)) {
                this.errors.setText(Messages.getMessage(Messages.Name.ALREADY_AN_OBSERVER_WITH_THAT_ABBREVIATION));
            } else if (!abbreviation.isEmpty() && User.NOT_ELIGIBLE_ABBREVIATION_CHARS.matchesAnyOf(abbreviation)) {
                this.errors.setText(Messages.getMessage(Messages.Name.ILLEGAL_ABBREVIATION_CHARACTER));
            } else {
                this.errors.setText("");
            }
            if (!newValue.isValid(this.userSet)) {
                newValue = null;
            }
            if (!Objects.equal(this.value, newValue)) {
                User.Builder oldValue = this.value;
                this.value = newValue;
                this.firePropertyChange("value", oldValue, newValue);
            }
        }
    }
}

