/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.UserSet;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.components.ChipsTextPanel;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class UserChipsUi {
    public final JLabel userLabel = new JLabel(Messages.getMessage(Messages.Name.OBSERVERS_LABEL));
    public final IndexerPanel<User> userIndexer = new IndexerPanel();
    public final JButton addUserButton;
    public final ChipsTextPanel<User> userChips;
    public final JScrollPane userChipsScrollPane;

    public UserChipsUi(UserSet userSet, FontManager fontManager) {
        this.userIndexer.setColumns(15);
        this.userIndexer.setLayoutStrategy(IndexerPanel.LayoutStrategy.BELOW);
        Indexer<User> indexer = new Indexer<User>(4);
        for (User user : userSet.allUsers()) {
            if (user.name() != null) {
                indexer.add(user.name(), user);
                continue;
            }
            indexer.add(user.abbreviation(), user);
        }
        ToString<User> toString = new ToString<User>(){

            @Override
            public String getString(User user) {
                return user.name() != null ? user.name() : user.abbreviation();
            }
        };
        this.userIndexer.addIndexerGroup(toString, indexer);
        this.userIndexer.setPreviewText(Messages.Name.OBSERVER_NAME);
        this.addUserButton = new JButton(Messages.getMessage(Messages.Name.ADD_BUTTON));
        this.addUserButton.setEnabled(false);
        this.userIndexer.addPropertyChangeListener("value", e -> this.addUserButton.setEnabled(e.getNewValue() != null));
        this.userChips = new ChipsTextPanel<User>(toString::getString, User.comparator(), fontManager);
        this.userChips.setScaledWidth(270);
        this.userChipsScrollPane = new JScrollPane(this.userChips, 20, 31);
        ActionListener addUser = e -> {
            User user = this.userIndexer.getValue();
            if (user != null) {
                this.userChips.addChip(user);
            }
            this.userIndexer.clearValue();
        };
        this.userIndexer.addActionListener(addUser);
        this.addUserButton.addActionListener(addUser);
    }

    public void setEnabled(boolean enabled) {
        this.userLabel.setEnabled(enabled);
        this.userIndexer.setEnabled(enabled);
        this.addUserButton.setVisible(enabled);
        this.userChips.setEnabled(enabled);
    }
}

