/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public enum UIMode {
    AUTOMATIC(Messages.Name.UI_MODE_AUTOMATIC),
    LIGHT(Messages.Name.UI_MODE_LIGHT),
    DARK(Messages.Name.UI_MODE_DARK);

    private final Messages.Name name;
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGDWORD_TOKEN = "REG_DWORD";
    private static final String DARK_THEME_CMD = "reg query \"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize\" /v AppsUseLightTheme";

    private UIMode(Messages.Name name) {
        this.name = name;
    }

    public void apply() {
        UIMode.applyMode(this);
    }

    public String toString() {
        return Messages.getMessage(this.name);
    }

    public static UIMode[] modesForOperatingSystem() {
        if (UIUtils.isMacOS() || UIUtils.isWindows()) {
            return UIMode.values();
        }
        return new UIMode[]{LIGHT, DARK};
    }

    private static void applyMode(UIMode mode) {
        if (mode == AUTOMATIC) {
            mode = UIUtils.isMacOS() ? (UIMode.isMacOsDarkMode() ? DARK : LIGHT) : (UIUtils.isWindows() ? (UIMode.isWindowsDarkMode() ? DARK : LIGHT) : LIGHT);
        }
        String lafClassName = switch (mode) {
            case LIGHT -> UIUtils.isMacOS() ? FlatMacLightLaf.class.getName() : FlatLightLaf.class.getName();
            case DARK -> UIUtils.isMacOS() ? FlatMacDarkLaf.class.getName() : FlatDarkLaf.class.getName();
            default -> throw new AssertionError((Object)("Unexpected mode: " + mode));
        };
        if (lafClassName.equals(UIManager.getLookAndFeel().getClass().getName())) {
            return;
        }
        try {
            UIManager.setLookAndFeel(lafClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            throw new RuntimeException(e);
        }
        FlatLaf.updateUI();
    }

    private static final boolean isMacOsDarkMode() {
        try {
            String line;
            boolean isDarkMode = false;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("defaults read -g AppleInterfaceStyle");
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader rdr = new BufferedReader(isr);
            while ((line = rdr.readLine()) != null) {
                if (!line.equals("Dark")) continue;
                isDarkMode = true;
            }
            int rc = process.waitFor();
            return 0 == rc && isDarkMode;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    private static boolean isWindowsDarkMode() {
        try {
            Process process = Runtime.getRuntime().exec(DARK_THEME_CMD);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join(3000L);
            String result = reader.getResult();
            int p = result.indexOf(REGDWORD_TOKEN);
            if (p == -1) {
                return false;
            }
            String temp = result.substring(p + REGDWORD_TOKEN.length()).trim();
            return Integer.parseInt(temp.substring("0x".length()), 16) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    static class StreamReader
    extends Thread {
        private final InputStream is;
        private final StringWriter sw;

        StreamReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

