/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.scythebill.birdlist.model.checklist.ChecklistResolution;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.CompletedUpgrade;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.ResolvedComparator;
import com.scythebill.birdlist.ui.backup.BackupSaver;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.location.ChecklistResolutionResults;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TaxonomyUpgradeNotice {
    private final Taxonomy clements;
    private final FontManager fontManager;
    private final Alerts alerts;
    private final TaxonomyStore taxonomyStore;

    public TaxonomyUpgradeNotice(Taxonomy clements, Alerts alerts, FontManager fontManager, TaxonomyStore taxonomyStore) {
        this.clements = clements;
        this.alerts = alerts;
        this.fontManager = fontManager;
        this.taxonomyStore = taxonomyStore;
    }

    public Collection<SightingTaxon> showClementsUpgrade(ReportSet reportSet, File reportSetFile, CompletedUpgrade completedUpgrade, BackupSaver backupSaver) {
        JTextArea textArea;
        JLabel message;
        String warningsTaxaName;
        String upgradeCaution;
        boolean standardBackupsAreEnabled = backupSaver.backupsAreEnabled();
        if (standardBackupsAreEnabled) {
            backupSaver.saveNow(reportSet, reportSetFile);
            upgradeCaution = Messages.getMessage(Messages.Name.RECORDS_HAVE_BEEN_UPDATED_AFTER_BACKUP);
        } else {
            File backupFile = this.getBackupFile(reportSetFile, completedUpgrade);
            try {
                Files.copy(reportSetFile, backupFile);
                upgradeCaution = Messages.getFormattedMessage(Messages.Name.RECORDS_UPDATED_WITH_ONE_OFF_COPY, HtmlResponseWriter.htmlEscape(backupFile.getName()));
            }
            catch (IOException e) {
                this.alerts.showError(null, (Throwable)e, Messages.Name.COULD_NOT_BACKUP_DURING_UPGRADE_TITLE, Messages.Name.COULD_NOT_BACKUP_DURING_UPGRADE_MESSAGE, backupFile.getParentFile().getAbsolutePath());
                upgradeCaution = Messages.getMessage(Messages.Name.RECORDS_UPDATED_WITHOUT_BACKUP);
            }
        }
        boolean warningsPresent = !completedUpgrade.warnings().isEmpty();
        Taxonomy currentTaxonomy = this.taxonomyStore.getTaxonomy();
        if (warningsPresent) {
            warningsTaxaName = this.getTaxonNames(currentTaxonomy, completedUpgrade.warnings(), true, null);
            if (warningsTaxaName.isEmpty()) {
                warningsPresent = false;
            }
        } else {
            warningsTaxaName = "";
        }
        boolean spsPresent = !completedUpgrade.sps(currentTaxonomy).isEmpty();
        ImmutableSet<SightingTaxon> sightingTaxaToUpgrade = ImmutableSet.of();
        String taxonNamesOfSps = "";
        if (spsPresent) {
            sightingTaxaToUpgrade = Sets.newHashSet();
            taxonNamesOfSps = this.getTaxonNames(currentTaxonomy, completedUpgrade.sps(currentTaxonomy), false, sightingTaxaToUpgrade);
            if (taxonNamesOfSps.isEmpty()) {
                spsPresent = false;
            }
        }
        String openDiv = spsPresent || warningsPresent ? String.format("<div style=\"width:%spx;\">", this.fontManager.scale(600)) : "";
        String closeDiv = spsPresent || warningsPresent ? "</div>" : "";
        String formattedMessage = this.alerts.getFormattedDialogMessage(Messages.getMessage(Messages.Name.UPGRADE_SUCCESSFUL), "", new Object[0]);
        ArrayList<JComponent> components = Lists.newArrayList();
        JLabel label = new JLabel(formattedMessage);
        label.putClientProperty("birdlist.plainLabel", true);
        components.add(label);
        JLabel upgradeLabel = new JLabel(String.format("<html><br>%s%s<br>%s%s", openDiv, Messages.getFormattedMessage(Messages.Name.SCYTHEBILL_UPGRADED_TO_TAXONOMY_FORMAT, this.clements.getName()), upgradeCaution, closeDiv));
        upgradeLabel.putClientProperty("birdlist.plainLabel", true);
        components.add(upgradeLabel);
        if (currentTaxonomy == this.taxonomyStore.getIoc()) {
            JLabel iocToo = new JLabel("<html><br>" + Messages.getMessage(Messages.Name.SCYTHEBILL_UPGRADE_EVEN_FOR_IOC_USERS));
            iocToo.putClientProperty("birdlist.plainLabel", true);
            components.add(iocToo);
        }
        if (warningsPresent) {
            message = new JLabel("<html><br>" + Messages.getMessage(Messages.Name.UPGRADE_MANUALLY_EXAMINE_TAXA));
            message.putClientProperty("birdlist.plainLabel", true);
            textArea = new JTextArea();
            textArea.setText(warningsTaxaName);
            textArea.setRows(Math.min(20, Math.max(3, completedUpgrade.warnings().size())));
            textArea.setEditable(false);
            textArea.selectAll();
            textArea.getTransferHandler().exportToClipboard(textArea, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
            textArea.select(0, 0);
            JScrollPane scrollPane = new JScrollPane(textArea);
            components.add(message);
            components.add(scrollPane);
        }
        if (spsPresent) {
            message = new JLabel("<html><br>" + Messages.getMessage(Messages.Name.UPGRADE_SOME_SPUH_TAXA));
            message.putClientProperty("birdlist.plainLabel", true);
            textArea = new JTextArea(taxonNamesOfSps);
            int rows = Iterables.size(Splitter.on('\n').split(taxonNamesOfSps));
            textArea.setRows(Math.min(20, Math.max(3, rows)));
            textArea.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(textArea);
            components.add(message);
            components.add(scrollPane);
        }
        for (JComponent component : components) {
            this.fontManager.applyTo(component);
        }
        JOptionPane.showMessageDialog(null, components.toArray(), "", 1, this.alerts.getAlertIcon());
        return sightingTaxaToUpgrade;
    }

    public Collection<SightingTaxon> showNonClementsUpgrade(ReportSet reportSet, File reportSetFile, CompletedUpgrade completedUpgrade) {
        Object message;
        String warningsTaxaName;
        boolean warningsPresent;
        Preconditions.checkArgument(completedUpgrade.getForcedTaxonomy() != null, "Expecting forced taxonomy");
        boolean bl = warningsPresent = !completedUpgrade.warnings().isEmpty();
        if (warningsPresent) {
            warningsTaxaName = this.getTaxonNames(completedUpgrade.getForcedTaxonomy(), completedUpgrade.warnings(), true, null);
            if (warningsTaxaName.isEmpty()) {
                warningsPresent = false;
            }
        } else {
            warningsTaxaName = "";
        }
        boolean spsPresent = !completedUpgrade.sps(completedUpgrade.getForcedTaxonomy()).isEmpty();
        ImmutableSet<SightingTaxon> sightingTaxaToUpgrade = ImmutableSet.of();
        String taxonNamesOfSps = "";
        if (spsPresent) {
            sightingTaxaToUpgrade = Sets.newHashSet();
            taxonNamesOfSps = this.getTaxonNames(completedUpgrade.getForcedTaxonomy(), completedUpgrade.sps(completedUpgrade.getForcedTaxonomy()), false, sightingTaxaToUpgrade);
            if (taxonNamesOfSps.isEmpty()) {
                spsPresent = false;
            }
        }
        String openDiv = spsPresent || warningsPresent ? String.format("<div style=\"width:%spx;\">", this.fontManager.scale(300)) : "";
        String closeDiv = spsPresent || warningsPresent ? "</div>" : "";
        String formattedMessage = this.alerts.getFormattedDialogMessage(Messages.getMessage(Messages.Name.UPGRADE_SUCCESSFUL), "", new Object[0]);
        ArrayList<Object> components = Lists.newArrayList();
        JLabel label = new JLabel(formattedMessage);
        label.putClientProperty("birdlist.plainLabel", true);
        components.add(label);
        JLabel upgradeLabel = new JLabel(String.format("<html><br>%s%s<br>%s", openDiv, Messages.getFormattedMessage(Messages.Name.SCYTHEBILL_UPGRADED_TO_TAXONOMY_FORMAT, completedUpgrade.getForcedTaxonomy().getName()), closeDiv));
        upgradeLabel.putClientProperty("birdlist.plainLabel", true);
        components.add(upgradeLabel);
        if (warningsPresent) {
            message = new JLabel("<html><br>" + Messages.getMessage(Messages.Name.UPGRADE_MANUALLY_EXAMINE_TAXA));
            ((JComponent)message).putClientProperty("birdlist.plainLabel", true);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setText(warningsTaxaName);
            jTextArea.setRows(Math.min(20, Math.max(3, completedUpgrade.warnings().size())));
            jTextArea.setEditable(false);
            jTextArea.selectAll();
            jTextArea.getTransferHandler().exportToClipboard(jTextArea, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
            jTextArea.select(0, 0);
            JScrollPane scrollPane = new JScrollPane(jTextArea);
            components.add(message);
            components.add(scrollPane);
        }
        if (spsPresent) {
            message = new JLabel("<html><br>" + Messages.getMessage(Messages.Name.UPGRADE_SOME_IOC_SPUH_TAXA));
            ((JComponent)message).putClientProperty("birdlist.plainLabel", true);
            JTextArea jTextArea = new JTextArea(taxonNamesOfSps);
            int rows = Iterables.size(Splitter.on('\n').split(taxonNamesOfSps));
            jTextArea.setRows(Math.min(20, Math.max(3, rows)));
            jTextArea.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(jTextArea);
            components.add(message);
            components.add(scrollPane);
        }
        for (JComponent jComponent : components) {
            this.fontManager.applyTo(jComponent);
        }
        Object[] options = new String[]{Messages.getMessage(Messages.Name.RESOLVE_NOW), Messages.getMessage(Messages.Name.NOT_NOW)};
        int n = JOptionPane.showOptionDialog(null, components.toArray(), "", -1, 1, this.alerts.getAlertIcon(), options, options[0]);
        return n == 0 ? sightingTaxaToUpgrade : ImmutableList.of();
    }

    private File getBackupFile(File oldFile, CompletedUpgrade completedUpgrade) {
        String oldName = oldFile.getName();
        if (oldName.endsWith(".bsxm")) {
            oldName = oldName.substring(0, oldName.length() - ".bsxm".length());
        }
        String newName = oldName + "_backup_" + completedUpgrade.getPreviousTaxonomyId() + ".bsxm";
        return new File(oldFile.getParent(), newName);
    }

    private String getTaxonNames(Taxonomy currentTaxonomy, Collection<SightingTaxon> collection, boolean includeScientific, @Nullable Collection<SightingTaxon> stillSpInTaxonomy) {
        TreeSet<SightingTaxon.Resolved> treeSet = Sets.newTreeSet(new ResolvedComparator());
        for (SightingTaxon taxon : collection) {
            SightingTaxon.Resolved resolved = taxon.resolve(currentTaxonomy);
            if (resolved.getSightingTaxon().getType() != SightingTaxon.Type.SP) continue;
            if (stillSpInTaxonomy != null) {
                stillSpInTaxonomy.add(taxon);
            }
            treeSet.add(resolved);
        }
        ArrayList<Object> taxaNames = Lists.newArrayList();
        for (SightingTaxon.Resolved resolved : treeSet) {
            Object next = includeScientific ? resolved.getCommonName() + " (" + resolved.getFullName() + ")" : resolved.getCommonName();
            if (((String)next).length() > 120) {
                next = ((String)next).substring(0, 120) + "\u2026";
            }
            taxaNames.add(next);
        }
        return Joiner.on('\n').join(taxaNames);
    }

    public ImmutableSet<SightingTaxon> attemptChecklistResolution(ReportSet reportSet, Checklists checklists, ImmutableSet<SightingTaxon> spsToResolve, boolean forceIocResolution) {
        ChecklistResolution checklistResolution = new ChecklistResolution(checklists, ImmutableSet.of());
        ImmutableSet<SightingTaxon> remainingSightingTaxons = checklistResolution.attemptChecklistResolution(reportSet, spsToResolve, forceIocResolution ? this.taxonomyStore.getIoc() : this.clements);
        List<Sighting> sightingsToRemove = checklistResolution.sightingsToRemove();
        List<Sighting> sightingsToAdd = checklistResolution.sightingsToAdd();
        int simplifiedButStillSp = checklistResolution.simplifiedButNotFullyResolved();
        int notSimplified = checklistResolution.notSimplifiedCount();
        if (sightingsToAdd.isEmpty()) {
            return null;
        }
        int totalSightingsConsidered = notSimplified + sightingsToAdd.size();
        String message = Messages.getFormattedMessage(Messages.Name.OUT_OF_SIGHTINGS_TO_RESOLVE_FORMAT, totalSightingsConsidered) + "\n\n";
        int fullyCleaned = sightingsToAdd.size() - simplifiedButStillSp;
        if (fullyCleaned > 0) {
            message = message + Messages.getFormattedMessage(Messages.Name.SOME_CAN_BE_ENTIRELY_RESOLVED_USING_CHECKLISTS, fullyCleaned) + "\n";
        }
        if (simplifiedButStillSp > 0) {
            message = message + Messages.getFormattedMessage(Messages.Name.SOME_CAN_BE_PARTIALLY_RESOLVED, simplifiedButStillSp) + "\n";
        }
        if (notSimplified > 0) {
            message = message + Messages.getFormattedMessage(Messages.Name.SOME_CANNOT_BE_RESOLVED_AT_ALL, notSimplified) + "\n";
        }
        message = message + "\n" + Messages.getMessage(Messages.Name.LET_SCYTHEBILL_RESOLVE_SIGHTINGS_AUTOMATICALLY);
        JComponent resultsSummary = ChecklistResolutionResults.asPanel(checklistResolution, forceIocResolution ? this.taxonomyStore.getIoc() : this.clements, this.fontManager);
        int yesOrNo = this.alerts.showYesNoWithPanel(null, this.alerts.getFormattedDialogMessage(Messages.getMessage(Messages.Name.AUTO_RESOLVE_WITH_CHECKLISTS), message, new Object[0]), resultsSummary);
        if (yesOrNo == 0) {
            reportSet.mutator().removing(sightingsToRemove).adding(sightingsToAdd).mutate();
            return remainingSightingTaxons;
        }
        return null;
    }
}

