/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.events.DefaultUserChangedEvent;
import com.scythebill.birdlist.ui.events.DefaultUserStore;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.guice.IOC;
import com.scythebill.birdlist.ui.messages.Messages;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

class TaxonomyChooserPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private final TaxonomyStore taxonomyStore;
    private final Taxonomy clements;
    private final MappedTaxonomy ioc;
    private JComboBox<PossibleTaxonomy> taxonomyChooser;
    private IndexerPanel<User> userIndexer;
    private JSeparator separator;
    private JLabel taxonomyLabel;
    private JLabel userLabel;
    private ReportSet reportSet;
    private DefaultUserStore defaultUserStore;

    @Inject
    public TaxonomyChooserPanel(TaxonomyStore taxonomyStore, @Clements Taxonomy clements, @IOC MappedTaxonomy ioc, DefaultUserStore defaultUserStore, ReportSet reportSet, FontManager fontManager, EventBusRegistrar eventBusRegistrar) {
        this.taxonomyStore = taxonomyStore;
        this.clements = clements;
        this.ioc = ioc;
        this.defaultUserStore = defaultUserStore;
        this.reportSet = reportSet;
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.initGui();
        fontManager.applyTo(this);
        this.taxonomyChooser.setSelectedIndex(this.findTaxonomyIndex(taxonomyStore.getTaxonomy()));
        this.taxonomyChooser.addActionListener(e -> this.updateTaxonomy());
        this.userIndexer.addPropertyChangeListener("value", e -> defaultUserStore.setUser(this.userIndexer.getValue()));
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                TaxonomyChooserPanel.this.taxonomyChanged(null);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private int findTaxonomyIndex(Taxonomy taxonomy) {
        for (int i = 0; i < this.taxonomyChooser.getItemCount(); ++i) {
            if (taxonomy != this.taxonomyChooser.getItemAt((int)i).taxonomy) continue;
            return i;
        }
        return 0;
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.updateTaxonomyChooser();
        int newIndex = this.findTaxonomyIndex(this.taxonomyStore.getTaxonomy());
        if (newIndex != this.taxonomyChooser.getSelectedIndex()) {
            this.taxonomyChooser.setSelectedIndex(newIndex);
        }
    }

    @Subscribe
    public void defaultUserChanged(DefaultUserChangedEvent event) {
        this.updateUserChooser();
        if (this.userIndexer != null && this.userIndexer.getValue() != event.getUser()) {
            this.userIndexer.setValue(event.getUser());
        }
    }

    private void updateTaxonomy() {
        this.taxonomyStore.setTaxonomy(((PossibleTaxonomy)this.taxonomyChooser.getSelectedItem()).taxonomy);
    }

    private void initGui() {
        this.taxonomyLabel = new JLabel(Messages.getMessage(Messages.Name.TAXONOMY_LABEL));
        this.taxonomyChooser = new JComboBox();
        this.updateTaxonomyChooser();
        this.userLabel = new JLabel(Messages.getMessage(Messages.Name.OBSERVER_LABEL));
        this.userIndexer = new IndexerPanel();
        this.userIndexer.setColumns(15);
        this.userIndexer.setLayoutStrategy(IndexerPanel.LayoutStrategy.BELOW);
        this.userIndexer.setPreviewText(Messages.Name.OBSERVER_NAME);
        this.updateUserChooser();
        this.separator = new JSeparator();
    }

    private void updateUserChooser() {
        if (this.reportSet.getUserSet() != null) {
            this.userLabel.setVisible(true);
            this.userIndexer.setVisible(true);
            this.userIndexer.removeAllIndexerGroups();
            Indexer<User> indexer = new Indexer<User>(4);
            for (User user : this.reportSet.getUserSet().allUsers()) {
                if (user.name() != null) {
                    indexer.add(user.name(), user);
                    continue;
                }
                indexer.add(user.abbreviation(), user);
            }
            ToString<User> toString = new ToString<User>(){

                @Override
                public String getString(User user) {
                    if (user == null) {
                        return "";
                    }
                    return user.name() != null ? user.name() : user.abbreviation();
                }
            };
            this.userIndexer.addIndexerGroup(toString, indexer);
            this.userIndexer.setValue(this.defaultUserStore.getUser());
        } else {
            this.userLabel.setVisible(false);
            this.userIndexer.setVisible(false);
        }
    }

    private void updateTaxonomyChooser() {
        boolean taxonomiesChanged = false;
        if (this.taxonomyChooser.getItemCount() != 2 + this.reportSet.extendedTaxonomies().size()) {
            taxonomiesChanged = true;
        }
        PossibleTaxonomy[] taxonomies = new PossibleTaxonomy[2 + this.reportSet.extendedTaxonomies().size()];
        taxonomies[0] = new PossibleTaxonomy("eBird/Clements", this.clements);
        taxonomies[1] = new PossibleTaxonomy("IOC", this.ioc);
        int i = 2;
        for (Taxonomy extendedTaxonomy : this.reportSet.extendedTaxonomies()) {
            if (!taxonomiesChanged) {
                PossibleTaxonomy existingItem = this.taxonomyChooser.getItemAt(i);
                if (existingItem.taxonomy != extendedTaxonomy) {
                    taxonomiesChanged = true;
                }
            }
            taxonomies[i++] = new PossibleTaxonomy(extendedTaxonomy.getName(), extendedTaxonomy);
        }
        if (taxonomiesChanged) {
            this.taxonomyChooser.setModel(new DefaultComboBoxModel<PossibleTaxonomy>(taxonomies));
            this.taxonomyChooser.setMaximumRowCount(taxonomies.length);
        }
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        int borderSize = fontManager.scale(10);
        this.setBorder(new EmptyBorder(borderSize, borderSize, borderSize, borderSize));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createBaselineGroup(false, false).addComponent(this.taxonomyLabel).addComponent(this.taxonomyChooser).addComponent(this.userLabel).addComponent(this.userIndexer)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.taxonomyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.taxonomyChooser, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.userLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userIndexer, -2, -1, -2)).addComponent(this.separator, fontManager.scale(50), fontManager.scale(300), Short.MAX_VALUE));
    }

    static class PossibleTaxonomy {
        final String name;
        final Taxonomy taxonomy;

        PossibleTaxonomy(String name, Taxonomy taxonomy) {
            this.name = name;
            this.taxonomy = taxonomy;
        }

        public String toString() {
            return this.name;
        }
    }
}

