/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.scythebill.birdlist.model.util.Progress;
import com.scythebill.birdlist.ui.app.StartupView;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.guice.ScythebillSplash;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.SplashScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class StartupPanel
implements StartupView {
    private static final int PROGRESS_PIXELS = 300;
    private Timer timer;
    private final FontManager fontManager;
    private final List<Supplier<Integer>> progressSuppliers = new CopyOnWriteArrayList<Supplier<Integer>>();
    private final Provider<Image> splashImageProvider;
    private JFrame frame;

    @Inject
    public StartupPanel(FontManager fontManager, @ScythebillSplash Provider<Image> splashImageProvider) {
        this.fontManager = fontManager;
        this.splashImageProvider = splashImageProvider;
    }

    @Override
    public void addProgress(final Progress progress, final double fraction) {
        this.progressSuppliers.add(new Supplier<Integer>(){

            @Override
            public Integer get() {
                return (int)(300.0 * (fraction * (double)progress.current() / (double)progress.max()));
            }
        });
    }

    @Override
    public void start() {
        final JProgressBar progressBar = new JProgressBar(0, 300);
        Dimension preferredSize = progressBar.getPreferredSize();
        preferredSize.width = 300;
        progressBar.setPreferredSize(preferredSize);
        JPanel content = new JPanel();
        content.setOpaque(false);
        JLabel loadingLabel = new JLabel(Messages.getMessage(Messages.Name.SCYTHEBILL_IS_STARTING));
        loadingLabel.setOpaque(false);
        loadingLabel.setFont(this.fontManager.getLabelFont());
        loadingLabel.setPreferredSize(new Dimension(300, 40));
        loadingLabel.setHorizontalTextPosition(0);
        loadingLabel.setVerticalTextPosition(0);
        loadingLabel.setAlignmentX(0.5f);
        loadingLabel.setAlignmentY(0.5f);
        BoxLayout layout = new BoxLayout(content, 1);
        content.setLayout(layout);
        content.add(Box.createVerticalGlue());
        content.add(loadingLabel);
        content.add(Box.createRigidArea(new Dimension(10, 10)));
        content.add(progressBar);
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.frame = new JFrame();
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)content, "Center");
        ((JPanel)this.frame.getContentPane()).setOpaque(false);
        this.frame.setUndecorated(true);
        this.frame.setResizable(false);
        SplashScreen splashScreen = SplashScreen.getSplashScreen();
        if (splashScreen == null) {
            Image splashImage = this.splashImageProvider.get();
            if (splashImage != null) {
                loadingLabel.setForeground(Color.WHITE);
                ImageIcon icon = new ImageIcon(splashImage);
                JLabel splash = new JLabel(icon);
                this.frame.getLayeredPane().add((Component)splash, (Object)Integer.MIN_VALUE);
                splash.setSize(icon.getIconWidth(), icon.getIconHeight());
                this.frame.setSize(icon.getIconWidth(), icon.getIconHeight());
            } else {
                this.frame.pack();
            }
            this.frame.setLocationRelativeTo(null);
        } else {
            loadingLabel.setForeground(Color.WHITE);
            this.frame.setBounds(splashScreen.getBounds());
            ImageIcon icon = new ImageIcon(splashScreen.getImageURL());
            JLabel iconLabel = new JLabel(icon);
            this.frame.getLayeredPane().add((Component)iconLabel, (Object)Integer.MIN_VALUE);
            iconLabel.setSize(splashScreen.getSize());
        }
        this.frame.setVisible(true);
        this.frame.toFront();
        this.timer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                progressBar.setValue(StartupPanel.this.getProgress());
            }
        });
        this.timer.start();
    }

    @Override
    public void stop() {
        this.timer.stop();
        this.frame.setVisible(false);
    }

    private int getProgress() {
        int progress = 0;
        for (Supplier<Integer> supplier : this.progressSuppliers) {
            progress += supplier.get().intValue();
        }
        return progress;
    }
}

