/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.formdev.flatlaf.FlatLaf;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.ui.actions.DelegatedAction;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.SpeciesIndexerPanelConfigurer;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.ShowSpeciesMap;
import com.scythebill.birdlist.ui.panels.SpHybridEntry;
import com.scythebill.birdlist.ui.panels.SpeciesInfoDescriber;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SpeciesSpHybridEntryPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private Taxonomy taxonomy;
    private FontManager fontManager;
    private JButton addButton;
    private IndexerPanel<String> speciesIndexer;
    private JEditorPane speciesInfoText;
    private JLabel indexerLabel;
    private final SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer;
    private FocusLocation focusLocation = null;
    private DelegatedAction addAction = new DelegatedAction();
    protected Taxon subspeciesPopupTaxon;
    private JButton spButton;
    private SpEntryPanel spEntryPanel;
    private JButton hybridButton;
    private final SpeciesInfoDescriber speciesInfoDescriber;
    private Supplier<SightingTaxon.Resolved> resolvedSource;
    private final ShowSpeciesMap showSpeciesMap;
    private final Alerts alerts;
    private final NamesPreferences namesPreferences;
    private JScrollPane speciesInfoScrollPane;
    private final ReportSet reportSet;
    private static final Logger logger = Logger.getLogger(SpeciesSpHybridEntryPanel.class.getName());
    private final List<SpeciesEntryListener> listeners = Lists.newCopyOnWriteArrayList();
    private Checklist checklist;
    private Location checklistLocation;

    @Inject
    public SpeciesSpHybridEntryPanel(ReportSet reportSet, SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer, FontManager fontManager, SpeciesInfoDescriber speciesInfoDescriber, ShowSpeciesMap showSpeciesMap, NamesPreferences namesPreferences, Alerts alerts) {
        this.reportSet = reportSet;
        this.speciesIndexerPanelConfigurer = speciesIndexerPanelConfigurer;
        this.fontManager = fontManager;
        this.speciesInfoDescriber = speciesInfoDescriber;
        this.showSpeciesMap = showSpeciesMap;
        this.namesPreferences = namesPreferences;
        this.alerts = alerts;
        this.initComponents();
        this.speciesIndexer.addPropertyChangeListener("selectedValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String taxonId = (String)evt.getNewValue();
                if (taxonId == null) {
                    if (SpeciesSpHybridEntryPanel.this.focusLocation == FocusLocation.SPECIES_POPUP) {
                        SpeciesSpHybridEntryPanel.this.setFocusLocation(FocusLocation.SPECIES);
                    }
                } else {
                    SpeciesSpHybridEntryPanel.this.setFocusLocation(FocusLocation.SPECIES_POPUP);
                }
                SpeciesSpHybridEntryPanel.this.updateSpeciesText();
            }
        });
        this.speciesIndexer.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SpeciesSpHybridEntryPanel.this.updatePrimarySpeciesButtons();
                SpeciesSpHybridEntryPanel.this.updateSpeciesText();
            }
        });
        this.addButton.getAction().setEnabled(false);
        this.spButton.setEnabled(false);
        this.hybridButton.setEnabled(false);
        this.addAction.setDelegate(this.addButton.getAction());
        this.speciesIndexer.getTextComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '/') {
                    e.consume();
                    if (SpeciesSpHybridEntryPanel.this.spButton.isEnabled()) {
                        SpeciesSpHybridEntryPanel.this.spButton.doClick(100);
                    }
                }
            }
        });
        this.updateSpeciesText();
    }

    public JComponent extractSpeciesInfoPanel() {
        this.remove(this.speciesInfoScrollPane);
        return this.speciesInfoScrollPane;
    }

    private void updatePrimarySpeciesButtons() {
        boolean enabled = this.speciesIndexer.getValue() != null && !this.spEntryPanel.isVisible();
        this.addButton.getAction().setEnabled(enabled);
        this.spButton.setEnabled(enabled);
        this.hybridButton.setEnabled(enabled);
        this.speciesIndexer.setEnabled(!this.spEntryPanel.isVisible());
    }

    private void setFocusLocation(FocusLocation focusLocation) {
        if (this.focusLocation != focusLocation) {
            this.focusLocation = focusLocation;
        }
    }

    private void updateSpeciesText() {
        StringBuilder builder = new StringBuilder("<html>");
        if (this.focusLocation == null) {
            builder.append("<span style='color:gray'>").append(Messages.getMessage(Messages.Name.SPECIES_INFORMATION_WILL_APPEAR_HERE)).append("</span>");
            builder.append("</html>");
            this.speciesInfoText.setText(builder.toString());
            return;
        }
        SightingTaxon.Resolved taxon = this.getFocusedTaxon();
        if (taxon != null) {
            this.speciesInfoDescriber.toHtmlText(taxon, this.reportSet, this.checklist, this.checklistLocation, builder);
        }
        builder.append("</html>");
        this.speciesInfoText.setText(builder.toString());
        this.speciesInfoText.select(0, 0);
    }

    private SightingTaxon.Resolved getFocusedTaxon() {
        Taxon taxon;
        switch (this.focusLocation) {
            case SPECIES: {
                taxon = this.speciesIndexer.getValue() == null ? null : this.taxonomy.getTaxon(this.speciesIndexer.getValue());
                break;
            }
            case SPECIES_POPUP: {
                taxon = this.speciesIndexer.getSelectedValue() == null ? null : this.taxonomy.getTaxon(this.speciesIndexer.getSelectedValue());
                break;
            }
            case SP_SPECIES_POPUP: {
                taxon = this.spEntryPanel.indexerPanel.getSelectedValue() == null ? null : this.taxonomy.getTaxon(this.spEntryPanel.indexerPanel.getSelectedValue());
                break;
            }
            case EXTERNAL: {
                return this.resolvedSource.get();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return taxon == null ? null : SightingTaxons.newResolved(taxon);
    }

    public void setFocusResolver(Supplier<SightingTaxon.Resolved> resolvedSource) {
        this.resolvedSource = resolvedSource;
        this.setFocusLocation(FocusLocation.EXTERNAL);
        this.updateSpeciesText();
    }

    public Action getAddAction() {
        return this.addAction;
    }

    public void setInPanelAddButtonVisibility(boolean addButtonVisibility) {
        this.addButton.setVisible(addButtonVisibility);
        this.spEntryPanel.addSpOrHybrid.setVisible(addButtonVisibility);
    }

    private void initComponents() {
        this.indexerLabel = new JLabel();
        this.indexerLabel.setAlignmentX(0.0f);
        this.speciesIndexer = new IndexerPanel();
        this.speciesIndexer.addActionListener(e -> this.addButton.doClick(100));
        this.speciesInfoScrollPane = new JScrollPane();
        this.speciesInfoText = new JEditorPane(){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setBackground(FlatLaf.isLafDark() ? UIManager.getColor("EditorPane.background") : Color.WHITE);
            }
        };
        this.speciesInfoText.setContentType("text/html");
        if (!FlatLaf.isLafDark()) {
            this.speciesInfoText.setBackground(Color.WHITE);
        }
        this.speciesInfoText.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.speciesInfoText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SpeciesSpHybridEntryPanel.this.speciesInfoText.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                SpeciesSpHybridEntryPanel.this.speciesInfoText.select(0, 0);
            }
        });
        this.speciesInfoText.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (SpeciesInfoDescriber.isShowMapUrl(event.getURL())) {
                        String id = SpeciesInfoDescriber.getShowMapSpeciesId(event.getURL());
                        try {
                            SpeciesSpHybridEntryPanel.this.showSpeciesMap.showRange(SpeciesSpHybridEntryPanel.this.reportSet, SpeciesSpHybridEntryPanel.this.taxonomy, id);
                        }
                        catch (IOException e) {
                            SpeciesSpHybridEntryPanel.this.alerts.showError((Object)SpeciesSpHybridEntryPanel.this, (Throwable)e, Messages.Name.MAP_FAILED, Messages.Name.COULDNT_WRITE_MAP, new Object[0]);
                        }
                    } else {
                        try {
                            DesktopUtils.openUrlInBrowser(event.getURL().toURI(), SpeciesSpHybridEntryPanel.this.alerts);
                        }
                        catch (URISyntaxException e) {
                            logger.log(Level.WARNING, "Couldn't open URL " + event.getURL(), e);
                        }
                    }
                }
            }
        });
        this.speciesInfoScrollPane.setViewportView(this.speciesInfoText);
        this.speciesInfoScrollPane.setVerticalScrollBarPolicy(20);
        this.speciesInfoScrollPane.setHorizontalScrollBarPolicy(31);
        this.speciesInfoText.setEditable(false);
        this.addButton = new JButton();
        this.spButton = new JButton();
        this.spButton.setText(Messages.getMessage(Messages.Name.SPUH_LABEL));
        this.hybridButton = new JButton();
        this.hybridButton.setText(Messages.getMessage(Messages.Name.HYBRID_LABEL));
        BoxLayout vertical = new BoxLayout(this, 3);
        this.setLayout(vertical);
        JPanel topRow = new JPanel();
        topRow.setAlignmentX(0.0f);
        BoxLayout topRowLayout = new BoxLayout(topRow, 2);
        topRow.setLayout(topRowLayout);
        topRow.add(this.indexerLabel);
        topRow.add(Box.createHorizontalStrut(20));
        topRow.add(this.speciesIndexer);
        topRow.add(this.addButton);
        topRow.add(this.spButton);
        topRow.add(this.hybridButton);
        this.spEntryPanel = new SpEntryPanel();
        this.spEntryPanel.setVisible(false);
        this.add(topRow);
        this.add(this.spEntryPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.speciesInfoScrollPane);
        this.addButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String taxonId = SpeciesSpHybridEntryPanel.this.speciesIndexer.getValue();
                Taxon taxon = SpeciesSpHybridEntryPanel.this.taxonomy.getTaxon(taxonId);
                SightingTaxon.Resolved resolved = SightingTaxons.newResolved(taxon);
                SpeciesSpHybridEntryPanel.this.addSpecies(resolved);
            }
        });
        this.addButton.setText(Messages.getMessage(Messages.Name.ADD_SPECIES));
        this.spButton.addActionListener(evt -> this.openSpPanel(evt, SightingTaxon.Type.SP));
        this.hybridButton.addActionListener(evt -> this.openSpPanel(evt, SightingTaxon.Type.HYBRID));
        this.fontManager.applyTo(this);
    }

    public void addSpeciesEntryListener(SpeciesEntryListener l) {
        this.listeners.add(l);
    }

    private void addSpecies(SightingTaxon.Resolved resolved) {
        SpeciesEntryEvent event = new SpeciesEntryEvent(resolved);
        for (SpeciesEntryListener listener : this.listeners) {
            listener.addSpecies(event);
        }
        this.speciesIndexer.setValue(null);
    }

    private void openSpPanel(ActionEvent evt, SightingTaxon.Type type) {
        String taxonId = this.speciesIndexer.getValue();
        Taxon taxon = this.taxonomy.getTaxon(taxonId);
        this.spEntryPanel.setVisible(true);
        this.spEntryPanel.setBaseTaxon(type, taxon);
        this.updatePrimarySpeciesButtons();
        this.spEntryPanel.requestFocusInWindow();
    }

    public String getTitle() {
        return "Enter Species";
    }

    public void setIndexerLabel(String indexerText) {
        this.indexerLabel.setText(indexerText);
    }

    public IndexerPanel<String> getIndexer() {
        return this.speciesIndexer;
    }

    public void setTaxonomy(Taxonomy newTaxonomy) {
        if (newTaxonomy == this.taxonomy) {
            return;
        }
        this.taxonomy = newTaxonomy;
        this.speciesIndexerPanelConfigurer.configure(this.speciesIndexer, newTaxonomy);
        this.speciesIndexer.setValue(null);
        this.spEntryPanel.hideSpOrHybridPanel();
        this.updatePrimarySpeciesButtons();
    }

    public void setChecklist(Checklist checklist, Location checklistLocation) {
        this.checklist = checklist;
        this.checklistLocation = checklistLocation;
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.speciesInfoText.setPreferredSize(fontManager.scale(new Dimension(480, 100)));
        this.speciesInfoText.setMaximumSize(fontManager.scale(new Dimension(Short.MAX_VALUE, 250)));
        this.updateSpeciesText();
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.indexerLabel.getBaseline(this.indexerLabel.getWidth(), this.indexerLabel.getHeight()) + this.indexerLabel.getY();
    }

    public Component getLastFocusableComponent() {
        return this.speciesInfoText;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.speciesIndexer.requestFocusInWindow();
    }

    private static enum FocusLocation {
        SPECIES_POPUP,
        SPECIES,
        SP_SPECIES_POPUP,
        EXTERNAL;

    }

    class SpEntryPanel
    extends JPanel {
        private JLabel baseSpeciesText;
        private IndexerPanel<String> indexerPanel;
        private JButton secondSp;
        private JButton addSpOrHybrid;
        private Taxon baseTaxon;
        private String secondTaxonId;
        private SightingTaxon.Type type;
        private JButton cancelSpOrHybrid;

        SpEntryPanel() {
            this.initComponents();
            this.indexerPanel.addPropertyChangeListener("selectedValue", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String taxonId = (String)evt.getNewValue();
                    if (taxonId == null) {
                        if (SpeciesSpHybridEntryPanel.this.focusLocation == FocusLocation.SP_SPECIES_POPUP) {
                            SpeciesSpHybridEntryPanel.this.setFocusLocation(FocusLocation.SPECIES);
                        }
                    } else {
                        SpeciesSpHybridEntryPanel.this.setFocusLocation(FocusLocation.SP_SPECIES_POPUP);
                    }
                    SpeciesSpHybridEntryPanel.this.updateSpeciesText();
                }
            });
            this.indexerPanel.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String taxonId = (String)evt.getNewValue();
                    SpEntryPanel.this.addSpOrHybrid.getAction().setEnabled(taxonId != null);
                    SpEntryPanel.this.secondSp.setEnabled(taxonId != null);
                    if (taxonId != null) {
                        SightingTaxon.Resolved resolved = SightingTaxons.newResolved(SpeciesSpHybridEntryPanel.this.taxonomy.getTaxon(taxonId));
                        SpeciesSpHybridEntryPanel.this.setFocusResolver(Suppliers.ofInstance(resolved));
                    }
                    SpeciesSpHybridEntryPanel.this.updateSpeciesText();
                }
            });
            this.indexerPanel.addActionListener(e -> this.addSpOrHybrid.doClick(100));
            this.addSpOrHybrid.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SpEntryPanel.this.addSpOrHybrid(event);
                }
            });
            this.addSpOrHybrid.setText(Messages.getMessage(Messages.Name.ADD_BUTTON));
            this.secondSp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpEntryPanel.this.secondTaxonId = SpEntryPanel.this.indexerPanel.getValue();
                    if (SpEntryPanel.this.secondTaxonId != null) {
                        String append = SpEntryPanel.this.type == SightingTaxon.Type.SP ? " / " : " x ";
                        Taxon secondTaxon = SpeciesSpHybridEntryPanel.this.taxonomy.getTaxon(SpEntryPanel.this.secondTaxonId);
                        SpEntryPanel.this.baseSpeciesText.setText(TaxonUtils.getCommonName(SpEntryPanel.this.baseTaxon) + append + TaxonUtils.getCommonName(secondTaxon) + append);
                        SpEntryPanel.this.indexerPanel.setTextValue("");
                        SpEntryPanel.this.secondSp.setVisible(false);
                        SpEntryPanel.this.indexerPanel.requestFocusInWindow();
                    }
                }
            });
            this.cancelSpOrHybrid.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeciesSpHybridEntryPanel.this.spEntryPanel.hideSpOrHybridPanel();
                    SpeciesSpHybridEntryPanel.this.updatePrimarySpeciesButtons();
                    SpeciesSpHybridEntryPanel.this.speciesIndexer.requestFocusInWindow();
                    SpeciesSpHybridEntryPanel.this.focusLocation = FocusLocation.SPECIES;
                }
            });
        }

        private void initComponents() {
            this.baseSpeciesText = new JLabel();
            this.setAlignmentX(0.0f);
            this.indexerPanel = new IndexerPanel();
            this.addSpOrHybrid = new JButton(Messages.getMessage(Messages.Name.ADD_BUTTON));
            this.cancelSpOrHybrid = new JButton(Messages.getMessage(Messages.Name.CANCEL_BUTTON));
            this.secondSp = new JButton(Messages.getMessage(Messages.Name.SPUH_LABEL));
            BoxLayout layout = new BoxLayout(this, 2);
            this.setLayout(layout);
            this.add(this.baseSpeciesText);
            this.add(this.indexerPanel);
            this.add(this.addSpOrHybrid);
            this.add(this.secondSp);
            this.add(this.cancelSpOrHybrid);
            SpeciesSpHybridEntryPanel.this.fontManager.applyTo(this);
        }

        public void setBaseTaxon(SightingTaxon.Type type, Taxon taxon) {
            this.type = type;
            this.baseTaxon = taxon;
            String append = type == SightingTaxon.Type.SP ? " / " : " x ";
            this.baseSpeciesText.setText(TaxonUtils.getCommonName(taxon) + append);
            this.secondSp.setVisible(type == SightingTaxon.Type.SP);
            SpHybridEntry.configureIndexer(this.indexerPanel, taxon, SpeciesSpHybridEntryPanel.this.namesPreferences);
            this.indexerPanel.setPreviewText(SpeciesSpHybridEntryPanel.this.speciesIndexer.getPreviewText());
            this.indexerPanel.setLayoutStrategy(SpeciesSpHybridEntryPanel.this.speciesIndexer.getLayoutStrategy());
            this.indexerPanel.setFont(SpeciesSpHybridEntryPanel.this.fontManager.getTextFont());
            this.indexerPanel.setValue(null);
            this.addSpOrHybrid.getAction().setEnabled(false);
            SpeciesSpHybridEntryPanel.this.addAction.setDelegate(this.addSpOrHybrid.getAction());
        }

        void hideSpOrHybridPanel() {
            this.setVisible(false);
            SpeciesSpHybridEntryPanel.this.addAction.setDelegate(SpeciesSpHybridEntryPanel.this.addButton.getAction());
        }

        private void addSpOrHybrid(ActionEvent evt) {
            String taxonId = this.indexerPanel.getValue();
            SightingTaxon newTaxon = this.secondTaxonId == null ? (this.type == SightingTaxon.Type.SP ? SightingTaxons.newSpTaxon(ImmutableSet.of(this.baseTaxon.getId(), taxonId)) : SightingTaxons.newHybridTaxon(ImmutableSet.of(this.baseTaxon.getId(), taxonId))) : (this.type == SightingTaxon.Type.SP ? SightingTaxons.newSpTaxon(ImmutableSet.of(this.baseTaxon.getId(), taxonId, this.secondTaxonId)) : SightingTaxons.newHybridTaxon(ImmutableSet.of(this.baseTaxon.getId(), taxonId, this.secondTaxonId)));
            SightingTaxon.Resolved resolved = newTaxon.resolveInternal(SpeciesSpHybridEntryPanel.this.taxonomy);
            SpeciesSpHybridEntryPanel.this.addSpecies(resolved);
            SpeciesSpHybridEntryPanel.this.speciesIndexer.setValue(null);
            this.indexerPanel.setValue(null);
            this.hideSpOrHybridPanel();
            SpeciesSpHybridEntryPanel.this.updatePrimarySpeciesButtons();
            SpeciesSpHybridEntryPanel.this.speciesIndexer.requestFocusInWindow();
            SpeciesSpHybridEntryPanel.this.focusLocation = FocusLocation.SPECIES;
        }

        @Override
        public boolean requestFocusInWindow() {
            return this.indexerPanel.requestFocusInWindow();
        }
    }

    public static class SpeciesEntryEvent {
        private final SightingTaxon.Resolved resolved;

        public SpeciesEntryEvent(SightingTaxon.Resolved resolved) {
            this.resolved = resolved;
        }

        public SightingTaxon.Resolved getResolved() {
            return this.resolved;
        }
    }

    public static interface SpeciesEntryListener
    extends EventListener {
        public void addSpecies(SpeciesEntryEvent var1);
    }
}

