/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.TransposedChecklists;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.LocalNames;
import com.scythebill.birdlist.model.util.TaxonNames;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.guice.IOC;
import com.scythebill.birdlist.ui.messages.Messages;
import java.net.URL;
import java.util.ArrayList;

public class SpeciesInfoDescriber {
    private static final String SHOW_MAP_URL_HOST = "scythebill.map";
    private final Taxonomy clements;
    private final MappedTaxonomy ioc;
    private static final Joiner NAME_JOINER = Joiner.on('/');

    @Inject
    public SpeciesInfoDescriber(@Clements Taxonomy clements, @IOC MappedTaxonomy ioc) {
        this.clements = clements;
        this.ioc = ioc;
    }

    public void toHtmlText(SightingTaxon.Resolved taxon, ReportSet reportSet, Checklist checklist, Location checklistLocation, StringBuilder builder) {
        this.toHtmlText(taxon, reportSet, builder, true);
        if (checklist != null) {
            SightingTaxon species = taxon.getParentOfAtLeastType(Taxon.Type.species);
            Checklist.Status status = checklist.getStatus(taxon.getTaxonomy(), species);
            if (status == null) {
                if (taxon.getTaxonStatus() != Species.Status.DO && species.getType() != SightingTaxon.Type.SP && species.getType() != SightingTaxon.Type.HYBRID) {
                    builder.append("<p><b>");
                    builder.append(Messages.getFormattedMessage(Messages.Name.NOT_ON_THE_CHECKLIST_FORMAT, HtmlResponseWriter.htmlEscape(checklistLocation.getDisplayName())));
                    builder.append("</b>");
                }
            } else if (status != Checklist.Status.NATIVE) {
                Messages.Name statusFormat = switch (status) {
                    case Checklist.Status.ENDEMIC -> Messages.Name.ENDEMIC_TO_FORMAT;
                    case Checklist.Status.ESCAPED -> Messages.Name.ESCAPEE_IN_FORMAT;
                    case Checklist.Status.INTRODUCED -> Messages.Name.INTRODUCED_IN_FORMAT;
                    case Checklist.Status.EXTINCT -> Messages.Name.EXTINCT_IN_FORMAT;
                    case Checklist.Status.RARITY -> Messages.Name.RARITY_IN_FORMAT;
                    case Checklist.Status.RARITY_FROM_INTRODUCED -> Messages.Name.RARITY_FROM_INTRODUCED_IN_FORMAT;
                    default -> throw new AssertionError((Object)"Unexpected status");
                };
                builder.append("<p>");
                builder.append(Messages.getFormattedMessage(statusFormat, HtmlResponseWriter.htmlEscape(checklistLocation.getDisplayName())));
            }
        }
    }

    public void toHtmlText(SightingTaxon.Resolved taxon, ReportSet reportSet, StringBuilder builder, boolean hyperlinkRange) {
        String commonName = taxon.getCommonName();
        builder.append(HtmlResponseWriter.htmlEscape(commonName)).append("<br>");
        String sciName = taxon.getFullName();
        builder.append("<i>").append(HtmlResponseWriter.htmlEscape(sciName)).append("</i>");
        Species.Status taxonStatus = taxon.getTaxonStatus();
        if (taxonStatus != Species.Status.LC) {
            builder.append("<br><b>");
            builder.append(HtmlResponseWriter.htmlEscape(Messages.getText(taxonStatus)));
            builder.append("</b>");
        }
        if (taxon.getTaxonomy().isBuiltIn()) {
            String otherTaxonomyName;
            String otherCommonName = null;
            String otherSciName = null;
            if (taxon.getTaxonomy() == this.clements) {
                otherTaxonomyName = "IOC";
                SightingTaxon.Resolved iocResolved = taxon.getSightingTaxon().resolve(this.ioc);
                if (iocResolved != null) {
                    SightingTaxon.Resolved iocResolvedSpecies = iocResolved.getParentOfAtLeastType(Taxon.Type.species).resolveInternal(this.ioc);
                    if (iocResolved != null) {
                        otherCommonName = iocResolvedSpecies.getCommonName();
                        otherSciName = iocResolved.getFullName();
                    }
                }
            } else {
                otherTaxonomyName = "Clements/eBird";
                SightingTaxon clementsTaxon = this.ioc.getMapping(taxon.getSightingTaxon());
                if (clementsTaxon != null) {
                    SightingTaxon.Resolved clementsResolved = clementsTaxon.resolve(this.clements);
                    SightingTaxon.Resolved clementsResolvedGroup = clementsResolved.getParentOfAtLeastType(Taxon.Type.group).resolveInternal(this.clements);
                    otherCommonName = clementsResolvedGroup.getCommonName();
                    otherSciName = clementsResolved.getFullName();
                }
            }
            if (!(otherCommonName == null || otherSciName == null || otherCommonName.equals(commonName) && otherSciName.equals(sciName))) {
                builder.append("<br><b>");
                builder.append(HtmlResponseWriter.htmlEscape(otherTaxonomyName));
                builder.append(":</b> ");
                builder.append(HtmlResponseWriter.htmlEscape(otherCommonName));
                builder.append(" <i>");
                builder.append(HtmlResponseWriter.htmlEscape(otherSciName));
                builder.append("</i>");
            }
        }
        if (taxon.getType() == SightingTaxon.Type.SINGLE && taxon.getTaxon() instanceof Species) {
            String accountUrl;
            String range;
            Species species = (Species)taxon.getTaxon();
            ArrayList<String> englishNames = Lists.newArrayList();
            LocalNames localNames = species.getTaxonomy().getLocalNames();
            if (species.getCommonName() != null && !species.getCommonName().equals(localNames.getCommonName(species))) {
                englishNames.add(species.getCommonName());
            }
            if (!englishNames.isEmpty()) {
                builder.append("<br><b>");
                builder.append(Messages.getMessage(Messages.Name.ALTERNATE_NAMES_LABEL));
                builder.append("</b> ");
                builder.append(HtmlResponseWriter.htmlEscape(TaxonNames.joinFromEnd(englishNames, NAME_JOINER)));
            }
            if ((range = TaxonUtils.getRange(species)) != null) {
                if (hyperlinkRange && TransposedChecklists.instance().hasTransposedChecklistEntry(reportSet, species)) {
                    builder.append("<br><b><a href=\"http://").append(SHOW_MAP_URL_HOST).append("/").append(species.getId()).append("\">").append(Messages.getMessage(Messages.Name.RANGE_LABEL)).append("</a> </b>");
                } else {
                    builder.append("<br><b>").append(Messages.getMessage(Messages.Name.RANGE_LABEL)).append("</b> ");
                }
                builder.append(HtmlResponseWriter.htmlEscape(range));
            }
            if (species.getAccountId() != null && (accountUrl = species.getTaxonomy().getTaxonAccountUrl(species.getAccountId())) != null) {
                if (builder.length() > 0) {
                    builder.append("<br>");
                }
                builder.append("<b><a href=\"").append(accountUrl).append("\">");
                String linkTitle = species.getTaxonomy().getAccountLinkTitle();
                linkTitle = linkTitle == null ? Messages.getMessage(Messages.Name.TAXON_PAGE) : Messages.getFormattedMessage(Messages.Name.PAGE_FORMAT, linkTitle);
                builder.append(linkTitle);
                builder.append("</a></b>");
            }
            if (species.getTaxonomicInfo() != null) {
                builder.append("<br><b>").append(Messages.getMessage(Messages.Name.TAXONOMY_LABEL)).append("</b> ");
                builder.append(HtmlResponseWriter.htmlEscape(species.getTaxonomicInfo()));
            }
            if (species.getConceptId() != null) {
                String avibaseUrl = String.format("https://avibase.bsc-eoc.org/species.jsp?avibaseid=%s", species.getConceptId());
                if (builder.length() > 0) {
                    builder.append("<br>");
                }
                builder.append("<b><a href=\"").append(avibaseUrl).append("\">Avibase</a></b>");
            }
        }
    }

    public String toPlainText(Species species) {
        String range = TaxonUtils.getRange(species);
        StringBuilder info = new StringBuilder(range == null ? "" : range);
        if (species.getStatus() != Species.Status.LC) {
            if (info.length() > 0) {
                info.append('\n');
            }
            info.append(Messages.getText(species.getStatus()));
        }
        ArrayList<String> englishNames = Lists.newArrayList();
        LocalNames localNames = species.getTaxonomy().getLocalNames();
        if (species.getCommonName() != null && !species.getCommonName().equals(localNames.getCommonName(species))) {
            englishNames.add(species.getCommonName());
        }
        englishNames.addAll(species.getAlternateCommonNames());
        if (!englishNames.isEmpty()) {
            if (info.length() > 0) {
                info.append('\n');
            }
            info.append(TaxonNames.joinFromEnd(englishNames, NAME_JOINER));
        }
        if (species.getTaxonomicInfo() != null) {
            if (info.length() > 0) {
                info.append('\n');
            }
            info.append(species.getTaxonomicInfo());
        }
        return info.toString();
    }

    public String toSimpleLinkedHtmlText(ReportSet reportSet, Species species) {
        String accountUrl;
        StringBuilder info = new StringBuilder();
        String range = TaxonUtils.getRange(species);
        if (range != null) {
            if (TransposedChecklists.instance().hasTransposedChecklistEntry(reportSet, species)) {
                info = new StringBuilder("<a href=\"http://").append(SHOW_MAP_URL_HOST).append("/").append(species.getId()).append("\">").append(Messages.getMessage(Messages.Name.RANGE_LABEL)).append("</a> ");
            }
            info.append(range);
        }
        if (species.getAccountId() != null && (accountUrl = species.getTaxonomy().getTaxonAccountUrl(species.getAccountId())) != null) {
            if (info.length() > 0) {
                info.append("<br>");
            }
            info.append("<a href=\"").append(accountUrl).append("\">");
            String linkTitle = species.getTaxonomy().getAccountLinkTitle();
            linkTitle = linkTitle == null ? Messages.getMessage(Messages.Name.TAXON_PAGE) : Messages.getFormattedMessage(Messages.Name.PAGE_FORMAT, linkTitle);
            info.append(linkTitle);
            info.append("</a>");
        }
        if (species.getStatus() != Species.Status.LC) {
            if (info.length() > 0) {
                info.append("<br>");
            }
            info.append(Messages.getText(species.getStatus()));
        }
        ArrayList<String> englishNames = Lists.newArrayList();
        LocalNames localNames = species.getTaxonomy().getLocalNames();
        if (species.getCommonName() != null && !species.getCommonName().equals(localNames.getCommonName(species))) {
            englishNames.add(species.getCommonName());
        }
        englishNames.addAll(species.getAlternateCommonNames());
        if (!englishNames.isEmpty()) {
            if (info.length() > 0) {
                info.append("<br>");
            }
            info.append(TaxonNames.joinFromEnd(englishNames, NAME_JOINER));
        }
        if (species.getTaxonomicInfo() != null) {
            if (info.length() > 0) {
                info.append("<br>");
            }
            info.append(species.getTaxonomicInfo());
        }
        if (species.getConceptId() != null) {
            String avibaseUrl = String.format("https://avibase.bsc-eoc.org/species.jsp?avibaseid=%s", species.getConceptId());
            if (info.length() > 0) {
                info.append("<br>");
            }
            info.append("<a href=\"").append(avibaseUrl).append("\">Avibase</a>");
        }
        return info.toString();
    }

    public static boolean isShowMapUrl(URL url) {
        return SHOW_MAP_URL_HOST.equals(url.getHost());
    }

    public static String getShowMapSpeciesId(URL url) {
        return url.getPath().replace("/", "");
    }
}

