/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.model.util.AlternateName;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import java.util.Set;
import javax.annotation.Nullable;

class SpHybridEntry {
    SpHybridEntry() {
    }

    public static void configureIndexer(IndexerPanel<String> indexerPanel, Taxon taxon, NamesPreferences namePreferences) {
        final Taxonomy taxonomy = taxon.getTaxonomy();
        Taxon root = taxon.getType() == Taxon.Type.species ? TaxonUtils.getParentOfType(taxon, Taxon.Type.family) : TaxonUtils.getParentOfType(taxon, Taxon.Type.species);
        Indexer<String> local = new Indexer<String>();
        Indexer<String> english = new Indexer<String>();
        Indexer<String> sci = new Indexer<String>();
        Indexer alternates = new Indexer();
        SpHybridEntry.buildIndices(local, english, sci, alternates, root, ImmutableSet.of(taxon, root), taxon.getType());
        ToString<String> localToString = new ToString<String>(){

            @Override
            public String getString(String taxonId) {
                Taxon taxon = taxonomy.getTaxon(taxonId);
                return taxon == null ? null : TaxonUtils.getCommonName(taxon);
            }

            @Override
            public String getPreviewString(String taxonId) {
                return this.getString(taxonId);
            }
        };
        ToString<String> englishToString = new ToString<String>(){

            @Override
            public String getString(String taxonId) {
                Taxon taxon = taxonomy.getTaxon(taxonId);
                return taxon == null ? null : TaxonUtils.getEnglishCommonName(taxon);
            }

            @Override
            public String getPreviewString(String taxonId) {
                return this.getString(taxonId);
            }
        };
        ToString<String> sciToString = new ToString<String>(){

            @Override
            public String getString(String taxonId) {
                Taxon taxon = taxonomy.getTaxon(taxonId);
                return taxon == null ? null : TaxonUtils.getFullName(taxon);
            }

            @Override
            public String getPreviewString(String taxonId) {
                return this.getString(taxonId);
            }
        };
        indexerPanel.removeAllIndexerGroups();
        switch (namePreferences.scientificOrCommon) {
            case COMMON_FIRST: {
                indexerPanel.addIndexerGroup(localToString, local);
                indexerPanel.addIndexerGroup(englishToString, english);
                indexerPanel.addAlternateIndexerGroup(localToString, alternates);
            }
            case SCIENTIFIC_ONLY: {
                indexerPanel.addIndexerGroup(sciToString, sci);
                break;
            }
            case SCIENTIFIC_FIRST: {
                indexerPanel.addIndexerGroup(sciToString, sci);
            }
            case COMMON_ONLY: {
                indexerPanel.addIndexerGroup(localToString, local);
                indexerPanel.addIndexerGroup(englishToString, english);
                indexerPanel.addAlternateIndexerGroup(localToString, alternates);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected name order");
            }
        }
        indexerPanel.setOrdering(Suppliers.ofInstance(new ProximityOrdering(taxon)));
        indexerPanel.revalidate();
    }

    private static void buildIndices(Indexer<String> local, Indexer<String> english, Indexer<String> sci, Indexer<AlternateName<String>> alternates, Taxon taxon, Set<Taxon> allExcept, Taxon.Type downToLevel) {
        if (taxon instanceof Species && !allExcept.contains(taxon)) {
            if (taxon.getCommonName() != null || downToLevel == Taxon.Type.subspecies) {
                String englishName;
                String commonName = TaxonUtils.getCommonName(taxon);
                if (!commonName.equals(englishName = TaxonUtils.getEnglishCommonName(taxon))) {
                    local.add(commonName, taxon.getId());
                }
                english.add(englishName, taxon.getId());
            }
            sci.add(TaxonUtils.getFullName(taxon), taxon.getId());
            for (String alternateCommonName : ((Species)taxon).getAlternateCommonNames()) {
                alternates.add(SpHybridEntry.trimSuffixes(alternateCommonName), AlternateName.forNameAndId(alternateCommonName, taxon.getId()));
            }
        }
        if (taxon.getType() == downToLevel) {
            return;
        }
        for (Taxon child : taxon.getContents()) {
            SpHybridEntry.buildIndices(local, english, sci, alternates, child, allExcept, downToLevel);
        }
    }

    private static String trimSuffixes(String alternate) {
        int indexOf = alternate.indexOf(" -");
        if (indexOf > 0) {
            return alternate.substring(0, indexOf);
        }
        return alternate;
    }

    private static class ProximityOrdering
    extends Ordering<String> {
        private final int fromIndex;
        private final Taxonomy taxonomy;

        ProximityOrdering(Taxon from) {
            this.fromIndex = from.getTaxonomyIndex();
            this.taxonomy = from.getTaxonomy();
        }

        @Override
        public int compare(@Nullable String left, @Nullable String right) {
            Taxon leftTaxon = this.taxonomy.getTaxon(left);
            Taxon rightTaxon = this.taxonomy.getTaxon(right);
            int leftDiff = Math.abs(leftTaxon.getTaxonomyIndex() - this.fromIndex);
            int rightDiff = Math.abs(rightTaxon.getTaxonomyIndex() - this.fromIndex);
            return leftDiff - rightDiff;
        }
    }
}

