/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.SpHybridEntry;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class SpHybridDialog {
    private final FontManager fontManager;
    private final NamesPreferences namesPreferences;

    @Inject
    public SpHybridDialog(FontManager fontManager, NamesPreferences namesPreferences) {
        this.fontManager = fontManager;
        this.namesPreferences = namesPreferences;
    }

    public void showDialog(Component parent, Taxon baseTaxon, Listener listener) {
        Dialog.ModalityType modality = Toolkit.getDefaultToolkit().isModalityTypeSupported(Dialog.ModalityType.DOCUMENT_MODAL) ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.APPLICATION_MODAL;
        JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(parent), Messages.getMessage(Messages.Name.CHANGE_TO_SP_OR_HYBRID), modality);
        SpHybridPanel panel = new SpHybridPanel(baseTaxon, dialog, listener);
        dialog.setContentPane(panel);
        this.fontManager.applyTo(dialog);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    class SpHybridPanel
    extends JPanel {
        private JButton spButton;
        private JButton hybridButton;
        private JButton cancelButton;
        private JLabel baseSpeciesText;
        private IndexerPanel<String> indexerPanel;
        private JLabel andText;

        public SpHybridPanel(Taxon baseTaxon, JDialog dialog, Listener listener) {
            this.setBorder(new EmptyBorder(20, 20, 15, 20));
            this.setPreferredSize(SpHybridDialog.this.fontManager.scale(new Dimension(350, 200)));
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            JSeparator separator = new JSeparator();
            String name = switch (SpHybridDialog.this.namesPreferences.scientificOrCommon) {
                case NamesPreferences.ScientificOrCommon.COMMON_FIRST, NamesPreferences.ScientificOrCommon.COMMON_ONLY -> TaxonUtils.getCommonName(baseTaxon);
                case NamesPreferences.ScientificOrCommon.SCIENTIFIC_FIRST, NamesPreferences.ScientificOrCommon.SCIENTIFIC_ONLY -> TaxonUtils.getFullName(baseTaxon);
                default -> throw new AssertionError((Object)("Unexpected name preference: " + SpHybridDialog.this.namesPreferences.scientificOrCommon));
            };
            this.baseSpeciesText = new JLabel();
            this.baseSpeciesText.setText(Messages.getFormattedMessage(Messages.Name.MAKE_SP_OR_HYBRID_FORMAT, name));
            this.andText = new JLabel(Messages.getMessage(Messages.Name.AND_LABEL));
            this.cancelButton = new JButton();
            this.cancelButton.setText(Messages.getMessage(Messages.Name.CANCEL_BUTTON));
            this.cancelButton.addActionListener(e -> dialog.dispose());
            this.spButton = new JButton();
            this.spButton.setText(Messages.getMessage(Messages.Name.SPUH_LABEL));
            this.spButton.addActionListener(e -> this.returnSpOrHybrid(listener, baseTaxon, SightingTaxon.Type.SP, dialog));
            this.hybridButton = new JButton();
            this.hybridButton.setText(Messages.getMessage(Messages.Name.HYBRID_LABEL));
            this.hybridButton.addActionListener(e -> this.returnSpOrHybrid(listener, baseTaxon, SightingTaxon.Type.HYBRID, dialog));
            this.indexerPanel = new IndexerPanel();
            this.indexerPanel.setLayoutStrategy(IndexerPanel.LayoutStrategy.BELOW);
            SpHybridEntry.configureIndexer(this.indexerPanel, baseTaxon, SpHybridDialog.this.namesPreferences);
            this.indexerPanel.setPreviewText(Messages.Name.ENTER_SPECIES);
            this.indexerPanel.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SpHybridPanel.this.hybridButton.setEnabled(evt.getNewValue() != null);
                    SpHybridPanel.this.spButton.setEnabled(evt.getNewValue() != null);
                }
            });
            this.hybridButton.setEnabled(false);
            this.spButton.setEnabled(false);
            JPanel spacer = new JPanel();
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.baseSpeciesText).addGroup(layout.createSequentialGroup().addComponent(this.andText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indexerPanel)).addComponent(spacer).addComponent(separator).addComponent(this.cancelButton, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.hybridButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spButton)));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.baseSpeciesText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.andText).addComponent(this.indexerPanel)).addGap(18).addComponent(spacer, 0, 0, Short.MAX_VALUE).addComponent(separator, -2, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.cancelButton).addComponent(this.hybridButton).addComponent(this.spButton)));
            layout.linkSize(this.cancelButton, this.spButton, this.hybridButton);
            UIUtils.focusOnEntry(this, this.indexerPanel);
            KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
            AbstractAction cancelAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpHybridPanel.this.cancelButton.doClick(100);
                }
            };
            this.getInputMap(1).put(escape, "cancelPanel");
            this.getActionMap().put("cancelPanel", cancelAction);
            this.indexerPanel.getTextComponent().getInputMap(0).put(escape, "cancelPanel");
            this.indexerPanel.getTextComponent().getActionMap().put("cancelPanel", cancelAction);
        }

        private void returnSpOrHybrid(Listener listener, Taxon baseTaxon, SightingTaxon.Type type, JDialog dialog) {
            String taxonId = this.indexerPanel.getValue();
            if (taxonId != null) {
                SightingTaxon newTaxon;
                dialog.dispose();
                Taxonomy taxonomy = baseTaxon.getTaxonomy();
                ImmutableSet<String> ids = ImmutableSet.of(baseTaxon.getId(), taxonId);
                SightingTaxon sightingTaxon = newTaxon = type == SightingTaxon.Type.SP ? SightingTaxons.newSpTaxon(ids) : SightingTaxons.newHybridTaxon(ids);
                if (taxonomy instanceof MappedTaxonomy) {
                    MappedTaxonomy mappedTaxonomy = (MappedTaxonomy)taxonomy;
                    newTaxon = mappedTaxonomy.getMapping(newTaxon).resolve(mappedTaxonomy).getSightingTaxon();
                }
                listener.newTaxon(newTaxon);
            }
        }
    }

    public static interface Listener {
        public void newTaxon(SightingTaxon var1);
    }
}

