/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.sighting.edits.RecentEdits;
import com.scythebill.birdlist.model.sighting.edits.SingleLocationEdit;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.Users;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.components.NewWhenAndWherePanel;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.WizardContentPanel;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class SingleLocationWhenAndWherePanel
extends WizardContentPanel<SingleLocationEdit>
implements Titled,
FontManager.FontsUpdatedListener {
    private final NewWhenAndWherePanel whenAndWhere;
    private final ReportSet reportSet;
    private final FontManager fontManager;
    private final Alerts alerts;
    private final TaxonomyStore taxonomyStore;
    private final RecentEdits recentEdits;
    private JRadioButton visitRadio;
    private JRadioButton tripRadio;
    private JLabel recentEditsLabel;
    private JComboBox<UIRecentEdit> recentEditsCombo;
    private ButtonGroup visitOrTripGroup;

    @Inject
    public SingleLocationWhenAndWherePanel(NewWhenAndWherePanel whenAndWhere, ReportSet reportSet, FontManager fontManager, TaxonomyStore taxonomyStore, Alerts alerts, RecentEdits recentEdits) {
        super("whenAndWhere", SingleLocationEdit.class);
        this.whenAndWhere = whenAndWhere;
        this.reportSet = reportSet;
        this.fontManager = fontManager;
        this.taxonomyStore = taxonomyStore;
        this.alerts = alerts;
        this.recentEdits = recentEdits;
        this.initGUI();
        this.hookUpContents();
    }

    private void hookUpContents() {
        PropertyChangeListener whereListener = e -> {
            ((SingleLocationEdit)this.wizardValue()).setLocation(this.whenAndWhere.getWhere());
            ((SingleLocationEdit)this.wizardValue()).setLocationName(this.whenAndWhere.getWhereText());
            this.updateComplete();
        };
        this.whenAndWhere.addPropertyChangeListener("where", whereListener);
        this.whenAndWhere.addPropertyChangeListener("whereText", whereListener);
        this.whenAndWhere.addPropertyChangeListener("wherePopupVisible", whereListener);
        this.whenAndWhere.addPropertyChangeListener("when", e -> {
            ((SingleLocationEdit)this.wizardValue()).setDate(this.whenAndWhere.getWhen());
            this.updateComplete();
        });
        this.whenAndWhere.addPropertyChangeListener("time", e -> ((SingleLocationEdit)this.wizardValue()).setTime(this.whenAndWhere.getTime()));
        this.whenAndWhere.addPropertyChangeListener("endWhen", e -> {
            ((SingleLocationEdit)this.wizardValue()).setEndDate(this.whenAndWhere.getEndWhen());
            this.updateComplete();
        });
        this.whenAndWhere.addPropertyChangeListener("endTime", e -> ((SingleLocationEdit)this.wizardValue()).setEndTime(this.whenAndWhere.getEndTime()));
        this.whenAndWhere.addPropertyChangeListener("who", e -> ((SingleLocationEdit)this.wizardValue()).setUsers(this.whenAndWhere.getWho()));
        this.recentEditsCombo.addActionListener(e -> this.changeRecentEdit());
        ActionListener updateVisitOrTrip = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleLocationWhenAndWherePanel.this.updateVisitOrTrip();
                ((SingleLocationEdit)SingleLocationWhenAndWherePanel.this.wizardValue()).setTrip(SingleLocationWhenAndWherePanel.this.tripRadio.isSelected());
                ((SingleLocationEdit)SingleLocationWhenAndWherePanel.this.wizardValue()).setEndDate(SingleLocationWhenAndWherePanel.this.whenAndWhere.getEndWhen());
                ((SingleLocationEdit)SingleLocationWhenAndWherePanel.this.wizardValue()).setEndTime(SingleLocationWhenAndWherePanel.this.whenAndWhere.getEndTime());
                SingleLocationWhenAndWherePanel.this.updateComplete();
            }
        };
        this.visitRadio.addActionListener(updateVisitOrTrip);
        this.tripRadio.addActionListener(updateVisitOrTrip);
    }

    private void updateVisitOrTrip() {
        this.whenAndWhere.setShowTripSettings(this.tripRadio.isSelected());
    }

    private void changeRecentEdit() {
        UIRecentEdit recentEdit = (UIRecentEdit)this.recentEditsCombo.getSelectedItem();
        if (!recentEdit.isNull()) {
            if (recentEdit.isTrip()) {
                this.tripRadio.setSelected(true);
                this.whenAndWhere.setShowTripSettings(true);
                this.whenAndWhere.setWhere(recentEdit.getLocation());
                this.whenAndWhere.setWhen(recentEdit.getDate());
                this.whenAndWhere.setTime(recentEdit.getStartTime());
                this.whenAndWhere.setEndWhen(recentEdit.getEndDate());
                this.whenAndWhere.setEndTime(recentEdit.getEndTime());
                Trip matchingTrip = ((SingleLocationEdit)this.wizardValue()).findMatchingTrip(this.reportSet);
                if (matchingTrip != null) {
                    this.whenAndWhere.setWho(Users.usersForTrip(this.reportSet, matchingTrip));
                }
            } else {
                VisitInfoKey visitInfoKey = recentEdit.asVisitInfoKey();
                this.setVisitInfoKeyAndUsers(visitInfoKey, Users.usersForVisitInfoKey(this.reportSet, visitInfoKey));
            }
            ((SingleLocationEdit)this.wizardValue()).clearSnapshot();
        }
    }

    @Override
    protected void shown() {
        super.shown();
        this.visitOrTripGroup.setSelected(((SingleLocationEdit)this.wizardValue()).isTrip() ? this.tripRadio.getModel() : this.visitRadio.getModel(), true);
        this.updateVisitOrTrip();
        this.whenAndWhere.setWhen(((SingleLocationEdit)this.wizardValue()).getDate());
        this.whenAndWhere.setTime(((SingleLocationEdit)this.wizardValue()).getTime());
        if (((SingleLocationEdit)this.wizardValue()).isTrip()) {
            this.whenAndWhere.setEndWhen(((SingleLocationEdit)this.wizardValue()).getEndDate());
            this.whenAndWhere.setEndTime(((SingleLocationEdit)this.wizardValue()).getEndTime());
        }
        if (((SingleLocationEdit)this.wizardValue()).getLocation() != null) {
            this.whenAndWhere.setWhere(((SingleLocationEdit)this.wizardValue()).getLocation());
        } else if (!this.whenAndWhere.getWhereText().equals(((SingleLocationEdit)this.wizardValue()).getLocationName())) {
            this.whenAndWhere.setWhereText(((SingleLocationEdit)this.wizardValue()).getLocationName());
        }
        this.whenAndWhere.setWho(((SingleLocationEdit)this.wizardValue()).getUsers());
        this.whenAndWhere.shown();
    }

    public boolean hasWhen() {
        return this.whenAndWhere.hasWhen();
    }

    public boolean hasEndWhen() {
        return this.whenAndWhere.hasEndWhen();
    }

    public boolean hasWhere() {
        return this.whenAndWhere.hasWhere();
    }

    public void setVisitInfoKeyAndUsers(VisitInfoKey visitInfoKey, Collection<User> users) {
        this.visitRadio.setSelected(true);
        this.whenAndWhere.setShowTripSettings(false);
        Location location = this.reportSet.getLocations().getLocation(visitInfoKey.locationId());
        this.whenAndWhere.setWhere(location);
        this.whenAndWhere.setWhen(visitInfoKey.date());
        this.whenAndWhere.setTime(visitInfoKey.startTime().orNull());
        this.whenAndWhere.setWho(users);
    }

    public void setTripAndUsers(Trip trip, Collection<User> users) {
        this.tripRadio.setSelected(true);
        Location location = trip.locationId() == null ? null : this.reportSet.getLocations().getLocation(trip.locationId());
        this.whenAndWhere.setShowTripSettings(true);
        this.whenAndWhere.setWhere(location);
        this.whenAndWhere.setWhen(trip.startDate());
        this.whenAndWhere.setTime(trip.startTime());
        this.whenAndWhere.setEndWhen(trip.endDate());
        this.whenAndWhere.setEndTime(trip.endTime());
        this.whenAndWhere.setWho(users);
    }

    private void updateComplete() {
        boolean isInvalidTrip = ((SingleLocationEdit)this.wizardValue()).isTrip() ? ((SingleLocationEdit)this.wizardValue()).getDate() == null || ((SingleLocationEdit)this.wizardValue()).getEndDate() == null : false;
        this.setComplete(!isInvalidTrip && !this.whenAndWhere.isWherePopupVisible() && (((SingleLocationEdit)this.wizardValue()).getLocation() != null || !Strings.isNullOrEmpty(((SingleLocationEdit)this.wizardValue()).getLocationName())));
    }

    private void initGUI() {
        this.visitRadio = new JRadioButton("Enter sightings for a single visit (one location on one day)");
        this.tripRadio = new JRadioButton("Enter sightings for a trip (multiple days)");
        this.visitOrTripGroup = new ButtonGroup();
        this.visitOrTripGroup.add(this.visitRadio);
        this.visitOrTripGroup.add(this.tripRadio);
        this.recentEditsLabel = new JLabel(Messages.getMessage(Messages.Name.OR_CHOOSE_A_RECENT_VISIT));
        List<RecentEdits.RecentEdit> recentEditsList = this.recentEdits.getRecentEditsList();
        if (recentEditsList.size() < 10) {
            for (RecentEdits.RecentEdit recentEdit : RecentEdits.getLastEdits(this.reportSet, 10)) {
                if (recentEditsList.contains(recentEdit)) continue;
                recentEditsList.add(recentEdit);
                if (recentEditsList.size() != 10) continue;
                break;
            }
        }
        List<UIRecentEdit> uiRecentEdits = this.toUIRecentEdits(recentEditsList);
        this.recentEditsCombo = new JComboBox<UIRecentEdit>(uiRecentEdits.toArray(new UIRecentEdit[0]));
        this.recentEditsCombo.setMaximumRowCount(this.recentEditsCombo.getItemCount());
        if (this.recentEditsCombo.getItemCount() == 1) {
            this.recentEditsLabel.setVisible(false);
            this.recentEditsCombo.setVisible(false);
        }
        this.fontManager.applyTo(this);
    }

    @Override
    public String getTitle() {
        if (this.reportSet.getUserSet() != null) {
            return Messages.getMessage(Messages.Name.WHO_WHEN_WHERE);
        }
        return Messages.getMessage(Messages.Name.WHEN_AND_WHERE);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setPreferredSize(fontManager.scale(new Dimension(400, 300)));
        GroupLayout layout = new GroupLayout(this);
        layout.setHonorsVisibility(true);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.visitRadio).addComponent(this.tripRadio).addComponent(this.whenAndWhere).addGroup(layout.createSequentialGroup().addGap(10).addGroup(layout.createParallelGroup().addComponent(this.recentEditsLabel).addComponent(this.recentEditsCombo, -2, -2, -2))));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.visitRadio).addComponent(this.tripRadio).addComponent(this.whenAndWhere).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.recentEditsLabel).addComponent(this.recentEditsCombo, -2, -2, -2));
    }

    @Override
    protected boolean leaving(boolean validateLeaving) {
        int year;
        boolean allowLeaving = validateLeaving ? (((SingleLocationEdit)this.wizardValue()).getDate() == null ? this.alerts.showYesNo((Object)this, Messages.Name.YOU_DIDNT_ENTER_A_DATE_TITLE, Messages.Name.YOU_DIDNT_ENTER_A_DATE_MESSAGE, new Object[0]) == 0 : (((SingleLocationEdit)this.wizardValue()).getDate().isSupported(DateTimeFieldType.year()) ? ((year = ((SingleLocationEdit)this.wizardValue()).getDate().get(DateTimeFieldType.year())) < DateTime.now().getYear() - 100 ? this.alerts.showYesNo((Object)this, Messages.Name.YEAR_MAY_BE_WRONG, Messages.Name.YEAR_IS_FAR_IN_THE_PAST_MESSAGE, year) == 0 : (year > DateTime.now().getYear() ? this.alerts.showYesNo((Object)this, Messages.Name.YEAR_MAY_BE_WRONG, Messages.Name.YEAR_IS_IN_THE_FUTURE_MESSAGE, year) == 0 : true)) : true)) : true;
        if (allowLeaving) {
            SingleLocationEdit edit = (SingleLocationEdit)this.wizardValue();
            boolean snapshot = true;
            if (edit.getDirty().isDirty()) {
                SingleLocationEdit.ExistingSightingSnapshotState snapshotState = edit.getSnapshotState();
                Messages.Name title = null;
                Messages.Name text = null;
                switch (snapshotState) {
                    case NONE: 
                    case NO_CHANGE: {
                        snapshot = ((SingleLocationEdit)this.wizardValue()).isEmpty();
                        break;
                    }
                    case DATE_CHANGED: {
                        title = Messages.Name.DATE_HAS_CHANGED_TITLE;
                        text = Messages.Name.DATE_HAS_CHANGED_MESSAGE;
                        break;
                    }
                    case LOCATION_CHANGED: {
                        title = Messages.Name.LOCATION_HAS_CHANGED_TITLE;
                        text = Messages.Name.LOCATION_HAS_CHANGED_MESSAGE;
                        break;
                    }
                    case DATE_AND_TIME_CHANGED: {
                        title = Messages.Name.DATE_AND_TIME_HAS_CHANGED_TITLE;
                        text = Messages.Name.DATE_AND_TIME_HAS_CHANGED_MESSAGE;
                        break;
                    }
                    case TIME_CHANGED: {
                        title = Messages.Name.TIME_HAS_CHANGED_TITLE;
                        text = Messages.Name.TIME_HAS_CHANGED_MESSAGE;
                        break;
                    }
                    case TIME_AND_LOCATION_CHANGED: {
                        title = Messages.Name.TIME_AND_LOCATION_HAS_CHANGED_TITLE;
                        text = Messages.Name.TIME_AND_LOCATION_HAS_CHANGED_MESSAGE;
                        break;
                    }
                    case DATE_AND_LOCATION_CHANGED: {
                        title = Messages.Name.DATE_AND_LOCATION_HAS_CHANGED_TITLE;
                        text = Messages.Name.DATE_AND_LOCATION_HAS_CHANGED_MESSAGE;
                        break;
                    }
                    case DATE_AND_AND_TIME_AND_LOCATION_CHANGED: {
                        title = Messages.Name.DATE_AND_TIME_AND_LOCATION_HAS_CHANGED_TITLE;
                        text = Messages.Name.DATE_AND_TIME_AND_LOCATION_HAS_CHANGED_MESSAGE;
                    }
                }
                if (title != null) {
                    int showConfirm = this.alerts.showConfirm((Object)this, title, text, new Object[0]);
                    if (showConfirm == 0) {
                        snapshot = false;
                    } else if (showConfirm == 1) {
                        snapshot = true;
                    } else {
                        return false;
                    }
                }
            }
            if (snapshot) {
                edit.snapshotExistingSightings(this.reportSet, this.taxonomyStore.getTaxonomy());
            }
        }
        return allowLeaving;
    }

    private List<UIRecentEdit> toUIRecentEdits(List<RecentEdits.RecentEdit> recentEditsList) {
        ArrayList<UIRecentEdit> uiRecentEdits = Lists.newArrayList(new UIRecentEdit());
        for (RecentEdits.RecentEdit recentEdit : recentEditsList) {
            Location location = this.reportSet.getLocations().getLocation(recentEdit.getLocationId());
            if (location == null || recentEdit.getDate() == null) continue;
            if (recentEdit.getEndDate() == null) {
                uiRecentEdits.add(new UIRecentEdit(location, recentEdit.getDate(), recentEdit.getStartTime()));
                continue;
            }
            uiRecentEdits.add(new UIRecentEdit(location, recentEdit.getDate(), recentEdit.getStartTime(), recentEdit.getEndDate(), recentEdit.getEndTime()));
        }
        return uiRecentEdits;
    }

    static class UIRecentEdit {
        private final ReadablePartial date;
        private final LocalTime startTime;
        private final ReadablePartial endDate;
        private final LocalTime endTime;
        private final Location location;
        private final String dateString;
        private final String endDateString;
        private final String startTimeString;
        private final String endTimeString;

        UIRecentEdit() {
            this.location = null;
            this.date = null;
            this.dateString = null;
            this.startTime = null;
            this.startTimeString = null;
            this.endDate = null;
            this.endDateString = null;
            this.endTime = null;
            this.endTimeString = null;
        }

        public boolean isTrip() {
            return this.endDate != null;
        }

        public boolean isNull() {
            return this.dateString == null;
        }

        UIRecentEdit(Location location, ReadablePartial date, LocalTime time) {
            this(location, date, time, null, null);
        }

        public UIRecentEdit(Location location, ReadablePartial date, LocalTime time, ReadablePartial endDate, LocalTime endTime) {
            this.location = Preconditions.checkNotNull(location);
            this.date = Preconditions.checkNotNull(date);
            this.dateString = PartialIO.toShortUserString(date, Locale.getDefault());
            this.startTime = time;
            this.startTimeString = time == null ? null : TimeIO.toShortUserString(this.startTime, Locale.getDefault());
            this.endDate = endDate;
            this.endDateString = endDate == null ? null : PartialIO.toShortUserString(endDate, Locale.getDefault());
            this.endTime = endTime;
            this.endTimeString = endTime == null ? null : TimeIO.toShortUserString(endTime, Locale.getDefault());
        }

        public VisitInfoKey asVisitInfoKey() {
            return new VisitInfoKey(this.location.getId(), this.date, this.startTime);
        }

        public Location getLocation() {
            return this.location;
        }

        public ReadablePartial getDate() {
            return this.date;
        }

        public LocalTime getStartTime() {
            return this.startTime;
        }

        public ReadablePartial getEndDate() {
            return this.endDate;
        }

        public LocalTime getEndTime() {
            return this.endTime;
        }

        public int hashCode() {
            return Objects.hashCode(this.location, this.date, this.startTime, this.endDate, this.endTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UIRecentEdit)) {
                return false;
            }
            UIRecentEdit that = (UIRecentEdit)o;
            return Objects.equal(this.location, that.location) && Objects.equal(this.date, that.date) && Objects.equal(this.startTime, that.startTime) && Objects.equal(this.endDate, that.endDate) && Objects.equal(this.endTime, that.endTime);
        }

        public String toString() {
            if (this.dateString == null) {
                return "";
            }
            if (this.endDate == null) {
                if (this.startTime == null) {
                    return String.format("%s: %s", this.location.getDisplayName(), this.dateString);
                }
                return String.format("%s: %s %s", this.location.getDisplayName(), this.dateString, this.startTimeString);
            }
            if (this.endDateString.equals(this.dateString)) {
                if (this.startTime != null && this.endTime != null) {
                    if (this.startTime.equals(this.endTime)) {
                        return String.format("%s: %s %s", this.location.getDisplayName(), this.dateString, this.startTimeString);
                    }
                    return String.format("%s: %s %s-%s", this.location.getDisplayName(), this.dateString, this.startTimeString, this.endTimeString);
                }
                return String.format("%s: %s", this.location.getDisplayName(), this.dateString);
            }
            return String.format("%s: %s-%s", this.location.getDisplayName(), this.dateString, this.endDateString);
        }
    }
}

