/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.edits.SingleLocationEdit;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.components.VisitInfoPanel;
import com.scythebill.birdlist.ui.components.VisitInfoPreferences;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.DataEntryPreferences;
import com.scythebill.birdlist.ui.panels.WizardContentPanel;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;

public class SingleLocationVisitInfoPanel
extends WizardContentPanel<SingleLocationEdit>
implements Titled,
FontManager.FontsUpdatedListener {
    private final VisitInfoPanel visitInfoPanel;
    private final FontManager fontManager;
    private final DataEntryPreferences dataEntryPreferences;
    private final PropertyChangeListener editedListener;

    @Inject
    public SingleLocationVisitInfoPanel(FontManager fontManager, DataEntryPreferences dataEntryPreferences, VisitInfoPreferences visitInfoPreferences, FileDialogs fileDialogs, Alerts alerts) {
        super("visitInfo", SingleLocationEdit.class);
        this.fontManager = fontManager;
        this.dataEntryPreferences = dataEntryPreferences;
        this.visitInfoPanel = new VisitInfoPanel(null, fontManager, visitInfoPreferences, fileDialogs, alerts);
        this.editedListener = e -> ((SingleLocationEdit)this.wizardValue()).edited();
        this.visitInfoPanel.addPropertyChangeListener("validValue", evt -> this.setComplete((Boolean)evt.getNewValue()));
        this.setComplete(this.visitInfoPanel.isValidValue());
    }

    @Override
    protected void shown() {
        super.shown();
        this.visitInfoPanel.setStartTime(((SingleLocationEdit)this.wizardValue()).getTime());
        VisitInfo visitInfo = ((SingleLocationEdit)this.wizardValue()).getVisitInfo();
        if (visitInfo != null && visitInfo.hasData()) {
            if (!this.visitInfoPanel.isValidValue() || !this.visitInfoPanel.getValue().equals(visitInfo)) {
                try {
                    this.visitInfoPanel.setValue(visitInfo);
                }
                catch (IllegalArgumentException e) {
                    if (this.visitInfoPanel.isValidValue()) {
                        ((SingleLocationEdit)this.wizardValue()).setVisitInfo(this.visitInfoPanel.getValue());
                    }
                }
            }
        } else if (visitInfo == null) {
            this.visitInfoPanel.tryDefaultObservationType(this.dataEntryPreferences.observationType);
            if (!((SingleLocationEdit)this.wizardValue()).getUsers().isEmpty()) {
                this.visitInfoPanel.setPartySize(((SingleLocationEdit)this.wizardValue()).getUsers().size());
            }
        }
        this.setComplete(this.visitInfoPanel.isValidValue());
        this.visitInfoPanel.addPropertyChangeListener("value", this.editedListener);
        this.fontManager.applyTo(this);
    }

    @Override
    protected boolean leaving(boolean validateLeaving) {
        if (this.visitInfoPanel.isValidValue()) {
            ((SingleLocationEdit)this.wizardValue()).setVisitInfo(this.visitInfoPanel.getValue());
        } else {
            ((SingleLocationEdit)this.wizardValue()).setVisitInfo(null);
        }
        this.visitInfoPanel.removePropertyChangeListener("value", this.editedListener);
        return true;
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.VISIT_DATA_TITLE);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setPreferredSize(fontManager.scale(new Dimension(400, 300)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.visitInfoPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.visitInfoPanel));
    }
}

