/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Link;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.sighting.edits.SingleLocationEdit;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.components.links.DefaultLinkClickedListener;
import com.scythebill.birdlist.ui.components.links.LinksListPanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.WizardContentPanel;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SingleLocationTripInfoPanel
extends WizardContentPanel<SingleLocationEdit>
implements Titled,
FontManager.FontsUpdatedListener {
    private JTextField nameField;
    private JScrollPane notesScrollPane;
    private final FontManager fontManager;
    private JLabel nameLabel;
    private JLabel notesLabel;
    private JTextArea notesArea;
    private FileDialogs fileDialogs;
    private Alerts alerts;
    private LinksListPanel<Link> linksListPanel;
    private DocumentListener nameAndNotesListener;
    private PropertyChangeListener linksListener;

    @Inject
    public SingleLocationTripInfoPanel(FontManager fontManager, FileDialogs fileDialogs, Alerts alerts) {
        super("tripInfo", SingleLocationEdit.class);
        this.fontManager = fontManager;
        this.fileDialogs = fileDialogs;
        this.alerts = alerts;
        this.initGUI();
        this.hookUpContents();
    }

    private void initGUI() {
        this.nameLabel = new JLabel(Messages.getMessage(Messages.Name.TRIP_NAME_LABEL));
        this.nameField = new JTextField(40);
        this.notesLabel = new JLabel(Messages.getMessage(Messages.Name.TRIP_NOTES_LABEL));
        this.notesScrollPane = new JScrollPane();
        this.notesArea = new JTextArea(8, 20);
        this.notesArea.setWrapStyleWord(true);
        this.notesArea.setLineWrap(true);
        this.notesScrollPane.setViewportView(this.notesArea);
        DefaultLinkClickedListener<Link> linkClicked = new DefaultLinkClickedListener<Link>((Component)this, this.fileDialogs, this.alerts){

            @Override
            protected Messages.Name shouldFindFileMessage() {
                return Messages.Name.LINK_NOT_THERE_ANYMORE;
            }

            @Override
            protected Link newLink(File file) {
                return new Link(file);
            }

            @Override
            protected void replaceLink(Link oldLink, Link newLink) {
                int index = ((SingleLocationEdit)SingleLocationTripInfoPanel.this.wizardValue()).getTripLinks().indexOf(oldLink);
                if (index >= 0) {
                    ArrayList<Link> links = new ArrayList<Link>(((SingleLocationEdit)SingleLocationTripInfoPanel.this.wizardValue()).getTripLinks());
                    links.set(index, newLink);
                    ((SingleLocationEdit)SingleLocationTripInfoPanel.this.wizardValue()).setTripLinks(links);
                    SingleLocationTripInfoPanel.this.linksListPanel.setLinks(links);
                }
            }
        };
        this.linksListPanel = new LinksListPanel<Link>(this.fontManager, this.fileDialogs, (LinksListPanel.LinkClickedListener)linkClicked){

            @Override
            protected Messages.Name dragLinkName() {
                return Messages.Name.DRAG_TRIP_LINK_OR_CLICK;
            }

            @Override
            protected Messages.Name chooseLinkName() {
                return Messages.Name.CHOOSE_A_LINK;
            }

            @Override
            protected Messages.Name linkFileName() {
                return Messages.Name.LINK_FILE;
            }

            @Override
            protected Link newLink(URI uri) {
                return new Link(uri);
            }

            @Override
            protected Link newLink(File file) {
                return new Link(file);
            }
        };
    }

    private void hookUpContents() {
        this.nameAndNotesListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SingleLocationTripInfoPanel.this.updateNameAndNotes();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SingleLocationTripInfoPanel.this.updateNameAndNotes();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SingleLocationTripInfoPanel.this.updateNameAndNotes();
            }
        };
        this.linksListener = e -> ((SingleLocationEdit)this.wizardValue()).edited();
    }

    @Override
    protected void shown() {
        super.shown();
        if (Strings.isNullOrEmpty(((SingleLocationEdit)this.wizardValue()).getTripName())) {
            String dateString = Trips.rangeToUserString(((SingleLocationEdit)this.wizardValue()).getDate(), ((SingleLocationEdit)this.wizardValue()).getEndDate(), this.getLocale());
            String locationString = ((SingleLocationEdit)this.wizardValue()).getLocationName();
            String defaultTripName = dateString == null ? locationString : (Strings.isNullOrEmpty(locationString) ? dateString : String.format("%s, %s", locationString, dateString));
            ((SingleLocationEdit)this.wizardValue()).setTripName(defaultTripName);
        }
        this.nameField.setText(Strings.nullToEmpty(((SingleLocationEdit)this.wizardValue()).getTripName()));
        this.notesArea.setText(Strings.nullToEmpty(((SingleLocationEdit)this.wizardValue()).getTripNotes()));
        this.linksListPanel.setLinks(((SingleLocationEdit)this.wizardValue()).getTripLinks());
        this.setComplete(this.isValidTrip());
        this.nameField.getDocument().addDocumentListener(this.nameAndNotesListener);
        this.notesArea.getDocument().addDocumentListener(this.nameAndNotesListener);
        this.linksListPanel.addPropertyChangeListener("links", this.linksListener);
        this.fontManager.applyTo(this);
    }

    private boolean isValidTrip() {
        return !this.nameField.getText().isBlank();
    }

    private void updateNameAndNotes() {
        ((SingleLocationEdit)this.wizardValue()).setTripName(Strings.emptyToNull(this.nameField.getText()));
        ((SingleLocationEdit)this.wizardValue()).setTripNotes(Strings.emptyToNull(this.notesArea.getText()));
        ((SingleLocationEdit)this.wizardValue()).edited();
        this.setComplete(this.isValidTrip());
    }

    @Override
    protected boolean leaving(boolean validateLeaving) {
        ((SingleLocationEdit)this.wizardValue()).setTripLinks(this.linksListPanel.getLinks());
        boolean retValue = super.leaving(validateLeaving);
        if (retValue) {
            this.nameField.getDocument().removeDocumentListener(this.nameAndNotesListener);
            this.notesArea.getDocument().removeDocumentListener(this.nameAndNotesListener);
            this.linksListPanel.removePropertyChangeListener("links", this.linksListener);
        }
        return retValue;
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.TRIP_DETAILS);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setPreferredSize(fontManager.scale(new Dimension(400, 300)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.nameLabel).addComponent(this.nameField, -2, -2, -2).addComponent(this.notesLabel).addComponent(this.notesScrollPane).addComponent(this.linksListPanel, -2, -2, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameField, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.notesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.notesScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.linksListPanel));
    }
}

