/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectoryBase;
import com.drew.metadata.iptc.IptcDirectory;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.ApproximateNumber;
import com.scythebill.birdlist.model.sighting.Link;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.edits.SingleLocationEdit;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.util.ResolvedComparator;
import com.scythebill.birdlist.model.util.ToString;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.components.ChecklistSpeciesTablePanel;
import com.scythebill.birdlist.ui.components.DirectSpeciesTablePanel;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.SightingInfoPanel;
import com.scythebill.birdlist.ui.components.SpeciesTablePanel;
import com.scythebill.birdlist.ui.components.links.BasicLinkClickedListener;
import com.scythebill.birdlist.ui.components.links.LinkDrops;
import com.scythebill.birdlist.ui.components.photos.PhotosListPanel;
import com.scythebill.birdlist.ui.components.table.DelayedUI;
import com.scythebill.birdlist.ui.components.table.ExpandableTable;
import com.scythebill.birdlist.ui.components.table.LabelColumn;
import com.scythebill.birdlist.ui.components.table.TableRowsModel;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.DataEntryPreferences;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.SpeciesSpHybridEntryPanel;
import com.scythebill.birdlist.ui.panels.WizardContentPanel;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.FindSpeciesInText;
import com.scythebill.birdlist.ui.util.Icons;
import com.scythebill.birdlist.ui.util.LocationTaxonScorer;
import com.scythebill.birdlist.ui.util.ScanSeenTaxa;
import com.scythebill.birdlist.ui.util.SightingFlags;
import com.scythebill.birdlist.ui.util.SubspeciesToString;
import com.scythebill.birdlist.ui.util.TaxonScorer;
import com.scythebill.birdlist.ui.util.ToStringListCellRenderer;
import com.scythebill.birdlist.ui.util.UIUtils;
import com.scythebill.birdlist.ui.util.UiFutures;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadablePartial;

public class SingleLocationSpeciesListPanel
extends WizardContentPanel<SingleLocationEdit>
implements Titled {
    private final TaxonomyStore taxonomyStore;
    private final Alerts alerts;
    private Taxonomy taxonomy;
    private final FontManager fontManager;
    private SpeciesTablePanel speciesTablePanel;
    private JComboBox<Taxon> currentSubspeciesComboBox;
    private final ReportSet reportSet;
    private TaxonScorer locationScorer;
    private final ListeningExecutorService executorService;
    private final Checklists checklists;
    private volatile Future<?> scorerFuture;
    private SpeciesSpHybridEntryPanel speciesEntryPanel;
    private ScanSeenTaxa scanSeenTaxa;
    private Checklist checklist;
    private Taxon subspeciesPopupTaxon;
    private JComboBox<DataEntryPreferences.ChecklistUse> checklistCombo;
    private JCheckBox completeCheckbox;
    private JLabel speciesCountLabel;
    private final ListCellRenderer<String> defaultRenderer = new JComboBox().getRenderer();
    private final ToString<Taxon> subspeciesToString = new SubspeciesToString();
    private final ActionListener checklistUpdated = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            SingleLocationSpeciesListPanel.this.dataEntryPreferences.checklistUse = (DataEntryPreferences.ChecklistUse)((Object)SingleLocationSpeciesListPanel.this.checklistCombo.getSelectedItem());
            SingleLocationSpeciesListPanel.this.rebuildTable(SingleLocationSpeciesListPanel.this.taxonomy);
        }
    };
    private JLabel checklistLabel;
    private final DataEntryPreferences dataEntryPreferences;
    private NewForColumn sightingInfoColumn;
    private final FileDialogs fileDialogs;
    private final QueryPreferences queryPreferences;
    private JComponent speciesInfoPane;
    private ImageIcon cameraIcon;
    private ImageIcon cameraIconActive;
    private Icon cameraIconWhite;
    private PhotosListPanel photosListPanel;
    private static final Object TAXON_KEY = new Object();
    private Location checklistLocation;
    private Location countryLocation;
    private Location stateLocation;
    private Location countyLocation;
    private static final Object FIRE_PENDING_ACTION = "firePendingAction";
    private static final Object POPUP_WILL_BE_VISIBLE = "popupWillBeVisible";
    private static final Joiner COMMA_JOINER = Joiner.on(',');

    @Inject
    public SingleLocationSpeciesListPanel(TaxonomyStore taxonomyStore, SpeciesSpHybridEntryPanel speciesEntryPanel, FontManager fontManager, ReportSet reportSet, ListeningExecutorService executorService, EventBusRegistrar eventBusRegistrar, Alerts alerts, Checklists checklists, DataEntryPreferences dataEntryPreferences, QueryPreferences queryPreferences, FileDialogs fileDialogs) {
        super("speciesList", SingleLocationEdit.class);
        this.taxonomyStore = taxonomyStore;
        this.speciesEntryPanel = speciesEntryPanel;
        this.fontManager = fontManager;
        this.reportSet = reportSet;
        this.executorService = executorService;
        this.alerts = alerts;
        this.checklists = checklists;
        this.dataEntryPreferences = dataEntryPreferences;
        this.queryPreferences = queryPreferences;
        this.fileDialogs = fileDialogs;
        this.cameraIcon = SingleLocationSpeciesListPanel.cameraIcon();
        this.cameraIconActive = SingleLocationSpeciesListPanel.cameraIconActive();
        this.cameraIconWhite = Icons.getWhiteIcon(this, this.cameraIcon);
        this.initComponents();
        KeyStroke focusOnSpecies = UIUtils.isMacOS() ? KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x200) : KeyStroke.getKeyStroke(39, 576);
        speciesEntryPanel.getIndexer().getInputMap(1).put(focusOnSpecies, "focusOnSpeciesList");
        speciesEntryPanel.getIndexer().getActionMap().put("focusOnSpeciesList", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SightingTaxon.Resolved selectedSpecies = SingleLocationSpeciesListPanel.this.speciesTablePanel.getSelectedSpecies();
                if (selectedSpecies != null) {
                    SingleLocationSpeciesListPanel.this.speciesTablePanel.expandSpeciesDetail(selectedSpecies);
                    SingleLocationSpeciesListPanel.this.speciesTablePanel.focusOnSpeciesDetail();
                }
            }
        });
        speciesEntryPanel.getIndexer().getTextComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() >= '0' && e.getKeyChar() <= '9') {
                    IndexerPanel<String> indexer = SingleLocationSpeciesListPanel.this.speciesEntryPanel.getIndexer();
                    SightingTaxon.Resolved selectedSpecies = SingleLocationSpeciesListPanel.this.speciesTablePanel.getSelectedSpecies();
                    if (indexer.getTextValue().isEmpty() && selectedSpecies != null) {
                        SingleLocationSpeciesListPanel.this.redirectFocusToNumberFieldOfSelectedSpecies(e, selectedSpecies);
                    }
                }
            }
        });
        speciesEntryPanel.addSpeciesEntryListener(new SpeciesSpHybridEntryPanel.SpeciesEntryListener(){

            @Override
            public void addSpecies(SpeciesSpHybridEntryPanel.SpeciesEntryEvent event) {
                SingleLocationSpeciesListPanel.this.speciesTablePanel.getSpeciesTable().setExpandedIndex(-1);
                SightingTaxon.Resolved resolved = event.getResolved();
                SingleLocationSpeciesListPanel.this.addSpeciesToTable(resolved);
                SingleLocationSpeciesListPanel.this.speciesTablePanel.selectSpecies(resolved, true);
                SingleLocationSpeciesListPanel.this.speciesEntryPanel.requestFocusInWindow();
                ((SingleLocationEdit)SingleLocationSpeciesListPanel.this.wizardValue()).edited();
            }
        });
        this.checklistCombo.addActionListener(this.checklistUpdated);
        this.completeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ((SingleLocationEdit)SingleLocationSpeciesListPanel.this.wizardValue()).setVisitInfo(((SingleLocationEdit)SingleLocationSpeciesListPanel.this.wizardValue()).getVisitInfo().asBuilder().withCompleteChecklist(SingleLocationSpeciesListPanel.this.completeCheckbox.isSelected()).build());
            }
        });
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.setTaxonomy(taxonomyStore.getTaxonomy(), true);
    }

    private void updateSubspeciesOfCurrentItem(Taxon current, Taxon newTaxon) {
        SightingInfo sightingInfo;
        if (newTaxon == null) {
            newTaxon = TaxonUtils.getParentOfType(current, Taxon.Type.species);
        }
        if (current != newTaxon) {
            ((SingleLocationEdit)this.wizardValue()).swapTaxa(SightingTaxons.newResolved(current), SightingTaxons.newResolved(newTaxon));
            this.speciesTablePanel.swapSpecies(SightingTaxons.newResolved(current), SightingTaxons.newResolved(newTaxon));
            this.speciesTablePanel.selectSpecies(SightingTaxons.newResolved(newTaxon), false);
        }
        SightingInfo.SightingStatus changedStatus = null;
        if (newTaxon.getStatus() == Species.Status.IN) {
            changedStatus = SightingInfo.SightingStatus.INTRODUCED;
        } else if (newTaxon.getStatus() == Species.Status.DO) {
            changedStatus = SightingInfo.SightingStatus.DOMESTIC;
        } else if (!(current.getStatus() != Species.Status.IN && current.getStatus() != Species.Status.DO || (sightingInfo = ((SingleLocationEdit)this.wizardValue()).getSightingInfo(SightingTaxons.newResolved(newTaxon))).getSightingStatus() != SightingInfo.SightingStatus.INTRODUCED && sightingInfo.getSightingStatus() != SightingInfo.SightingStatus.DOMESTIC)) {
            changedStatus = SightingInfo.SightingStatus.NONE;
        }
        if (changedStatus != null) {
            SightingTaxon.Resolved resolved = SightingTaxons.newResolved(newTaxon);
            ((SingleLocationEdit)this.wizardValue()).getSightingInfo(resolved).setSightingStatus(changedStatus);
            this.speciesTablePanel.resolvedUpdated(resolved);
        }
    }

    private void initComponents() {
        this.checklistLabel = new JLabel();
        this.checklistCombo = new JComboBox<DataEntryPreferences.ChecklistUse>(DataEntryPreferences.ChecklistUse.values());
        this.checklistCombo.setVisible(false);
        this.completeCheckbox = new JCheckBox(Messages.getMessage(Messages.Name.COMPLETE_LIST_OF_SIGHTINGS_QUESTION));
        this.completeCheckbox.setVisible(false);
        this.speciesCountLabel = new JLabel();
        this.updateSpeciesCount(ImmutableList.of(), 0);
        this.speciesInfoPane = this.speciesEntryPanel.extractSpeciesInfoPanel();
        this.photosListPanel = new PhotosListPanel(this.fontManager, this.fileDialogs, new BasicLinkClickedListener(this.alerts)){

            @Override
            protected List<Photo> beforeAddLinks(ImmutableList<Photo> newLinks) {
                return SingleLocationSpeciesListPanel.this.lookForSpeciesInLinks(newLinks);
            }

            @Override
            protected boolean withFavorite() {
                return false;
            }

            @Override
            protected boolean withDrag() {
                return true;
            }

            @Override
            protected Messages.Name dragLinkName() {
                return Messages.Name.DRAG_PHOTOS_WITH_SPECIES_NAMES;
            }
        };
        this.initTable(this.taxonomy);
        this.initLayout();
        this.fontManager.applyTo(this);
    }

    private void updateCompleteAndTaxaCount(List<SightingTaxon.Resolved> taxa, Taxonomy currentTaxonomy) {
        int incompatibleTaxonomyCount = ((SingleLocationEdit)this.wizardValue()).getIncompatibleTaxonomyCount(currentTaxonomy);
        this.setComplete(!taxa.isEmpty() || incompatibleTaxonomyCount > 0);
        this.updateSpeciesCount(taxa, incompatibleTaxonomyCount);
    }

    private void updateSpeciesCount(List<SightingTaxon.Resolved> taxa, int otherTaxa) {
        HashSet<SightingTaxon> species = Sets.newHashSet();
        for (SightingTaxon.Resolved resolved : taxa) {
            SightingTaxon taxon = resolved.getParentOfAtLeastType(Taxon.Type.species);
            if (taxon.getType() != SightingTaxon.Type.SINGLE && taxon.getType() != SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) continue;
            species.add(taxon);
        }
        if (otherTaxa == 0) {
            this.speciesCountLabel.setText(Messages.getFormattedMessage(Messages.Name.NUMBER_OF_SPECIES_FORMAT, species.size()));
        } else {
            this.speciesCountLabel.setText(Messages.getFormattedMessage(Messages.Name.NUMBER_OF_SPECIES_AND_OTHER_TAXA_FORMAT, species.size(), otherTaxa));
        }
    }

    private void rebuildTable(Taxonomy taxonomy) {
        this.speciesTablePanel.flushEdits();
        this.initTable(taxonomy);
        this.initLayout();
    }

    private void initLayout() {
        GroupLayout layout = new GroupLayout(this);
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createBaselineGroup(false, false).addComponent(this.checklistLabel).addComponent(this.checklistCombo).addComponent(this.completeCheckbox).addComponent(this.speciesCountLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.speciesEntryPanel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.speciesTablePanel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createBaselineGroup(false, true).addComponent(this.speciesInfoPane).addComponent(this.photosListPanel)));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.checklistLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checklistCombo, -2, -2, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.completeCheckbox, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.speciesCountLabel, -2, -2, -2)).addComponent(this.speciesEntryPanel).addComponent(this.speciesTablePanel).addGroup(layout.createSequentialGroup().addComponent(this.speciesInfoPane).addComponent(this.photosListPanel)));
        layout.linkSize(this.speciesInfoPane, this.photosListPanel);
        this.setLayout(layout);
    }

    private void initTable(final Taxonomy currentTaxonomy) {
        ImmutableList<SightingTaxon.Resolved> existingResolved;
        if (this.speciesTablePanel != null && this.speciesTablePanel.getParent() != null) {
            this.speciesTablePanel.getParent().remove(this.speciesTablePanel);
            existingResolved = this.speciesTablePanel.getValue();
        } else {
            existingResolved = ImmutableList.of();
        }
        this.sightingInfoColumn = new NewForColumn();
        if (this.checklist == null || this.checklistCombo.getSelectedItem() == DataEntryPreferences.ChecklistUse.NO) {
            this.speciesTablePanel = new DirectSpeciesTablePanel(new SightingInfoDetail(), "Show sighting details", this.fontManager);
            this.speciesTablePanel.setEditable(true);
            this.speciesTablePanel.addColumn(new SubspeciesColumn());
            this.speciesTablePanel.addColumn(new PhotoColumn());
            this.speciesTablePanel.addColumn(new NumberColumn());
            this.speciesTablePanel.addColumn(new SightingStatusColumn());
            this.speciesTablePanel.addColumn(this.sightingInfoColumn);
            if (this.reportSet.getUserSet() != null) {
                this.speciesTablePanel.addColumn(new ObserversColumn());
            }
            ((DirectSpeciesTablePanel)this.speciesTablePanel).addDeleteColumn();
        } else {
            boolean includeRarities = this.checklistCombo.getSelectedItem() == DataEntryPreferences.ChecklistUse.YES_WITH_RARITIES;
            this.speciesTablePanel = new ChecklistSpeciesTablePanel(new SightingInfoDetail(), "Show sighting details", this.fontManager, this.checklist, includeRarities, currentTaxonomy);
            this.speciesTablePanel.setEditable(true);
            this.speciesTablePanel.addColumn(new SubspeciesColumn());
            this.speciesTablePanel.addColumn(new PhotoColumn());
            this.speciesTablePanel.addColumn(new NumberColumn());
            this.speciesTablePanel.addColumn(new SightingStatusColumn());
            this.speciesTablePanel.addColumn(this.sightingInfoColumn);
            if (this.reportSet.getUserSet() != null) {
                this.speciesTablePanel.addColumn(new ObserversColumn());
            }
        }
        this.speciesTablePanel.setSortedContents(currentTaxonomy, existingResolved);
        this.speciesTablePanel.getSpeciesTable().forceComponentCreation();
        if (this.isShowing()) {
            this.speciesTablePanel.getSpeciesTable().setFocusableComponentAfterTable(this.getFocusableComponentAfterContent());
            this.speciesTablePanel.getSpeciesTable().setFocusableComponentBeforeTable(this.speciesEntryPanel.getLastFocusableComponent());
        }
        KeyStroke backToIndexer = UIUtils.isMacOS() ? KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x200) : KeyStroke.getKeyStroke(37, 576);
        this.speciesTablePanel.getInputMap(1).put(backToIndexer, "focusOnIndexer");
        this.speciesTablePanel.getActionMap().put("focusOnIndexer", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleLocationSpeciesListPanel.this.speciesEntryPanel.getIndexer().transferFocus();
            }
        });
        this.speciesTablePanel.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List taxa = (List)evt.getNewValue();
                SingleLocationSpeciesListPanel.this.updateCompleteAndTaxaCount(taxa, currentTaxonomy);
            }
        });
        this.speciesTablePanel.addUserModificationListener(() -> ((SingleLocationEdit)this.wizardValue()).edited());
        if (this.isShowing()) {
            this.updateCompleteAndTaxaCount(existingResolved, currentTaxonomy);
        }
        this.speciesTablePanel.addPropertyChangeListener("selectedValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SingleLocationSpeciesListPanel.this.speciesEntryPanel.setFocusResolver(SingleLocationSpeciesListPanel.this.speciesTablePanel::getSelectedSpecies);
            }
        });
        this.speciesTablePanel.setIsImportant(new Predicate<SightingTaxon.Resolved>(){

            @Override
            public boolean apply(SightingTaxon.Resolved input) {
                if (input.getType() != SightingTaxon.Type.SINGLE) {
                    return false;
                }
                if (SingleLocationSpeciesListPanel.this.scanSeenTaxa == null) {
                    return false;
                }
                Set<String> currentSeenTaxa = SingleLocationSpeciesListPanel.this.scanSeenTaxa.getSeenTaxa(input.getTaxonomy(), null);
                if (currentSeenTaxa == null) {
                    return false;
                }
                SightingInfo sightingInfo = SingleLocationSpeciesListPanel.this.getCurrentSightingInfo(input);
                if (!SingleLocationSpeciesListPanel.this.queryPreferences.countHeardOnly && sightingInfo.isHeardOnly()) {
                    return false;
                }
                if (!SingleLocationSpeciesListPanel.this.queryPreferences.countIntroduced && sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.INTRODUCED) {
                    return false;
                }
                if (sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED || sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.ID_UNCERTAIN || sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.UNSATISFACTORY_VIEWS || sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.DOMESTIC || sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.DEAD || sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.SIGNS || sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.NOT_BY_ME) {
                    return false;
                }
                return !TaxonUtils.isItselfOrAChildIn(input.getTaxon(), currentSeenTaxa);
            }
        });
        this.speciesTablePanel.getSpeciesTable().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SightingTaxon.Resolved selectedSpecies;
                if (e.getKeyChar() >= '0' && e.getKeyChar() <= '9' && (selectedSpecies = SingleLocationSpeciesListPanel.this.speciesTablePanel.getSelectedSpecies()) != null) {
                    ExpandableTable<SightingTaxon.Resolved> speciesTable = SingleLocationSpeciesListPanel.this.speciesTablePanel.getSpeciesTable();
                    TableRowsModel enabledRowsModel = speciesTable.getEnabledRowsModel();
                    if (!enabledRowsModel.isIncluded(speciesTable.getSelectedIndex())) {
                        enabledRowsModel.includeRow(speciesTable.getSelectedIndex());
                    }
                    SingleLocationSpeciesListPanel.this.redirectFocusToNumberFieldOfSelectedSpecies(e, selectedSpecies);
                }
            }
        });
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.ENTER_SPECIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shown() {
        super.shown();
        if (this.taxonomy != this.taxonomyStore.getTaxonomy()) {
            this.taxonomy = this.taxonomyStore.getTaxonomy();
        }
        ImmutableSet<User> usersOnSpeciesList = ((SingleLocationEdit)this.wizardValue()).getUsersOnSpeciesList();
        ImmutableSet<User> users = ((SingleLocationEdit)this.wizardValue()).getUsers();
        if (usersOnSpeciesList != null && users != null && !users.equals(usersOnSpeciesList)) {
            Sets.SetView<User> usersToRemove = Sets.difference(usersOnSpeciesList, users);
            Sets.SetView<User> usersToAdd = Sets.difference(users, usersOnSpeciesList);
            for (SightingInfo sightingInfo : ((SingleLocationEdit)this.wizardValue()).getSightingInfos()) {
                ImmutableSet.Builder sightingUsers = ImmutableSet.builder();
                sightingUsers.addAll(Sets.difference(sightingInfo.getUsers(), usersToRemove));
                sightingUsers.addAll(usersToAdd);
                sightingInfo.setUsers(sightingUsers.build());
            }
        }
        ((SingleLocationEdit)this.wizardValue()).setUsersOnSpeciesList(((SingleLocationEdit)this.wizardValue()).getUsers());
        this.startScoringLocations();
        this.speciesEntryPanel.setTaxonomy(this.taxonomy);
        this.speciesEntryPanel.setIndexerLabel(this.getWhereAndWhen());
        this.speciesEntryPanel.getIndexer().requestFocusInWindow();
        this.speciesTablePanel.getSpeciesTable().setFocusableComponentAfterTable(this.getFocusableComponentAfterContent());
        this.speciesTablePanel.getSpeciesTable().setFocusableComponentBeforeTable(this.speciesEntryPanel.getLastFocusableComponent());
        this.updateChecklist(this.taxonomy);
        this.rebuildTable(this.taxonomy);
        VisitInfo visitInfo = ((SingleLocationEdit)this.wizardValue()).getVisitInfo();
        this.completeCheckbox.setVisible(!((SingleLocationEdit)this.wizardValue()).isTrip() && visitInfo != null && visitInfo.observationType() != VisitInfo.ObservationType.INCIDENTAL);
        if (this.completeCheckbox.isVisible()) {
            this.completeCheckbox.setSelected(((SingleLocationEdit)this.wizardValue()).getVisitInfo().completeChecklist());
        } else {
            this.completeCheckbox.setSelected(false);
        }
        ImmutableList<SightingTaxon.Resolved> currentTableEntries = this.speciesTablePanel.getValue();
        List<SightingTaxon.Resolved> wizardEntries = ((SingleLocationEdit)this.wizardValue()).getCompatibleTaxa(this.taxonomyStore.getTaxonomy());
        if (!currentTableEntries.equals(wizardEntries)) {
            DelayedUI.instance().enableDelay();
            try {
                this.speciesTablePanel.setSortedContents(this.taxonomyStore.getTaxonomy(), wizardEntries);
            }
            finally {
                DelayedUI.instance().liftDelay();
            }
        }
    }

    private void updateChecklist(Taxonomy currentTaxonomy) {
        this.checklist = null;
        this.checklistLocation = ((SingleLocationEdit)this.wizardValue()).getLocation();
        while (this.checklistLocation != null && this.checklist == null) {
            this.checklist = this.checklists.getChecklist(this.reportSet, currentTaxonomy, this.checklistLocation);
            if (this.checklist != null) continue;
            this.checklistLocation = this.checklistLocation.getParent();
        }
        this.speciesEntryPanel.setChecklist(this.checklist, this.checklistLocation);
        if (this.checklistLocation == null) {
            this.checklistLabel.setVisible(false);
            this.checklistCombo.setVisible(false);
        } else {
            boolean hasRarities;
            this.checklistLabel.setText(Messages.getFormattedMessage(Messages.Name.USE_CHECKLIST_QUESTION, this.checklistLocation.getDisplayName()));
            boolean bl = hasRarities = !this.checklist.getTaxa(currentTaxonomy, Checklist.Status.RARITY).isEmpty() || !this.checklist.getTaxa(currentTaxonomy, Checklist.Status.RARITY_FROM_INTRODUCED).isEmpty();
            if (hasRarities) {
                this.checklistCombo.setModel(new DefaultComboBoxModel<DataEntryPreferences.ChecklistUse>(new DataEntryPreferences.ChecklistUse[]{DataEntryPreferences.ChecklistUse.NO, DataEntryPreferences.ChecklistUse.YES, DataEntryPreferences.ChecklistUse.YES_WITH_RARITIES}));
            } else {
                this.checklistCombo.setModel(new DefaultComboBoxModel<DataEntryPreferences.ChecklistUse>(new DataEntryPreferences.ChecklistUse[]{DataEntryPreferences.ChecklistUse.NO, DataEntryPreferences.ChecklistUse.YES}));
            }
            DataEntryPreferences.ChecklistUse checklistUse = this.dataEntryPreferences.checklistUse;
            if (checklistUse == null) {
                checklistUse = DataEntryPreferences.ChecklistUse.NO;
            } else if (checklistUse == DataEntryPreferences.ChecklistUse.YES_WITH_RARITIES && !hasRarities) {
                checklistUse = DataEntryPreferences.ChecklistUse.YES;
            }
            this.checklistCombo.removeActionListener(this.checklistUpdated);
            this.checklistCombo.setSelectedItem((Object)checklistUse);
            this.checklistCombo.addActionListener(this.checklistUpdated);
            this.checklistLabel.setVisible(true);
            this.checklistCombo.setVisible(true);
        }
    }

    @Override
    protected boolean leaving(boolean validate) {
        super.leaving(validate);
        if (validate && !this.photosListPanel.getLinks().isEmpty()) {
            int chosenOption = this.alerts.showWithOptions((Object)this, Messages.Name.ADD_LEFTOVER_PHOTOS, ((SingleLocationEdit)this.wizardValue()).isTrip() ? Messages.Name.ADD_LEFTOVER_PHOTOS_TO_TRIP : Messages.Name.ADD_LEFTOVER_PHOTOS_TO_VISIT, Messages.getMessage(Messages.Name.ADD_PHOTOS), Messages.getMessage(Messages.Name.DROP_PHOTOS), Messages.getMessage(Messages.Name.CANCEL_BUTTON));
            if (chosenOption == 2 || chosenOption < 0) {
                return false;
            }
            if (chosenOption == 0) {
                if (((SingleLocationEdit)this.wizardValue()).isTrip()) {
                    ArrayList<Link> links = new ArrayList<Link>();
                    links.addAll(((SingleLocationEdit)this.wizardValue()).getTripLinks());
                    links.addAll(this.photosListPanel.getLinks());
                    ((SingleLocationEdit)this.wizardValue()).setTripLinks(links);
                } else {
                    VisitInfo.Builder visitInfoBuilder;
                    ArrayList<Photo> photos = new ArrayList<Photo>();
                    if (((SingleLocationEdit)this.wizardValue()).getVisitInfo() == null) {
                        visitInfoBuilder = VisitInfo.builder().withObservationType(VisitInfo.ObservationType.INCIDENTAL);
                    } else {
                        visitInfoBuilder = ((SingleLocationEdit)this.wizardValue()).getVisitInfo().asBuilder();
                        photos.addAll(((SingleLocationEdit)this.wizardValue()).getVisitInfo().photos());
                    }
                    photos.addAll(this.photosListPanel.getLinks());
                    visitInfoBuilder.withPhotos(photos);
                    ((SingleLocationEdit)this.wizardValue()).setVisitInfo(visitInfoBuilder.build());
                }
            }
            this.photosListPanel.setLinks(ImmutableList.of());
        }
        this.speciesTablePanel.flushEdits();
        ImmutableList<SightingTaxon.Resolved> taxa = this.speciesTablePanel.getValue();
        if (!((SingleLocationEdit)this.wizardValue()).getCompatibleTaxa(this.taxonomy).equals(taxa)) {
            ((SingleLocationEdit)this.wizardValue()).syncTaxa(this.taxonomy, this.speciesTablePanel.getValue());
        }
        return true;
    }

    private String getWhereAndWhen() {
        String tripName;
        if (((SingleLocationEdit)this.wizardValue()).isTrip() && !Strings.isNullOrEmpty(tripName = ((SingleLocationEdit)this.wizardValue()).getTripName())) {
            return tripName;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(((SingleLocationEdit)this.wizardValue()).getLocation().getDisplayName());
        if (((SingleLocationEdit)this.wizardValue()).getDate() != null) {
            builder.append(", ");
            builder.append(PartialIO.toUserString(((SingleLocationEdit)this.wizardValue()).getDate(), this.getLocale()));
        }
        return builder.toString();
    }

    private void redirectFocusToNumberFieldOfSelectedSpecies(final KeyEvent originalKeyEvent, SightingTaxon.Resolved selectedSpecies) {
        this.speciesTablePanel.expandSpeciesDetail(selectedSpecies);
        JComponent expandedRowComponent = this.speciesTablePanel.getSpeciesTable().getExpandedRowComponent();
        if (expandedRowComponent != null) {
            final SightingInfoPanel sightingInfoPanel = (SightingInfoPanel)expandedRowComponent;
            final JFormattedTextField numberField = sightingInfoPanel.getNumberField();
            final String textValue = "" + originalKeyEvent.getKeyChar();
            FocusAdapter moveSelectionToEnd = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    EventQueue.invokeLater(() -> {
                        numberField.setText(textValue);
                        numberField.getCaret().setDot(1);
                        numberField.removeFocusListener(this);
                        sightingInfoPanel.getDirty().setDirty(true);
                        numberField.addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyTyped(KeyEvent e) {
                                if (e.getKeyChar() == '\n') {
                                    originalKeyEvent.getComponent().requestFocusInWindow();
                                    numberField.removeKeyListener(this);
                                    e.consume();
                                }
                            }
                        });
                    });
                }
            };
            numberField.addFocusListener(moveSelectionToEnd);
            numberField.requestFocusInWindow();
            originalKeyEvent.consume();
        }
    }

    private boolean isNewForLocation(Taxonomy taxonomy, Location location, SightingTaxon taxon, int minimumVisitsRequired) {
        int visitCount;
        if (this.scanSeenTaxa == null) {
            return false;
        }
        if (minimumVisitsRequired > 0 && (visitCount = this.scanSeenTaxa.getVisitCount(location)) < minimumVisitsRequired) {
            return false;
        }
        Set<String> seenTaxa = this.scanSeenTaxa.getSeenTaxa(taxonomy, location);
        if (seenTaxa == null) {
            return false;
        }
        return !seenTaxa.contains(taxon.getId());
    }

    private boolean isNewForUser(Taxonomy taxonomy, User user, SightingTaxon taxon) {
        if (this.scanSeenTaxa == null) {
            return false;
        }
        Set<String> seenTaxa = this.scanSeenTaxa.getTaxaForUser(taxonomy, user);
        if (seenTaxa == null) {
            return false;
        }
        return !seenTaxa.contains(taxon.getId());
    }

    private boolean isNewForYear(Taxonomy taxonomy, SightingTaxon taxon) {
        if (this.scanSeenTaxa == null) {
            return false;
        }
        ReadablePartial date = ((SingleLocationEdit)this.wizardValue()).getDate();
        if (date == null || !date.isSupported(DateTimeFieldType.year())) {
            return false;
        }
        Set<String> yearTaxa = this.scanSeenTaxa.getYearTaxa(taxonomy, date.get(DateTimeFieldType.year()));
        if (yearTaxa == null) {
            return false;
        }
        return !yearTaxa.contains(taxon.getId());
    }

    private boolean isNewForPhotographed(Taxonomy taxonomy, SightingTaxon taxon) {
        if (this.scanSeenTaxa == null) {
            return false;
        }
        Set<String> photographedTaxa = this.scanSeenTaxa.getPhotographedTaxa(taxonomy);
        if (photographedTaxa == null) {
            return false;
        }
        return !photographedTaxa.contains(taxon.getId());
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.setTaxonomy(event.getTaxonomy(), false);
        if (!this.photosListPanel.getLinks().isEmpty()) {
            this.photosListPanel.setLinks(this.lookForSpeciesInLinks(this.photosListPanel.getLinks()));
        }
    }

    private void setTaxonomy(Taxonomy newTaxonomy, boolean skipTableUpdates) {
        ArrayList<SightingTaxon.Resolved> newCompatibleTaxa;
        if (newTaxonomy == this.taxonomy) {
            return;
        }
        if (skipTableUpdates) {
            newCompatibleTaxa = null;
        } else {
            int option;
            ((SingleLocationEdit)this.wizardValue()).syncTaxa(this.taxonomy, this.speciesTablePanel.getValue());
            this.updateChecklist(newTaxonomy);
            newCompatibleTaxa = new ArrayList<SightingTaxon.Resolved>();
            ArrayList<String> failedMappings = new ArrayList<String>();
            List<SightingTaxon.Resolved> previousCompatibleTaxa = TaxonUtils.areCompatible(newTaxonomy, this.taxonomy) ? this.speciesTablePanel.getValue() : ((SingleLocationEdit)this.wizardValue()).getCompatibleTaxa(newTaxonomy);
            for (SightingTaxon.Resolved resolved : previousCompatibleTaxa) {
                MappedTaxonomy mapped;
                if (resolved.getTaxonomy() == newTaxonomy) {
                    newCompatibleTaxa.add(resolved);
                    continue;
                }
                if (resolved.getTaxonomy() instanceof MappedTaxonomy) {
                    mapped = (MappedTaxonomy)resolved.getTaxonomy();
                    Preconditions.checkState(newTaxonomy == mapped.getBaseTaxonomy());
                    SightingTaxon baseMapping = mapped.getMapping(resolved.getSightingTaxon());
                    if (baseMapping == null) {
                        failedMappings.add(HtmlResponseWriter.htmlEscape(resolved.getCommonName()));
                        continue;
                    }
                    newCompatibleTaxa.add(baseMapping.resolveInternal(newTaxonomy));
                    continue;
                }
                Preconditions.checkState(newTaxonomy instanceof MappedTaxonomy);
                mapped = (MappedTaxonomy)newTaxonomy;
                Preconditions.checkState(resolved.getTaxonomy() == mapped.getBaseTaxonomy());
                SightingTaxon.Resolved mappedResolved = mapped.resolveInto(resolved.getSightingTaxon());
                if (mappedResolved == null) {
                    failedMappings.add(HtmlResponseWriter.htmlEscape(resolved.getCommonName()));
                    continue;
                }
                newCompatibleTaxa.add(mappedResolved);
            }
            if (!failedMappings.isEmpty() && (option = this.alerts.showOkCancel((Object)this, Messages.Name.FAILED_MAPPINGS_TITLE, Messages.Name.FAILED_MAPPINGS_FORMAT, newTaxonomy.getName(), Joiner.on("<br>").join(failedMappings))) != 0) {
                this.taxonomyStore.setTaxonomy(this.taxonomy);
                return;
            }
            Collections.sort(newCompatibleTaxa, new ResolvedComparator());
            this.speciesTablePanel.flushEdits();
            this.updateChecklist(newTaxonomy);
            this.speciesTablePanel.setSortedContents(this.taxonomy, ImmutableList.of());
            this.rebuildTable(newTaxonomy);
            this.updateCompleteAndTaxaCount(newCompatibleTaxa, newTaxonomy);
        }
        this.taxonomy = newTaxonomy;
        this.speciesEntryPanel.setTaxonomy(newTaxonomy);
        if (this.isShowing()) {
            ((SingleLocationEdit)this.wizardValue()).setTaxonomy(newTaxonomy, this.speciesTablePanel.getValue());
            this.startScoringLocations();
        }
        if (newCompatibleTaxa != null) {
            this.speciesTablePanel.setSortedContents(newTaxonomy, newCompatibleTaxa);
        }
    }

    private void startScoringLocations() {
        ReadablePartial date;
        Predicate<Sighting> sightingsToInclude;
        if (this.scanSeenTaxa != null) {
            this.scanSeenTaxa.cancel();
        }
        Location rootLocation = ((SingleLocationEdit)this.wizardValue()).getLocation();
        ArrayList<Location> locations = new ArrayList<Location>();
        this.countryLocation = null;
        this.stateLocation = null;
        this.countyLocation = null;
        Location perhapsInterestingLocation = rootLocation;
        if (rootLocation != null && rootLocation.getId() != null && rootLocation.getType() != Location.Type.country && rootLocation.getType() != Location.Type.state && rootLocation.getType() != Location.Type.county) {
            locations.add(rootLocation);
            perhapsInterestingLocation = rootLocation.getParent();
        }
        while (perhapsInterestingLocation != null) {
            if (perhapsInterestingLocation.getType() != null) {
                switch (perhapsInterestingLocation.getType()) {
                    case country: {
                        if (this.countryLocation != null) break;
                        this.countryLocation = perhapsInterestingLocation;
                        locations.add(perhapsInterestingLocation);
                        break;
                    }
                    case state: {
                        if (this.stateLocation != null) break;
                        this.stateLocation = perhapsInterestingLocation;
                        locations.add(perhapsInterestingLocation);
                        break;
                    }
                    case county: {
                        if (this.countyLocation != null) break;
                        this.countyLocation = perhapsInterestingLocation;
                        locations.add(perhapsInterestingLocation);
                        break;
                    }
                }
            }
            perhapsInterestingLocation = perhapsInterestingLocation.getParent();
        }
        locations.add(null);
        if (((SingleLocationEdit)this.wizardValue()).getLocation() == null || ((SingleLocationEdit)this.wizardValue()).getLocation().getId() == null) {
            sightingsToInclude = Predicates.alwaysTrue();
        } else {
            final String locationId = ((SingleLocationEdit)this.wizardValue()).getLocation().getId();
            date = ((SingleLocationEdit)this.wizardValue()).getDate();
            sightingsToInclude = new Predicate<Sighting>(){

                @Override
                public boolean apply(Sighting sighting) {
                    return !Objects.equal(locationId, sighting.getLocationId()) || !Objects.equal(date, sighting.getStartDateAsPartial());
                }
            };
        }
        sightingsToInclude = Predicates.and(sightingsToInclude, this.queryPreferences.getCountablePredicate(this.taxonomy, false, null));
        date = ((SingleLocationEdit)this.wizardValue()).getDate();
        OptionalInt yearToScan = date != null && date.isSupported(DateTimeFieldType.year()) ? OptionalInt.of(date.get(DateTimeFieldType.year())) : OptionalInt.empty();
        ImmutableSet<User> users = ((SingleLocationEdit)this.wizardValue()).getUsers();
        if (!users.isEmpty()) {
            sightingsToInclude = Predicates.and(sightingsToInclude, SightingPredicates.includesAnyOfUsers(users));
        }
        this.scanSeenTaxa = ScanSeenTaxa.start(this.reportSet, this.taxonomy, this.executorService, scanned -> this.speciesTablePanel.getSpeciesTable().resetColumnValues(this.sightingInfoColumn), locations, sightingsToInclude, new ScanSeenTaxa.Options().setYearToScan(yearToScan).setUsers(users));
        while (rootLocation != null && rootLocation.getId() == null) {
            if (rootLocation.isBuiltInLocation() && this.checklists.hasChecklist(this.taxonomy, this.reportSet, rootLocation)) {
                boolean isLocationSetDirty = this.reportSet.getLocations().getDirty().isDirty();
                this.reportSet.getLocations().ensureAdded(rootLocation);
                if (isLocationSetDirty) break;
                this.reportSet.getLocations().clearDirty();
                break;
            }
            rootLocation = rootLocation.getParent();
        }
        this.locationScorer = LocationTaxonScorer.newTaxonScorer(this.taxonomy, this.reportSet, rootLocation, ((SingleLocationEdit)this.wizardValue()).getDate(), this.checklists);
        this.speciesEntryPanel.getIndexer().setOrdering(this.locationScorer::ordering);
        this.speciesEntryPanel.getIndexer().setMixer(new IndexerPanel.Mixer<String>(){

            @Override
            public List<String> mix(List<String> original) {
                String highestScoringSubspecies;
                if (original.size() == 1) {
                    ArrayList<String> mixed = Lists.newArrayList(original.get(0));
                    mixed.addAll(this.getHighScoringSubspecies(original.get(0)));
                    return mixed;
                }
                if (!original.isEmpty() && (highestScoringSubspecies = this.getHighestScoringSubspecies(original.get(0))) != null) {
                    ArrayList<String> mixed = new ArrayList<String>();
                    mixed.add(original.get(0));
                    mixed.add(highestScoringSubspecies);
                    mixed.addAll(original.subList(1, original.size()));
                    return mixed;
                }
                return original;
            }

            private String getHighestScoringSubspecies(String taxon) {
                List<String> subspecies = this.gatherSubspecies(taxon);
                if (subspecies.isEmpty()) {
                    return null;
                }
                String min = SingleLocationSpeciesListPanel.this.locationScorer.ordering().min(subspecies);
                if (SingleLocationSpeciesListPanel.this.locationScorer.getScore(min) == 0) {
                    return null;
                }
                return min;
            }

            private List<String> getHighScoringSubspecies(String taxon) {
                List<String> subspecies = this.gatherSubspecies(taxon);
                if (subspecies.isEmpty()) {
                    return ImmutableList.of();
                }
                List<String> sorted = SingleLocationSpeciesListPanel.this.locationScorer.ordering().sortedCopy(subspecies);
                ArrayList<String> highScoring = new ArrayList<String>();
                for (String id : sorted) {
                    if (SingleLocationSpeciesListPanel.this.locationScorer.getScore(id) == 0) break;
                    highScoring.add(id);
                    if (highScoring.size() != 3) continue;
                    break;
                }
                return highScoring;
            }

            private List<String> gatherSubspecies(String taxon) {
                final ArrayList<String> subspecies = new ArrayList<String>();
                TaxonUtils.visitTaxa(SingleLocationSpeciesListPanel.this.taxonomy.getTaxon(taxon), new TaxonVisitor(){

                    @Override
                    public boolean visitTaxon(Taxon taxon) {
                        if (taxon.getType() != Taxon.Type.species) {
                            subspecies.add(taxon.getId());
                        }
                        return true;
                    }
                });
                return subspecies;
            }
        });
        if (this.scorerFuture != null) {
            this.scorerFuture.cancel(true);
        }
        this.scorerFuture = this.locationScorer.start(this.executorService);
        UiFutures.cancelFutureOnHide(this.scorerFuture, this);
    }

    private static boolean isFocusable(Component candidate) {
        InputMap whenFocusedMap;
        if (!(candidate.isEnabled() && candidate.isFocusable() && candidate.isDisplayable())) {
            return false;
        }
        if (candidate instanceof JComboBox) {
            return ((JComboBox)candidate).getUI().isFocusTraversable((JComboBox)candidate);
        }
        return !(candidate instanceof JComponent) || (whenFocusedMap = ((JComponent)candidate).getInputMap(0)) != null && whenFocusedMap.allKeys() != null && whenFocusedMap.allKeys().length != 0;
    }

    private SightingInfo getCurrentSightingInfo(SightingTaxon.Resolved resolved) {
        return ((SingleLocationEdit)this.wizardValue()).getSightingInfo(resolved);
    }

    private List<Photo> lookForSpeciesInLinks(Collection<Photo> newLinks) {
        ImmutableList.Builder photos = ImmutableList.builder();
        FindSpeciesInText findSpeciesInText = new FindSpeciesInText(this.taxonomy, this.checklist);
        for (Photo photo : newLinks) {
            if (this.handleDroppedPhoto(photo, findSpeciesInText)) continue;
            photos.add(photo);
        }
        return photos.build();
    }

    private boolean handleDroppedPhoto(Photo photo, FindSpeciesInText findSpecies) {
        if (!photo.isFileBased()) {
            return false;
        }
        File file = photo.toFile();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.add(file.getName());
        try {
            Metadata metadata = ImageMetadataReader.readMetadata(file);
            for (Directory directory : metadata.getDirectoriesOfType(ExifDirectoryBase.class)) {
                if (!directory.containsTag(270)) continue;
                names.add(directory.getString(270));
            }
            for (Directory directory : metadata.getDirectoriesOfType(IptcDirectory.class)) {
                if (!directory.containsTag(632)) continue;
                names.add(directory.getString(632));
            }
        }
        catch (ImageProcessingException | IOException e) {
            return false;
        }
        String text = Joiner.on('\n').join(names);
        FindSpeciesInText.Results results = findSpecies.search(text, findSpecies.primarySearch());
        if (results.found.isEmpty()) {
            results = findSpecies.search(results.remainingText, findSpecies.secondarySearch(false));
            if (results.found.isEmpty()) {
                results = findSpecies.search(text, findSpecies.tertiarySearch());
            }
        }
        if (results.found.isEmpty()) {
            return false;
        }
        this.speciesTablePanel.getSpeciesTable().setExpandedIndex(-1);
        for (SightingTaxon.Resolved resolved : results.found) {
            if (resolved.getType() == SightingTaxon.Type.SINGLE) {
                Taxon taxon = resolved.getTaxon();
                for (SightingTaxon.Resolved existingResolved : this.speciesTablePanel.getValue()) {
                    if (!existingResolved.isChildOf(taxon)) continue;
                    resolved = existingResolved;
                    break;
                }
            }
            this.addSpeciesToTable(resolved);
            SightingInfo sightingInfo = ((SingleLocationEdit)this.wizardValue()).getSightingInfo(resolved);
            ArrayList<Photo> photos = new ArrayList<Photo>(sightingInfo.getPhotos());
            if (photos.stream().anyMatch(p -> p.getUri().equals(photo.getUri()))) continue;
            photos.add(photo);
            sightingInfo.setPhotos(photos);
            sightingInfo.setPhotographed(true);
            this.speciesTablePanel.resolvedUpdated(resolved);
        }
        ((SingleLocationEdit)this.wizardValue()).edited();
        return true;
    }

    private void addSpeciesToTable(SightingTaxon.Resolved resolved) {
        this.speciesTablePanel.addSpecies(resolved);
        SightingInfo.SightingStatus changedStatus = null;
        if (resolved.getTaxonStatus() == Species.Status.IN) {
            changedStatus = SightingInfo.SightingStatus.INTRODUCED;
        } else if (resolved.getTaxonStatus() == Species.Status.DO) {
            SightingTaxon taxon;
            Checklist.Status status;
            changedStatus = SightingInfo.SightingStatus.DOMESTIC;
            if (this.checklist != null && ((status = this.checklist.getStatus(this.taxonomy, taxon = resolved.getParentOfAtLeastType(Taxon.Type.species))) == Checklist.Status.INTRODUCED || status == Checklist.Status.RARITY_FROM_INTRODUCED)) {
                changedStatus = SightingInfo.SightingStatus.INTRODUCED;
            }
        } else if (this.checklist != null) {
            SightingTaxon taxon = resolved.getParentOfAtLeastType(Taxon.Type.species);
            Checklist.Status status = this.checklist.getStatus(this.taxonomy, taxon);
            if (status == Checklist.Status.INTRODUCED || status == Checklist.Status.RARITY_FROM_INTRODUCED) {
                changedStatus = SightingInfo.SightingStatus.INTRODUCED;
            } else if (status == Checklist.Status.ESCAPED) {
                changedStatus = SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED;
            }
        }
        if (changedStatus != null) {
            ((SingleLocationEdit)this.wizardValue()).getSightingInfo(resolved).setSightingStatus(changedStatus);
            this.speciesTablePanel.resolvedUpdated(resolved);
        }
    }

    private static ImageIcon cameraIcon() {
        return new ImageIcon(Resources.getResource("com/scythebill/birdlist/ui/icons/camera_18.png"));
    }

    private static ImageIcon cameraIconActive() {
        return new ImageIcon(Resources.getResource("com/scythebill/birdlist/ui/icons/camera_18_light.png"));
    }

    private class NewForColumn
    extends LabelColumn<SightingTaxon.Resolved> {
        public NewForColumn() {
            super(ExpandableTable.ColumnLayout.weightedWidth(0.7f), Messages.getMessage(Messages.Name.NEW_FOR_COLUMN));
        }

        @Override
        public void updateComponentValue(Component component, SightingTaxon.Resolved resolved) {
            JLabel label = (JLabel)component;
            String text = "";
            String tooltip = null;
            SightingTaxon taxon = resolved.getSmallestTaxonType() != Taxon.Type.species ? resolved.getParentOfAtLeastType(Taxon.Type.species) : resolved.getSightingTaxon();
            if (taxon.getType() == SightingTaxon.Type.SINGLE || taxon.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
                Checklist.Status status;
                if (SingleLocationSpeciesListPanel.this.checklist != null && (status = SingleLocationSpeciesListPanel.this.checklist.getStatus(resolved.getTaxonomy(), taxon)) == null) {
                    text = Messages.getMessage(Messages.Name.NEW_FOR_CHECKLIST);
                    tooltip = Messages.getFormattedMessage(Messages.Name.NOT_FOUND_ON_CHECKLIST_FORMAT, SingleLocationSpeciesListPanel.this.checklistLocation.getDisplayName());
                }
                if (SingleLocationSpeciesListPanel.this.scanSeenTaxa != null && text.isEmpty()) {
                    SightingInfo sightingInfo = SingleLocationSpeciesListPanel.this.getCurrentSightingInfo(resolved);
                    if (SingleLocationSpeciesListPanel.this.isNewForLocation(resolved.getTaxonomy(), null, taxon, 0)) {
                        text = Messages.getMessage(Messages.Name.WORLD_TEXT);
                    } else {
                        ArrayList<String> userAbbreviations = null;
                        for (User user : sightingInfo.getUsers()) {
                            if (!SingleLocationSpeciesListPanel.this.isNewForUser(resolved.getTaxonomy(), user, taxon)) continue;
                            if (userAbbreviations == null) {
                                userAbbreviations = new ArrayList<String>();
                            }
                            userAbbreviations.add(user.abbreviation());
                        }
                        if (userAbbreviations != null) {
                            text = Joiner.on(',').join(userAbbreviations);
                        } else if (SingleLocationSpeciesListPanel.this.countryLocation != null && SingleLocationSpeciesListPanel.this.isNewForLocation(resolved.getTaxonomy(), SingleLocationSpeciesListPanel.this.countryLocation, taxon, 0)) {
                            text = this.locationOrAbbreviated(SingleLocationSpeciesListPanel.this.countryLocation);
                        } else if (SingleLocationSpeciesListPanel.this.stateLocation != null && SingleLocationSpeciesListPanel.this.isNewForLocation(resolved.getTaxonomy(), SingleLocationSpeciesListPanel.this.stateLocation, taxon, 0)) {
                            text = this.locationOrAbbreviated(SingleLocationSpeciesListPanel.this.stateLocation);
                        } else if (SingleLocationSpeciesListPanel.this.countyLocation != null && SingleLocationSpeciesListPanel.this.isNewForLocation(resolved.getTaxonomy(), SingleLocationSpeciesListPanel.this.countyLocation, taxon, 0)) {
                            text = this.locationOrAbbreviated(SingleLocationSpeciesListPanel.this.countyLocation);
                        } else {
                            Location location = ((SingleLocationEdit)SingleLocationSpeciesListPanel.this.wizardValue()).getLocation();
                            if (location != null && location.getId() != null && SingleLocationSpeciesListPanel.this.isNewForLocation(resolved.getTaxonomy(), location, taxon, 2)) {
                                text = this.locationOrAbbreviated(location);
                            }
                        }
                        if (sightingInfo.isPhotographed() && SingleLocationSpeciesListPanel.this.isNewForPhotographed(resolved.getTaxonomy(), taxon)) {
                            text = Messages.getMessage(Messages.Name.PHOTOGRAPHED_TEXT);
                        }
                        if (text.isEmpty() && SingleLocationSpeciesListPanel.this.isNewForYear(resolved.getTaxonomy(), taxon)) {
                            text = Messages.getMessage(Messages.Name.YEAR_TEXT);
                        }
                    }
                    if (!SingleLocationSpeciesListPanel.this.queryPreferences.countHeardOnly && sightingInfo.isHeardOnly()) {
                        text = "";
                    } else if (!SingleLocationSpeciesListPanel.this.queryPreferences.countIntroduced && sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.INTRODUCED) {
                        text = "";
                    } else if (!SingleLocationSpeciesListPanel.this.queryPreferences.countRestrained && sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.RESTRAINED) {
                        text = "";
                    } else if (sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED || sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.ID_UNCERTAIN || sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.UNSATISFACTORY_VIEWS || sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.DOMESTIC || sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.DEAD || sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.SIGNS || sightingInfo.getSightingStatus() == SightingInfo.SightingStatus.NOT_BY_ME) {
                        text = "";
                    }
                }
            }
            label.setText(text);
            label.setToolTipText(tooltip);
        }

        @Override
        public void updateComponentState(Component component, SightingTaxon.Resolved resolved, Set<ExpandableTable.RowState> states) {
            super.updateComponentState(component, resolved, states);
            component.setVisible(states.contains((Object)ExpandableTable.RowState.ENABLED));
        }

        private String locationOrAbbreviated(Location location) {
            String name = location.getDisplayName();
            if (name.length() > 20) {
                return name.substring(0, 19) + "\u2026";
            }
            return name;
        }
    }

    private class SightingInfoDetail
    implements ExpandableTable.DetailView<SightingTaxon.Resolved> {
        SightingInfoDetail() {
        }

        @Override
        public JComponent createComponent(SightingTaxon.Resolved taxon) {
            SightingInfoPanel panel = new SightingInfoPanel(SingleLocationSpeciesListPanel.this.reportSet, SightingInfoPanel.Layout.HORIZONTAL, SingleLocationSpeciesListPanel.this.fontManager, SingleLocationSpeciesListPanel.this.fileDialogs, SingleLocationSpeciesListPanel.this.alerts);
            SingleLocationSpeciesListPanel.this.fontManager.applyTo(panel);
            panel.setSighting(((SingleLocationEdit)SingleLocationSpeciesListPanel.this.wizardValue()).getSightingInfo(taxon));
            panel.getDirty().addDirtyListener(e -> ((SingleLocationEdit)SingleLocationSpeciesListPanel.this.wizardValue()).edited());
            panel.addPropertyChangeListener("value", e -> {
                panel.save();
                SingleLocationSpeciesListPanel.this.speciesTablePanel.resolvedUpdated(taxon);
            });
            return panel;
        }

        @Override
        public void onClose(JComponent component) {
            SightingInfoPanel panel = (SightingInfoPanel)component;
            if (panel.getDirty().isDirty()) {
                panel.save();
            }
        }

        @Override
        public int getHeight() {
            if (SingleLocationSpeciesListPanel.this.reportSet.getUserSet() != null) {
                return Math.max(200, SingleLocationSpeciesListPanel.this.fontManager.scale(215));
            }
            return Math.max(135, SingleLocationSpeciesListPanel.this.fontManager.scale(150));
        }
    }

    private class SubspeciesColumn
    implements ExpandableTable.Column<SightingTaxon.Resolved> {
        private final ExpandableTable.ColumnLayout width = ExpandableTable.ColumnLayout.weightedWidth(1.0f);

        private SubspeciesColumn() {
        }

        @Override
        public JComponent createComponent(SightingTaxon.Resolved resolved, Set<ExpandableTable.RowState> states) {
            if (resolved.getType() != SightingTaxon.Type.SINGLE) {
                Taxon.Type largestTaxonType = resolved.getLargestTaxonType();
                if (largestTaxonType == Taxon.Type.group || largestTaxonType == Taxon.Type.subspecies) {
                    JLabel label = new JLabel(resolved.getPreferredSingleNameWithoutSpecies());
                    label.putClientProperty("birdlist.plainLabel", true);
                    return label;
                }
                return new JLabel("");
            }
            Taxon taxon = resolved.getTaxon();
            if (taxon.getType() == Taxon.Type.species && taxon.getContents().isEmpty()) {
                return new JLabel(""){

                    @Override
                    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                        if (!"parent".equals(propertyName) && !"ancestor".equals(propertyName)) {
                            super.firePropertyChange(propertyName, oldValue, newValue);
                        }
                    }
                };
            }
            final JComboBox<Taxon> subspeciesCombo = new JComboBox<Taxon>(){

                @Override
                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                    if (!"parent".equals(propertyName) && !"ancestor".equals(propertyName)) {
                        super.firePropertyChange(propertyName, oldValue, newValue);
                    }
                }

                @Override
                public void updateUI() {
                    if (DelayedUI.instance().requestUICreation(this)) {
                        super.updateUI();
                    }
                }
            };
            subspeciesCombo.setRenderer(new ToStringListCellRenderer<Taxon>(SingleLocationSpeciesListPanel.this.subspeciesToString, Taxon.class, SingleLocationSpeciesListPanel.this.defaultRenderer){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (isSelected) {
                        SingleLocationSpeciesListPanel.this.subspeciesPopupTaxon = (Taxon)value;
                        SightingTaxon.Resolved resolved = value != null ? SightingTaxons.newResolved(SingleLocationSpeciesListPanel.this.subspeciesPopupTaxon) : SingleLocationSpeciesListPanel.this.speciesTablePanel.getSelectedSpecies();
                        SingleLocationSpeciesListPanel.this.speciesEntryPanel.setFocusResolver(Suppliers.ofInstance(resolved));
                    }
                    return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                }
            });
            this.buildSubspeciesModel(taxon, subspeciesCombo);
            subspeciesCombo.setMaximumRowCount(Math.min(12, subspeciesCombo.getModel().getSize()));
            subspeciesCombo.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    subspeciesCombo.putClientProperty(POPUP_WILL_BE_VISIBLE, true);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    if (Boolean.TRUE.equals(subspeciesCombo.getClientProperty(FIRE_PENDING_ACTION))) {
                        subspeciesCombo.putClientProperty(POPUP_WILL_BE_VISIBLE, null);
                        subspeciesCombo.putClientProperty(FIRE_PENDING_ACTION, null);
                        ActionEvent event = new ActionEvent(subspeciesCombo, 0, "");
                        for (ActionListener listener : subspeciesCombo.getActionListeners()) {
                            listener.actionPerformed(event);
                        }
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    subspeciesCombo.putClientProperty(POPUP_WILL_BE_VISIBLE, null);
                    subspeciesCombo.putClientProperty(FIRE_PENDING_ACTION, null);
                }
            });
            subspeciesCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SingleLocationSpeciesListPanel.this.speciesEntryPanel.setFocusResolver(new Supplier<SightingTaxon.Resolved>(){

                        @Override
                        public SightingTaxon.Resolved get() {
                            if (SingleLocationSpeciesListPanel.this.currentSubspeciesComboBox != null) {
                                Taxon taxon = (Taxon)SingleLocationSpeciesListPanel.this.currentSubspeciesComboBox.getSelectedItem();
                                if (taxon == null) {
                                    taxon = (Taxon)SingleLocationSpeciesListPanel.this.currentSubspeciesComboBox.getClientProperty(TAXON_KEY);
                                }
                                if (taxon != null) {
                                    return SightingTaxons.newResolved(taxon);
                                }
                            }
                            return SingleLocationSpeciesListPanel.this.speciesTablePanel.getSelectedSpecies();
                        }
                    });
                    if (Boolean.TRUE.equals(subspeciesCombo.getClientProperty(POPUP_WILL_BE_VISIBLE))) {
                        subspeciesCombo.putClientProperty(FIRE_PENDING_ACTION, true);
                        return;
                    }
                    subspeciesCombo.putClientProperty(FIRE_PENDING_ACTION, null);
                    boolean isFocusOwner = subspeciesCombo.isFocusOwner();
                    Taxon current = (Taxon)subspeciesCombo.getClientProperty(TAXON_KEY);
                    Taxon subspeciesOrGroup = (Taxon)subspeciesCombo.getSelectedItem();
                    SingleLocationSpeciesListPanel.this.updateSubspeciesOfCurrentItem(current, subspeciesOrGroup);
                    if (isFocusOwner) {
                        Component component;
                        boolean movedFocus = false;
                        int row = SingleLocationSpeciesListPanel.this.speciesTablePanel.findTaxon(SightingTaxons.newResolved(subspeciesOrGroup));
                        if (row >= 0 && SingleLocationSpeciesListPanel.isFocusable(component = SingleLocationSpeciesListPanel.this.speciesTablePanel.getSpeciesTable().getComponent(row, SubspeciesColumn.this))) {
                            component.requestFocusInWindow();
                            movedFocus = true;
                        }
                        if (!movedFocus) {
                            SingleLocationSpeciesListPanel.this.speciesTablePanel.requestFocusInWindow();
                        }
                    }
                }
            });
            subspeciesCombo.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    SingleLocationSpeciesListPanel.this.currentSubspeciesComboBox = subspeciesCombo;
                }
            });
            this.updateComponentState((Component)subspeciesCombo, resolved, states);
            return subspeciesCombo;
        }

        @Override
        public ExpandableTable.ColumnLayout getWidth() {
            return this.width;
        }

        @Override
        public boolean sizeComponentsToFit() {
            return true;
        }

        @Override
        public void updateComponentValue(Component component, SightingTaxon.Resolved value) {
            if (component instanceof JComboBox) {
                this.buildSubspeciesModel(value.getTaxon(), (JComboBox)component);
            }
        }

        private void buildSubspeciesModel(Taxon taxon, JComboBox<Taxon> subspeciesCombo) {
            subspeciesCombo.putClientProperty(TAXON_KEY, taxon);
            final DefaultComboBoxModel<Taxon> model = new DefaultComboBoxModel<Taxon>();
            final Taxon species = TaxonUtils.getParentOfType(taxon, Taxon.Type.species);
            model.addElement(species);
            TaxonUtils.visitTaxa(species, new TaxonVisitor(){

                @Override
                public boolean visitTaxon(Taxon visited) {
                    if (species != visited && !visited.isDisabled()) {
                        model.addElement(visited);
                    }
                    return true;
                }
            });
            subspeciesCombo.setEnabled(model.getSize() > 1);
            if (taxon.getType().compareTo(Taxon.Type.species) < 0) {
                model.setSelectedItem(taxon);
            }
            subspeciesCombo.setModel(model);
        }

        @Override
        public String getName() {
            return Messages.getMessage(Messages.Name.SUBSPECIES_COLUMN);
        }

        @Override
        public void updateComponentState(Component component, SightingTaxon.Resolved resolved, Set<ExpandableTable.RowState> states) {
            component.setEnabled(states.contains((Object)ExpandableTable.RowState.ENABLED));
        }
    }

    private class PhotoColumn
    implements ExpandableTable.Column<SightingTaxon.Resolved> {
        private final MouseListener listener;
        private final Border defaultBorder = new EmptyBorder(2, 2, 2, 2);
        private final Border dragOverBorder;
        private ExpandableTable.ColumnLayout width = ExpandableTable.ColumnLayout.scalableFixedWidth(55);
        private ExpandableTable<SightingTaxon.Resolved> table;
        private static final Object LATEST_STATE_KEY = new Object();

        public PhotoColumn() {
            this.table = SingleLocationSpeciesListPanel.this.speciesTablePanel.getSpeciesTable();
            Color color = UIManager.getColor("Focus.color");
            this.dragOverBorder = color != null ? new LineBorder(color, 2, false) : this.defaultBorder;
            this.listener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JLabel label;
                    label.setForeground(UIManager.getColor(PhotoColumn.this.isSelected(label = (JLabel)e.getComponent()) ? "Table.selectionForeground" : "Table.foreground"));
                    Point tablePoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), PhotoColumn.this.table);
                    int row = PhotoColumn.this.table.getRow(tablePoint.y);
                    PhotoColumn.this.addPhoto((JLabel)e.getComponent(), row);
                    e.consume();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    JLabel label = (JLabel)e.getComponent();
                    if (label.getIcon() != null) {
                        label.setIcon(SingleLocationSpeciesListPanel.this.cameraIconActive);
                    } else {
                        label.setForeground(Color.GRAY);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    JLabel label = (JLabel)e.getComponent();
                    if (label.getIcon() != null) {
                        label.setIcon(PhotoColumn.this.currentIcon(label));
                    } else {
                        label.setForeground(UIManager.getColor(PhotoColumn.this.isSelected(label) ? "Table.selectionForeground" : "Table.foreground"));
                    }
                }
            };
        }

        @Override
        public JComponent createComponent(final SightingTaxon.Resolved value, Set<ExpandableTable.RowState> states) {
            final JLabel label = new JLabel();
            label.setOpaque(false);
            label.setToolTipText(Messages.getMessage(Messages.Name.ADD_A_PHOTO));
            label.addMouseListener(this.listener);
            label.setHorizontalAlignment(0);
            this.updateComponentState((Component)label, value, states);
            new LinkDrops<Photo>(){

                @Override
                protected void setDragOverBorder() {
                    label.setBorder(PhotoColumn.this.dragOverBorder);
                }

                @Override
                protected void setDefaultBorder() {
                    label.setBorder(PhotoColumn.this.defaultBorder);
                }

                @Override
                protected void addLinks(List<Photo> photos) {
                    PhotoColumn.this.addPhotos(label, value, photos);
                }

                @Override
                protected Photo newLink(URI uri) {
                    return new Photo(uri);
                }

                @Override
                protected Photo newLink(File file) {
                    return new Photo(file);
                }
            }.activate(label);
            return label;
        }

        @Override
        public ExpandableTable.ColumnLayout getWidth() {
            return this.width;
        }

        @Override
        public boolean sizeComponentsToFit() {
            return false;
        }

        @Override
        public void updateComponentValue(Component component, SightingTaxon.Resolved value) {
            int photosCount = this.photosCount(value);
            JLabel label = (JLabel)component;
            this.updateLabel(photosCount, label);
        }

        private void updateLabel(int photosCount, JLabel label) {
            if (photosCount == 0) {
                label.setText("");
                label.setIcon(this.currentIcon(label));
            } else {
                label.setText("" + photosCount);
                label.setForeground(UIManager.getColor(this.isSelected(label) ? "Table.selectionForeground" : "Table.foreground"));
                label.setIcon(null);
            }
        }

        private boolean isSelected(JLabel label) {
            Set states = (Set)label.getClientProperty(LATEST_STATE_KEY);
            return states.contains((Object)ExpandableTable.RowState.SELECTED);
        }

        private Icon currentIcon(JLabel label) {
            return this.isSelected(label) ? SingleLocationSpeciesListPanel.this.cameraIconWhite : SingleLocationSpeciesListPanel.this.cameraIcon;
        }

        private int photosCount(SightingTaxon.Resolved resolved) {
            return SingleLocationSpeciesListPanel.this.getCurrentSightingInfo(resolved).getPhotos().size();
        }

        @Override
        public void updateComponentState(Component component, SightingTaxon.Resolved resolved, Set<ExpandableTable.RowState> states) {
            JLabel label = (JLabel)component;
            label.putClientProperty(LATEST_STATE_KEY, states);
            if (states.contains((Object)ExpandableTable.RowState.ENABLED)) {
                this.updateComponentValue(component, resolved);
            } else {
                label.setIcon(null);
                label.setText("");
            }
        }

        private void addPhoto(JLabel label, int index) {
            File file = SingleLocationSpeciesListPanel.this.fileDialogs.openFile(UIUtils.findFrame(SingleLocationSpeciesListPanel.this), Messages.getMessage(Messages.Name.CHOOSE_A_PHOTO), new FileFilter(){

                @Override
                public String getDescription() {
                    return Messages.getMessage(Messages.Name.IMAGE_FILE);
                }

                @Override
                public boolean accept(File f) {
                    return true;
                }
            }, FilePreferences.FileType.OTHER);
            if (file != null) {
                SightingTaxon.Resolved resolved = SingleLocationSpeciesListPanel.this.speciesTablePanel.getSpecies(index);
                this.addPhotos(label, resolved, ImmutableList.of(new Photo(file)));
            }
        }

        private void addPhotos(JLabel label, SightingTaxon.Resolved resolved, List<Photo> newPhotos) {
            SightingInfo sightingInfo = ((SingleLocationEdit)SingleLocationSpeciesListPanel.this.wizardValue()).getSightingInfo(resolved);
            ArrayList<Photo> combinedPhotos = new ArrayList<Photo>(sightingInfo.getPhotos());
            combinedPhotos.addAll(newPhotos);
            sightingInfo.setPhotos(combinedPhotos);
            sightingInfo.setPhotographed(true);
            this.updateLabel(combinedPhotos.size(), label);
            SingleLocationSpeciesListPanel.this.speciesTablePanel.resolvedUpdated(resolved);
            ((SingleLocationEdit)SingleLocationSpeciesListPanel.this.wizardValue()).edited();
        }

        @Override
        public String getName() {
            return Messages.getMessage(Messages.Name.PHOTOS_TEXT);
        }
    }

    private class NumberColumn
    extends LabelColumn<SightingTaxon.Resolved> {
        public NumberColumn() {
            super(ExpandableTable.ColumnLayout.weightedWidth(0.3f), Messages.getMessage(Messages.Name.NUMBER_TEXT));
        }

        @Override
        public JComponent createComponent(SightingTaxon.Resolved value, Set<ExpandableTable.RowState> states) {
            JLabel label = (JLabel)super.createComponent(value, states);
            label.setHorizontalAlignment(4);
            return label;
        }

        @Override
        protected String getText(SightingTaxon.Resolved value) {
            ApproximateNumber number = SingleLocationSpeciesListPanel.this.getCurrentSightingInfo(value).getNumber();
            return number == null ? "" : number.toFormattedString();
        }
    }

    private class SightingStatusColumn
    extends LabelColumn<SightingTaxon.Resolved> {
        public SightingStatusColumn() {
            super(ExpandableTable.ColumnLayout.weightedWidth(0.3f), Messages.getMessage(Messages.Name.STATUS_COLUMN));
        }

        @Override
        protected String getText(SightingTaxon.Resolved value) {
            return Strings.nullToEmpty(SightingFlags.getAbbreviatedSightingFlags(SingleLocationSpeciesListPanel.this.getCurrentSightingInfo(value)));
        }
    }

    private class ObserversColumn
    implements ExpandableTable.Column<SightingTaxon.Resolved> {
        private final ExpandableTable.ColumnLayout width = ExpandableTable.ColumnLayout.weightedWidth(0.7f);

        @Override
        public JComponent createComponent(SightingTaxon.Resolved value, Set<ExpandableTable.RowState> states) {
            JLabel label = new JLabel();
            label.setOpaque(false);
            label.setHorizontalAlignment(0);
            this.updateComponentState((Component)label, value, states);
            return label;
        }

        @Override
        public ExpandableTable.ColumnLayout getWidth() {
            return this.width;
        }

        @Override
        public boolean sizeComponentsToFit() {
            return true;
        }

        @Override
        public void updateComponentValue(Component component, SightingTaxon.Resolved value) {
            ImmutableSet<User> users = SingleLocationSpeciesListPanel.this.getCurrentSightingInfo(value).getUsers();
            JLabel label = (JLabel)component;
            if (users.isEmpty()) {
                label.setText("");
            } else {
                ArrayList<String> abbreviations = new ArrayList<String>(users.size());
                for (User user : users) {
                    if (user.abbreviation() == null) continue;
                    abbreviations.add(user.abbreviation());
                }
                Collections.sort(abbreviations);
                label.setText(COMMA_JOINER.join(abbreviations));
            }
        }

        @Override
        public void updateComponentState(Component component, SightingTaxon.Resolved resolved, Set<ExpandableTable.RowState> states) {
            this.updateComponentValue(component, resolved);
        }

        @Override
        public String getName() {
            return Messages.getMessage(Messages.Name.OBSERVERS_TEXT);
        }
    }
}

