/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.edits.SingleLocationEdit;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.components.NewLocationPanel;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.WizardContentPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JLabel;

public class SingleLocationNewLocationPanel
extends WizardContentPanel<SingleLocationEdit>
implements Titled,
FontManager.FontsUpdatedListener {
    private final NewLocationPanel newLocation;
    private final FontManager fontManager;
    private JLabel helpLabel;

    @Inject
    public SingleLocationNewLocationPanel(NewLocationPanel newLocation, FontManager fontManager) {
        super("NewLocation", SingleLocationEdit.class);
        this.newLocation = newLocation;
        this.fontManager = fontManager;
        this.initGUI();
        this.hookupContents();
    }

    private void hookupContents() {
        this.newLocation.setLocationName("");
        this.newLocation.addPropertyChangeListener("complete", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SingleLocationNewLocationPanel.this.setComplete((Boolean)e.getNewValue());
            }
        });
        this.newLocation.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ((SingleLocationEdit)SingleLocationNewLocationPanel.this.wizardValue()).setLocation((Location)e.getNewValue());
            }
        });
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        Box content = new Box(3);
        this.add((Component)content, "Center");
        this.helpLabel = new JLabel();
        this.helpLabel.putClientProperty("birdlist.plainLabel", true);
        content.add(this.helpLabel);
        content.add(Box.createVerticalStrut(20));
        content.add(this.newLocation);
        this.helpLabel.setAlignmentX(0.0f);
        this.newLocation.setAlignmentX(0.0f);
        this.fontManager.applyTo(this);
    }

    @Override
    public String getTitle() {
        return "New Location";
    }

    @Override
    protected void shown() {
        super.shown();
        this.newLocation.requestFocusInWindow();
    }

    @Override
    protected boolean leaving(boolean validate) {
        super.leaving(validate);
        ((SingleLocationEdit)this.wizardValue()).setLocationName(this.newLocation.getLocationName());
        if (!validate) {
            return true;
        }
        Location location = this.newLocation.getValueAfterValidating();
        return location != null && ((SingleLocationEdit)this.wizardValue()).getLocation() != null;
    }

    @Override
    protected void beforeShown() {
        if (!((SingleLocationEdit)this.wizardValue()).getLocationName().equals(this.newLocation.getLocationName())) {
            this.newLocation.setLocationName(((SingleLocationEdit)this.wizardValue()).getLocationName());
        }
        this.helpLabel.setText(Messages.getFormattedMessage(Messages.Name.ENTER_LOCATION_HELP_FORMAT, ((SingleLocationEdit)this.wizardValue()).getLocationName()));
        Location location = this.newLocation.getValueAfterValidating();
        ((SingleLocationEdit)this.wizardValue()).setLocation(location);
        this.setComplete(location != null);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setPreferredSize(fontManager.scale(new Dimension(600, 500)));
    }
}

